/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.AnnotationDefinition;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.RelationRule;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.type.system.Relation;
import edu.utah.bmi.nlp.type.system.Sentence;
import edu.utah.bmi.nlp.type.system.Token;
import edu.utah.bmi.nlp.uima.ae.RuleBasedAEInf;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.common.UIMATypeFunctions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.FSUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class RelationAnnotator
extends JCasAnnotator_ImplBase
implements RuleBasedAEInf {
    public static final Logger logger = IOUtil.getLogger(RelationAnnotator.class);
    public static final String PARAM_RULE_STR = "RuleFileOrStr";
    protected ArrayList<ArrayList<String>> ruleCells = new ArrayList();
    protected HashMap<String, String> valueFeatureMap = new HashMap();
    protected LinkedHashMap<String, TypeDefinition> typeDefinitions = new LinkedHashMap();
    protected HashMap<String, Class<? extends Annotation>> srcAnnoClassMap = new LinkedHashMap<String, Class<? extends Annotation>>();
    protected HashMap<String, Class<? extends Annotation>> conclusionAnnoClassMap = new LinkedHashMap<String, Class<? extends Annotation>>();
    protected HashMap<String, HashMap<String, String>> setGetFeatureMap = new HashMap();
    protected HashMap<Class, HashMap<String, Method>> conclusionConceptSetFeatures = new HashMap();
    protected HashMap<String, HashMap<String, Method>> evidenceConceptGetFeatures = new LinkedHashMap<String, HashMap<String, Method>>();
    protected HashMap<Class, HashMap<String, Method>> elementGetFeatures = new HashMap();
    protected HashMap<String, Constructor<? extends Annotation>> conclusionConstructorMap = new HashMap();
    protected LinkedHashMap<String, IntervalST<LinkedHashSet<Integer>>> annoIdx = new LinkedHashMap();
    protected LinkedHashMap<String, ArrayList<Annotation>> annos = new LinkedHashMap();
    protected HashMap ruleMap = new LinkedHashMap();
    protected HashMap<String, AnnotationDefinition> relationDefs = new HashMap();
    public LinkedHashMap<Integer, RelationRule> ruleStore = new LinkedHashMap();
    protected static final String ARG1 = "Arg1";
    protected static final String ARG2 = "Arg2";
    protected final String END = "<END>";

    @Override
    public void initialize(UimaContext cont) {
        String ruleStr = (String)cont.getConfigParameterValue(PARAM_RULE_STR);
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        this.parseRules(ioUtil);
    }

    protected void parseRules(IOUtil ioUtil) {
        this.typeDefinitions = this.getTypeDefs(ioUtil);
        for (ArrayList<String> arrayList : ioUtil.getInitiations()) {
            if (!arrayList.get(1).substring(1).equals("RELATION_DEFINITION")) continue;
            String relationType = arrayList.get(2);
            this.relationDefs.put(relationType, new AnnotationDefinition(this.typeDefinitions.get(relationType)));
            String[] srcTypeNames = arrayList.get(4).split("[,:;]");
            this.srcAnnoClassMap.put((String)srcTypeNames[0], AnnotationOper.getTypeClass((String)srcTypeNames[0]));
            this.relationDefs.get(relationType).setFeatureValue(ARG1, srcTypeNames[0]);
            this.srcAnnoClassMap.put((String)srcTypeNames[1], AnnotationOper.getTypeClass((String)srcTypeNames[1]));
            this.relationDefs.get(relationType).setFeatureValue(ARG2, srcTypeNames[1]);
            for (String featureValuePairStr : arrayList.get(3).split("\\s*,\\s*")) {
                String[] featureValuePair = featureValuePairStr.split("\\s*:\\s*");
                if (featureValuePair.length > 2) {
                    String evidenceClassName = featureValuePair[1].trim();
                    String setFeatureName = featureValuePair[0].trim();
                    String getFeatureName = featureValuePair[2].trim();
                    if (!this.setGetFeatureMap.containsKey(evidenceClassName)) {
                        this.setGetFeatureMap.put(evidenceClassName, new HashMap());
                    }
                    this.setGetFeatureMap.get(evidenceClassName).put(setFeatureName, getFeatureName);
                }
                this.relationDefs.get(relationType).setFeatureValue(featureValuePair[0], featureValuePair[1]);
            }
        }
        this.srcAnnoClassMap.put("Token", Token.class);
        this.srcAnnoClassMap.put("Sentence", Sentence.class);
        AnnotationOper.initSetReflections(this.typeDefinitions, this.conclusionAnnoClassMap, this.conclusionConstructorMap, this.conclusionConceptSetFeatures);
        for (TypeDefinition typeDefinition : this.typeDefinitions.values()) {
            String shortTypeName = typeDefinition.shortTypeName;
            for (String featureName : typeDefinition.getNewFeatureNames()) {
                String[] stringArray = featureName.split(":");
            }
        }
        for (ArrayList arrayList : ioUtil.getRuleCells()) {
            int offset = 0;
            if (arrayList.size() < 6) {
                offset = -1;
            }
            String scope = (String)arrayList.get(5 + offset);
            String relationType = (String)arrayList.get(4 + offset);
            RelationRule.TriggerTypes triggerType = RelationRule.TriggerTypes.valueOf((String)arrayList.get(3 + offset));
            RelationRule.TriggerTypes direction = RelationRule.TriggerTypes.valueOf((String)arrayList.get(2 + offset));
            int ruleId = NumberUtils.createInteger((String)arrayList.get(0));
            this.ruleStore.put(ruleId, new RelationRule(ruleId, (String)arrayList.get(1), relationType, direction, triggerType));
            AnnotationDefinition relationDef = this.relationDefs.get(relationType);
            if (!this.ruleMap.containsKey(relationDef.getFeatureValue(ARG1))) {
                this.ruleMap.put(relationDef.getFeatureValue(ARG1), new LinkedHashMap());
            }
            HashMap tmp = (HashMap)this.ruleMap.get(relationDef.getFeatureValue(ARG1));
            if (NumberUtils.isParsable(scope)) {
                int num;
                if (!tmp.containsKey("Token")) {
                    tmp.put("Token", new LinkedHashMap());
                }
                if (!(tmp = (HashMap)tmp.get("Token")).containsKey(num = NumberUtils.createInteger(scope).intValue())) {
                    tmp.put(num, new HashMap());
                }
                tmp = (HashMap)tmp.get(num);
            } else {
                int splitter = scope.indexOf("*");
                if (splitter != -1) {
                    String typeName = scope.substring(0, splitter);
                    int num = NumberUtils.createInteger(scope.substring(splitter + 1));
                    this.annos.put(typeName, new ArrayList());
                    if (!this.srcAnnoClassMap.containsKey(typeName)) {
                        this.srcAnnoClassMap.put(typeName, AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(typeName)));
                    }
                    if (!tmp.containsKey(typeName)) {
                        tmp.put(typeName, new LinkedHashMap());
                    }
                    if (!(tmp = (HashMap)tmp.get(typeName)).containsKey(num)) {
                        tmp.put(num, new LinkedHashMap());
                    }
                    tmp = (HashMap)tmp.get(num);
                } else {
                    this.annos.put(scope, new ArrayList());
                    if (!this.srcAnnoClassMap.containsKey(scope)) {
                        this.srcAnnoClassMap.put(scope, AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(scope)));
                    }
                    if (!tmp.containsKey(scope)) {
                        tmp.put(scope, new LinkedHashMap());
                    }
                    if (!(tmp = (HashMap)tmp.get(scope)).containsKey(1)) {
                        tmp.put(1, new LinkedHashMap());
                    }
                    tmp = (HashMap)tmp.get(1);
                }
            }
            if (!tmp.containsKey((Object)direction)) {
                tmp.put(direction, new LinkedHashMap());
            }
            if (!(tmp = (HashMap)tmp.get((Object)direction)).containsKey(relationDef.getFeatureValue(ARG2))) {
                tmp.put(relationDef.getFeatureValue(ARG2), new LinkedHashMap());
            }
            tmp = (HashMap)tmp.get(relationDef.getFeatureValue(ARG2));
            if (offset == -1) {
                if (!tmp.containsKey("<END>")) {
                    tmp.put("<END>", new ArrayList());
                }
                ((ArrayList)tmp.get("<END>")).add(ruleId);
                continue;
            }
            for (String ele : ((String)arrayList.get(1)).split("\\s+")) {
                if (!tmp.containsKey(ele)) {
                    tmp.put(ele, new HashMap());
                }
                if (ele.startsWith("<") && ele.endsWith(">")) {
                    String annoType = ele.substring(1, ele.length() - 1);
                    this.getAnnoClass(annoType);
                }
                tmp = (HashMap)tmp.get(ele);
            }
            if (!tmp.containsKey("<END>")) {
                tmp.put("<END>", new ArrayList());
            }
            ((ArrayList)tmp.get("<END>")).add(ruleId);
        }
        this.initGetRelections(this.relationDefs, this.srcAnnoClassMap, this.evidenceConceptGetFeatures);
    }

    private void initGetRelections(HashMap<String, AnnotationDefinition> relationDefs, HashMap<String, Class<? extends Annotation>> srcAnnoClassMap, HashMap<String, HashMap<String, Method>> evidenceConceptGetFeatures) {
        for (String relationTypeName : relationDefs.keySet()) {
            AnnotationDefinition relationTypeDef = relationDefs.get(relationTypeName);
            LinkedHashMap<String, Object> featureValues = relationTypeDef.getFullFeatureValuePairs();
            Iterator<String> iterator2 = featureValues.keySet().iterator();
            block8: while (iterator2.hasNext()) {
                String featureName;
                switch (featureName = iterator2.next()) {
                    case "Arg1": 
                    case "Arg2": {
                        continue block8;
                    }
                }
                String value = (String)featureValues.get(featureName);
                if (!srcAnnoClassMap.containsKey(value)) continue;
                if (!evidenceConceptGetFeatures.containsKey(value)) {
                    evidenceConceptGetFeatures.put(value, new HashMap());
                }
                if (this.setGetFeatureMap.containsKey(value) && this.setGetFeatureMap.get(value).containsKey(featureName)) {
                    featureName = this.setGetFeatureMap.get(value).get(featureName);
                }
                if (featureName.equals("SimpleType")) {
                    evidenceConceptGetFeatures.get(value).put(featureName, AnnotationOper.getFeatureMethod(srcAnnoClassMap.get(value), "Type"));
                    continue;
                }
                evidenceConceptGetFeatures.get(value).put(featureName, AnnotationOper.getFeatureMethod(srcAnnoClassMap.get(value), featureName));
            }
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.annoIdx.clear();
        this.annos.clear();
        this.indexClues(aJCas, this.srcAnnoClassMap.keySet(), this.annoIdx, this.annos);
        HashMap<String, HashMap<String, RelationRule>> matches = new HashMap<String, HashMap<String, RelationRule>>();
        for (Object eleObj : this.ruleMap.keySet()) {
            String ele1Type = (String)eleObj;
            ArrayList<Annotation> ele1s = this.annos.get(ele1Type);
            for (int ele1Id = 0; ele1Id < ele1s.size(); ++ele1Id) {
                Annotation ele1 = ele1s.get(ele1Id);
                HashMap ele1tmp = (HashMap)this.ruleMap.get(eleObj);
                for (Object scopeObj : ele1tmp.keySet()) {
                    LinkedHashSet<Integer> tokenIds;
                    String scopeType = (String)scopeObj;
                    if (!this.annoIdx.containsKey(scopeType) || this.annoIdx.get(scopeType).size() == 0 || !(tokenIds = this.annoIdx.get(scopeType).get(new Interval1D(ele1.getEnd() - 1, ele1.getEnd()))).iterator().hasNext()) continue;
                    int endScopeId = (Integer)this.annoIdx.get(scopeType).get(new Interval1D(ele1.getEnd() - 1, ele1.getEnd())).iterator().next();
                    int beginScopeId = (Integer)this.annoIdx.get(scopeType).get(new Interval1D(ele1.getBegin(), ele1.getBegin() + 1)).iterator().next();
                    HashMap scopetmp = (HashMap)ele1tmp.get(scopeObj);
                    for (Object scopeNumObj : scopetmp.keySet()) {
                        int scopeNum = (Integer)scopeNumObj;
                        HashMap numtmp = (HashMap)scopetmp.get(scopeNum);
                        for (Object directionObj : numtmp.keySet()) {
                            RelationRule.TriggerTypes direction = (RelationRule.TriggerTypes)((Object)directionObj);
                            HashMap directiontmp = (HashMap)numtmp.get((Object)direction);
                            block10: for (Object ele2Obj : directiontmp.keySet()) {
                                String ele2Type = (String)ele2Obj;
                                Iterable<Object> ele2s = new ArrayList();
                                Interval1D scopeInv = null;
                                switch (direction) {
                                    case forward: {
                                        int scopebegin = ele1.getEnd();
                                        int scopeEndId = endScopeId + scopeNum;
                                        int total = this.annos.get(scopeType).size();
                                        if (scopeEndId >= total) {
                                            scopeEndId = total - 1;
                                        }
                                        int scopeend = this.annos.get(scopeType).get(scopeEndId).getEnd();
                                        scopeInv = new Interval1D(scopebegin, scopeend);
                                        if (!this.annoIdx.containsKey(ele2Type)) continue block10;
                                        ele2s = this.annoIdx.get(ele2Type).getAll(scopeInv);
                                        break;
                                    }
                                    case backward: {
                                        int scopebegin;
                                        int scopeend = ele1.getBegin();
                                        int scopeBeginId = beginScopeId - scopeNum;
                                        if (scopeBeginId < 0) {
                                            scopeBeginId = 0;
                                        }
                                        if ((scopebegin = this.annos.get(scopeType).get(scopeBeginId).getBegin()) > scopeend) {
                                            logger.warning(AnnotationOper.deserializeDocSrcInfor(aJCas).toString());
                                            logger.warning(ele1.getType().getShortName() + "\t" + ele1.getCoveredText());
                                            logger.warning(this.annos.get(scopeType).get(scopeBeginId).getCoveredText());
                                            logger.warning(this.annos.get(scopeType).get(beginScopeId).getCoveredText());
                                            logger.warning(scopebegin + "-" + scopeend);
                                        }
                                        scopeInv = new Interval1D(scopebegin, scopeend);
                                        if (!this.annoIdx.containsKey(ele2Type)) continue block10;
                                        ele2s = this.annoIdx.get(ele2Type).getAll(scopeInv);
                                        break;
                                    }
                                    case both: {
                                        int scopeBeginId = beginScopeId - scopeNum;
                                        if (scopeBeginId < 0) {
                                            scopeBeginId = 0;
                                        }
                                        int scopebegin = this.annos.get(scopeType).get(scopeBeginId).getBegin();
                                        int scopeEndId = endScopeId + scopeNum;
                                        int total = this.annos.get(scopeType).size();
                                        if (scopeEndId >= total) {
                                            scopeEndId = total - 1;
                                        }
                                        int scopeend = this.annos.get(scopeType).get(scopeEndId).getEnd();
                                        scopeInv = new Interval1D(scopebegin, scopeend);
                                        if (!this.annoIdx.containsKey(ele2Type)) continue block10;
                                        ele2s = this.annoIdx.get(ele2Type).getAll(scopeInv);
                                    }
                                }
                                for (LinkedHashSet ele2Ids : ele2s) {
                                    Iterator iterator2 = ele2Ids.iterator();
                                    while (iterator2.hasNext()) {
                                        int ele2Id = (Integer)iterator2.next();
                                        Annotation ele2 = this.annos.get(ele2Type).get(ele2Id);
                                        if (directiontmp.containsKey("<END>")) {
                                            ArrayList relationRuleIds = (ArrayList)directiontmp.get("<END>");
                                            Iterator iterator3 = relationRuleIds.iterator();
                                            while (iterator3.hasNext()) {
                                                int relationRuleId = (Integer)iterator3.next();
                                                RelationRule currentRule = this.ruleStore.get(relationRuleId).clone();
                                                if (!matches.containsKey(currentRule.ruleName)) {
                                                    matches.put(currentRule.ruleName, new HashMap());
                                                }
                                                String matchedId = ele1Id + "_" + ele2Id;
                                                if (((HashMap)matches.get(currentRule.ruleName)).containsKey(matchedId)) {
                                                    RelationRule previousMatch = (RelationRule)((HashMap)matches.get(currentRule.ruleName)).get(matchedId);
                                                    if (currentRule.triggerType != RelationRule.TriggerTypes.trigger || currentRule.rule.length() <= previousMatch.rule.length()) continue;
                                                    ((HashMap)matches.get(currentRule.ruleName)).put(matchedId, currentRule);
                                                    continue;
                                                }
                                                ((HashMap)matches.get(currentRule.ruleName)).put(ele1Id + "_" + ele2Id, currentRule);
                                            }
                                            continue;
                                        }
                                        if (!directiontmp.containsKey(ele2Type)) continue;
                                        if (ele1.getBegin() < ele2.getBegin()) {
                                            int tokenScopeBegin = (Integer)this.annoIdx.get("Token").get(new Interval1D(ele1.getEnd() - 1, ele1.getEnd())).iterator().next() + 1;
                                            int tokenScopeEnd = (Integer)this.annoIdx.get("Token").get(new Interval1D(ele2.getBegin(), ele2.getBegin() + 1)).iterator().next();
                                            logger.finest(String.format("%d: %s\t---\t%d: %s", tokenScopeBegin, this.annos.get("Token").get(tokenScopeBegin).getCoveredText(), tokenScopeEnd, this.annos.get("Token").get(tokenScopeEnd).getCoveredText()));
                                            this.processRelationRules((HashMap)directiontmp.get(ele2Type), matches, new Interval1D(ele1.getEnd(), ele2.getBegin()), ele1Id, ele2Id, ele1Type, ele2Type, direction, tokenScopeBegin, tokenScopeEnd, true);
                                            continue;
                                        }
                                        int tokenScopeBegin = (Integer)this.annoIdx.get("Token").get(new Interval1D(ele2.getEnd() - 1, ele2.getEnd())).iterator().next() + 1;
                                        int tokenScopeEnd = (Integer)this.annoIdx.get("Token").get(new Interval1D(ele1.getBegin(), ele1.getBegin() + 1)).iterator().next();
                                        logger.finest(String.format("%d: %s\t---\t%d: %s", tokenScopeBegin, this.annos.get("Token").get(tokenScopeBegin).getCoveredText(), tokenScopeEnd, this.annos.get("Token").get(tokenScopeEnd).getCoveredText()));
                                        if (ele2.getEnd() > ele1.getBegin()) {
                                            logger.warning(AnnotationOper.deserializeDocSrcInfor(aJCas).toString());
                                            logger.warning(String.format("%d: %s\t---\t%d: %s", tokenScopeBegin, this.annos.get("Token").get(tokenScopeBegin).getCoveredText(), tokenScopeEnd, this.annos.get("Token").get(tokenScopeEnd).getCoveredText()));
                                        }
                                        this.processRelationRules((HashMap)directiontmp.get(ele2Type), matches, new Interval1D(ele2.getEnd(), ele1.getBegin()), ele1Id, ele2Id, ele1Type, ele2Type, direction, tokenScopeBegin, tokenScopeEnd, true);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        for (String relationType : matches.keySet()) {
            for (String key : ((HashMap)matches.get(relationType)).keySet()) {
                RelationRule rule = (RelationRule)((HashMap)matches.get(relationType)).get(key);
                if (rule.triggerType != RelationRule.TriggerTypes.trigger) continue;
                String ele1Type = (String)this.relationDefs.get(rule.ruleName).getFeatureValue(ARG1);
                String ele2Type = (String)this.relationDefs.get(rule.ruleName).getFeatureValue(ARG2);
                String[] eleIds = key.split("_");
                Integer ele1Id = NumberUtils.createInteger(eleIds[0]);
                Integer ele2Id = NumberUtils.createInteger(eleIds[1]);
                this.addRelation(aJCas, rule.id, this.annos.get(ele1Type).get(ele1Id), this.annos.get(ele2Type).get(ele2Id));
            }
        }
    }

    private void logTokens(int tokenBegin, int tokenEnd) {
        if (logger.isLoggable(Level.FINEST)) {
            ArrayList<String> tokens = new ArrayList<String>();
            for (Annotation token : this.annos.get("Token").subList(tokenBegin, tokenEnd)) {
                tokens.add(token.getCoveredText());
            }
            logger.finest(String.format("Token (%d-%d): %s", tokenBegin, tokenEnd, tokens.toString().replaceAll(", ", " ")));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processRelationRules(HashMap tmp, HashMap<String, HashMap<String, RelationRule>> matches, Interval1D scopeInv, int ele1Id, int ele2Id, String ele1Type, String ele2Type, RelationRule.TriggerTypes direction, int tokenScopeBegin, int tokenScopeEnd, boolean previousEleIsType) {
        this.logTokens(tokenScopeBegin, tokenScopeEnd);
        for (K next : tmp.keySet()) {
            block27: {
                if (next != "<END>") break block27;
                relationRuleIds = (ArrayList)tmp.get("<END>");
                var15_15 = relationRuleIds.iterator();
lbl6:
                // 6 sources

                while (var15_15.hasNext()) {
                    block28: {
                        relationRuleId = (Integer)var15_15.next();
                        currentRule = this.ruleStore.get(relationRuleId).clone();
                        ele1 = this.annos.get(ele1Type).get(ele1Id);
                        if (!this.annos.containsKey(ele2Type)) continue;
                        ele2 = this.annos.get(ele2Type).get(ele2Id);
                        if (!matches.containsKey(currentRule.ruleName)) {
                            matches.put(currentRule.ruleName, new HashMap<K, V>());
                        }
                        matchedId = ele1Id + "_" + ele2Id;
                        if (!matches.get(currentRule.ruleName).containsKey(matchedId)) break block28;
                        previousMatch = matches.get(currentRule.ruleName).get(matchedId);
                        block0 : switch (1.$SwitchMap$edu$utah$bmi$nlp$core$RelationRule$TriggerTypes[currentRule.triggerType.ordinal()]) {
                            case 4: {
                                if (currentRule.rule.length() <= previousMatch.rule.length()) break;
                                switch (1.$SwitchMap$edu$utah$bmi$nlp$core$RelationRule$TriggerTypes[currentRule.direction.ordinal()]) {
                                    case 1: {
                                        if (ele1.getEnd() > ele2.getBegin()) break;
                                        matches.get(currentRule.ruleName).put(matchedId, currentRule);
                                        break block0;
                                    }
                                    case 2: {
                                        if (ele1.getBegin() < ele2.getEnd()) break;
                                        matches.get(currentRule.ruleName).put(matchedId, currentRule);
                                        break block0;
                                    }
                                    case 3: {
                                        matches.get(currentRule.ruleName).put(matchedId, currentRule);
                                    }
                                }
                                break;
                            }
                            case 5: {
                                switch (1.$SwitchMap$edu$utah$bmi$nlp$core$RelationRule$TriggerTypes[currentRule.direction.ordinal()]) {
                                    case 1: {
                                        if (ele1.getEnd() <= ele2.getBegin()) {
                                            matches.get(currentRule.ruleName).put(matchedId, currentRule);
                                            break block0;
                                        }
                                        ** GOTO lbl6
                                    }
                                    case 2: {
                                        if (ele1.getBegin() >= ele2.getEnd()) {
                                            matches.get(currentRule.ruleName).put(matchedId, currentRule);
                                            break block0;
                                        }
                                        ** GOTO lbl6
                                    }
                                    case 3: {
                                        matches.get(currentRule.ruleName).put(matchedId, currentRule);
                                    }
                                }
                            }
                        }
                        continue;
                    }
                    matches.get(currentRule.ruleName).put(ele1Id + "_" + ele2Id, currentRule);
                }
                continue;
            }
            nextKey = (String)next;
            if (nextKey.startsWith("<") && nextKey.endsWith(">")) {
                clueType = nextKey.substring(1, nextKey.length() - 1);
                clues = this.annoIdx.get(clueType).getAll(scopeInv);
                sortedClueIds = new ArrayList<Integer>();
                for (LinkedHashSet<Integer> ids : clues) {
                    sortedClueIds.addAll(ids);
                }
                Collections.sort(sortedClueIds);
                var18_23 = sortedClueIds.iterator();
                while (var18_23.hasNext()) {
                    cludId = (Integer)var18_23.next();
                    tokenClueId = (Integer)this.annoIdx.get("Token").get(new Interval1D(this.annos.get(clueType).get(cludId).getEnd() - 1, this.annos.get(clueType).get(cludId).getEnd())).iterator().next();
                    localTokenScopeBegin = tokenClueId + 1;
                    if (localTokenScopeBegin > tokenScopeEnd) continue;
                    if (localTokenScopeBegin >= this.annos.get("Token").size()) {
                        localTokenScopeBegin = this.annos.get("Token").size() - 1;
                    }
                    if (scopeInv.max <= (scopeBegin = this.annos.get("Token").get(localTokenScopeBegin).getEnd())) {
                        if (!RelationAnnotator.logger.isLoggable(Level.FINEST)) continue;
                        RelationAnnotator.logger.finest(this.annos.get("Token").get(localTokenScopeBegin).getCoveredText() + "\t" + this.annos.get("Token").get((Integer)this.annoIdx.get("Token").get(new Interval1D(scopeInv.max - 1, scopeInv.max)).iterator().next()).getCoveredText());
                        RelationAnnotator.logger.finest(scopeBegin + "\t" + scopeInv.max + "\t" + cludId);
                        continue;
                    }
                    this.processRelationRules((HashMap)tmp.get(next), matches, new Interval1D(scopeBegin, scopeInv.max), ele1Id, ele2Id, ele1Type, ele2Type, direction, localTokenScopeBegin, tokenScopeEnd, true);
                }
                continue;
            }
            if (previousEleIsType) {
                for (tokenId = tokenScopeBegin; tokenId <= tokenScopeEnd; ++tokenId) {
                    this.logTokens(tokenId, tokenScopeEnd);
                    token = this.annos.get("Token").get(tokenId);
                    if (!token.getCoveredText().equals(nextKey)) continue;
                    if (scopeInv.max <= token.getEnd()) {
                        if (!RelationAnnotator.logger.isLoggable(Level.FINEST)) continue;
                        RelationAnnotator.logger.finest(token.getCoveredText() + "\t" + this.annos.get("Token").get((Integer)this.annoIdx.get("Token").get(new Interval1D(scopeInv.max - 1, scopeInv.max)).iterator().next()).getCoveredText());
                        RelationAnnotator.logger.finest(token.getEnd() + "\t" + scopeInv.max + "\t" + tokenId);
                        continue;
                    }
                    this.processRelationRules((HashMap)tmp.get(next), matches, new Interval1D(token.getEnd(), scopeInv.max), ele1Id, ele2Id, ele1Type, ele2Type, direction, tokenId, tokenScopeEnd, false);
                }
                continue;
            }
            token = this.annos.get("Token").get(tokenScopeBegin);
            if (!token.getCoveredText().equals(nextKey)) continue;
            this.processRelationRules((HashMap)tmp.get(next), matches, new Interval1D(token.getEnd(), scopeInv.max), ele1Id, ele2Id, ele1Type, ele2Type, direction, tokenScopeBegin + 1, tokenScopeEnd, false);
        }
    }

    protected void addRelation(JCas jCas, int relationRuleId, Annotation ele1, Annotation ele2) {
        int end;
        Class<? extends Annotation> relationCls = this.getAnnoClass(this.ruleStore.get((Object)Integer.valueOf((int)relationRuleId)).ruleName);
        int begin = ele1.getBegin() < ele2.getBegin() ? ele1.getBegin() : ele2.getBegin();
        Annotation anno = AnnotationFactory.createAnnotation(jCas, begin, end = ele2.getEnd() > ele1.getEnd() ? ele2.getEnd() : ele1.getEnd(), relationCls);
        if (anno instanceof Relation) {
            Relation relationAnno = (Relation)anno;
            String relationTypeName = relationAnno.getType().getShortName();
            relationAnno.setNote("Rule(" + relationRuleId + "):" + this.ruleStore.get((Object)Integer.valueOf((int)relationRuleId)).rule);
            relationAnno.setArg1(ele1);
            relationAnno.setArg2(ele2);
            HashMap<String, Annotation> args2 = new HashMap<String, Annotation>();
            String simpleType = ele1.getType().getShortName();
            args2.put(simpleType, ele1);
            Class<? extends Annotation> ele1Cls = AnnotationOper.getTypeClass(simpleType);
            args2.put(ele1Cls.getSuperclass().getSimpleName(), ele1);
            simpleType = ele2.getType().getShortName();
            args2.put(simpleType, ele2);
            Class<? extends Annotation> ele2Cls = AnnotationOper.getTypeClass(simpleType);
            args2.put(ele2Cls.getSuperclass().getSimpleName(), ele2);
            LinkedHashMap<String, Object> featureValues = this.relationDefs.get(relationTypeName).getFullFeatureValuePairs();
            Iterator<String> iterator2 = featureValues.keySet().iterator();
            block7: while (iterator2.hasNext()) {
                String featureName;
                switch (featureName = iterator2.next()) {
                    case "Arg1": 
                    case "Arg2": {
                        continue block7;
                    }
                }
                String srcClsName = (String)featureValues.get(featureName);
                if (this.srcAnnoClassMap.containsKey(srcClsName)) {
                    Feature f1;
                    Class<? extends Annotation> srcCls = this.srcAnnoClassMap.get(srcClsName);
                    String getFeatureName = featureName;
                    if (this.setGetFeatureMap.containsKey(srcClsName) && this.setGetFeatureMap.get(srcClsName).containsKey(featureName)) {
                        getFeatureName = this.setGetFeatureMap.get(srcClsName).get(featureName);
                    }
                    if ((f1 = ((Annotation)args2.get(srcClsName)).getType().getFeatureByBaseName(featureName)) == null) {
                        logger.warning("Feature: " + featureName + " doesn't exists in annotation type: " + srcCls + ". Please check the relation rules configuration related to " + srcCls + " where the feature " + featureName + " is assigned a value.");
                        continue;
                    }
                    Object featureValue = FSUtil.getFeature((FeatureStructure)args2.get(srcClsName), f1, Object.class);
                    if (getFeatureName.equals("SimpleType") && featureValue instanceof Type) {
                        featureValue = ((Type)featureValue).getShortName();
                    }
                    FSUtil.setFeature((FeatureStructure)relationAnno, featureName, featureValue == null ? null : featureValue.toString());
                    continue;
                }
                FSUtil.setFeature((FeatureStructure)relationAnno, featureName, srcClsName);
            }
            relationAnno.addToIndexes();
        }
    }

    protected Constructor<? extends Annotation> getConstructor(Class<? extends Annotation> relationCls) {
        String typeName = relationCls.getSimpleName();
        if (this.conclusionConstructorMap.containsKey(typeName)) {
            return this.conclusionConstructorMap.get(typeName);
        }
        Constructor<? extends Annotation> constructor = null;
        try {
            constructor = relationCls.getConstructor(JCas.class);
            this.conclusionConstructorMap.put(typeName, constructor);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return constructor;
    }

    protected void indexClues(JCas jCas, Set<String> types, LinkedHashMap<String, IntervalST<LinkedHashSet<Integer>>> annoIdx, LinkedHashMap<String, ArrayList<Annotation>> annos) {
        for (String typeName : types) {
            Class<? extends Annotation> cls = this.getAnnoClass(typeName);
            if (!annoIdx.containsKey(typeName)) {
                annoIdx.put(typeName, new IntervalST());
                annos.put(typeName, new ArrayList());
            }
            HashSet<List<Integer>> addedInterval = new HashSet<List<Integer>>();
            for (Annotation annotation : JCasUtil.select(jCas, cls)) {
                if (!addedInterval.contains(Arrays.asList(annotation.getBegin(), annotation.getEnd()))) {
                    annoIdx.get(typeName).put(new Interval1D(annotation.getBegin(), annotation.getEnd() - 1), new LinkedHashSet());
                    addedInterval.add(Arrays.asList(annotation.getBegin(), annotation.getEnd()));
                }
                annoIdx.get(typeName).get(new Interval1D(annotation.getBegin(), annotation.getEnd() - 1)).add(annos.get(typeName).size());
                annos.get(typeName).add(annotation);
            }
        }
    }

    protected Class<? extends Annotation> getAnnoClass(String className) {
        if (this.srcAnnoClassMap.containsKey(className) && this.srcAnnoClassMap.get(className) != null) {
            return this.srcAnnoClassMap.get(className);
        }
        Class<? extends Annotation> cls = AnnotationOper.getTypeClass(className);
        this.srcAnnoClassMap.put(className, cls);
        this.srcAnnoClassMap.put(cls.getSimpleName(), cls);
        return cls;
    }

    @Override
    public LinkedHashMap<String, TypeDefinition> getTypeDefs(String ruleStr) {
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        return this.getTypeDefs(ioUtil);
    }

    protected LinkedHashMap<String, TypeDefinition> getTypeDefs(IOUtil ioUtil) {
        if (ioUtil.getInitiations().size() > 1) {
            UIMATypeFunctions.getTypeDefinitions(ioUtil, this.ruleCells, this.valueFeatureMap, new HashMap<String, Integer>(), new HashMap<String, String>(), this.typeDefinitions);
        }
        return this.typeDefinitions;
    }
}

