/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.ae;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.SimpleParser;
import edu.utah.bmi.nlp.core.Span;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;

public class SimpleParser_AE
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SENTENCE_TYPE_NAME = "SentenceTypeName";
    public static final String PARAM_TOKEN_TYPE_NAME = "TokenTypeName";
    public static final String PARAM_INCLUDE_PUNCTUATION = "IncludePunctuation";
    protected Class<? extends Annotation> SentenceType;
    protected Class<? extends Annotation> TokenType;
    protected boolean includePunctuation = false;
    protected static Constructor<? extends Annotation> SentenceTypeConstructor;
    protected static Constructor<? extends Annotation> TokenTypeConstructor;

    @Override
    public void initialize(UimaContext cont) {
        String tokenTypeName;
        String sentenceTypeName;
        Object obj = cont.getConfigParameterValue(PARAM_SENTENCE_TYPE_NAME);
        if (obj != null && obj instanceof String) {
            sentenceTypeName = ((String)obj).trim();
            sentenceTypeName = DeterminantValueSet.checkNameSpace(sentenceTypeName);
        } else {
            sentenceTypeName = DeterminantValueSet.checkNameSpace("Sentence");
        }
        obj = cont.getConfigParameterValue(PARAM_TOKEN_TYPE_NAME);
        if (obj != null && obj instanceof String) {
            tokenTypeName = ((String)obj).trim();
            tokenTypeName = DeterminantValueSet.checkNameSpace(tokenTypeName);
        } else {
            tokenTypeName = DeterminantValueSet.checkNameSpace("Token");
        }
        obj = cont.getConfigParameterValue(PARAM_INCLUDE_PUNCTUATION);
        if (obj != null && obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.includePunctuation = true;
        }
        try {
            this.SentenceType = AnnotationOper.getTypeClass(sentenceTypeName);
            this.TokenType = AnnotationOper.getTypeClass(tokenTypeName);
            SentenceTypeConstructor = this.SentenceType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
            TokenTypeConstructor = this.TokenType.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        String text = jcas.getDocumentText();
        ArrayList<ArrayList<Span>> sentences = SimpleParser.tokenizeDecimalSmartWSentences(text, this.includePunctuation);
        for (ArrayList<Span> sentence : sentences) {
            int thisBegin = sentence.get((int)0).begin;
            int thisEnd = sentence.get((int)(sentence.size() - 1)).end;
            this.saveSentence(jcas, thisBegin, thisEnd);
            this.saveTokens(jcas, sentence);
        }
    }

    protected void saveSentence(JCas jcas, int begin, int end) {
        this.saveAnnotation(jcas, SentenceTypeConstructor, begin, end);
    }

    protected void saveTokens(JCas jcas, ArrayList<Span> tokens) {
        for (int i = 0; i < tokens.size(); ++i) {
            Span thisSpan = tokens.get(i);
            this.saveToken(jcas, thisSpan.begin, thisSpan.end);
        }
    }

    protected void saveToken(JCas jcas, int begin, int end) {
        this.saveAnnotation(jcas, TokenTypeConstructor, begin, end);
    }

    protected void saveAnnotation(JCas jcas, Constructor<? extends Annotation> annoConstructor, int begin, int end) {
        TOP anno = null;
        try {
            anno = annoConstructor.newInstance(jcas, begin, end);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        anno.addToIndexes();
    }
}

