/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.common;

import edu.utah.bmi.nlp.compiler.MemoryClassLoader;
import edu.utah.bmi.nlp.core.AnnotationDefinition;
import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.Interval1D;
import edu.utah.bmi.nlp.core.IntervalST;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.sql.RecordRow;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Logger;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.factory.AnnotationFactory;
import org.apache.uima.fit.util.FSUtil;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.Annotation_Type;

public class AnnotationOper {
    public static Logger logger = IOUtil.getLogger(AnnotationOper.class);

    public static IntervalST<Annotation> indexAnnotation(JCas jcas, int typeId) {
        AnnotationIndex annoIndex = jcas.getAnnotationIndex(typeId);
        FSIterator annoIter = annoIndex.iterator();
        IntervalST<Annotation> index = new IntervalST<Annotation>();
        while (annoIter.hasNext()) {
            Annotation annotation = (Annotation)annoIter.next();
            index.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), annotation);
        }
        return index;
    }

    public static IntervalST<Integer> indexAnnotation(JCas jcas, int typeId, ArrayList<Annotation> annotations) {
        AnnotationIndex annoIndex = jcas.getAnnotationIndex(typeId);
        FSIterator annoIter = annoIndex.iterator();
        IntervalST<Integer> index = new IntervalST<Integer>();
        int i = 0;
        while (annoIter.hasNext()) {
            Annotation annotation = (Annotation)annoIter.next();
            annotations.add(annotation);
            index.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), i);
            ++i;
        }
        return index;
    }

    public static IntervalST<Annotation> indexAnnotation(JCas jcas, Class<? extends Annotation> type) {
        Iterator<? extends Annotation> annotationIter = JCasUtil.iterator(jcas, type);
        IntervalST<Annotation> index = new IntervalST<Annotation>();
        while (annotationIter.hasNext()) {
            Annotation annotation = type.cast(annotationIter.next());
            index.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), annotation);
        }
        return index;
    }

    public static IntervalST<Integer> indexAnnotation(JCas jcas, Class<? extends Annotation> type, ArrayList<Annotation> annotations) {
        Iterator<? extends Annotation> annotationIter = JCasUtil.iterator(jcas, type);
        IntervalST<Integer> index = new IntervalST<Integer>();
        int i = 0;
        while (annotationIter.hasNext()) {
            Annotation annotation = type.cast(annotationIter.next());
            annotations.add(annotation);
            index.put(new Interval1D(annotation.getBegin(), annotation.getEnd()), i);
            ++i;
        }
        return index;
    }

    public static void buildAnnoMap(ArrayList<Annotation> parents, ArrayList<Annotation> children, TreeMap<Integer, TreeSet<Integer>> parent2ChildrenMap) {
        int parentPointer = 0;
        for (int i = 0; i < children.size(); ++i) {
            Annotation thisChild = children.get(i);
            if (parentPointer >= parents.size()) break;
            Annotation thisParent = parents.get(parentPointer);
            if (thisChild.getBegin() >= thisParent.getBegin() && thisChild.getEnd() <= thisParent.getEnd()) {
                AnnotationOper.addAnnoMapValue(parent2ChildrenMap, parentPointer, i);
                continue;
            }
            if (thisChild.getBegin() < thisParent.getEnd() || parentPointer >= parents.size() - 1 || thisChild.getBegin() < parents.get(parentPointer + 1).getBegin()) continue;
            thisParent = parents.get(++parentPointer);
            AnnotationOper.addAnnoMapValue(parent2ChildrenMap, parentPointer, i);
        }
    }

    private static void addAnnoMapValue(TreeMap<Integer, TreeSet<Integer>> annoMap, int key, int value) {
        TreeSet<Integer> valueSet = new TreeSet<Integer>();
        if (annoMap.containsKey(key)) {
            valueSet = annoMap.get(key);
        }
        valueSet.add(value);
        annoMap.put(key, valueSet);
    }

    public static int getTypeId(Class typeClass) {
        int id = 0;
        if (typeClass == null) {
            logger.warning(typeClass.getCanonicalName() + " has not been initiated. Please check the definition in rule files.");
            return id;
        }
        try {
            id = typeClass.getField("type").getInt(null);
        }
        catch (IllegalAccessException e) {
            logger.fine(e.toString());
        }
        catch (NoSuchFieldException e) {
            logger.fine(e.toString());
        }
        return id;
    }

    public static int getTypeId(String typeFullName) {
        Class<? extends Annotation> typeClass = AnnotationOper.getTypeClass(typeFullName);
        return AnnotationOper.getTypeId(typeClass);
    }

    public static Class getClass(String typeFullName, Class superClass) {
        if (typeFullName.equals("uima.tcas.Annotation")) {
            return Annotation.class;
        }
        Class typeClass = null;
        try {
            typeClass = Class.forName(typeFullName).asSubclass(superClass);
            logger.finest(String.format("Load class %s from AppClassLoader", typeFullName));
        }
        catch (ClassNotFoundException e) {
            try {
                MemoryClassLoader loader = MemoryClassLoader.getInstance(MemoryClassLoader.CURRENT_LOADER_NAME);
                if (loader == null) {
                    return null;
                }
                Thread.currentThread().setContextClassLoader(loader);
                typeClass = loader.load(typeFullName);
                logger.finest(String.format("Load class %s from MemoryClassLoader", typeFullName));
            }
            catch (ClassNotFoundException ex) {
                logger.finest(e.toString());
            }
        }
        return typeClass;
    }

    public static Class<? extends Annotation_Type> get_TypeClass(String typeFullName) {
        return AnnotationOper.getClass(typeFullName, Annotation_Type.class);
    }

    public static Class<? extends Annotation> getTypeClass(String typeName) {
        return AnnotationOper.getTypeClass(typeName, Annotation.class, true);
    }

    public static Class<? extends Annotation> getTypeClass(String typeFullName, boolean checkDomain) {
        return AnnotationOper.getTypeClass(typeFullName, Annotation.class, checkDomain);
    }

    public static Class<? extends Annotation> getTypeClass(String typeFullName, Class superClass) {
        return AnnotationOper.getTypeClass(typeFullName, superClass, true);
    }

    public static Class<? extends Annotation> getTypeClass(String typeFullName, Class superClass, boolean checkDomain) {
        return AnnotationOper.getClass(DeterminantValueSet.checkNameSpace(typeFullName), superClass);
    }

    public static Class getUIMAClass(String typeFullName) {
        if (typeFullName.endsWith("_Type")) {
            return AnnotationOper.get_TypeClass(typeFullName);
        }
        return AnnotationOper.getTypeClass(typeFullName);
    }

    @Deprecated
    public static void setFeatureValue(Method method, Annotation annotation, String value) {
        try {
            method.invoke((Object)annotation, value);
        }
        catch (IllegalAccessException e) {
            logger.fine(e.toString());
        }
        catch (InvocationTargetException e) {
            logger.fine(e.toString());
        }
    }

    public static void setFeatureValue(String featureName, Annotation annotation, String value) {
        FSUtil.setFeature((FeatureStructure)annotation, featureName, value);
    }

    public static void setFeatureObjValue(String featureName, Annotation annotation, Object value) {
        String valueType;
        switch (valueType = value.getClass().getSimpleName()) {
            case "Integer": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (Integer)value);
                break;
            }
            case "String": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (String)value);
                break;
            }
            case "Boolean": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (Boolean)value);
                break;
            }
            case "Double": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (Double)value);
                break;
            }
            case "Float": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, ((Float)value).floatValue());
                break;
            }
            case "Collection": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (Collection)value);
                break;
            }
            case "Long": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (Long)value);
                break;
            }
            case "Short": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (Short)value);
                break;
            }
            case "FeatureStructrue": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (FeatureStructure)value);
                break;
            }
            case "Byte": {
                FSUtil.setFeature((FeatureStructure)annotation, featureName, (Byte)value);
                break;
            }
            default: {
                logger.warning(String.format("%s is not a supported Type %s", value, valueType));
            }
        }
    }

    @Deprecated
    public static void setFeatureObjValue(Method method, Annotation annotation, Object value) {
        try {
            method.invoke((Object)annotation, value);
        }
        catch (IllegalAccessException e) {
            logger.fine(e.toString());
        }
        catch (InvocationTargetException e) {
            logger.fine(e.toString());
        }
    }

    public static String inferMethodName(String featureName, String prefix) {
        String methodName = "";
        methodName = featureName.trim().length() == 0 ? "" : (featureName.startsWith(prefix) ? featureName : (Character.isUpperCase(featureName.charAt(0)) ? prefix + featureName : prefix + Character.toUpperCase(featureName.charAt(0)) + featureName.substring(1)));
        return methodName;
    }

    public static String inferSetMethodName(String featureName) {
        return AnnotationOper.inferMethodName(featureName, "set");
    }

    public static String inferGetMethodName(String featureName) {
        return AnnotationOper.inferMethodName(featureName, "get");
    }

    @Deprecated
    public static Object getFeatureValue(Method method, Annotation annotation) {
        Object output = null;
        try {
            output = method.invoke((Object)annotation, new Object[0]);
        }
        catch (IllegalAccessException e) {
            logger.fine(e.toString());
        }
        catch (InvocationTargetException e) {
            logger.fine(e.toString());
        }
        return output;
    }

    public static Object getFeatureValue(String featureName, Annotation annotation) {
        Feature f = annotation.getType().getFeatureByBaseName(featureName);
        if (f == null) {
            logger.info("Feature: " + featureName + " doesn't exists in annotation: " + annotation.getType());
            return null;
        }
        Object value = FSUtil.getFeature((FeatureStructure)annotation, f, Object.class);
        return value;
    }

    @Deprecated
    public static void getMethods(Class c, LinkedHashSet<Method> methods) {
        if (c.getSimpleName().equals("Annotation")) {
            return;
        }
        for (Method method : c.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || methodName.equals("getTypeIndexID") || method.getParameterCount() != 0) continue;
            methods.add(method);
        }
        AnnotationOper.getMethods(c.getSuperclass(), methods);
    }

    public static Method getMethod(Class cls, String methodName, Class<?> ... paraTypes) {
        Method m3 = null;
        try {
            m3 = cls.getMethod(methodName, paraTypes);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return m3;
    }

    public static Method getDefaultGetMethod(Class cls, String methodName) {
        methodName = AnnotationOper.inferGetMethodName(methodName);
        return AnnotationOper.getMethod(cls, methodName, new Class[0]);
    }

    public static Method getDefaultSetMethod(Class cls, String methodName) {
        if ((methodName = AnnotationOper.inferSetMethodName(methodName)).length() < 3) {
            logger.warning("Method name: '" + methodName + "' could be wrong");
            return null;
        }
        Method getMethod = AnnotationOper.getDefaultGetMethod(cls, methodName.substring(3));
        if (getMethod == null) {
            return null;
        }
        return AnnotationOper.getMethod(cls, methodName, getMethod.getReturnType());
    }

    public static void initGetReflections(HashMap<String, HashMap<String, Method>> evidenceConceptGetFeatures, String evidenceTypeShortName, Class evidenceTypeClass, String[] featureValueMatchRule, ArrayList<String> needEvidenceFeatures) {
        Method m3;
        if (!evidenceConceptGetFeatures.containsKey(evidenceTypeShortName)) {
            evidenceConceptGetFeatures.put(evidenceTypeShortName, new HashMap());
        }
        HashMap<String, Method> methods = evidenceConceptGetFeatures.get(evidenceTypeShortName);
        for (int i = 0; i < featureValueMatchRule.length - 1; i += 2) {
            String featureName = featureValueMatchRule[i];
            if (featureName == null) {
                System.out.println(Arrays.asList(featureValueMatchRule));
            }
            if (featureName.indexOf(":") != -1) {
                featureName = featureName.split(":")[0].trim();
            }
            if (methods.containsKey(featureName) || (m3 = AnnotationOper.getFeatureMethod(evidenceTypeClass, featureName)) == null) continue;
            methods.put(featureName, m3);
        }
        for (String featureName : needEvidenceFeatures) {
            if (featureName.indexOf(":") != -1) {
                featureName = featureName.split(":")[0].trim();
            }
            if (methods.containsKey(featureName)) continue;
            m3 = AnnotationOper.getFeatureMethod(evidenceTypeClass, featureName);
            if (m3 != null) {
                methods.put(featureName, m3);
            }
            methods.put(featureName, m3);
        }
    }

    public static Method getFeatureMethod(Class evidenceTypeClass, String featureName) {
        Method m3 = null;
        try {
            m3 = evidenceTypeClass.getMethod(AnnotationOper.inferGetMethodName(featureName), new Class[0]);
        }
        catch (Exception e) {
            logger.fine(e.toString());
        }
        return m3;
    }

    public static void initSetReflections(LinkedHashMap<String, TypeDefinition> typeDefinitions, HashMap<String, Class<? extends Annotation>> conceptClassMap, HashMap<String, Constructor<? extends Annotation>> conceptTypeConstructors, HashMap<Class, HashMap<String, Method>> conclusionConceptSetFeatures) {
        for (TypeDefinition typeDefinition : typeDefinitions.values()) {
            try {
                String shortTypeName = typeDefinition.shortTypeName;
                Class<? extends Annotation> typeClass = AnnotationOper.getTypeClass(typeDefinition.fullTypeName);
                if (typeClass == null) {
                    logger.warning(typeDefinition.shortTypeName + " has not been initiated. Please check the definition in rule files.");
                    continue;
                }
                conceptClassMap.put(shortTypeName, typeClass);
                conceptTypeConstructors.put(shortTypeName, typeClass.getConstructor(JCas.class, Integer.TYPE, Integer.TYPE));
                if (!conclusionConceptSetFeatures.containsKey(shortTypeName)) {
                    conclusionConceptSetFeatures.put(typeClass, new HashMap());
                }
                for (String featureName : typeDefinition.getNewFeatureNames()) {
                    if (featureName.indexOf(":") != -1) {
                        featureName = featureName.split(":")[0].trim();
                    }
                    String setMethodName = AnnotationOper.inferSetMethodName(featureName);
                    logger.fine("try set: " + typeClass.getCanonicalName() + "\t" + setMethodName);
                    conclusionConceptSetFeatures.get(typeClass).put(featureName, AnnotationOper.getDefaultSetMethod(typeClass, setMethodName));
                }
            }
            catch (NoSuchMethodException e) {
                logger.fine(e.toString() + "\n\t" + typeDefinition);
            }
        }
    }

    public static AnnotationDefinition createConclusionAnnotationDefinition(AnnotationDefinition conclusionDefinition, HashMap<String, HashMap<String, Method>> evidenceConceptGetFeatures, HashMap<String, String> uniqueFeatureClassMap, List<Annotation> evidenceAnnotations, LinkedHashMap<String, TypeDefinition> typeDefinitions) {
        AnnotationDefinition conclusionAnnotatoinDef = conclusionDefinition.clone();
        String resultTypeShortName = conclusionDefinition.getShortTypeName();
        LinkedHashMap<String, Annotation> sortedEvidenceAnnotations = new LinkedHashMap<String, Annotation>();
        for (Annotation annotation : evidenceAnnotations) {
            sortedEvidenceAnnotations.put(annotation.getClass().getSimpleName(), annotation);
        }
        for (Map.Entry entry : conclusionDefinition.getFeatureValuePairs().entrySet()) {
            Object value;
            String featureName = (String)entry.getKey();
            if (featureName.indexOf(":") != -1) {
                featureName = featureName.split(":")[0].trim();
            }
            if ((value = entry.getValue()) instanceof String && ((String)value).length() == 0) {
                logger.info("Conclusion type '" + resultTypeShortName + "' feature '" + featureName + "' value is empty.");
                value = null;
            }
            try {
                HashMap<String, Method> evidenceFeatureMap;
                Method featureMethod;
                String evidenceClassName;
                Annotation evidenceAnnotation;
                if (value == null) {
                    if (evidenceAnnotations.size() == 0) {
                        logger.warning("Evidence annotation for conclusion: '" + resultTypeShortName + "' feature " + featureName + " is needed");
                        continue;
                    }
                    evidenceAnnotation = evidenceAnnotations.get(0);
                    evidenceClassName = evidenceAnnotation.getClass().getSimpleName();
                    featureMethod = null;
                    if (evidenceAnnotations.size() > 1) {
                        if (!uniqueFeatureClassMap.containsKey(featureName)) {
                            for (String className : sortedEvidenceAnnotations.keySet()) {
                                if (!evidenceConceptGetFeatures.get(className).containsKey(featureName)) continue;
                                if (uniqueFeatureClassMap.containsKey(featureName)) {
                                    logger.warning("Feature " + featureName + " is not unique in current evidences: " + sortedEvidenceAnnotations.keySet() + ". Only the 1st referenced Class will be used: " + uniqueFeatureClassMap.get(featureName));
                                    continue;
                                }
                                uniqueFeatureClassMap.put(featureName, className);
                            }
                        }
                        evidenceClassName = uniqueFeatureClassMap.get(featureName);
                        evidenceAnnotation = (Annotation)sortedEvidenceAnnotations.get(evidenceClassName);
                    }
                    evidenceFeatureMap = null;
                    if (evidenceConceptGetFeatures.containsKey(evidenceClassName)) {
                        evidenceFeatureMap = evidenceConceptGetFeatures.get(evidenceClassName);
                    } else {
                        Class<?> parentClass = evidenceAnnotation.getClass();
                        while (parentClass != null && parentClass != Annotation.class) {
                            if (!evidenceConceptGetFeatures.containsKey((parentClass = parentClass.getSuperclass()).getSimpleName())) continue;
                            evidenceFeatureMap = evidenceConceptGetFeatures.get(parentClass);
                            break;
                        }
                    }
                    if (evidenceFeatureMap == null) {
                        evidenceConceptGetFeatures.put(evidenceClassName, new HashMap());
                        evidenceFeatureMap = evidenceConceptGetFeatures.get(evidenceClassName);
                    }
                    if (evidenceFeatureMap.containsKey(featureName) && evidenceFeatureMap.get(featureName) != null) {
                        featureMethod = evidenceFeatureMap.get(featureName);
                    }
                    if (featureMethod == null) {
                        featureMethod = AnnotationOper.getDefaultGetMethod(evidenceAnnotation.getClass(), featureName);
                    }
                    if (featureMethod != null) {
                        value = featureMethod.invoke((Object)evidenceAnnotation, new Object[0]);
                    } else {
                        logger.fine(evidenceClassName + " doesn't have the feature: " + featureName);
                    }
                } else if (value instanceof String && Character.isUpperCase(((String)value).charAt(0)) && (evidenceAnnotation = (Annotation)sortedEvidenceAnnotations.get(evidenceClassName = (String)value)) != null) {
                    featureMethod = null;
                    evidenceFeatureMap = evidenceConceptGetFeatures.get(evidenceClassName);
                    if (evidenceFeatureMap.containsKey(featureName) && evidenceFeatureMap.get(featureName) != null) {
                        featureMethod = evidenceFeatureMap.get(featureName);
                    } else {
                        featureMethod = AnnotationOper.getDefaultGetMethod(evidenceAnnotation.getClass(), featureName);
                        evidenceFeatureMap.put(featureName, featureMethod);
                    }
                    value = featureMethod.invoke((Object)evidenceAnnotation, new Object[0]);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            if (value != null) {
                conclusionAnnotatoinDef.setFeatureValue(featureName, value);
                continue;
            }
            if (!typeDefinitions.containsKey(conclusionAnnotatoinDef.shortTypeName) || !typeDefinitions.get(conclusionAnnotatoinDef.getShortTypeName()).getFeatureValuePairs().containsKey(featureName)) continue;
            conclusionAnnotatoinDef.setFeatureValue(featureName, typeDefinitions.get(conclusionAnnotatoinDef.getShortTypeName()).getFeatureValuePairs().get(featureName));
        }
        return conclusionAnnotatoinDef;
    }

    public static Annotation createAnnotation(JCas jcas, AnnotationDefinition conclusionAnnotationDefinition, Class<? extends Annotation> annoClass, int begin, int end) {
        Annotation anno = AnnotationFactory.createAnnotation(jcas, begin, end, annoClass);
        for (Map.Entry<String, Object> featureValueEntry : conclusionAnnotationDefinition.getFullFeatureValuePairs().entrySet()) {
            Object value;
            String featureName = featureValueEntry.getKey();
            if (featureName.indexOf(":") != -1) {
                featureName = featureName.split(":")[0].trim();
            }
            if ((value = featureValueEntry.getValue()) == null) continue;
            String type = value.getClass().getSimpleName();
            try {
                switch (type) {
                    case "int": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (Integer)value);
                        break;
                    }
                    case "String": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (String)value);
                        break;
                    }
                    case "boolean": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (Boolean)value);
                        break;
                    }
                    case "long": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (Long)value);
                        break;
                    }
                    case "short": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (Short)value);
                        break;
                    }
                    case "double": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (Double)value);
                        break;
                    }
                    case "float": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, ((Float)value).floatValue());
                        break;
                    }
                    case "FeatureStructure": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (FeatureStructure)value);
                        break;
                    }
                    case "Collection": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (Collection)value);
                        break;
                    }
                    case "byte": {
                        FSUtil.setFeature((FeatureStructure)anno, featureName, (Byte)value);
                    }
                }
            }
            catch (Exception e) {
                logger.info(e.toString());
            }
        }
        return anno;
    }

    @Deprecated
    public static Annotation createAnnotation(JCas jcas, AnnotationDefinition conclusionAnnotationDefinition, Constructor<? extends Annotation> annoConstructor, int begin, int end, HashMap<String, Method> conclusionSetFeatureMethods) {
        Annotation anno = null;
        try {
            anno = annoConstructor.newInstance(jcas, begin, end);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        for (Map.Entry<String, Object> featureValueEntry : conclusionAnnotationDefinition.getFullFeatureValuePairs().entrySet()) {
            String featureName = featureValueEntry.getKey();
            if (featureName.indexOf(":") != -1) {
                featureName = featureName.split(":")[0].trim();
            }
            Object value = featureValueEntry.getValue();
            Method setMethod = conclusionSetFeatureMethods.get(featureName);
            try {
                if (setMethod == null) {
                    logger.fine(anno + " doesn't initiate the set method for: " + featureName);
                    setMethod = AnnotationOper.getDefaultSetMethod(anno.getClass(), featureName);
                    if (setMethod == null) {
                        logger.info("the type: " + anno.getType() + "'s method:\t'" + featureName + "' has not be set up in rules.\t\n Fail to set the value: '" + value + "' for this method.");
                    } else {
                        conclusionSetFeatureMethods.put(featureName, setMethod);
                    }
                }
                setMethod.invoke((Object)anno, value);
            }
            catch (Exception e) {
                logger.warning("When trying to set value: '" + value + "' to the method:" + featureName + "' of annotation: '" + anno.getType().getShortName() + "', throw error: ");
                e.printStackTrace();
            }
        }
        return anno;
    }

    private static LinkedHashSet<Method> retrieveMethods(Class<? extends Annotation> aClass, LinkedHashMap<Class, LinkedHashSet<Method>> typeMethods) {
        if (typeMethods.containsKey(aClass)) {
            return typeMethods.get(aClass);
        }
        Class<? extends Annotation> superClass = aClass.getSuperclass();
        while (!typeMethods.containsKey(superClass)) {
            if (!superClass.equals(Annotation.class)) continue;
            return null;
        }
        typeMethods.put(aClass, typeMethods.get(superClass));
        return typeMethods.get(superClass);
    }

    public static RecordRow deserializeDocSrcInfor(JCas jCas) {
        RecordRow recordRow = new RecordRow();
        FSIterator it = jCas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        if (it.hasNext()) {
            SourceDocumentInformation e = (SourceDocumentInformation)it.next();
            String serializedString = e.getUri();
            recordRow.deserialize(serializedString);
        }
        return recordRow;
    }

    public static boolean classLoaded(String className) {
        return AnnotationOper.getTypeClass(className) != null;
    }
}

