/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.common;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import org.apache.uima.jcas.tcas.Annotation;

public class UIMATypeFunctions {
    private static final HashSet<String> baseMethods = new HashSet<String>(Arrays.asList("TypeIndexID", "Sofa", "CASImpl", "LowLevelCas", "CAS", "Address", "Type", "Class", "View", "avoidcollisionTypeCode", "Begin", "Start", "End", "CoveredText", "Text"));
    public static Logger logger = IOUtil.getLogger(UIMATypeFunctions.class);

    @Deprecated
    public static boolean classLoaded(String className) {
        return AnnotationOper.classLoaded(className);
    }

    public static HashMap<String, String> getMethodUIMATypesFromLoadedClass(String evidenceTypeName) {
        HashMap<String, String> methodTypes = UIMATypeFunctions.getMethodTypesFromLoadedClass(evidenceTypeName);
        for (String methodName : methodTypes.keySet()) {
            String type = methodTypes.get(methodName);
            if (type.startsWith("java.lang.")) {
                type = "uima.cas." + type.substring(10);
            }
            methodTypes.put(methodName, type);
        }
        return methodTypes;
    }

    public static HashMap<String, String> getMethodTypesFromLoadedClass(String evidenceTypeName) {
        LinkedHashMap<String, String> methodTypes = new LinkedHashMap<String, String>();
        Class<? extends Annotation> evidenceTypeClass = AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(evidenceTypeName));
        if (evidenceTypeClass != null) {
            for (Method method : evidenceTypeClass.getMethods()) {
                if (!method.getName().startsWith("get") || method.getParameterCount() != 0) continue;
                String type = method.getReturnType().getCanonicalName();
                String featureName = method.getName().substring(3);
                if (baseMethods.contains(featureName)) continue;
                type = type.indexOf(".") == -1 ? "uima.cas." + type : type.replaceAll("org.apache.uima.jcas.cas", "uima.cas");
                methodTypes.put(featureName, type);
            }
        } else {
            logger.fine("Class: " + DeterminantValueSet.checkNameSpace(evidenceTypeName) + " has not been loaded yet. Skip initiate getMethods.");
        }
        return methodTypes;
    }

    public static void getTypeDefinitions(String ruleStr, ArrayList<ArrayList<String>> ruleCells, HashMap<String, String> valueFeatureMap, HashMap<String, Integer> valueWeightMap, HashMap<String, String> defaultDocMap, LinkedHashMap<String, TypeDefinition> typeDefinitions) {
        IOUtil ioUtil = new IOUtil(ruleStr, true);
        UIMATypeFunctions.getTypeDefinitions(ioUtil, ruleCells, valueFeatureMap, valueWeightMap, defaultDocMap, typeDefinitions);
    }

    public static void getTypeDefinitions(IOUtil ioUtil, ArrayList<ArrayList<String>> ruleCells, HashMap<String, String> valueFeatureMap, HashMap<String, Integer> valueWeightMap, HashMap<String, String> defaultTypeMap, LinkedHashMap<String, TypeDefinition> typeDefinitions) {
        ruleCells.addAll(ioUtil.getRuleCells());
        HashMap<String, String> featureNameTypes = new HashMap<String, String>();
        LinkedHashMap<String, String> featureDefaultValueMap = new LinkedHashMap<String, String>();
        ArrayList<String> newTypes = new ArrayList<String>();
        block18: for (ArrayList<String> initRow : ioUtil.getInitiations()) {
            String header = initRow.get(1).trim();
            switch (header) {
                case "@FEATURE_VALUES": 
                case "&FEATURE_VALUES": {
                    String featureName = initRow.get(2);
                    if (featureName.indexOf(":") != -1) {
                        int separator = featureName.indexOf(":");
                        featureNameTypes.put(featureName.substring(0, separator).trim(), featureName.substring(separator + 1));
                    }
                    for (int i = 3; i < initRow.size(); ++i) {
                        String value = initRow.get(i).trim();
                        if (value.length() == 0) continue;
                        if (valueFeatureMap.containsKey(value)) {
                            logger.info("You have more than one features have the value: " + value + ". You won't be able to use the value alone to define the conditions.Instead, you will need to use 'FeatureName:value' format.");
                            continue;
                        }
                        valueFeatureMap.put(value, featureName);
                        valueWeightMap.put(value, i - 3);
                        if (i != 3) continue;
                        featureDefaultValueMap.put(featureName, value);
                    }
                    continue block18;
                }
                case "@CONCEPT_FEATURES": 
                case "&CONCEPT_FEATURES": {
                    String[] featureValuePair;
                    int i;
                    String conclusionTypeName = initRow.get(2).trim();
                    String superTypeName = initRow.get(3);
                    TypeDefinition typeDefinition = new TypeDefinition(conclusionTypeName, superTypeName, new ArrayList<String>());
                    if (initRow.size() > 4) {
                        for (i = 4; i < initRow.size(); ++i) {
                            featureValuePair = initRow.get(i).split(":");
                            if (featureValuePair.length == 1 || featureValuePair[1].trim().length() == 0) {
                                typeDefinition.addFeatureDefaultValue(featureValuePair[0].trim(), null);
                                continue;
                            }
                            typeDefinition.addFeatureDefaultValue(featureValuePair[0].trim(), featureValuePair[1].trim());
                        }
                    }
                    typeDefinitions.put(typeDefinition.shortTypeName, typeDefinition);
                    newTypes.add(typeDefinition.shortTypeName);
                    break;
                }
                case "@DEFAULT_DOC_TYPE": 
                case "&DEFAULT_DOC_TYPE": 
                case "@DEFAULT_BUNCH_TYPE": 
                case "&DEFAULT_BUNCH_TYPE": {
                    defaultTypeMap.put(initRow.get(2).trim(), initRow.get(3).trim());
                    break;
                }
                case "@RELATION_DEFINITION": 
                case "&RELATION_DEFINITION": {
                    break;
                }
                default: {
                    String[] featureValuePair;
                    int i;
                    String conclusionTypeName = initRow.get(1).substring(1);
                    if (conclusionTypeName.toLowerCase().endsWith("_doc")) {
                        defaultTypeMap.put(conclusionTypeName, initRow.get(2).trim());
                        continue block18;
                    }
                    String superTypeName = initRow.get(2);
                    TypeDefinition typeDefinition = new TypeDefinition(conclusionTypeName, superTypeName, new ArrayList<String>());
                    if (initRow.size() > 3) {
                        for (i = 3; i < initRow.size(); ++i) {
                            featureValuePair = initRow.get(i).split(":");
                            if (featureValuePair[0].startsWith("COPYALL")) {
                                logger.info("You need to define the Concept '" + conclusionTypeName + "' first before using 'COPYALL' or 'COPYALLEXCEPT' syntax.");
                                logger.info("For instance: @Negated_PE\tConcept\tSection:DocumentAnnotation\nThis rule define a 'Negated_PE' concept derived from 'Concept' type, and has one feature 'Section', with default value 'DocumentAnnotation'");
                            }
                            if (featureValuePair.length == 1 || featureValuePair[1].trim().length() == 0) {
                                typeDefinition.addFeatureDefaultValue(featureValuePair[0].trim(), null);
                                continue;
                            }
                            typeDefinition.addFeatureDefaultValue(featureValuePair[0].trim(), featureValuePair[1].trim());
                        }
                    }
                    typeDefinitions.put(typeDefinition.shortTypeName, typeDefinition);
                }
            }
        }
        for (String typeName : newTypes) {
            TypeDefinition typeDefinition = typeDefinitions.get(typeName);
            for (String featureName : typeDefinition.getFeatureValuePairs().keySet()) {
                if (featureNameTypes.containsKey(featureName)) {
                    typeDefinition.setFeatureType(featureName, (String)featureNameTypes.get(featureName));
                }
                if (!featureDefaultValueMap.containsKey(featureName) || typeDefinition.getFeatureValuePairs().containsKey(featureName)) continue;
                typeDefinition.addFeatureDefaultValue(featureName, (String)featureDefaultValueMap.get(featureName));
            }
        }
    }

    public HashMap<String, String> getMethodTypes(String evidenceTypeName, LinkedHashMap<String, TypeDefinition> typeDefinitions) {
        if (typeDefinitions.containsKey(evidenceTypeName)) {
            return typeDefinitions.get((Object)evidenceTypeName).featureTypes;
        }
        HashMap<String, String> methodTypes = UIMATypeFunctions.getMethodTypesFromLoadedClass(evidenceTypeName);
        return methodTypes;
    }
}

