/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.loggers;

import edu.utah.bmi.nlp.uima.loggers.UIMALogger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.EntityProcessStatus;

public class ConsoleLogger
implements UIMALogger {
    public static Logger syslogger = Logger.getLogger(UIMALogger.class.getCanonicalName());
    protected long startTime = 0L;
    protected long initCompleteTime = 0L;
    protected long completeTime = 0L;
    protected int totaldocs = -1;
    protected long size = 0L;
    protected int entityCount = 0;
    protected LinkedHashMap<String, Object> loggedItems = new LinkedHashMap();
    protected String unit = "docs";
    protected boolean report = true;
    protected DateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");

    @Override
    public void reset() {
        this.entityCount = 0;
        this.loggedItems.clear();
    }

    @Override
    public void setItem(String key, Object value) {
        this.loggedItems.put(key, value);
    }

    @Override
    public void logStartTime() {
        this.startTime = System.currentTimeMillis();
        this.entityCount = 0;
    }

    @Override
    public void logCompleteTime() {
        this.completeTime = System.currentTimeMillis();
    }

    @Override
    public long getStarttime() {
        return this.startTime;
    }

    @Override
    public long getCompletetime() {
        return this.completeTime;
    }

    @Override
    public String logItems() {
        StringBuilder logs = new StringBuilder();
        for (Map.Entry<String, Object> item : this.loggedItems.entrySet()) {
            logs.append(item.getKey());
            logs.append("\n");
            logs.append(item.getValue());
            logs.append("\n\n");
        }
        this.logString(logs.toString());
        return logs.toString();
    }

    @Override
    public Object getRunid() {
        return -1;
    }

    @Override
    public void logString(String msg) {
        syslogger.fine(msg);
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public void initializationComplete(int totalDocs) {
        this.logString("Initialization complete. Total " + totalDocs + " documents to process.");
        this.initCompleteTime = System.currentTimeMillis();
        this.logString(this.df.format(new Date()) + "\tCPM Initialization Complete");
        this.totaldocs = totalDocs;
    }

    @Override
    public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        if (aStatus.isException()) {
            List<Exception> ex = aStatus.getExceptions();
            this.displayError(ex.get(0));
        } else {
            ++this.entityCount;
        }
    }

    @Override
    public void batchProcessComplete() {
    }

    @Override
    public void collectionProcessComplete(String reportContent) {
        this.logCompleteTime();
        long initTime = this.initCompleteTime - this.startTime;
        long processingTime = this.completeTime - this.initCompleteTime;
        long elapsedTime = initTime + processingTime;
        StringBuilder report = new StringBuilder();
        report.append(this.entityCount + " notes\n");
        if (this.size > 0L) {
            report.append(this.size + " characters\n");
        }
        report.append("Total:\t" + elapsedTime + " ms\n");
        report.append("Initialization:\t" + initTime + " ms\n");
        report.append("Processing:\t" + processingTime + " ms\n");
        report.append(reportContent);
        this.logString(report.toString());
    }

    @Override
    public void paused() {
        this.logString("StatusCallbackListenerImpl::paused()");
    }

    @Override
    public void resumed() {
        this.logString("StatusCallbackListenerImpl::resumed");
    }

    @Override
    public void aborted() {
        this.logString("StatusCallbackListenerImpl::aborted");
    }

    public void setReportable(boolean report) {
        this.report = report;
    }

    public boolean reportable() {
        return this.report;
    }

    @Override
    public String getItem(String key) {
        if (this.loggedItems.containsKey(key)) {
            return this.loggedItems.get(key).toString();
        }
        return "";
    }

    public void displayError(Throwable aThrowable) {
        aThrowable.printStackTrace();
        String message = aThrowable.toString();
        while (aThrowable instanceof UIMAException || aThrowable instanceof UIMARuntimeException) {
            if (aThrowable instanceof UIMAException) {
                aThrowable = aThrowable.getCause();
            } else if (aThrowable instanceof UIMARuntimeException) {
                aThrowable = aThrowable.getCause();
            }
            if (aThrowable == null) continue;
            message = message + "\nCausedBy: " + aThrowable.toString();
        }
        this.logString(message);
    }
}

