/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.reader;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.type.system.Concept;
import edu.utah.bmi.nlp.type.system.Doc_Base;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.reader.AbFileCollectionReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class BratReader
extends AbFileCollectionReader {
    public static Logger logger = IOUtil.getLogger(BratReader.class);
    public static final String PARAM_READ_TYPES = "ReadTypes";
    protected HashMap<Class, HashMap<String, Method>> typeSetMethods = new HashMap();
    protected HashMap<String, Constructor<? extends Annotation>> typeConstructors = new HashMap();
    protected HashMap<String, Class<? extends Annotation>> typeClasses = new HashMap();
    protected int id = 0;
    protected static final String beginOffset = "<begin>";
    protected static final String endOffset = "<end>";
    protected static final String typeName = "<typeName>";
    private String readTypes = "";
    private LinkedHashMap<String, String> unconfiguredAnnotationTypes = new LinkedHashMap();
    private String currentFileName = "";

    @Override
    public void initialize() throws ResourceInitializationException {
        File directory = new File(((String)this.getConfigParameterValue("InputDirectory")).trim());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{"InputDirectory", this.getMetaData().getName(), directory.getPath()});
        }
        this.overWriteAnnotatorName = "brat";
        Object para = this.getConfigParameterValue("OverWriteAnnotatorName");
        if (para != null && para instanceof String && ((String)para).trim().length() > 0) {
            this.overWriteAnnotatorName = ((String)para).trim();
        }
        if ((para = this.getConfigParameterValue(PARAM_READ_TYPES)) != null && para instanceof String && ((String)para).trim().length() > 0) {
            this.readTypes = ((String)para).trim();
        }
        this.mRecursive = true;
        this.mFiles = new ArrayList<File>(FileUtils.listFiles(directory, new String[]{"txt"}, true));
        this.mCurrentIndex = 0;
        this.mEncoding = "UTF-8";
        LinkedHashMap<String, TypeDefinition> typeDefinitions = BratReader.getTypeDefinitionMap(directory.getAbsolutePath());
        AnnotationOper.initSetReflections(typeDefinitions, this.typeClasses, this.typeConstructors, this.typeSetMethods);
    }

    @Override
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException(e);
        }
        File file = (File)this.mFiles.get(this.mCurrentIndex++);
        this.currentFileName = file.getName();
        this.currentFileName = this.currentFileName.substring(0, this.currentFileName.length() - 4);
        String text = FileUtils.readFileToString(file, this.mEncoding);
        jcas.setDocumentText(text);
        if (this.mLanguage != null) {
            jcas.setDocumentLanguage(this.mLanguage);
        }
        File annotationFile = new File(file.getParentFile(), this.currentFileName + ".ann");
        List<String> annoContent = FileUtils.readLines(annotationFile, this.mEncoding);
        SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas);
        srcDocInfo.setUri(this.genURIStr(file));
        srcDocInfo.setOffsetInSource(0);
        srcDocInfo.setDocumentSize((int)file.length());
        srcDocInfo.setLastSegment(this.mCurrentIndex == this.mFiles.size());
        srcDocInfo.addToIndexes();
        this.parseAnn(jcas, text, annoContent);
        if (this.mCurrentIndex >= this.mFiles.size() && logger.isLoggable(Level.INFO)) {
            logger.info("The following types are not configured in Brat annotation.conf files");
            for (String type : this.unconfiguredAnnotationTypes.keySet()) {
                logger.info(type + "\t" + this.unconfiguredAnnotationTypes.get(type));
            }
        }
    }

    public void parseAnn(JCas jcas, String txtContent, List<String> annoContent) {
        LinkedHashMap annotations = new LinkedHashMap();
        block8: for (int i = 0; i < annoContent.size(); ++i) {
            String line = annoContent.get(i);
            String[] elements = line.split("\\t");
            switch (line.charAt(0)) {
                case 'T': {
                    annotations.put(elements[0], new LinkedHashMap());
                    String[] properties = elements[1].split("\\s+");
                    ((LinkedHashMap)annotations.get(elements[0])).put(typeName, properties[0]);
                    ((LinkedHashMap)annotations.get(elements[0])).put(beginOffset, properties[1]);
                    if (properties[2].indexOf(";") > 0) {
                        ((LinkedHashMap)annotations.get(elements[0])).put(endOffset, properties[3]);
                        continue block8;
                    }
                    ((LinkedHashMap)annotations.get(elements[0])).put(endOffset, properties[2]);
                    continue block8;
                }
                case 'A': {
                    String[] linkage = elements[1].split("\\s+");
                    if (!annotations.containsKey(linkage[1])) {
                        if (i >= annoContent.size() - 1) continue block8;
                        annoContent.add(line);
                        continue block8;
                    }
                    ((LinkedHashMap)annotations.get(linkage[1])).put(linkage[0], linkage[2]);
                }
            }
        }
        for (LinkedHashMap annotation : annotations.values()) {
            String type = (String)annotation.get(typeName);
            annotation.remove(typeName);
            try {
                this.addAnnotation(jcas, type, annotation);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    protected void addAnnotation(JCas jcas, String typeName, LinkedHashMap<String, String> attributes) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        typeName = DeterminantValueSet.checkNameSpace(typeName);
        int begin = Integer.parseInt(attributes.get(beginOffset));
        int end = Integer.parseInt(attributes.get(endOffset));
        attributes.remove(beginOffset);
        attributes.remove(endOffset);
        if (!this.typeClasses.containsKey(typeName)) {
            this.unconfiguredAnnotationTypes.put(typeName, this.currentFileName);
            return;
        }
        Annotation annotation = this.typeConstructors.get(typeName).newInstance(jcas);
        annotation.setBegin(begin);
        annotation.setEnd(end);
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String featureName = attribute.getKey();
            String value = attribute.getValue();
            String methodName = "set" + featureName.substring(0, 1).toUpperCase() + featureName.substring(1);
            if (this.typeClasses.containsKey(typeName) && this.typeSetMethods.get(typeName).containsKey(methodName)) {
                Method featureMethod = this.typeSetMethods.get(this.typeClasses.get(typeName)).get(methodName);
                featureMethod.invoke((Object)annotation, value);
                continue;
            }
            logger.info(methodName + "doesn't exist in " + typeName);
        }
        annotation.addToIndexes();
    }

    @Override
    public void close() {
    }

    public static LinkedHashMap<String, TypeDefinition> getTypeDefinitionMap(String projectDir) {
        File inputDir = new File(projectDir);
        if (!inputDir.exists() || inputDir.isFile()) {
            logger.warning("Project Directory " + projectDir + " does not exist.");
            return null;
        }
        LinkedHashMap<String, TypeDefinition> typeDefinitions = new LinkedHashMap<String, TypeDefinition>();
        for (Map.Entry<String, HashSet<String>> entry : BratReader.readBratTypes(inputDir).entrySet()) {
            if (entry.getKey().toLowerCase().endsWith("_doc")) {
                typeDefinitions.put(entry.getKey(), new TypeDefinition(entry.getKey(), Doc_Base.class.getCanonicalName(), (Set<String>)entry.getValue()));
                continue;
            }
            typeDefinitions.put(entry.getKey(), new TypeDefinition(entry.getKey(), Concept.class.getCanonicalName(), (Set<String>)entry.getValue()));
        }
        return typeDefinitions;
    }

    public static Collection<TypeDefinition> getTypeDefinitions(String projectDir) {
        LinkedHashMap<String, TypeDefinition> typeDefinitions = BratReader.getTypeDefinitionMap(projectDir);
        return typeDefinitions.values();
    }

    protected static LinkedHashMap<String, HashSet<String>> readBratTypes(File inputDirectory) {
        Collection<File> schemaFiles = FileUtils.listFiles(inputDirectory, new NameFileFilter("annotation.conf"), TrueFileFilter.INSTANCE);
        LinkedHashMap<String, HashSet<String>> types = new LinkedHashMap<String, HashSet<String>>();
        boolean typeReady = false;
        boolean attributeReady = false;
        for (File schemaFile : schemaFiles) {
            try {
                List<String> lines = FileUtils.readLines(schemaFile, StandardCharsets.UTF_8);
                for (String line : lines) {
                    if (line.trim().length() == 0 || line.charAt(0) == '#') continue;
                    if (line.startsWith("[en") || line.startsWith("[s")) {
                        typeReady = true;
                        continue;
                    }
                    if (line.startsWith("[a")) {
                        typeReady = false;
                        attributeReady = true;
                        continue;
                    }
                    if (line.charAt(0) == '[') {
                        attributeReady = false;
                        typeReady = false;
                        continue;
                    }
                    if (typeReady) {
                        types.put(line.trim(), new HashSet());
                        continue;
                    }
                    if (!attributeReady) continue;
                    String[] elements = line.split("\\s+");
                    String attributeName = elements[0];
                    elements[1] = elements[1].trim();
                    String typesString = elements[1].substring(4);
                    if (typesString.endsWith(",")) {
                        typesString = typesString.substring(0, typesString.length() - 1);
                    }
                    for (String type : typesString.split("\\|")) {
                        if (!types.containsKey(type)) {
                            types.put(type, new HashSet());
                        }
                        types.get(type).add(attributeName);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return types;
    }
}

