/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.reader;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.reader.AbFileCollectionReader;
import edu.utah.bmi.nlp.uima.reader.EhostXMLParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class EhostReader
extends AbFileCollectionReader {
    public static Logger logger = IOUtil.getLogger(EhostReader.class);
    public static final String PARAM_READ_TYPES = "ReadTypes";
    protected HashMap<Class, HashMap<String, Method>> typeSetMethods = new HashMap();
    protected HashMap<String, Constructor<? extends Annotation>> typeConstructors = new HashMap();
    protected HashMap<String, Class<? extends Annotation>> typeClasses = new HashMap();
    protected int id = 0;
    protected boolean print = false;
    private String readTypes = "";

    @Override
    public void initialize() throws ResourceInitializationException {
        File directory = new File(((String)this.getConfigParameterValue("InputDirectory")).trim());
        if (!directory.exists() || !directory.isDirectory()) {
            throw new ResourceInitializationException("directory_not_found", new Object[]{"InputDirectory", this.getMetaData().getName(), directory.getPath()});
        }
        this.overWriteAnnotatorName = "ehost";
        Object para = this.getConfigParameterValue("OverWriteAnnotatorName");
        if (para != null && para instanceof String && ((String)para).trim().length() > 0) {
            this.overWriteAnnotatorName = ((String)para).trim();
        }
        if ((para = this.getConfigParameterValue(PARAM_READ_TYPES)) != null && para instanceof String && ((String)para).trim().length() > 0) {
            this.readTypes = ((String)para).trim();
        }
        this.mRecursive = true;
        para = this.getConfigParameterValue("Print");
        if (para != null && para instanceof Boolean) {
            this.print = (Boolean)para;
        }
        this.mFiles = new ArrayList<File>(FileUtils.listFiles(directory, new String[]{"txt"}, true));
        this.mCurrentIndex = 0;
        this.mEncoding = "UTF-8";
        LinkedHashMap<String, TypeDefinition> typeDefinitions = EhostReader.getTypeDefinitionMap(directory.getAbsolutePath());
        AnnotationOper.initSetReflections(typeDefinitions, this.typeClasses, this.typeConstructors, this.typeSetMethods);
    }

    @Override
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException(e);
        }
        File file = (File)this.mFiles.get(this.mCurrentIndex++);
        logger.fine("Import annotations for file: " + file.getName() + "\t\t");
        String fileName = file.getName();
        String text = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        jcas.setDocumentText(text);
        if (this.mLanguage != null) {
            jcas.setDocumentLanguage(this.mLanguage);
        }
        File xmlFile = new File(file.getParentFile().getParentFile(), "saved/" + fileName + ".knowtator.xml");
        String xmlContent = FileUtils.readFileToString(xmlFile, this.mEncoding);
        SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas, 0, text.length());
        srcDocInfo.setUri(this.genURIStr(file));
        srcDocInfo.setOffsetInSource(0);
        srcDocInfo.setDocumentSize((int)file.length());
        srcDocInfo.setLastSegment(this.mCurrentIndex == this.mFiles.size());
        srcDocInfo.addToIndexes();
        this.parseXML(jcas, text, xmlContent, fileName);
        logger.fine("Success!");
    }

    public String readTextAsEhost(File file) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> contents = new ArrayList<String>();
        try {
            BufferedReader f = new BufferedReader(new FileReader(file));
            String line = f.readLine();
            while (line != null) {
                contents.add(line);
                line = f.readLine();
            }
            f.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (String line : contents) {
            content.append(line + " ");
        }
        return content.toString();
    }

    public void parseXML(JCas jcas, String txtContent, String xmlContent, String docId) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlContent.getBytes());
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream);
            String featureName = "";
            String typeName = "";
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement()) continue;
                StartElement startElement = xmlEvent.asStartElement();
                switch (startElement.getName().getLocalPart()) {
                    case "annotator": {
                        xmlEvent = xmlEventReader.nextEvent();
                        if (this.overWriteAnnotatorName.length() > 0) {
                            attributes.put("Annotator", this.overWriteAnnotatorName);
                            break;
                        }
                        if (!xmlEvent.isCharacters()) break;
                        attributes.put("Annotator", xmlEvent.asCharacters().getData());
                        break;
                    }
                    case "span": {
                        Attribute endAttr;
                        Attribute beginAttr = startElement.getAttributeByName(new QName("start"));
                        if (beginAttr != null) {
                            attributes.put("Begin", beginAttr.getValue());
                        }
                        if ((endAttr = startElement.getAttributeByName(new QName("end"))) == null) break;
                        attributes.put("End", endAttr.getValue());
                        break;
                    }
                    case "spannedText": {
                        xmlEvent = xmlEventReader.nextEvent();
                        if (!xmlEvent.isCharacters()) break;
                        attributes.put("Text", xmlEvent.asCharacters().getData());
                        break;
                    }
                    case "mentionSlot": {
                        Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                        if (idAttr == null) break;
                        featureName = idAttr.getValue();
                        break;
                    }
                    case "stringSlotMentionValue": {
                        Attribute valueAttr = startElement.getAttributeByName(new QName("value"));
                        if (valueAttr == null) break;
                        attributes.put(featureName, valueAttr.getValue());
                        break;
                    }
                    case "mentionClass": {
                        Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                        if (idAttr == null) break;
                        typeName = idAttr.getValue();
                        if (typeName.indexOf(" ") != -1) {
                            typeName = typeName.replaceAll(" +", "_");
                        }
                        try {
                            this.addAnnotation(jcas, typeName, attributes);
                            attributes.clear();
                            break;
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                            break;
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                            break;
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    protected void addAnnotation(JCas jcas, String typeName, LinkedHashMap<String, String> attributes) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        typeName = DeterminantValueSet.getShortName(typeName);
        int begin = Integer.parseInt(attributes.get("Begin"));
        int end = Integer.parseInt(attributes.get("End"));
        attributes.remove("Begin");
        attributes.remove("End");
        if (!this.typeClasses.containsKey(typeName)) {
            return;
        }
        Annotation annotation = this.typeConstructors.get(typeName).newInstance(jcas, begin, end);
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            String featureName = attribute.getKey();
            String value = attribute.getValue();
            String methodName = "set" + featureName.substring(0, 1).toUpperCase() + featureName.substring(1);
            if (this.typeClasses.containsKey(typeName) && this.typeSetMethods.get(this.typeClasses.get(typeName)).containsKey(methodName)) {
                Method featureMethod = this.typeSetMethods.get(this.typeClasses.get(typeName)).get(methodName);
                featureMethod.invoke((Object)annotation, value);
                continue;
            }
            logger.info(methodName + "  was defined in Java class name, but doesn't exist in Ehost annotation type " + typeName);
        }
        annotation.addToIndexes();
    }

    @Override
    public void close() {
    }

    public static LinkedHashMap<String, TypeDefinition> getTypeDefinitionMap(String projectDir) {
        LinkedHashMap<String, TypeDefinition> typeDefinition = new LinkedHashMap<String, TypeDefinition>();
        File inputDir = new File(projectDir);
        if (!inputDir.exists() || inputDir.isFile()) {
            System.err.println("Project Directory " + projectDir + " does not exist.");
            return null;
        }
        Collection<File> schemaFiles = FileUtils.listFiles(inputDir, new NameFileFilter("projectschema.xml"), TrueFileFilter.INSTANCE);
        for (File schemaFile : schemaFiles) {
            try {
                EhostXMLParser.getTypesFromSchema(typeDefinition, FileUtils.readFileToString(schemaFile, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return typeDefinition;
    }

    public static Collection<TypeDefinition> getTypeDefinitions(String projectDir) {
        LinkedHashMap<String, TypeDefinition> typeDefinition = EhostReader.getTypeDefinitionMap(projectDir);
        return typeDefinition.values();
    }
}

