/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.reader;

import edu.utah.bmi.nlp.core.TypeDefinition;
import edu.utah.bmi.nlp.type.system.Concept;
import edu.utah.bmi.nlp.type.system.Doc_Base;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class EhostXMLParser {
    public static void getTypes(HashMap<String, HashSet<String>> types, String xmlContent) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlContent.getBytes());
        HashSet<String> attributes = new HashSet<String>();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream);
            String featureName = "";
            String typeName = "";
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement()) continue;
                StartElement startElement = xmlEvent.asStartElement();
                switch (startElement.getName().getLocalPart()) {
                    case "annotator": {
                        xmlEvent = xmlEventReader.nextEvent();
                        attributes.add("Annotator");
                        break;
                    }
                    case "spannedText": {
                        xmlEvent = xmlEventReader.nextEvent();
                        attributes.add("Text");
                        break;
                    }
                    case "mentionSlot": {
                        Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                        if (idAttr == null) break;
                        attributes.add(idAttr.getValue());
                        break;
                    }
                    case "mentionClass": {
                        Attribute idAttr = startElement.getAttributeByName(new QName("id"));
                        if (idAttr == null) break;
                        typeName = idAttr.getValue();
                        if (typeName.indexOf(" ") != -1) {
                            typeName = typeName.replaceAll(" +", "_");
                        }
                        if (types.containsKey(typeName)) break;
                        types.put(typeName, (HashSet)attributes.clone());
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public static void getTypesFromSchema(LinkedHashMap<String, TypeDefinition> typeDefinitions, String xmlContent) {
        LinkedHashMap<String, HashSet<String>> types = new LinkedHashMap<String, HashSet<String>>();
        EhostXMLParser.getTypesFromSchema(types, xmlContent);
        for (Map.Entry<String, HashSet<String>> entry : types.entrySet()) {
            String typeName = entry.getKey().replaceAll(" +", "_");
            if (typeName.trim().length() == 0) continue;
            if (typeName.toLowerCase().endsWith("_doc")) {
                typeDefinitions.put(typeName, new TypeDefinition(typeName, Doc_Base.class.getCanonicalName(), (Set<String>)entry.getValue()));
                continue;
            }
            typeDefinitions.put(typeName, new TypeDefinition(typeName, Concept.class.getCanonicalName(), (Set<String>)entry.getValue()));
        }
    }

    public static void getTypesFromSchema(HashMap<String, HashSet<String>> types, String xmlContent) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xmlContent.getBytes());
        HashSet<String> attributes = new HashSet<String>();
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        LinkedHashSet methods = new LinkedHashSet();
        HashSet<String> commonAttribs = new HashSet<String>();
        for (Method method : methods) {
            commonAttribs.add(method.getName().substring(3));
        }
        try {
            XMLEventReader xmlEventReader = xmlInputFactory.createXMLEventReader(inputStream);
            String featureName = "";
            String typeName = "";
            boolean isClassName = false;
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement()) continue;
                StartElement startElement = xmlEvent.asStartElement();
                switch (startElement.getName().getLocalPart()) {
                    case "classDef": {
                        if (typeName.length() > 0 && !types.containsKey(typeName)) {
                            types.put(typeName, (HashSet)attributes.clone());
                            attributes.clear();
                        }
                        isClassName = true;
                        break;
                    }
                    case "Name": {
                        xmlEvent = xmlEventReader.nextEvent();
                        String name = "";
                        if (xmlEvent.isCharacters()) {
                            name = ((Characters)xmlEvent).getData();
                        }
                        if (isClassName) {
                            typeName = name;
                            break;
                        }
                        if (commonAttribs.contains(name)) break;
                        attributes.add(name);
                        break;
                    }
                    case "attributeDef": {
                        isClassName = false;
                    }
                }
            }
            types.put(typeName, (HashSet)attributes.clone());
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }
}

