/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.reader;

import edu.utah.bmi.nlp.sql.RecordRow;
import java.io.IOException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.component.initialize.ConfigurationParameterInitializer;
import org.apache.uima.fit.component.initialize.ExternalResourceInitializer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class StringMetaReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUT = "InputString";
    @ConfigurationParameter(name="InputString", mandatory=false, defaultValue={""}, description="A string as the input to be processed")
    protected String input;
    public static final String PARAM_META = "Meta";
    @ConfigurationParameter(name="Meta", mandatory=false, defaultValue={""}, description="A string that stores the meta data columns, where columns is separated by a pipe character(|); within each column, the column name and value are separated by comma(,).")
    protected String meta;
    public static final String PARAM_LANGUAGE = "Language";
    @ConfigurationParameter(name="Language", mandatory=false, defaultValue={"en"}, description="Name of optional configuration parameter that contains the language of the input string.")
    protected String mLanguage;
    protected int mCurrentIndex;

    @Override
    public void initialize() throws ResourceInitializationException {
        super.initialize();
        ConfigurationParameterInitializer.initialize((Object)this, this.getUimaContext());
        ExternalResourceInitializer.initialize(this, this.getUimaContext());
        this.mCurrentIndex = 0;
    }

    @Override
    public boolean hasNext() {
        return this.mCurrentIndex < 1;
    }

    @Override
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        RecordRow recordRow = new RecordRow();
        if (this.meta != null && this.meta.length() > 0) {
            for (String metaInfor : this.meta.split("\\|")) {
                String[] pair = metaInfor.split(",");
                recordRow.addCell(pair[0], pair[1]);
            }
        }
        String metaInfor = recordRow.serialize(new String[0]);
        JCas jcas = null;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException var6) {
            System.out.println(var6.toString());
        }
        jcas.setDocumentText(this.input);
        SourceDocumentInformation srcDocInfo = new SourceDocumentInformation(jcas, 0, this.input.length());
        srcDocInfo.setUri(metaInfor);
        srcDocInfo.setOffsetInSource(0);
        srcDocInfo.setDocumentSize(this.input.length());
        srcDocInfo.setLastSegment(true);
        srcDocInfo.addToIndexes();
        if (this.mLanguage != null) {
            jcas.setDocumentLanguage(this.mLanguage);
        }
        ++this.mCurrentIndex;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Progress[] getProgress() {
        return new Progress[]{new ProgressImpl(this.mCurrentIndex, 1, "entities")};
    }

    public int getNumberOfDocuments() {
        return 1;
    }
}

