/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.writer;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.common.BratOperator;
import edu.utah.bmi.nlp.uima.writer.XMIWritter_AE;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.uima.UimaContext;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class BratExporter_AE
extends XMIWritter_AE {
    private ArrayList<Class<? extends Annotation>> exportTypes = new ArrayList();
    private LinkedHashMap<Class, LinkedHashSet<Method>> typeMethods;
    private HashMap<String, HashSet<String>> attributeToConcepts;
    private HashMap<String, HashSet<String>> attributeToValues;
    public static String outputStr;
    public static final String PARAM_RULE_STR = "RuleFileOrStr";

    @Override
    public void initialize(UimaContext cont) {
        String ruleFileOrStr = BratExporter_AE.readConfigureString(cont, PARAM_RULE_STR, "");
        IOUtil ioUtils = new IOUtil(ruleFileOrStr);
        LinkedHashMap<String, ArrayList<String>> includeTypes = new LinkedHashMap<String, ArrayList<String>>();
        for (ArrayList<String> row : ioUtils.getRuleCells()) {
            includeTypes.put(row.get(1), new ArrayList());
            if (row.size() <= 2 || row.get(2) == null || row.get(2).trim().length() <= 1) continue;
            if (row.get(2).toLowerCase().equals("null")) {
                includeTypes.put(row.get(1), null);
                continue;
            }
            includeTypes.get(row.get(1)).addAll(Arrays.asList(row.get(2).trim().split("\\s*[,;\\|]\\s*")));
        }
        this.typeMethods = new LinkedHashMap();
        this.initGetMethods(includeTypes);
        this.attributeToConcepts = new HashMap();
        this.attributeToValues = new HashMap();
    }

    @Override
    public void process(JCas jCas) {
        outputStr = BratOperator.exportBrat(jCas, this.exportTypes, this.typeMethods, this.attributeToConcepts, this.attributeToValues);
    }

    private void initGetMethods(LinkedHashMap<String, ArrayList<String>> includeTypes) {
        for (Map.Entry<String, ArrayList<String>> typeFeaturePairs : includeTypes.entrySet()) {
            String typeName = DeterminantValueSet.checkNameSpace(typeFeaturePairs.getKey());
            ArrayList<String> featureNames = typeFeaturePairs.getValue();
            Class<? extends Annotation> cls = AnnotationOper.getTypeClass(typeName);
            this.exportTypes.add(cls);
            if (featureNames == null) {
                this.typeMethods.put(cls, new LinkedHashSet());
                continue;
            }
            if (featureNames.size() == 0) {
                AnnotationOper.getMethods(cls, this.typeMethods.get(cls));
                continue;
            }
            for (String featureName : featureNames) {
                if (!this.typeMethods.containsKey(cls)) {
                    this.typeMethods.put(cls, new LinkedHashSet());
                }
                this.typeMethods.get(cls).add(AnnotationOper.getDefaultGetMethod(cls, AnnotationOper.inferGetMethodName(featureName)));
            }
        }
    }

    @Override
    public void collectionProcessComplete() {
        File configFile = new File(this.outputDirectory, "annotation.conf");
        StringBuilder config = new StringBuilder();
        if (!configFile.exists()) {
            config.append("[entities]\n");
            for (Map.Entry<Class, LinkedHashSet<Method>> entry : this.typeMethods.entrySet()) {
                config.append(entry.getKey().getSimpleName() + "\n");
            }
            config.append("[features]\n");
            for (Map.Entry<Object, HashSet> entry : this.attributeToValues.entrySet()) {
                if (entry.getValue().size() <= 0 || entry.getValue().size() == 1 && entry.getValue().contains("")) continue;
                String attributeName = (String)entry.getKey();
                config.append(attributeName);
                config.append("\tArg:");
                config.append(this.serializeHashSet(this.attributeToConcepts.get(attributeName)));
                String values2 = this.serializeHashSet(entry.getValue());
                if (values2.length() > 0) {
                    config.append(",\tValue:");
                    config.append(values2);
                }
                config.append("\n");
            }
            config.append("[relations]\n[events]");
        }
    }

    private String serializeHashSet(HashSet<String> set) {
        if (set.size() == 1) {
            if (set.contains("")) {
                return "";
            }
            Iterator<String> iterator2 = set.iterator();
            if (iterator2.hasNext()) {
                String ele = iterator2.next();
                return ele;
            }
        }
        StringBuilder output = new StringBuilder();
        for (String ele : set) {
            if (ele.indexOf(":") != -1 || ele.indexOf(",") != -1) {
                return "";
            }
            output.append(ele);
            output.append("|");
        }
        output.deleteCharAt(output.length() - 1);
        return output.toString();
    }
}

