/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.writer;

import edu.utah.bmi.nlp.uima.writer.StaticVariables;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class EhostConfigurator {
    private static int seed = 1234;
    private static FileOutputStream outputStream;

    /*
     * WARNING - void declaration
     */
    public static void setUp(File outputFile, HashMap<String, LinkedHashSet<String>> typeMethods, String colorPool, int randomColor) {
        if (randomColor < 2 && StaticVariables.colorPool.size() == 0 && colorPool.length() > 0) {
            void var7_12;
            int i = 0;
            String[] stringArray = colorPool.split("\\|");
            int n = stringArray.length;
            boolean bl = false;
            while (var7_12 < n) {
                String color = stringArray[var7_12];
                StaticVariables.colorPool.put(i, color.trim());
                ++i;
                ++var7_12;
            }
            StaticVariables.resetColorPool();
            StaticVariables.randomPick = randomColor == 1;
        }
        XMLStreamWriter xtw = EhostConfigurator.initXml(outputFile);
        ArrayList<String> sortedTypes = new ArrayList<String>();
        sortedTypes.addAll(typeMethods.keySet());
        Collections.sort(sortedTypes);
        try {
            for (String entry : sortedTypes) {
                EhostConfigurator.writeType(xtw, entry, typeMethods.get(entry), randomColor);
            }
            for (Map.Entry entry : typeMethods.entrySet()) {
            }
            xtw.writeEndElement();
            xtw.writeEndElement();
            xtw.flush();
            outputStream.close();
            xtw.close();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static XMLStreamWriter initXml(File outputFile) {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter xtw = null;
        try {
            outputStream = new FileOutputStream(outputFile);
            xtw = xof.createXMLStreamWriter(outputStream, "UTF-8");
            xtw.writeStartDocument("UTF-8", "1.0");
            xtw.writeStartElement("eHOST_Project_Configure");
            EhostConfigurator.writeEle(xtw, "Handling_Text_Database", "false");
            EhostConfigurator.writeEle(xtw, "OracleFunction_Enabled", "false");
            EhostConfigurator.writeEle(xtw, "AttributeEditor_PopUp_Enabled", "false");
            EhostConfigurator.writeEle(xtw, "OracleFunction", "false");
            EhostConfigurator.writeEle(xtw, "AnnotationBuilder_Using_ExactSpan", "false");
            EhostConfigurator.writeEle(xtw, "OracleFunction_Using_WholeWord", "true");
            EhostConfigurator.writeEle(xtw, "GraphicAnnotationPath_Enabled", "true");
            EhostConfigurator.writeEle(xtw, "Diff_Indicator_Enabled", "true");
            EhostConfigurator.writeEle(xtw, "Diff_Indicator_Check_CrossSpan", "true");
            EhostConfigurator.writeEle(xtw, "Diff_Indicator_Check_Overlaps", "false");
            EhostConfigurator.writeEle(xtw, "StopWords_Enabled", "false");
            EhostConfigurator.writeEle(xtw, "Output_VerifySuggestions", "false");
            EhostConfigurator.writeEle(xtw, "Pre_Defined_Dictionary_DifferentWeight", "false");
            xtw.writeStartElement("PreAnnotated_Dictionaries");
            xtw.writeAttribute("Owner", "NLP_Assistant");
            xtw.writeEndElement();
            EhostConfigurator.writeEle(xtw, "attributeDefs", "");
            EhostConfigurator.writeEle(xtw, "Relationship_Rules", "");
            xtw.writeStartElement("classDefs");
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return xtw;
    }

    public static void writeEle(XMLStreamWriter xtw, String elementName, String elementValue) throws XMLStreamException {
        xtw.writeStartElement(elementName);
        xtw.writeCharacters(elementValue);
        xtw.writeEndElement();
    }

    public static void writeType(XMLStreamWriter xtw, String typeName, LinkedHashSet<String> type, int randomColor) throws XMLStreamException {
        xtw.writeStartElement("classDef");
        EhostConfigurator.writeEle(xtw, "Name", typeName);
        int[] colors = new int[3];
        colors = randomColor == 2 ? EhostConfigurator.getRandomBeautifulColors() : EhostConfigurator.convert2RGB(StaticVariables.pickColor(typeName));
        EhostConfigurator.writeEle(xtw, "RGB_R", colors[0] + "");
        EhostConfigurator.writeEle(xtw, "RGB_G", colors[1] + "");
        EhostConfigurator.writeEle(xtw, "RGB_B", colors[2] + "");
        EhostConfigurator.writeEle(xtw, "InHerit_Public_Attributes", "true");
        for (String attr : type) {
            xtw.writeStartElement("attributeDef");
            EhostConfigurator.writeEle(xtw, "Name", attr);
            EhostConfigurator.writeEle(xtw, "isCode", "false");
            xtw.writeEndElement();
        }
        EhostConfigurator.writeEle(xtw, "Source", "eHOST");
        xtw.writeEndElement();
    }

    public static int[] getRandomBeautifulColors() {
        String colorString = Integer.toHexString((int)Math.floor(Math.random() * 1.6777215E7));
        if (colorString.length() == 5) {
            colorString = "0" + colorString;
        }
        int[] rgb = EhostConfigurator.convert2RGB(colorString);
        return rgb;
    }

    public static int[] convert2RGB(String hexColor) {
        if (!hexColor.startsWith("#") && !hexColor.startsWith("0x")) {
            hexColor = "#" + hexColor;
        }
        Color color = Color.decode(hexColor);
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return new int[]{red, green, blue};
    }
}

