/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.writer;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.core.IOUtil;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import edu.utah.bmi.nlp.uima.writer.EhostConfigurator;
import edu.utah.bmi.nlp.uima.writer.XMIWritter_AE;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;

public class EhostWriter_AE
extends XMIWritter_AE {
    public static Logger logger = IOUtil.getLogger(EhostWriter_AE.class);
    public static String PARAM_COLOR_POOL = "ColorPool";
    public static String PARMA_RANDOM_COLOR = "RandomColor";
    private boolean keepSubDir = false;
    private File xmlOutputDir;
    private File txtOutputDir;
    private File configDir;
    private String annotator = "org/apache/uima";
    private int mDocNum;
    private int docCounter = 0;
    private int subCorpusCounter = 0;
    private int elementId = 0;
    private int randomColor = 2;
    private String colorPool = "";
    protected HashMap<Class, LinkedHashSet<Method>> typeMethods = new HashMap();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy");

    @Override
    public void initialize(UimaContext cont) {
        String includeTypes = this.baseInit(cont, "data/output/ehost", "org/apache/uima");
        Object value = cont.getConfigParameterValue(PARAM_COLOR_POOL);
        if (value != null && value instanceof String && ((String)value).length() > 0) {
            this.colorPool = ((String)value).trim();
        }
        if ((value = cont.getConfigParameterValue(PARMA_RANDOM_COLOR)) != null) {
            if (value instanceof Integer) {
                this.randomColor = (Integer)value;
            } else if (value instanceof String && (value = NumberUtils.createInteger((String)value)) != null) {
                this.randomColor = (Integer)value;
            }
        }
        this.mDocNum = 0;
        logger.fine("Ehost annotations will be exported to: " + this.outputDirectory);
        this.outputDirectory = new File(this.outputDirectory, this.annotator);
        this.xmlOutputDir = new File(this.outputDirectory, "saved");
        this.txtOutputDir = new File(this.outputDirectory, "corpus");
        try {
            if (!this.xmlOutputDir.exists()) {
                Files.createDirectories(Paths.get(this.xmlOutputDir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            if (!this.txtOutputDir.exists()) {
                Files.createDirectories(Paths.get(this.txtOutputDir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
            this.configDir = new File(this.outputDirectory, "config");
            if (!this.configDir.exists()) {
                Files.createDirectories(Paths.get(this.configDir.getAbsolutePath(), new String[0]), new FileAttribute[0]);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (includeTypes.length() == 0) {
            includeTypes = "Annotation";
        }
        String[] types = includeTypes.split(",");
        Arrays.asList(types).forEach(e -> {
            Class<? extends Annotation> cls;
            if (e.trim().length() > 0 && (cls = AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(e.trim()))) != null) {
                this.typeMethods.put(cls, this.getMethods(cls));
            }
        });
    }

    @Override
    public void process(JCas jcas) throws AnalysisEngineProcessException {
        ArrayList<Class> typeClasses = new ArrayList<Class>();
        typeClasses.addAll(this.typeMethods.keySet());
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (Class typecls : typeClasses) {
            annotations.addAll(JCasUtil.select(jcas, typecls));
        }
        File[] files = this.initialOutputXml(jcas);
        System.out.println("\n\n" + files[1].getName());
        File outputXml = files[1];
        File sourceFile = files[0];
        try {
            this.writeEhostXML(jcas, annotations, sourceFile, outputXml);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    protected LinkedHashSet<Method> getMethods(Class<? extends Annotation> cls) {
        if (this.typeMethods.containsKey(cls)) {
            return this.typeMethods.get(cls);
        }
        LinkedHashSet<Method> attributes = new LinkedHashSet<Method>();
        this.getMethods(cls, attributes);
        this.typeMethods.put(cls, attributes);
        return attributes;
    }

    protected LinkedHashSet<Method> getMethods(Annotation annotation) {
        return this.getMethods(annotation.getClass());
    }

    public void getMethods(Class c, LinkedHashSet<Method> methods) {
        if (c.getSimpleName().equals("Annotation")) {
            return;
        }
        for (Method method : c.getDeclaredMethods()) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || methodName.equals("getTypeIndexID")) continue;
            methods.add(method);
        }
        this.getMethods(c.getSuperclass(), methods);
    }

    protected void writeEhostXML(JCas jcas, Collection<Annotation> annotations, File sourceFile, File outputXml) throws IOException, XMLStreamException {
        try {
            FileUtils.write(sourceFile, (CharSequence)jcas.getDocumentText().replace('\r', ' '), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FileOutputStream outputXmlStream = new FileOutputStream(outputXml);
        XMLStreamWriter xtw = this.initiateWritter(outputXmlStream, sourceFile);
        this.elementId = 0;
        block2: for (Annotation annotation : annotations) {
            if (annotation instanceof SourceDocumentInformation || annotation instanceof DocumentAnnotation) continue;
            System.out.println(annotation.getType().getShortName());
            if (this.typeMethods.size() == 0) {
                this.writeEhostAnnotation(xtw, annotation);
                continue;
            }
            if (this.typeMethods.containsKey(annotation.getClass())) {
                if (this.typeMethods.get(annotation.getClass()) != null) continue;
                logger.fine(annotation.getCoveredText());
                this.writeEhostAnnotation(xtw, annotation);
                continue;
            }
            for (Class typeCls : this.typeMethods.keySet()) {
                if (!typeCls.isInstance(annotation)) continue;
                this.typeMethods.put(annotation.getClass(), this.typeMethods.get(typeCls));
                this.writeEhostAnnotation(xtw, annotation);
                continue block2;
            }
        }
        xtw.writeEndElement();
        xtw.writeEndDocument();
        xtw.flush();
        outputXmlStream.close();
        xtw.close();
    }

    private void writeEhostAnnotation(XMLStreamWriter xtw, Annotation annotation) throws XMLStreamException {
        int begin = annotation.getBegin();
        int end = annotation.getEnd();
        String type = annotation.getType().getShortName();
        String coveredText = StringEscapeUtils.escapeXml(annotation.getCoveredText());
        xtw.writeStartElement("annotation");
        xtw.writeStartElement("mention");
        xtw.writeAttribute("id", "EHOST_Instance_" + this.elementId);
        xtw.writeEndElement();
        xtw.writeStartElement("annotator");
        xtw.writeAttribute("id", this.annotator);
        xtw.writeCharacters(this.annotator);
        xtw.writeEndElement();
        xtw.writeStartElement("span");
        xtw.writeAttribute("start", begin + "");
        xtw.writeAttribute("end", end + "");
        xtw.writeEndElement();
        xtw.writeStartElement("spannedText");
        xtw.writeCharacters(coveredText);
        xtw.writeEndElement();
        xtw.writeStartElement("creationDate");
        xtw.writeCharacters(this.dateFormat.format(new Date()));
        xtw.writeEndElement();
        xtw.writeEndElement();
        int attributeIds = 0;
        if (!this.typeMethods.containsKey(annotation.getClass())) {
            this.typeMethods.put(annotation.getClass(), new LinkedHashSet());
            AnnotationOper.getMethods(annotation.getClass(), this.typeMethods.get(annotation.getClass()));
        }
        for (Method method : this.typeMethods.get(annotation.getClass())) {
            xtw.writeStartElement("stringSlotMention");
            xtw.writeAttribute("id", "EHOST_Instance_" + (this.elementId + attributeIds));
            ++attributeIds;
            xtw.writeStartElement("mentionSlot");
            xtw.writeAttribute("id", method.getName().substring(3));
            xtw.writeEndElement();
            xtw.writeStartElement("stringSlotMentionValue");
            String value = this.getMethodValue(method, annotation);
            xtw.writeAttribute("value", value);
            xtw.writeEndElement();
            xtw.writeEndElement();
        }
        xtw.writeStartElement("classMention");
        xtw.writeAttribute("id", "EHOST_Instance_" + this.elementId);
        for (int i = 0; i < attributeIds; ++i) {
            xtw.writeStartElement("hasSlotMention");
            xtw.writeAttribute("id", "EHOST_Instance_" + (this.elementId + i));
            xtw.writeEndElement();
        }
        xtw.writeStartElement("mentionClass");
        xtw.writeAttribute("id", type);
        xtw.writeCharacters(coveredText);
        xtw.writeEndElement();
        this.elementId += attributeIds + 1;
        xtw.writeEndElement();
    }

    protected String getMethodValue(Method method, Annotation annotation) {
        String value = "";
        try {
            Object valueObj = method.invoke((Object)annotation, null);
            value = valueObj instanceof FSArray ? this.serilizeFSArray((FSArray)valueObj) : valueObj + "";
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return value;
    }

    protected XMLStreamWriter initiateWritter(FileOutputStream outputFileStream, File sourceFile) throws XMLStreamException {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter xtw = xof.createXMLStreamWriter(outputFileStream, "UTF-8");
        xtw.writeStartDocument("UTF-8", "1.0");
        xtw.writeStartElement("annotations");
        xtw.writeAttribute("textSource", sourceFile.getAbsolutePath());
        return xtw;
    }

    protected File[] initialOutputXml(JCas jcas) {
        String originalFileName = EhostWriter_AE.readFileIDName(jcas, this.nameWId);
        if (originalFileName.length() == 0) {
            originalFileName = "doc" + this.mDocNum;
        }
        if (!originalFileName.endsWith("txt")) {
            originalFileName = originalFileName + ".txt";
        }
        File outFile = new File(this.xmlOutputDir, originalFileName + ".knowtator.xml");
        File sourceFile = new File(this.txtOutputDir, originalFileName);
        return new File[]{sourceFile, outFile};
    }

    @Override
    public void collectionProcessComplete() {
        HashMap<String, LinkedHashSet<String>> typeConfigs = new HashMap<String, LinkedHashSet<String>>();
        for (Class cls : this.typeMethods.keySet()) {
            String typeName = cls.getSimpleName();
            typeConfigs.put(typeName, new LinkedHashSet());
            for (Method method : this.typeMethods.get(cls)) {
                typeConfigs.get(typeName).add(method.getName().substring(3));
            }
        }
        EhostConfigurator.setUp(new File(this.configDir, "projectschema.xml"), typeConfigs, this.colorPool, this.randomColor);
    }
}

