/*
 * Decompiled with CFR 0.152.
 */
package edu.utah.bmi.nlp.uima.writer;

import edu.utah.bmi.nlp.core.DeterminantValueSet;
import edu.utah.bmi.nlp.sql.RecordRow;
import edu.utah.bmi.nlp.type.system.Concept;
import edu.utah.bmi.nlp.uima.common.AnnotationOper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.Type;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.CasIOUtils;

public class XMIWritter_AE
extends JCasAnnotator_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    public static final String PARAM_UIMATYPES = "UIMATypes";
    public static final String PARAM_ANNOTATOR = "Annotator";
    public static final String PARAM_NAME_W_ID = "NameWithId";
    protected String annotator;
    protected HashMap<Class, Boolean> uimaTypes = new HashMap();
    public File outputDirectory;
    protected boolean nameWId = false;

    @Override
    public void initialize(UimaContext cont) {
        String includeTypes = this.baseInit(cont, "data/output/xmi", "org/apache/uima");
        this.uimaTypes = new HashMap();
        if (includeTypes.length() > 0) {
            String[] types = includeTypes.split(",");
            Arrays.asList(types).forEach(e -> {
                if (e.trim().length() > 0) {
                    this.uimaTypes.put(AnnotationOper.getTypeClass(DeterminantValueSet.checkNameSpace(e.trim())), true);
                }
            });
        }
    }

    protected String baseInit(UimaContext cont, String defaultDir, String defaultAnnotator) {
        this.outputDirectory = new File(XMIWritter_AE.readConfigureString(cont, PARAM_OUTPUTDIR, defaultDir));
        System.out.println("UIMA annotations will be exported to: " + this.outputDirectory.getAbsolutePath());
        Object tmpObj = cont.getConfigParameterValue(PARAM_NAME_W_ID);
        if (tmpObj != null && tmpObj instanceof Boolean) {
            this.nameWId = (Boolean)tmpObj;
        }
        if (!this.outputDirectory.exists()) {
            try {
                FileUtils.forceMkdir(this.outputDirectory);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.annotator = XMIWritter_AE.readConfigureString(cont, PARAM_ANNOTATOR, defaultAnnotator);
        String includeTypes = XMIWritter_AE.readConfigureString(cont, PARAM_UIMATYPES, "");
        includeTypes = includeTypes.replaceAll("\\s+", "");
        return includeTypes;
    }

    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String FileName = XMIWritter_AE.readFileIDName(jCas, this.nameWId);
        if (this.uimaTypes.size() > 0 && !this.uimaTypes.containsKey("")) {
            Iterator<Annotation> iterator2 = JCasUtil.iterator(jCas, Annotation.class);
            while (iterator2.hasNext()) {
                Annotation anno = iterator2.next();
                if (!this.included(anno)) {
                    anno.removeFromIndexes();
                }
                if (!(anno instanceof Concept)) continue;
                ((Concept)anno).setAnnotator(this.annotator);
            }
        }
        try {
            CasIOUtils.save(jCas.getCas(), new FileOutputStream(new File(this.outputDirectory, FileName + ".xmi")), SerialFormat.XMI);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected boolean included(Annotation anno) {
        Class<?> thisTypeClass = anno.getClass();
        if (this.uimaTypes.containsKey(thisTypeClass)) {
            return this.uimaTypes.get(thisTypeClass);
        }
        for (Class type : this.uimaTypes.keySet()) {
            if (!type.isInstance(anno)) continue;
            this.uimaTypes.put(thisTypeClass, true);
            return true;
        }
        this.uimaTypes.put(thisTypeClass, false);
        return false;
    }

    public static String readFileIDName(JCas jCas, boolean includeId) {
        RecordRow baseRecordRow = new RecordRow();
        for (SourceDocumentInformation e : JCasUtil.select(jCas, SourceDocumentInformation.class)) {
            String serializedString = new File(e.getUri()).getName();
            baseRecordRow.deserialize(serializedString);
        }
        String fileName = (includeId ? baseRecordRow.getValueByColumnName("DOC_ID") + "_" : "") + baseRecordRow.getValueByColumnName("DOC_NAME");
        return fileName;
    }

    public static String readConfigureString(UimaContext cont, String parameterName, String defaultValue) {
        Object tmpObj = cont.getConfigParameterValue(parameterName);
        String value = tmpObj == null ? defaultValue : (tmpObj + "").trim();
        return value;
    }

    protected String serilizeFSArray(FSArray ary) {
        StringBuilder sb = new StringBuilder();
        int size = ary.size();
        String[] values2 = new String[size];
        ary.copyToArray(0, values2, 0, size);
        for (FeatureStructure fs : ary) {
            List<Feature> features = fs.getType().getFeatures();
            for (Feature feature : features) {
                String domain = feature.getDomain().getShortName();
                if (domain.equals("AnnotationBase") || domain.equals("Annotation")) continue;
                Type range = feature.getRange();
                if (!range.isPrimitive()) {
                    FeatureStructure child = fs.getFeatureValue(feature);
                    sb.append(child + "");
                    continue;
                }
                sb.append("\t" + feature.getShortName() + ":" + fs.getFeatureValueAsString(feature) + "\n");
            }
        }
        return sb.toString();
    }
}

