/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.time.Duration;

class ThreadMonitor
implements Runnable {
    private final Thread thread;
    private final Duration timeout;

    static Thread start(Duration timeout) {
        return ThreadMonitor.start(Thread.currentThread(), timeout);
    }

    static Thread start(Thread thread2, Duration timeout) {
        if (timeout.isZero() || timeout.isNegative()) {
            return null;
        }
        ThreadMonitor timout = new ThreadMonitor(thread2, timeout);
        Thread monitor = new Thread((Runnable)timout, ThreadMonitor.class.getSimpleName());
        monitor.setDaemon(true);
        monitor.start();
        return monitor;
    }

    static void stop(Thread thread2) {
        if (thread2 != null) {
            thread2.interrupt();
        }
    }

    private ThreadMonitor(Thread thread2, Duration timeout) {
        this.thread = thread2;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        try {
            ThreadMonitor.sleep(this.timeout);
            this.thread.interrupt();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void sleep(Duration duration) throws InterruptedException {
        long millis = duration.toMillis();
        long finishAtMillis = System.currentTimeMillis() + millis;
        long remainingMillis = millis;
        do {
            Thread.sleep(remainingMillis);
        } while ((remainingMillis = finishAtMillis - System.currentTimeMillis()) > 0L);
    }
}

