/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

public class LogSource {
    protected static Hashtable logs;
    protected static boolean log4jIsAvailable;
    protected static boolean jdk14IsAvailable;
    protected static Constructor logImplctor;

    static {
        block19: {
            logs = new Hashtable();
            log4jIsAvailable = false;
            jdk14IsAvailable = false;
            logImplctor = null;
            try {
                log4jIsAvailable = Class.forName("org.apache.log4j.Logger") != null;
            }
            catch (Throwable throwable) {
                log4jIsAvailable = false;
            }
            try {
                jdk14IsAvailable = Class.forName("java.util.logging.Logger") != null && Class.forName("org.apache.commons.logging.impl.Jdk14Logger") != null;
            }
            catch (Throwable throwable) {
                jdk14IsAvailable = false;
            }
            String name = null;
            try {
                name = System.getProperty("org.apache.commons.logging.log");
                if (name == null) {
                    name = System.getProperty("org.apache.commons.logging.Log");
                }
            }
            catch (Throwable throwable) {}
            if (name != null) {
                try {
                    LogSource.setLogImplementation(name);
                }
                catch (Throwable throwable) {
                    try {
                        LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                    }
                    catch (Throwable throwable2) {}
                }
            } else {
                try {
                    if (log4jIsAvailable) {
                        LogSource.setLogImplementation("org.apache.commons.logging.impl.Log4JLogger");
                        break block19;
                    }
                    if (jdk14IsAvailable) {
                        LogSource.setLogImplementation("org.apache.commons.logging.impl.Jdk14Logger");
                        break block19;
                    }
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {
                    try {
                        LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                    }
                    catch (Throwable throwable3) {}
                }
            }
        }
    }

    private LogSource() {
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log getInstance(String name) {
        Log log = (Log)logs.get(name);
        if (log == null) {
            log = LogSource.makeNewLogInstance(name);
            logs.put(name, log);
        }
        return log;
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(new String[logs.size()]);
    }

    public static Log makeNewLogInstance(String name) {
        Log log = null;
        try {
            Object[] args2 = new Object[]{name};
            log = (Log)logImplctor.newInstance(args2);
        }
        catch (Throwable throwable) {
            log = null;
        }
        if (log == null) {
            log = new NoOpLog(name);
        }
        return log;
    }

    public static void setLogImplementation(Class logclass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] argtypes = new Class[]{"".getClass()};
        logImplctor = logclass.getConstructor(argtypes);
    }

    public static void setLogImplementation(String classname) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class<?> logclass = Class.forName(classname);
            Class[] argtypes = new Class[]{"".getClass()};
            logImplctor = logclass.getConstructor(argtypes);
        }
        catch (Throwable throwable) {
            logImplctor = null;
        }
    }
}

