/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.OldFileFormatException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.util.IOUtils;

public class SlideShowFactory {
    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(POIFSFileSystem fs) throws IOException {
        return SlideShowFactory.create(fs, null);
    }

    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(POIFSFileSystem fs, String password) throws IOException {
        return SlideShowFactory.create(fs.getRoot(), password);
    }

    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(DirectoryNode root) throws IOException {
        return SlideShowFactory.create(root, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(DirectoryNode root, String password) throws IOException {
        if (root.hasEntry("EncryptedPackage")) {
            InputStream stream = null;
            try {
                stream = DocumentFactoryHelper.getDecryptedStream(root, password);
                SlideShow<S, P> slideShow = SlideShowFactory.createXSLFSlideShow(stream);
                return slideShow;
            }
            finally {
                IOUtils.closeQuietly(stream);
                root.getFileSystem().close();
            }
        }
        boolean passwordSet = false;
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword(password);
            passwordSet = true;
        }
        try {
            SlideShow<S, P> slideShow = SlideShowFactory.createHSLFSlideShow(root);
            return slideShow;
        }
        finally {
            if (passwordSet) {
                Biff8EncryptionKey.setCurrentUserPassword(null);
            }
        }
    }

    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(InputStream inp) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(inp, null);
    }

    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(InputStream inp, String password) throws IOException, EncryptedDocumentException {
        InputStream is = FileMagic.prepareToCheckMagic(inp);
        FileMagic fm = FileMagic.valueOf(is);
        switch (fm) {
            case OLE2: {
                POIFSFileSystem fs = new POIFSFileSystem(is);
                return SlideShowFactory.create(fs, password);
            }
            case OOXML: {
                return SlideShowFactory.createXSLFSlideShow(is);
            }
        }
        throw new IOException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(File file) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, null);
    }

    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(File file, String password) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, password, false);
    }

    public static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> create(File file, String password, boolean readOnly) throws IOException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(file, readOnly);
            return SlideShowFactory.create(fs, password);
        }
        catch (OfficeXmlFileException e) {
            IOUtils.closeQuietly(fs);
            return SlideShowFactory.createXSLFSlideShow(file, readOnly);
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly(fs);
            throw e;
        }
    }

    private static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> createHSLFSlideShow(Object ... args2) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.hslf.usermodel.HSLFSlideShowFactory", args2);
    }

    private static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> createXSLFSlideShow(Object ... args2) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.xslf.usermodel.XSLFSlideShowFactory", args2);
    }

    private static <S extends Shape<S, P>, P extends TextParagraph<S, P, ? extends TextRun>> SlideShow<S, P> createSlideShow(String factoryClass, Object[] args2) throws IOException, EncryptedDocumentException {
        try {
            Class<?> clazz = SlideShowFactory.class.getClassLoader().loadClass(factoryClass);
            Class[] argsClz = new Class[args2.length];
            int i = 0;
            for (Object o : args2) {
                Class<Object> c = o.getClass();
                if (Boolean.class.isAssignableFrom(c)) {
                    c = Boolean.TYPE;
                } else if (InputStream.class.isAssignableFrom(c)) {
                    c = InputStream.class;
                }
                argsClz[i++] = c;
            }
            Method m3 = clazz.getMethod("createSlideShow", argsClz);
            return (SlideShow)m3.invoke(null, args2);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof EncryptedDocumentException) {
                throw (EncryptedDocumentException)t;
            }
            if (t instanceof OldFileFormatException) {
                throw (OldFileFormatException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IOException(t);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

