/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.EvaluationSheet;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.UserDefinedFunction;
import org.apache.poi.ss.formula.eval.ConcatEval;
import org.apache.poi.ss.formula.eval.FunctionEval;
import org.apache.poi.ss.formula.eval.IntersectionEval;
import org.apache.poi.ss.formula.eval.PercentEval;
import org.apache.poi.ss.formula.eval.RangeEval;
import org.apache.poi.ss.formula.eval.RelationalOperationEval;
import org.apache.poi.ss.formula.eval.TwoOperandNumericOperation;
import org.apache.poi.ss.formula.eval.UnaryMinusEval;
import org.apache.poi.ss.formula.eval.UnaryPlusEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayFunction;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.Indirect;
import org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import org.apache.poi.ss.formula.ptg.AddPtg;
import org.apache.poi.ss.formula.ptg.ConcatPtg;
import org.apache.poi.ss.formula.ptg.DividePtg;
import org.apache.poi.ss.formula.ptg.EqualPtg;
import org.apache.poi.ss.formula.ptg.GreaterEqualPtg;
import org.apache.poi.ss.formula.ptg.GreaterThanPtg;
import org.apache.poi.ss.formula.ptg.IntersectionPtg;
import org.apache.poi.ss.formula.ptg.LessEqualPtg;
import org.apache.poi.ss.formula.ptg.LessThanPtg;
import org.apache.poi.ss.formula.ptg.MultiplyPtg;
import org.apache.poi.ss.formula.ptg.NotEqualPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.PercentPtg;
import org.apache.poi.ss.formula.ptg.PowerPtg;
import org.apache.poi.ss.formula.ptg.RangePtg;
import org.apache.poi.ss.formula.ptg.SubtractPtg;
import org.apache.poi.ss.formula.ptg.UnaryMinusPtg;
import org.apache.poi.ss.formula.ptg.UnaryPlusPtg;

final class OperationEvaluatorFactory {
    private static final Map<OperationPtg, Function> _instancesByPtgClass = OperationEvaluatorFactory.initialiseInstancesMap();

    private OperationEvaluatorFactory() {
    }

    private static Map<OperationPtg, Function> initialiseInstancesMap() {
        HashMap<OperationPtg, Function> m3 = new HashMap<OperationPtg, Function>(32);
        OperationEvaluatorFactory.put(m3, EqualPtg.instance, RelationalOperationEval.EqualEval);
        OperationEvaluatorFactory.put(m3, GreaterEqualPtg.instance, RelationalOperationEval.GreaterEqualEval);
        OperationEvaluatorFactory.put(m3, GreaterThanPtg.instance, RelationalOperationEval.GreaterThanEval);
        OperationEvaluatorFactory.put(m3, LessEqualPtg.instance, RelationalOperationEval.LessEqualEval);
        OperationEvaluatorFactory.put(m3, LessThanPtg.instance, RelationalOperationEval.LessThanEval);
        OperationEvaluatorFactory.put(m3, NotEqualPtg.instance, RelationalOperationEval.NotEqualEval);
        OperationEvaluatorFactory.put(m3, ConcatPtg.instance, ConcatEval.instance);
        OperationEvaluatorFactory.put(m3, AddPtg.instance, TwoOperandNumericOperation.AddEval);
        OperationEvaluatorFactory.put(m3, DividePtg.instance, TwoOperandNumericOperation.DivideEval);
        OperationEvaluatorFactory.put(m3, MultiplyPtg.instance, TwoOperandNumericOperation.MultiplyEval);
        OperationEvaluatorFactory.put(m3, PercentPtg.instance, PercentEval.instance);
        OperationEvaluatorFactory.put(m3, PowerPtg.instance, TwoOperandNumericOperation.PowerEval);
        OperationEvaluatorFactory.put(m3, SubtractPtg.instance, TwoOperandNumericOperation.SubtractEval);
        OperationEvaluatorFactory.put(m3, UnaryMinusPtg.instance, UnaryMinusEval.instance);
        OperationEvaluatorFactory.put(m3, UnaryPlusPtg.instance, UnaryPlusEval.instance);
        OperationEvaluatorFactory.put(m3, RangePtg.instance, RangeEval.instance);
        OperationEvaluatorFactory.put(m3, IntersectionPtg.instance, IntersectionEval.instance);
        return m3;
    }

    private static void put(Map<OperationPtg, Function> m3, OperationPtg ptgKey, Function instance) {
        Constructor<?>[] cc = ptgKey.getClass().getDeclaredConstructors();
        if (cc.length > 1 || !Modifier.isPrivate(cc[0].getModifiers())) {
            throw new RuntimeException("Failed to verify instance (" + ptgKey.getClass().getName() + ") is a singleton.");
        }
        m3.put(ptgKey, instance);
    }

    public static ValueEval evaluate(OperationPtg ptg, ValueEval[] args2, OperationEvaluationContext ec) {
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        Function result = _instancesByPtgClass.get(ptg);
        FreeRefFunction udfFunc = null;
        if (result == null && ptg instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg fptg = (AbstractFunctionPtg)ptg;
            short functionIndex = fptg.getFunctionIndex();
            switch (functionIndex) {
                case 148: {
                    udfFunc = Indirect.instance;
                    break;
                }
                case 255: {
                    udfFunc = UserDefinedFunction.instance;
                    break;
                }
                default: {
                    result = FunctionEval.getBasicFunction(functionIndex);
                }
            }
        }
        if (result != null) {
            EvaluationSheet evalSheet = ec.getWorkbook().getSheet(ec.getSheetIndex());
            EvaluationCell evalCell = evalSheet.getCell(ec.getRowIndex(), ec.getColumnIndex());
            if (evalCell != null && (evalCell.isPartOfArrayFormulaGroup() || ec.isArraymode()) && result instanceof ArrayFunction) {
                return ((ArrayFunction)((Object)result)).evaluateArray(args2, ec.getRowIndex(), ec.getColumnIndex());
            }
            return result.evaluate(args2, ec.getRowIndex(), ec.getColumnIndex());
        }
        if (udfFunc != null) {
            return udfFunc.evaluate(args2, ec);
        }
        throw new RuntimeException("Unexpected operation ptg class (" + ptg.getClass().getName() + ")");
    }
}

