/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.vinci.CASTransportable;
import org.apache.uima.adapter.vinci.VinciBinaryAnalysisEngineServiceStub;
import org.apache.uima.adapter.vinci.util.VinciSaxParser;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineServiceStub;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.SaxDeserializer;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.context.VinciContext;
import org.apache.vinci.transport.document.AFrame;

public class VinciAnalysisEngineServiceStub
implements AnalysisEngineServiceStub {
    private VinciClient mVinciClient;
    private Resource mOwner;
    private int mTimeout;
    private int mGetMetaDataTimeout;
    private static final boolean debug = System.getProperty("DEBUG") != null;
    private static final List SUPPORT_XCAS_V1 = Collections.unmodifiableList(Arrays.asList("1"));

    public VinciAnalysisEngineServiceStub(String endpointURI, Resource owner) throws ResourceInitializationException {
        this(endpointURI, null, owner, null);
    }

    public VinciAnalysisEngineServiceStub(String endpointURI, Integer timeout, Resource owner, Parameter[] parameters) throws ResourceInitializationException {
        this.mOwner = owner;
        try {
            VinciContext vctx = new VinciContext(InetAddress.getLocalHost().getCanonicalHostName(), 0);
            String vnsHost = null;
            String vnsPort = null;
            String getMetaDataTimeout = null;
            if (parameters != null) {
                vnsHost = VinciBinaryAnalysisEngineServiceStub.getParameterValueFor("VNS_HOST", parameters);
                vnsPort = VinciBinaryAnalysisEngineServiceStub.getParameterValueFor("VNS_PORT", parameters);
                getMetaDataTimeout = VinciBinaryAnalysisEngineServiceStub.getParameterValueFor("GetMetaDataTimeout", parameters);
            }
            if (vnsHost == null && (vnsHost = System.getProperty("VNS_HOST")) == null) {
                vnsHost = "localhost";
            }
            if (vnsPort == null && (vnsPort = System.getProperty("VNS_PORT")) == null) {
                vnsPort = "9000";
            }
            vctx.setVNSHost(vnsHost);
            vctx.setVNSPort(Integer.parseInt(vnsPort));
            vctx.setSocketKeepAliveEnabled(this.isSocketKeepAliveEnabled());
            if (debug) {
                System.out.println("Establishing connnection to " + endpointURI + " using VNS_HOST:" + vctx.getVNSHost() + " and VNS_PORT=" + vctx.getVNSPort());
            }
            this.mVinciClient = new VinciClient(endpointURI, AFrame.getAFrameFactory(), vctx);
            this.mTimeout = timeout != null ? timeout.intValue() : this.mVinciClient.getSocketTimeout();
            this.mGetMetaDataTimeout = getMetaDataTimeout != null ? Integer.parseInt(getMetaDataTimeout) : this.mVinciClient.getSocketTimeout();
            if (debug) {
                System.out.println("Success");
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public ResourceMetaData callGetMetaData() throws ResourceServiceException {
        try {
            VinciFrame queryFrame = new VinciFrame();
            queryFrame.fadd("vinci:COMMAND", "GetMeta");
            if (debug) {
                System.out.println("Calling GetMeta");
            }
            VinciFrame resultFrame = this.mVinciClient.rpc(queryFrame, this.mGetMetaDataTimeout);
            if (debug) {
                System.out.println("Success");
            }
            int i = 0;
            while (i < resultFrame.getKeyValuePairCount()) {
                String key = resultFrame.getKeyValuePair(i).getKey();
                if (key.length() < 8 || !key.substring(key.length() - 8).equalsIgnoreCase("metadata")) {
                    resultFrame.fdrop(key);
                    continue;
                }
                ++i;
            }
            SaxDeserializer saxDeser = UIMAFramework.getXMLParser().newSaxDeserializer();
            VinciSaxParser vinciSaxParser = new VinciSaxParser();
            vinciSaxParser.setContentHandler(saxDeser);
            vinciSaxParser.parse(resultFrame);
            ProcessingResourceMetaData metadata = (ProcessingResourceMetaData)saxDeser.getObject();
            return metadata;
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    @Override
    public void callProcess(CAS aCAS) throws ResourceServiceException {
        this.doProcess(aCAS);
    }

    public void callProcessCas(CAS aCAS) throws ResourceServiceException {
        this.doProcess(aCAS);
    }

    private void doProcess(CAS aCAS) throws ResourceServiceException {
        try {
            aCAS = ((CASImpl)aCAS).getBaseCAS();
            final CASTransportable query = new CASTransportable(aCAS, null, this.mOwner.getUimaContext(), true);
            query.setCommand("Annotate");
            this.mVinciClient.sendAndReceive(query, new TransportableFactory(){

                @Override
                public Transportable makeTransportable() {
                    return query;
                }
            }, this.mTimeout);
            int annotationTime = query.getExtraDataFrame().fgetInt("TAE:AnnotationTime");
            if (annotationTime > 0) {
                AnalysisEngineManagementImpl mbean = (AnalysisEngineManagementImpl)this.mOwner.getUimaContextAdmin().getManagementInterface();
                mbean.reportAnalysisTime(annotationTime);
            }
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    @Override
    public void destroy() {
        this.mVinciClient.close();
    }

    @Override
    public void callBatchProcessComplete() throws ResourceServiceException {
        try {
            AFrame queryFrame = new AFrame();
            queryFrame.fadd("vinci:COMMAND", "BatchProcessComplete");
            this.mVinciClient.send(queryFrame);
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    @Override
    public void callCollectionProcessComplete() throws ResourceServiceException {
        try {
            AFrame queryFrame = new AFrame();
            queryFrame.fadd("vinci:COMMAND", "CollectionProcessComplete");
            this.mVinciClient.rpc(queryFrame, this.mTimeout);
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    public boolean callIsReadOnly() throws ResourceServiceException {
        try {
            AFrame queryFrame = new AFrame();
            queryFrame.fadd("vinci:COMMAND", "IsReadOnly");
            VinciFrame resultFrame = this.mVinciClient.rpc(queryFrame);
            boolean result = resultFrame.fgetBoolean("Result");
            return result;
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    public boolean callIsStateless() throws ResourceServiceException {
        try {
            AFrame queryFrame = new AFrame();
            queryFrame.fadd("vinci:COMMAND", "IsStateless");
            VinciFrame resultFrame = this.mVinciClient.rpc(queryFrame);
            boolean result = resultFrame.fgetBoolean("Result");
            return result;
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    public List callGetSupportedXCasVersions() throws ResourceServiceException {
        try {
            AFrame queryFrame = new AFrame();
            queryFrame.fadd("vinci:COMMAND", "GetSupportedXCasVersions");
            VinciFrame resultFrame = this.mVinciClient.rpc(queryFrame);
            String result = resultFrame.fgetString("Result");
            if (result != null) {
                String[] versions = result.split("\\s+");
                return Collections.unmodifiableList(Arrays.asList(versions));
            }
            return SUPPORT_XCAS_V1;
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    protected boolean isSocketKeepAliveEnabled() {
        Properties settings;
        if (this.mOwner instanceof AnalysisEngine && (settings = ((AnalysisEngine)this.mOwner).getPerformanceTuningSettings()) != null) {
            String enabledStr = (String)settings.get(UIMAFramework.SOCKET_KEEPALIVE_ENABLED);
            return !"false".equalsIgnoreCase(enabledStr);
        }
        return true;
    }
}

