/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.vinci.CASTransportable;
import org.apache.uima.adapter.vinci.util.Descriptor;
import org.apache.uima.adapter.vinci.util.NetworkUtil;
import org.apache.uima.adapter.vinci.util.SaxVinciFrameBuilder;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.internal.util.UIMALogFormatter;
import org.apache.uima.internal.util.UIMAStreamHandler;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasPool;
import org.apache.uima.util.XMLInputSource;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.ServiceDownException;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.VinciServableAdapter;
import org.apache.vinci.transport.VinciServer;
import org.apache.vinci.transport.document.AFrame;

public class VinciAnalysisEngineService_impl
extends VinciServableAdapter {
    private VinciServer _server = null;
    private AnalysisEngine mAE = null;
    private CasPool mCasPool = null;
    private Descriptor descriptor = null;
    private boolean debug = false;
    private int serviceInstanceId = -1;

    public VinciAnalysisEngineService_impl(String serviceConfigPath, boolean debug, String instanceId) throws Exception {
        this(serviceConfigPath, debug);
        this.serviceInstanceId = Integer.parseInt(instanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VinciAnalysisEngineService_impl(String serviceConfigPath, boolean debug) throws Exception {
        this.debug = debug;
        UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINE, "VinciAnalysisEngineService_impl: constructor");
        this.descriptor = new Descriptor(serviceConfigPath);
        String aResourceSpecifierPath = this.descriptor.getResourceSpecifierPath();
        UIMAFramework.getLogger().log(org.apache.uima.util.Level.CONFIG, "Resource Specifier Path::" + aResourceSpecifierPath);
        ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(aResourceSpecifierPath));
        if (this.mAE == null) {
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINE, "VinciAnalysisEngineService_impl: creating CAS Processor");
            this.mAE = UIMAFramework.produceAnalysisEngine(resourceSpecifier, this.descriptor.getInstanceCount(), 0);
        }
        if (this.mCasPool == null) {
            this.mCasPool = new CasPool(this.descriptor.getInstanceCount(), this.mAE.getProcessingResourceMetaData());
        }
        CAS cas = this.mCasPool.getCas();
        try {
            this.mAE.typeSystemInit(cas.getTypeSystem());
        }
        finally {
            this.mCasPool.releaseCas(cas);
        }
    }

    public VinciAnalysisEngineService_impl(String serviceConfigPath) throws Exception {
        this(serviceConfigPath, false);
    }

    private Frame getMetaData() throws Exception {
        UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "VinciAnalysisEngineService.getMetaData()");
        ProcessingResourceMetaData md = this.mAE.getProcessingResourceMetaData();
        AFrame response = new AFrame();
        SaxVinciFrameBuilder vinciFrameBuilder = new SaxVinciFrameBuilder();
        vinciFrameBuilder.setParentFrame(response);
        vinciFrameBuilder.startDocument();
        md.toXML(vinciFrameBuilder);
        vinciFrameBuilder.endDocument();
        return response;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private Transportable analyze(CASTransportable ct) throws Exception {
        CAS cas = ct.getCas();
        try {
            long annotStartTime = System.currentTimeMillis();
            this.mAE.process(cas);
            int annotationTime = (int)(System.currentTimeMillis() - annotStartTime);
            if (this.debug) {
                System.out.println("Annotation took: " + annotationTime + "ms");
            }
            ct.getExtraDataFrame().fset("TAE:AnnotationTime", annotationTime);
            int totalAnnots = 0;
            FSIterator<SofaFS> sItr = cas.getSofaIterator();
            while (sItr.isValid()) {
                SofaFS sofa = sItr.get();
                totalAnnots += cas.getView(sofa).getAnnotationIndex().size();
                sItr.moveToNext();
            }
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "CAS ACount::" + totalAnnots);
            ct.setCommand(null);
            return ct;
        }
        catch (Exception ex) {
            ct.cleanup();
            throw ex;
        }
    }

    @Override
    public Transportable eval(Transportable doc) throws ServiceException {
        try {
            CASTransportable ct = (CASTransportable)doc;
            String op = ct.getCommand();
            if ("GetMeta".equals(op)) {
                ct.cleanup();
                return this.getMetaData();
            }
            if ("ProcessCas".equals(op) || "Annotate".equals(op)) {
                return this.analyze(ct);
            }
            if ("BatchProcessComplete".equals(op)) {
                ct.cleanup();
                this.mAE.batchProcessComplete();
                return null;
            }
            if ("CollectionProcessComplete".equals(op)) {
                ct.cleanup();
                this.mAE.collectionProcessComplete();
                return new VinciFrame();
            }
            if ("IsStateless".equals(op)) {
                ct.cleanup();
                return new AFrame().fadd("Result", this.mAE.isStateless());
            }
            if ("IsReadOnly".equals(op)) {
                ct.cleanup();
                return new AFrame().fadd("Result", this.mAE.isReadOnly());
            }
            if ("GetSupportedXCasVersions".equals(op)) {
                return new AFrame().fadd("Result", "2");
            }
            if ("Shutdown".equals(op)) {
                this.stop();
                System.exit(1);
            }
            ct.cleanup();
            return new VinciFrame().fadd("Error", "Invalid Operation:" + op);
        }
        catch (Exception e) {
            e.printStackTrace();
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.WARNING, e.getMessage(), e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = "Error Processing Request";
            }
            return new VinciFrame().fadd("Error", msg);
        }
    }

    protected void start() {
        try {
            ShutdownHook shutdownHook = new ShutdownHook(this);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            String serviceName = this.getDescriptor().getServiceName();
            String serviceHost = System.getProperty("LOCAL_HOST");
            if (serviceHost == null) {
                serviceHost = NetworkUtil.getLocalHostAddress().getHostAddress();
            }
            this._server = this.serviceInstanceId > 0 ? new VinciServer(serviceName, serviceHost, this, 0, this.serviceInstanceId) : new VinciServer(serviceName, serviceHost, this);
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "VinciAnalysisEngineService_impl: Starting Server with Socket Timeout:" + this.descriptor.getServerSocketTimeout());
            System.out.println("VinciAnalysisEngineService_impl: Starting Server with Socket Timeout:" + this.descriptor.getServerSocketTimeout());
            this._server.setSocketTimeout(this.descriptor.getServerSocketTimeout());
            this._server.setThreadPoolSize(this.descriptor.getThreadPoolMinSize(), this.descriptor.getThreadPoolMaxSize());
            this._server.serve();
        }
        catch (ServiceDownException e) {
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.SEVERE, e.getMessage());
            System.out.println("\nFailed to contact VNS! Make sure you've specified the correct VNS_HOST and that VNS is up and running.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public void stop() {
        try {
            if (this._server != null) {
                this._server.shutdown("Shutting Down the Vinci Analysis Engine Service");
                UIMAFramework.getLogger().log(org.apache.uima.util.Level.INFO, "Shutting Down the Vinci Analysis Engine Service");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args2) {
        try {
            String logFile;
            boolean debug;
            File descriptorFile;
            if (args2.length < 1) {
                System.err.println("Usage: java " + VinciAnalysisEngineService_impl.class.getName() + " <deployment descriptor file>");
                System.exit(1);
            }
            if (!(descriptorFile = new File(args2[0])).exists()) {
                System.err.println("Deployment descriptor \"" + args2[0] + "\" does not exist.");
                System.exit(1);
            }
            boolean bl = debug = System.getProperty("DEBUG") != null;
            if (System.getProperty("VNS_HOST") == null) {
                System.out.println("No VNS_HOST specified; using default localhost");
                System.setProperty("VNS_HOST", "localhost");
            }
            if ((logFile = System.getProperty("LOG")) != null) {
                if (logFile.equalsIgnoreCase("stdout")) {
                    VinciAnalysisEngineService_impl.redirectLoggerOutput(System.out);
                } else {
                    VinciAnalysisEngineService_impl.redirectLoggerOutput(new FileOutputStream(logFile));
                }
            }
            VinciAnalysisEngineService_impl vinciService = args2 != null && args2.length > 1 ? new VinciAnalysisEngineService_impl(descriptorFile.toString(), debug, args2[1]) : new VinciAnalysisEngineService_impl(descriptorFile.toString(), debug);
            vinciService.start();
        }
        catch (Exception ex) {
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.SEVERE, ex.getMessage(), ex);
            ex.printStackTrace();
        }
    }

    private static void redirectLoggerOutput(OutputStream out) {
        Handler[] handlers = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            LogManager.getLogManager().getLogger("").removeHandler(handlers[i]);
        }
        UIMAStreamHandler streamHandler = new UIMAStreamHandler(out, new UIMALogFormatter());
        streamHandler.setLevel(Level.ALL);
        LogManager.getLogManager().getLogger("").addHandler(streamHandler);
    }

    @Override
    public synchronized Transportable makeTransportable() {
        return new CASTransportable(this.mCasPool, new OutOfTypeSystemData(), null, false);
    }

    static class ShutdownHook
    extends Thread {
        VinciAnalysisEngineService_impl server;

        public ShutdownHook(VinciAnalysisEngineService_impl instance) {
            this.server = instance;
        }

        @Override
        public void run() {
            this.server.stop();
        }
    }
}

