/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci;

import java.net.InetAddress;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.vinci.util.VinciSaxParser;
import org.apache.uima.analysis_engine.AnalysisEngineServiceStub;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.analysis_engine.service.impl.AnalysisEngineServiceAdapter;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.internal.util.SerializationUtils;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.SaxDeserializer;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.context.VinciContext;
import org.apache.vinci.transport.document.AFrame;

public class VinciBinaryAnalysisEngineServiceStub
implements AnalysisEngineServiceStub {
    private static final boolean debug = false;
    private VinciClient mVinciClient;
    private AnalysisEngineServiceAdapter mOwner;
    private int mTimeout;
    private int mGetMetaDataTimeout;

    public VinciBinaryAnalysisEngineServiceStub(String endpointURI, AnalysisEngineServiceAdapter owner) throws ResourceInitializationException {
        this(endpointURI, null, owner, null);
    }

    public VinciBinaryAnalysisEngineServiceStub(String endpointURI, Integer timeout, AnalysisEngineServiceAdapter owner, Parameter[] parameters) throws ResourceInitializationException {
        this.mOwner = owner;
        try {
            VinciContext vctx = new VinciContext(InetAddress.getLocalHost().getCanonicalHostName(), 0);
            String vnsHost = null;
            String vnsPort = null;
            String getMetaDataTimeout = null;
            if (parameters != null) {
                vnsHost = VinciBinaryAnalysisEngineServiceStub.getParameterValueFor("VNS_HOST", parameters);
                vnsPort = VinciBinaryAnalysisEngineServiceStub.getParameterValueFor("VNS_PORT", parameters);
                getMetaDataTimeout = VinciBinaryAnalysisEngineServiceStub.getParameterValueFor("GetMetaDataTimeout", parameters);
            }
            if (vnsHost == null && (vnsHost = System.getProperty("VNS_HOST")) == null) {
                vnsHost = "localhost";
            }
            if (vnsPort == null && (vnsPort = System.getProperty("VNS_PORT")) == null) {
                vnsPort = "9000";
            }
            vctx.setVNSHost(vnsHost);
            vctx.setVNSPort(Integer.parseInt(vnsPort));
            vctx.setSocketKeepAliveEnabled(this.isSocketKeepAliveEnabled());
            this.mVinciClient = new VinciClient(endpointURI, AFrame.getAFrameFactory(), vctx);
            this.mTimeout = timeout != null ? timeout.intValue() : this.mVinciClient.getSocketTimeout();
            this.mGetMetaDataTimeout = getMetaDataTimeout != null ? Integer.parseInt(getMetaDataTimeout) : this.mVinciClient.getSocketTimeout();
        }
        catch (Exception e) {
            throw new ResourceInitializationException(e);
        }
    }

    public static String getParameterValueFor(String aKey, Parameter[] parameters) {
        if (aKey != null) {
            for (int i = 0; parameters != null && i < parameters.length; ++i) {
                if (!aKey.equals(parameters[i].getName())) continue;
                return parameters[i].getValue();
            }
        }
        return null;
    }

    @Override
    public ResourceMetaData callGetMetaData() throws ResourceServiceException {
        try {
            VinciFrame queryFrame = new VinciFrame();
            queryFrame.fadd("vinci:COMMAND", "GetMeta");
            this.mVinciClient.setTransportableFactory(AFrame.getAFrameFactory());
            VinciFrame resultFrame = this.mVinciClient.rpc(queryFrame, this.mGetMetaDataTimeout);
            int i = 0;
            while (i < resultFrame.getKeyValuePairCount()) {
                String key = resultFrame.getKeyValuePair(i).getKey();
                if (key.length() < 8 || !key.substring(key.length() - 8).equalsIgnoreCase("metadata")) {
                    resultFrame.fdrop(key);
                    continue;
                }
                ++i;
            }
            SaxDeserializer saxDeser = UIMAFramework.getXMLParser().newSaxDeserializer();
            VinciSaxParser vinciSaxParser = new VinciSaxParser();
            vinciSaxParser.setContentHandler(saxDeser);
            vinciSaxParser.parse(resultFrame);
            AnalysisEngineMetaData metadata = (AnalysisEngineMetaData)saxDeser.getObject();
            return metadata;
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    @Override
    public void callProcess(CAS aCAS) throws ResourceServiceException {
        try {
            AFrame requestFrame = new AFrame();
            requestFrame.fset("vinci:COMMAND", "Annotate");
            CASMgr cas = (CASMgr)((Object)aCAS);
            CASCompleteSerializer serializer = Serialization.serializeCASComplete(cas);
            requestFrame.fsetTrueBinary("BinaryCAS", SerializationUtils.serialize(serializer));
            AFrame responseFrame = (AFrame)this.mVinciClient.sendAndReceive((Transportable)requestFrame, this.mTimeout);
            byte[] responseCasBytes = responseFrame.fgetTrueBinary("BinaryCAS");
            CASSerializer responseSerializer = (CASSerializer)SerializationUtils.deserialize(responseCasBytes);
            ((CASImpl)cas).reinit(responseSerializer);
            int annotationTime = responseFrame.fgetInt("TAE:AnnotationTime");
            if (annotationTime > 0) {
                AnalysisEngineManagementImpl mbean = (AnalysisEngineManagementImpl)this.mOwner.getManagementInterface();
                mbean.reportAnalysisTime(annotationTime);
            }
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    @Override
    public void callBatchProcessComplete() throws ResourceServiceException {
        try {
            AFrame queryFrame = new AFrame();
            queryFrame.fadd("vinci:COMMAND", "BatchProcessComplete");
            this.mVinciClient.send(queryFrame);
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    @Override
    public void callCollectionProcessComplete() throws ResourceServiceException {
        try {
            AFrame queryFrame = new AFrame();
            queryFrame.fadd("vinci:COMMAND", "CollectionProcessComplete");
            this.mVinciClient.rpc(queryFrame, this.mTimeout);
        }
        catch (Exception e) {
            throw new ResourceServiceException(e);
        }
    }

    @Override
    public void destroy() {
        this.mVinciClient.close();
    }

    private boolean isSocketKeepAliveEnabled() {
        Properties settings = this.mOwner.getPerformanceTuningSettings();
        if (settings != null) {
            String enabledStr = (String)settings.get(UIMAFramework.SOCKET_KEEPALIVE_ENABLED);
            return !"false".equalsIgnoreCase(enabledStr);
        }
        return true;
    }
}

