/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.vinci.util.Descriptor;
import org.apache.uima.adapter.vinci.util.NetworkUtil;
import org.apache.uima.adapter.vinci.util.SaxVinciFrameBuilder;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.Serialization;
import org.apache.uima.internal.util.SerializationUtils;
import org.apache.uima.internal.util.UIMALogFormatter;
import org.apache.uima.internal.util.UIMAStreamHandler;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasPool;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.impl.ProcessTrace_impl;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.ServiceDownException;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.VinciServableAdapter;
import org.apache.vinci.transport.VinciServer;
import org.apache.vinci.transport.document.AFrame;

public class VinciBinaryAnalysisEngineService_impl
extends VinciServableAdapter {
    private VinciServer _server = null;
    private AnalysisEngine mAE = null;
    private CasPool mCasPool = null;
    private Descriptor descriptor = null;
    private boolean debug = false;
    private int serviceInstanceId = -1;

    public VinciBinaryAnalysisEngineService_impl(String serviceConfigPath, boolean debug, String instanceId) throws Exception {
        this(serviceConfigPath, debug);
        this.serviceInstanceId = Integer.parseInt(instanceId);
    }

    public VinciBinaryAnalysisEngineService_impl(String serviceConfigPath, boolean debug) throws Exception {
        this.debug = debug;
        UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "VinciBinaryAnalysisEngineService_impl: constructor");
        this.descriptor = new Descriptor(serviceConfigPath);
        String aResourceSpecifierPath = this.descriptor.getResourceSpecifierPath();
        UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINE, "Resource Specifier Path::" + aResourceSpecifierPath);
        ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(aResourceSpecifierPath));
        if (this.mAE == null) {
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "VinciBinaryAnalysisEngineService_impl: creating CAS Processor");
            this.mAE = UIMAFramework.produceAnalysisEngine(resourceSpecifier, this.descriptor.getInstanceCount(), 0);
        }
        if (this.mCasPool == null) {
            this.mCasPool = new CasPool(this.descriptor.getInstanceCount(), this.mAE);
        }
    }

    public VinciBinaryAnalysisEngineService_impl(String serviceConfigPath) throws Exception {
        this(serviceConfigPath, false);
    }

    private Frame getMetaData() throws Exception {
        UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "getMetaData()");
        ProcessingResourceMetaData md = this.mAE.getProcessingResourceMetaData();
        AFrame response = new AFrame();
        SaxVinciFrameBuilder vinciFrameBuilder = new SaxVinciFrameBuilder();
        vinciFrameBuilder.setParentFrame(response);
        vinciFrameBuilder.startDocument();
        md.toXML(vinciFrameBuilder);
        vinciFrameBuilder.endDocument();
        return response;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private Transportable analyze(AFrame aRequestFrame) throws ServiceException {
        CAS cas = null;
        try {
            cas = this.mCasPool.getCas(0L);
            byte[] casBytes = aRequestFrame.fgetTrueBinary("BinaryCAS");
            CASCompleteSerializer serializer = (CASCompleteSerializer)SerializationUtils.deserialize(casBytes);
            Serialization.deserializeCASComplete(serializer, (CASMgr)((Object)cas));
            long annotStartTime = System.currentTimeMillis();
            this.mAE.processCas(cas);
            int annotationTime = (int)(System.currentTimeMillis() - annotStartTime);
            if (this.debug) {
                System.out.println("Annotation took: " + annotationTime + "ms");
            }
            AFrame responseFrame = new AFrame();
            CASSerializer responseSerializer = Serialization.serializeCAS(cas);
            byte[] responseCasBytes = SerializationUtils.serialize(responseSerializer);
            responseFrame.fsetTrueBinary("BinaryCAS", responseCasBytes);
            responseFrame.fset("TAE:AnnotationTime", annotationTime);
            int totalAnnots = 0;
            FSIterator<SofaFS> sItr = cas.getSofaIterator();
            while (sItr.isValid()) {
                SofaFS sofa = sItr.get();
                totalAnnots += cas.getView(sofa).getAnnotationIndex().size();
                sItr.moveToNext();
            }
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINE, "CAS Annotation Count::" + totalAnnots);
            AFrame aFrame = responseFrame;
            return aFrame;
        }
        catch (Throwable ex) {
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.SEVERE, "", ex);
            throw new ServiceException("Unexpected exception in analyze(): " + ex);
        }
        finally {
            if (cas != null) {
                this.mCasPool.releaseCas(cas);
            }
        }
    }

    @Override
    public Transportable eval(Transportable doc) throws ServiceException {
        AFrame frame = (AFrame)doc;
        String op = frame.fgetString("vinci:COMMAND");
        UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "Command::" + op);
        if ("GetMeta".equals(op)) {
            try {
                return this.getMetaData();
            }
            catch (Exception ex) {
                throw new ServiceException("getMetaData() threw exception: " + ex);
            }
        }
        if ("ProcessCas".equals(op) || "Annotate".equals(op)) {
            return this.analyze(frame);
        }
        if ("BatchProcessComplete".equals(op)) {
            try {
                this.mAE.batchProcessComplete(new ProcessTrace_impl());
                return null;
            }
            catch (IOException e) {
                throw new ServiceException("IOException: " + e);
            }
            catch (ResourceProcessException e) {
                throw new ServiceException("ResourceProcessException: " + e);
            }
        }
        if ("CollectionProcessComplete".equals(op)) {
            try {
                this.mAE.collectionProcessComplete(new ProcessTrace_impl());
                return new VinciFrame();
            }
            catch (IOException e) {
                throw new ServiceException("IOException: " + e);
            }
            catch (ResourceProcessException e) {
                throw new ServiceException("ResourceProcessException: " + e);
            }
        }
        if ("IsStateless".equals(op)) {
            return new AFrame().fadd("Result", this.mAE.isStateless());
        }
        if ("IsReadOnly".equals(op)) {
            return new AFrame().fadd("Result", this.mAE.isReadOnly());
        }
        if ("Shutdown".equals(op)) {
            this.stop();
            System.exit(1);
        }
        return new VinciFrame().fadd("Error", "Invalid Operation:" + op);
    }

    protected void start() {
        try {
            ShutdownHook shutdownHook = new ShutdownHook(this);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            String serviceName = this.getDescriptor().getServiceName();
            String serviceHost = System.getProperty("LOCAL_HOST");
            if (serviceHost == null) {
                serviceHost = NetworkUtil.getLocalHostAddress().getHostAddress();
            }
            this._server = this.serviceInstanceId > 0 ? new VinciServer(serviceName, serviceHost, this, 0, this.serviceInstanceId) : new VinciServer(serviceName, serviceHost, this);
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.FINEST, "VinciBinaryAnalysisEngineService_impl: Starting Server with Socket Timeout:" + this.descriptor.getServerSocketTimeout());
            System.out.println("VinciBinaryAnalysisEngineService_impl: Starting Server with Socket Timeout:" + this.descriptor.getServerSocketTimeout());
            this._server.setSocketTimeout(this.descriptor.getServerSocketTimeout());
            this._server.setThreadPoolSize(this.descriptor.getThreadPoolMinSize(), this.descriptor.getThreadPoolMaxSize());
            this._server.serve();
        }
        catch (ServiceDownException e) {
            UIMAFramework.getLogger().log(org.apache.uima.util.Level.SEVERE, e.getMessage());
            System.out.println("\nFailed to contact VNS! Make sure you've specified the correct VNS_HOST and that VNS is up and running.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    public void stop() {
        try {
            if (this._server != null) {
                this._server.shutdown("Shutting Down the Vinci Analysis Engine Service");
                UIMAFramework.getLogger().log(org.apache.uima.util.Level.INFO, "Shutting Down the Vinci Analysis Engine Service");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args2) {
        try {
            String logFile;
            boolean debug;
            boolean bl = debug = System.getProperty("DEBUG") != null;
            if (System.getProperty("VNS_HOST") == null) {
                System.out.println("No VNS_HOST specified; using default localhost");
                System.setProperty("VNS_HOST", "localhost");
            }
            if ((logFile = System.getProperty("LOG")) != null) {
                if (logFile.equalsIgnoreCase("stdout")) {
                    VinciBinaryAnalysisEngineService_impl.redirectLoggerOutput(System.out);
                } else {
                    VinciBinaryAnalysisEngineService_impl.redirectLoggerOutput(new FileOutputStream(logFile));
                }
            }
            VinciBinaryAnalysisEngineService_impl vinciService = args2 != null && args2.length > 1 ? new VinciBinaryAnalysisEngineService_impl(args2[0], debug, args2[1]) : new VinciBinaryAnalysisEngineService_impl(args2[0], debug);
            vinciService.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void redirectLoggerOutput(OutputStream out) {
        Handler[] handlers = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            LogManager.getLogManager().getLogger("").removeHandler(handlers[i]);
        }
        UIMAStreamHandler streamHandler = new UIMAStreamHandler(out, new UIMALogFormatter());
        streamHandler.setLevel(Level.ALL);
        LogManager.getLogManager().getLogger("").addHandler(streamHandler);
    }

    @Override
    public Transportable makeTransportable() {
        return new AFrame();
    }

    static class ShutdownHook
    extends Thread {
        VinciBinaryAnalysisEngineService_impl server;

        public ShutdownHook(VinciBinaryAnalysisEngineService_impl instance) {
            this.server = instance;
        }

        @Override
        public void run() {
            this.server.stop();
        }
    }
}

