/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.AbstractCas_ImplBase;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CasOwner;
import org.apache.uima.cas.ComponentInfo;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIndexRepository;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FeatureValuePath;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.SofaID;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.FSIndexRepositoryMgr;
import org.apache.uima.cas.admin.TypeSystemMgr;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.AnnotationBaseImpl;
import org.apache.uima.cas.impl.AnnotationImpl;
import org.apache.uima.cas.impl.AnnotationIndexImpl;
import org.apache.uima.cas.impl.ArrayFSGenerator;
import org.apache.uima.cas.impl.BinaryCasSerDes4;
import org.apache.uima.cas.impl.BinaryCasSerDes6;
import org.apache.uima.cas.impl.BooleanArrayFSImpl;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.ByteHeap;
import org.apache.uima.cas.impl.CASCompleteSerializer;
import org.apache.uima.cas.impl.CASMetadata;
import org.apache.uima.cas.impl.CASMgrSerializer;
import org.apache.uima.cas.impl.CASSerializer;
import org.apache.uima.cas.impl.CommonSerDes;
import org.apache.uima.cas.impl.DebugFSLogicalStructure;
import org.apache.uima.cas.impl.DebugNameValuePair;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.FSClassRegistry;
import org.apache.uima.cas.impl.FSGenerator;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FSListIteratorImpl;
import org.apache.uima.cas.impl.FSsTobeAddedback;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeaturePathImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.FeatureValuePathImpl;
import org.apache.uima.cas.impl.FilteredIterator;
import org.apache.uima.cas.impl.FloatArrayFSImpl;
import org.apache.uima.cas.impl.Heap;
import org.apache.uima.cas.impl.IntArrayFSImpl;
import org.apache.uima.cas.impl.LongArrayFSImpl;
import org.apache.uima.cas.impl.LongHeap;
import org.apache.uima.cas.impl.LowLevelCAS;
import org.apache.uima.cas.impl.LowLevelException;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.ShortArrayFSImpl;
import org.apache.uima.cas.impl.ShortHeap;
import org.apache.uima.cas.impl.SofaFSImpl;
import org.apache.uima.cas.impl.StringArrayFSImpl;
import org.apache.uima.cas.impl.StringHeap;
import org.apache.uima.cas.impl.StringHeapDeserializationHelper;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.cas.text.Language;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.MiscImpl;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.impl.JCasImpl;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.CasLoadMode;
import org.apache.uima.util.Level;
import org.apache.uima.util.Misc;

public class CASImpl
extends AbstractCas_ImplBase
implements CAS,
CASMgr,
LowLevelCAS {
    private static final boolean trace = false;
    public static final boolean traceFSs = false;
    private static final String traceFile = "traceFSs.log.txt";
    private static final PrintStream traceOut;
    private static final AtomicInteger casIdProvider;
    public static final int NULL = 0;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    private static final int[] INT0;
    public static final int DEFAULT_INITIAL_HEAP_SIZE = 500000;
    public static final int DEFAULT_RESET_HEAP_SIZE = 5000000;
    public static final String THROW_EXCEPTION_FS_UPDATES_CORRUPTS = "uima.exception_when_fs_update_corrupts_index";
    public static final boolean IS_THROW_EXCEPTION_CORRUPT_INDEX;
    public static final String REPORT_FS_UPDATES_CORRUPTS = "uima.report_fs_update_corrupts_index";
    private static final boolean IS_REPORT_FS_UPDATE_CORRUPTS_INDEX;
    public static final String DISABLE_PROTECT_INDEXES = "uima.disable_auto_protect_indexes";
    private static final boolean IS_DISABLED_PROTECT_INDEXES;
    private static final int arrayLengthFeatOffset = 1;
    private static final int arrayContentOffset = 2;
    private static final boolean DEFAULT_USE_FS_CACHE = false;
    final SharedViewData svd;
    FSIndexRepositoryImpl indexRepository;
    private int mySofaRef = 0;
    private JCasImpl jcas = null;
    private final boolean isUsedJcasCache;

    void addbackSingle(int fsAddr) {
        this.svd.fsTobeAddedbackSingle.addback(fsAddr);
        this.svd.fsTobeAddedbackSingleInUse = false;
    }

    void resetAddbackSingleInUse() {
        this.svd.fsTobeAddedbackSingleInUse = false;
    }

    FSsTobeAddedback.FSsTobeAddedbackSingle getAddbackSingle() {
        if (this.svd.fsTobeAddedbackSingleInUse) {
            throw new RuntimeException();
        }
        this.svd.fsTobeAddedbackSingleInUse = true;
        return this.svd.fsTobeAddedbackSingle;
    }

    void featureCodesInIndexKeysAdd(int featCode) {
        this.svd.featureCodesInIndexKeys.add(featCode);
    }

    void maybeClearCacheNotInIndex(int fsAddr) {
        if (this.svd.cache_not_in_index == fsAddr) {
            this.svd.cache_not_in_index = 0;
        }
    }

    public void setCacheNotInIndex(int fsAddr) {
        this.svd.cache_not_in_index = fsAddr;
    }

    private final ArrayList<String> getStringList() {
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add(null);
        int end = this.getStringHeap().getLargestStringCode();
        for (int pos = this.getStringHeap().getLeastStringCode(); pos <= end; ++pos) {
            stringList.add(this.getStringHeap().getStringForCode(pos));
        }
        return stringList;
    }

    @Override
    public void setCAS(CAS cas) {
    }

    public CASImpl(TypeSystemImpl typeSystem, int initialHeapSize, boolean useJcasCache) {
        this(typeSystem, initialHeapSize, false, useJcasCache);
    }

    CASImpl(TypeSystemImpl typeSystem, int initialHeapSize, boolean useFSCache, boolean useJcasCache) {
        this.isUsedJcasCache = useJcasCache;
        boolean externalTypeSystem = typeSystem != null;
        TypeSystemImpl ts = externalTypeSystem ? typeSystem : new TypeSystemImpl();
        this.svd = new SharedViewData(useFSCache, new Heap(initialHeapSize), this, ts.casMetadata);
        if (externalTypeSystem) {
            this.commitTypeSystem();
        }
        this.svd.sofa2indexMap = new HashMap();
        this.svd.sofaNbr2ViewMap = new ArrayList();
        this.svd.sofaNameSet = new HashSet();
        this.svd.initialSofaCreated = false;
        this.svd.viewCount = 0;
        this.clearTrackingMarks();
    }

    public CASImpl() {
        this(500000, true);
    }

    public CASImpl(int initialHeapSize, boolean useJcasCache) {
        this((TypeSystemImpl)null, initialHeapSize, useJcasCache);
    }

    public CASImpl(CASMgrSerializer ser) {
        this(ser.getTypeSystem(), 500000, true);
        this.checkInternalCodes(ser);
        this.indexRepository = ser.getIndexRepository(this);
    }

    CASImpl(CASImpl cas, SofaFS aSofa, boolean useJcasCache) {
        this.isUsedJcasCache = useJcasCache;
        this.svd = cas.svd;
        this.mySofaRef = aSofa != null ? ((FeatureStructureImpl)((Object)aSofa)).getAddress() : -1;
        FSIndexRepositoryImpl fSIndexRepositoryImpl = this.indexRepository = this.mySofaRef == -1 ? (FSIndexRepositoryImpl)cas.getSofaIndexRepository(1) : (FSIndexRepositoryImpl)cas.getSofaIndexRepository(aSofa);
        if (null == this.indexRepository) {
            this.indexRepository = new FSIndexRepositoryImpl(this, (FSIndexRepositoryImpl)cas.getBaseIndexRepository());
            this.indexRepository.commit();
            if (this.mySofaRef == -1) {
                cas.setSofaIndexRepository(1, (FSIndexRepository)this.indexRepository);
            } else {
                cas.setSofaIndexRepository(aSofa, (FSIndexRepository)this.indexRepository);
            }
        }
    }

    void refreshView(CAS cas, SofaFS aSofa) {
        this.mySofaRef = aSofa != null ? ((FeatureStructureImpl)((Object)aSofa)).getAddress() : -1;
        this.jcas = null;
        this.indexRepository = new FSIndexRepositoryImpl(this, (FSIndexRepositoryImpl)((CASImpl)cas).getBaseIndexRepository());
        this.indexRepository.commit();
        if (this.mySofaRef == -1) {
            ((CASImpl)cas).setSofaIndexRepository(1, (FSIndexRepository)this.indexRepository);
        } else {
            ((CASImpl)cas).setSofaIndexRepository(aSofa, (FSIndexRepository)this.indexRepository);
        }
    }

    private void checkInternalCodes(CASMgrSerializer ser) throws CASAdminException {
        if (ser.topTypeCode > 0 && ser.topTypeCode != ((TypeImpl)((SharedViewData)this.svd).casMetadata.ts.getTopType()).getCode()) {
            throw new CASAdminException(8);
        }
        if (ser.featureOffsets == null) {
            return;
        }
        if (ser.featureOffsets.length != ((SharedViewData)this.svd).casMetadata.featureOffset.length) {
            throw new CASAdminException(8);
        }
        for (int i = 1; i < ser.featureOffsets.length; ++i) {
            if (ser.featureOffsets[i] == ((SharedViewData)this.svd).casMetadata.featureOffset[i]) continue;
            throw new CASAdminException(8);
        }
    }

    @Override
    public void enableReset(boolean flag) {
        this.svd.flushEnabled = flag;
    }

    @Override
    public TypeSystem getTypeSystem() {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        if (ts.isCommitted()) {
            return ts;
        }
        throw new CASRuntimeException("TYPESYSTEM_NOT_LOCKED");
    }

    @Override
    public ConstraintFactory getConstraintFactory() {
        return ConstraintFactory.instance();
    }

    @Override
    public <T extends FeatureStructure> T createFS(Type type) {
        int typeCode = ((TypeImpl)type).getCode();
        if (!this.isCreatableType(typeCode)) {
            CASRuntimeException e = new CASRuntimeException("NON_CREATABLE_TYPE", new String[]{type.getName(), "CAS.createFS()"});
            throw e;
        }
        return this.ll_getFSForRef(this.ll_createFSAnnotCheck(typeCode));
    }

    public int ll_createFSAnnotCheck(int typeCode) {
        int addr = this.ll_createFS(typeCode);
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        boolean isAnnot = ts.subsumes(34, typeCode);
        if (isAnnot && this == this.getBaseCAS()) {
            CASRuntimeException e = new CASRuntimeException("DISALLOW_CREATE_ANNOTATION_IN_BASE_CAS", new String[]{ts.ll_getTypeForCode(typeCode).getName()});
            throw e;
        }
        if (isAnnot) {
            this.setFeatureValueNotJournaled(addr, 15, this.getSofaRef());
        }
        return addr;
    }

    @Override
    public ArrayFS createArrayFS(int length) {
        this.checkArrayPreconditions(length);
        int addr = this.createTempArray(6, length);
        return (ArrayFS)this.createFS(addr);
    }

    @Override
    public IntArrayFS createIntArrayFS(int length) {
        this.checkArrayPreconditions(length);
        int addr = this.createTempArray(8, length);
        return (IntArrayFS)this.createFS(addr);
    }

    @Override
    public FloatArrayFS createFloatArrayFS(int length) {
        this.checkArrayPreconditions(length);
        int addr = this.createTempArray(7, length);
        return (FloatArrayFS)this.createFS(addr);
    }

    @Override
    public StringArrayFS createStringArrayFS(int length) {
        this.checkArrayPreconditions(length);
        int addr = this.createTempArray(9, length);
        return (StringArrayFS)this.createFS(addr);
    }

    public final void checkArrayPreconditions(int len) throws CASRuntimeException {
        if (len < 0) {
            throw new CASRuntimeException("ILLEGAL_ARRAY_SIZE");
        }
    }

    public boolean isBackwardCompatibleCas() {
        if (this.svd.viewCount != 1) {
            return false;
        }
        if (!this.svd.initialSofaCreated) {
            return false;
        }
        int llsofa = this.getInitialView().getLowLevelCAS().ll_getSofa();
        String sofaMime = this.ll_getStringValue(llsofa, 11);
        if (!"text".equals(sofaMime)) {
            return false;
        }
        String sofaUri = this.ll_getStringValue(llsofa, 14);
        if (sofaUri != null) {
            return false;
        }
        int sofaArray = this.ll_getRefValue(llsofa, 12);
        if (sofaArray != 0) {
            return false;
        }
        String sofaname = this.ll_getStringValue(llsofa, 10);
        return "_InitialView".equals(sofaname);
    }

    int getBaseSofaCount() {
        return this.svd.viewCount;
    }

    FSIndexRepository getSofaIndexRepository(SofaFS aSofa) {
        return this.getSofaIndexRepository(aSofa.getSofaRef());
    }

    FSIndexRepository getSofaIndexRepository(int aSofaRef) {
        return (FSIndexRepository)this.svd.sofa2indexMap.get(aSofaRef);
    }

    void setSofaIndexRepository(SofaFS aSofa, FSIndexRepository indxRepos) {
        this.setSofaIndexRepository(aSofa.getSofaRef(), indxRepos);
    }

    void setSofaIndexRepository(int aSofaRef, FSIndexRepository indxRepos) {
        this.svd.sofa2indexMap.put(aSofaRef, indxRepos);
    }

    @Override
    @Deprecated
    public SofaFS createSofa(SofaID sofaID, String mimeType) {
        SofaFS aSofa = this.createSofa(sofaID.getSofaID(), mimeType);
        this.getView(aSofa);
        return aSofa;
    }

    SofaFS createSofa(String sofaName, String mimeType) {
        int addr = this.ll_createFS(33);
        Object sofa = this.ll_getFSForRef(addr);
        this.addSofa((FeatureStructure)sofa, sofaName, mimeType);
        return (SofaFS)sofa;
    }

    SofaFS createInitialSofa(String mimeType) {
        int addr = this.ll_createFS(33);
        Object sofa = this.ll_getFSForRef(addr);
        this.ll_setIntValue(addr, 9, 1);
        this.addSofa((FeatureStructure)sofa, "_InitialView", mimeType);
        this.registerInitialSofa();
        this.mySofaRef = addr;
        return (SofaFS)sofa;
    }

    void registerInitialSofa() {
        this.svd.initialSofaCreated = true;
    }

    boolean isInitialSofaCreated() {
        return this.svd.initialSofaCreated;
    }

    public void addSofa(FeatureStructure sofa, String sofaName, String mimeType) {
        if (this.svd.sofaNameSet.contains(sofaName)) {
            CASRuntimeException e = new CASRuntimeException("SOFANAME_ALREADY_EXISTS", new String[]{sofaName});
            throw e;
        }
        int llsofa = this.ll_getFSRef(sofa);
        if (0 == this.ll_getIntValue(llsofa, 9)) {
            this.ll_setIntValue(llsofa, 9, ++this.svd.viewCount);
        }
        this.ll_setStringValue(llsofa, 10, sofaName);
        this.ll_setStringValue(llsofa, 11, mimeType);
        this.getBaseIndexRepository().addFS(sofa);
        this.svd.sofaNameSet.add(sofaName);
    }

    @Override
    @Deprecated
    public SofaFS getSofa(SofaID sofaID) {
        return this.getSofa(sofaID.getSofaID());
    }

    private SofaFS getSofa(String sofaName) {
        FSIterator<SofaFS> iterator2 = this.svd.baseCAS.getSofaIterator();
        while (iterator2.isValid()) {
            SofaFS sofa = iterator2.get();
            if (sofaName.equals(this.getStringValue(((FeatureStructureImpl)((Object)sofa)).getAddress(), 10))) {
                return sofa;
            }
            iterator2.moveToNext();
        }
        CASRuntimeException e = new CASRuntimeException("SOFANAME_NOT_FOUND", new String[]{sofaName});
        throw e;
    }

    SofaFS getSofa(int sofaRef) {
        SofaFS aSofa = (SofaFS)this.ll_getFSForRef(sofaRef);
        if (aSofa == null) {
            CASRuntimeException e = new CASRuntimeException("SOFAREF_NOT_FOUND");
            throw e;
        }
        return aSofa;
    }

    public int ll_getSofaNum(int sofaRef) {
        return this.ll_getIntValue(sofaRef, 9);
    }

    public String ll_getSofaID(int sofaRef) {
        return this.ll_getStringValue(sofaRef, 10);
    }

    public String ll_getSofaDataString(int sofaAddr) {
        return this.ll_getStringValue(sofaAddr, 13);
    }

    public CASImpl getBaseCAS() {
        return this.svd.baseCAS;
    }

    @Override
    public FSIterator<SofaFS> getSofaIterator() {
        FSIndex sofaIndex = ((SharedViewData)this.svd).baseCAS.indexRepository.getIndex("SofaIndex");
        return sofaIndex.iterator();
    }

    public void setSofaFeat(int addr, int sofa) {
        this.setFeatureValueNoIndexCorruptionCheck(addr, 15, sofa);
    }

    public int getSofaFeat(int addr) {
        return this.getFeatureValue(addr, 15);
    }

    public int getSofaRef() {
        if (this.mySofaRef == -1) {
            this.mySofaRef = this.createInitialSofa(null).hashCode();
        }
        return this.mySofaRef;
    }

    public InputStream getSofaDataStream(SofaFS aSofa) {
        block18: {
            try {
                if (null != aSofa.getLocalStringData()) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(aSofa.getLocalStringData().getBytes("UTF-8"));
                    return bis;
                }
                if (null != aSofa.getLocalFSData()) {
                    FeatureStructureImpl fs = (FeatureStructureImpl)aSofa.getLocalFSData();
                    int arrayStart = 0;
                    int arraySize = this.ll_getArraySize(fs.getAddress());
                    ByteBuffer buf = null;
                    Type type = fs.getType();
                    if (type.getName().equals("uima.cas.StringArray")) {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < ((StringArrayFS)((Object)fs)).size(); ++i) {
                            if (i == 0) {
                                sb.append(((StringArrayFS)((Object)fs)).get(i));
                                continue;
                            }
                            sb.append("\n" + ((StringArrayFS)((Object)fs)).get(i));
                        }
                        ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes("UTF-8"));
                        return bis;
                    }
                    if (type.getName().equals("uima.cas.IntegerArray")) {
                        arrayStart = this.getArrayStartAddress(fs.getAddress());
                        buf = ByteBuffer.allocate(arraySize * 4);
                        IntBuffer intbuf = buf.asIntBuffer();
                        intbuf.put(this.getHeap().heap, arrayStart, arraySize);
                        ByteArrayInputStream bis = new ByteArrayInputStream(buf.array());
                        return bis;
                    }
                    if (type.getName().equals("uima.cas.FloatArray")) {
                        arrayStart = this.getArrayStartAddress(fs.getAddress());
                        buf = ByteBuffer.allocate(arraySize * 4);
                        FloatBuffer floatbuf = buf.asFloatBuffer();
                        float[] floatArray = new float[arraySize];
                        for (int i = arrayStart; i < arrayStart + arraySize; ++i) {
                            floatArray[i - arrayStart] = Float.intBitsToFloat(this.getHeap().heap[i]);
                        }
                        floatbuf.put(floatArray);
                        ByteArrayInputStream bis = new ByteArrayInputStream(buf.array());
                        return bis;
                    }
                    if (type.getName().equals("uima.cas.BooleanArray") || type.getName().equals("uima.cas.ByteArray")) {
                        arrayStart = this.getHeap().heap[this.getArrayStartAddress(fs.getAddress())];
                        buf = ByteBuffer.allocate(arraySize);
                        buf.put(this.getByteHeap().heap, arrayStart, arraySize);
                        ByteArrayInputStream bis = new ByteArrayInputStream(buf.array());
                        return bis;
                    }
                    if (type.getName().equals("uima.cas.ShortArray")) {
                        arrayStart = this.getHeap().heap[this.getArrayStartAddress(fs.getAddress())];
                        buf = ByteBuffer.allocate(arraySize * 2);
                        ShortBuffer shortbuf = buf.asShortBuffer();
                        shortbuf.put(this.getShortHeap().heap, arrayStart, arraySize);
                        ByteArrayInputStream bis = new ByteArrayInputStream(buf.array());
                        return bis;
                    }
                    if (type.getName().equals("uima.cas.LongArray")) {
                        arrayStart = this.getHeap().heap[this.getArrayStartAddress(fs.getAddress())];
                        buf = ByteBuffer.allocate(arraySize * 8);
                        LongBuffer longbuf = buf.asLongBuffer();
                        longbuf.put(this.getLongHeap().heap, arrayStart, arraySize);
                        ByteArrayInputStream bis = new ByteArrayInputStream(buf.array());
                        return bis;
                    }
                    if (type.getName().equals("uima.cas.DoubleArray")) {
                        arrayStart = this.getHeap().heap[this.getArrayStartAddress(fs.getAddress())];
                        buf = ByteBuffer.allocate(arraySize * 8);
                        DoubleBuffer doublebuf = buf.asDoubleBuffer();
                        double[] doubleArray = new double[arraySize];
                        for (int i = arrayStart; i < arrayStart + arraySize; ++i) {
                            doubleArray[i - arrayStart] = Double.longBitsToDouble(this.getLongHeap().heap[i]);
                        }
                        doublebuf.put(doubleArray);
                        ByteArrayInputStream bis = new ByteArrayInputStream(buf.array());
                        return bis;
                    }
                    break block18;
                }
                if (null != aSofa.getSofaURI()) {
                    URL url = new URL(aSofa.getSofaURI());
                    return url.openStream();
                }
                return null;
            }
            catch (MalformedURLException exc) {
                CASRuntimeException e = new CASRuntimeException("SOFADATASTREAM_ERROR", new String[]{exc.getMessage()});
                throw e;
            }
            catch (CASRuntimeException exc) {
                CASRuntimeException e = new CASRuntimeException("SOFADATASTREAM_ERROR", new String[]{exc.getMessage()});
                throw e;
            }
            catch (IOException exc) {
                CASRuntimeException e = new CASRuntimeException("SOFADATASTREAM_ERROR", new String[]{exc.getMessage()});
                throw e;
            }
        }
        return null;
    }

    @Override
    public <T extends FeatureStructure> FSIterator<T> createFilteredIterator(FSIterator<T> it, FSMatchConstraint cons) {
        return new FilteredIterator<T>(it, cons);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTypeSystem() {
        TypeSystemImpl ts;
        TypeSystemImpl typeSystemImpl = ts = ((SharedViewData)this.svd).casMetadata.ts;
        synchronized (typeSystemImpl) {
            if (!ts.isCommitted()) {
                ts.commit();
                this.initFSClassRegistry();
                FSClassRegistry fscr = this.getFSClassRegistry();
                fscr.saveGeneratorsForClassLoader(this.svd.previousJCasClassLoader, fscr.getBaseGenerators());
            }
        }
        this.setLocalFsGenerators(((SharedViewData)this.svd).casMetadata.fsClassRegistry.getBaseGenerators());
        this.createIndexRepository();
        this.svd.annotFeatOffset_begin = this.getFeatureOffset(16);
        this.svd.annotFeatOffset_end = this.getFeatureOffset(17);
    }

    public void setLocalFsGenerators(FSGenerator<? extends FeatureStructure>[] fsGenerators) {
        SharedViewData.access$1702(this.svd, fsGenerators);
    }

    private void createIndexRepository() {
        if (!this.getTypeSystemMgr().isCommitted()) {
            throw new CASAdminException(2);
        }
        if (this.indexRepository == null) {
            this.indexRepository = new FSIndexRepositoryImpl(this);
        }
    }

    @Override
    public FSIndexRepositoryMgr getIndexRepositoryMgr() {
        return this.indexRepository;
    }

    @Deprecated
    public void commitFS(FeatureStructure fs) {
        this.getIndexRepository().addFS(fs);
    }

    @Override
    public FeaturePath createFeaturePath() {
        return new FeaturePathImpl();
    }

    @Override
    public TypeSystemMgr getTypeSystemMgr() {
        return ((SharedViewData)this.svd).casMetadata.ts;
    }

    @Override
    public void reset() {
        if (!this.svd.flushEnabled) {
            throw new CASAdminException(9);
        }
        if (this == this.svd.baseCAS) {
            this.resetNoQuestions();
            return;
        }
        this.svd.baseCAS.resetNoQuestions();
    }

    private void resetView() {
        this.indexRepository.flush();
    }

    public void resetNoQuestions() {
        this.svd.casResets.incrementAndGet();
        int numViews = this.getBaseSofaCount();
        for (int view = 1; view <= numViews; ++view) {
            CAS tcas;
            CAS cAS = tcas = view == 1 ? this.getInitialView() : this.getView(view);
            if (tcas == null) continue;
            ((CASImpl)tcas).resetView();
            ((CASImpl)tcas).mySofaRef = 1 == view ? -1 : 0;
        }
        this.getHeap().reset();
        this.resetStringTable();
        this.getByteHeap().reset();
        this.getShortHeap().reset();
        this.getLongHeap().reset();
        this.indexRepository.flush();
        this.svd.sofaNameSet = new HashSet();
        this.svd.initialSofaCreated = false;
        this.svd.viewCount = 1;
        if (null != ((SharedViewData)this.svd).casMetadata.fsClassRegistry) {
            ((SharedViewData)this.svd).casMetadata.fsClassRegistry.flush();
        }
        if (this.jcas != null) {
            JCasImpl.clearData(this);
        }
        this.clearTrackingMarks();
        this.svd.cache_not_in_index = 0;
        this.svd.fssTobeAddedback.clear();
        this.svd.fssTobeAddedback.trimToSize();
        this.svd.traceFSid = 0;
        this.svd.componentInfo = null;
    }

    @Override
    @Deprecated
    public void flush() {
        this.reset();
    }

    @Override
    public FSIndexRepository getIndexRepository() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        if (this.indexRepository.isCommitted()) {
            return this.indexRepository;
        }
        return null;
    }

    FSIndexRepository getBaseIndexRepository() {
        if (((SharedViewData)this.svd).baseCAS.indexRepository.isCommitted()) {
            return ((SharedViewData)this.svd).baseCAS.indexRepository;
        }
        return null;
    }

    void addSofaFsToIndex(SofaFS sofa) {
        this.svd.baseCAS.getBaseIndexRepository().addFS(sofa);
    }

    void registerView(SofaFS aSofa) {
        this.mySofaRef = ((FeatureStructureImpl)((Object)aSofa)).getAddress();
    }

    public void reinit(CASSerializer ser) {
        if (this != this.svd.baseCAS) {
            this.svd.baseCAS.reinit(ser);
            return;
        }
        this.resetNoQuestions();
        this.reinit(ser.getHeapMetadata(), ser.getHeapArray(), ser.getStringTable(), ser.getFSIndex(), ser.getByteArray(), ser.getShortArray(), ser.getLongArray());
    }

    @Override
    public <T extends FeatureStructure> ListIterator<T> fs2listIterator(FSIterator<T> it) {
        return new FSListIteratorImpl<T>(it);
    }

    @Override
    public CAS getCAS() {
        if (this.indexRepository.isCommitted()) {
            return this;
        }
        throw new CASAdminException(3);
    }

    void resetStringTable() {
        this.getStringHeap().reset();
    }

    private void initFSClassRegistry() {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.initGeneratorArray();
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.fsArrayType, new ArrayFSGenerator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.intArrayType, IntArrayFSImpl.generator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.floatArrayType, FloatArrayFSImpl.generator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.stringArrayType, StringArrayFSImpl.generator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.sofaType, SofaFSImpl.getSofaFSGenerator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.annotBaseType, AnnotationBaseImpl.getAnnotationGenerator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.annotType, AnnotationImpl.getAnnotationGenerator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.byteArrayType, ByteArrayFSImpl.generator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.booleanArrayType, BooleanArrayFSImpl.generator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.shortArrayType, ShortArrayFSImpl.generator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.longArrayType, LongArrayFSImpl.generator());
        ((SharedViewData)this.svd).casMetadata.fsClassRegistry.addClassForType(ts.doubleArrayType, DoubleArrayFSImpl.generator());
    }

    public FSClassRegistry getFSClassRegistry() {
        return ((SharedViewData)this.svd).casMetadata.fsClassRegistry;
    }

    public CASImpl setupCasFromCasMgrSerializer(CASMgrSerializer casMgrSerializer) {
        CASImpl cas = this.getBaseCAS();
        if (null != casMgrSerializer) {
            TypeSystemImpl ts = casMgrSerializer.getTypeSystem();
            cas.svd.casMetadata = ts.casMetadata;
            cas.commitTypeSystem();
            cas.indexRepository = casMgrSerializer.getIndexRepository(cas);
            cas.indexRepository.commit();
            CAS initialView = cas.getInitialView();
            cas.svd.sofa2indexMap.clear();
            cas.svd.sofaNbr2ViewMap.clear();
            cas.svd.viewCount = 0;
            ((CASImpl)initialView).refreshView(cas.svd.baseCAS, null);
            this.setViewForSofaNbr(1, initialView);
            cas.svd.viewCount = 1;
        }
        return cas;
    }

    public void reinit(CASCompleteSerializer casCompSer) {
        if (this != this.svd.baseCAS) {
            this.svd.baseCAS.reinit(casCompSer);
            return;
        }
        this.setupCasFromCasMgrSerializer(casCompSer.getCASMgrSerializer());
        CASSerializer casSer = casCompSer.getCASSerializer();
        this.reinit(casSer.getHeapMetadata(), casSer.getHeapArray(), casSer.getStringTable(), casSer.getFSIndex(), casSer.getByteArray(), casSer.getShortArray(), casSer.getLongArray());
        this.jcas = null;
        this.clearTrackingMarks();
    }

    private void clearTrackingMarks() {
        if (this.svd.trackingMarkList != null) {
            for (int i = 0; i < this.svd.trackingMarkList.size(); ++i) {
                ((MarkerImpl)((SharedViewData)this.svd).trackingMarkList.get((int)i)).isValid = false;
            }
        }
        this.svd.trackingMark = null;
        this.svd.modifiedPreexistingFSs = null;
        this.svd.modifiedFSHeapCells = null;
        this.svd.modifiedByteHeapCells = null;
        this.svd.modifiedShortHeapCells = null;
        this.svd.modifiedLongHeapCells = null;
        this.svd.trackingMarkList = null;
    }

    void reinit(int[] heapMetadata, int[] heapArray, String[] stringTable, int[] fsIndex, byte[] byteHeapArray, short[] shortHeapArray, long[] longHeapArray) {
        this.createStringTableFromArray(stringTable);
        this.getHeap().reinit(heapMetadata, heapArray);
        if (byteHeapArray != null) {
            this.getByteHeap().reinit(byteHeapArray);
        }
        if (shortHeapArray != null) {
            this.getShortHeap().reinit(shortHeapArray);
        }
        if (longHeapArray != null) {
            this.getLongHeap().reinit(longHeapArray);
        }
        this.reinitIndexedFSs(fsIndex);
    }

    public SerialFormat reinit(InputStream istream) throws CASRuntimeException {
        if (this != this.svd.baseCAS) {
            return this.svd.baseCAS.reinit(istream);
        }
        DataInputStream dis = CommonSerDes.maybeWrapToDataInputStream(istream);
        try {
            CommonSerDes.Header h2 = CommonSerDes.readHeader(dis);
            return this.reinit(h2, istream, null, CasLoadMode.DEFAULT, null, AllowPreexistingFS.allow, null);
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            CASRuntimeException exception = new CASRuntimeException("BLOB_DESERIALIZATION", new String[]{msg});
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerialFormat reinit(CommonSerDes.Header h2, InputStream istream, CASMgrSerializer casMgrSerializer, CasLoadMode casLoadMode, BinaryCasSerDes6 f6, AllowPreexistingFS allowPreexistingFS, TypeSystemImpl ts) throws CASRuntimeException {
        if (this != this.svd.baseCAS) {
            return this.svd.baseCAS.reinit(h2, istream, casMgrSerializer, casLoadMode, f6, allowPreexistingFS, ts);
        }
        DataInputStream dis = CommonSerDes.maybeWrapToDataInputStream(istream);
        BinDeserSupport bds = new BinDeserSupport();
        CASMgrSerializer embeddedCasMgrSerializer = CASImpl.maybeReadEmbeddedTSI(h2, dis);
        if (!h2.isForm6() || casLoadMode == CasLoadMode.REINIT) {
            this.setupCasFromCasMgrSerializer(null != embeddedCasMgrSerializer && embeddedCasMgrSerializer.hasIndexRepository() ? embeddedCasMgrSerializer : casMgrSerializer);
        }
        if (!h2.isForm6() && casLoadMode == CasLoadMode.LENIENT) {
            throw new CASRuntimeException("LENIENT_NOT_SUPPORTED", new Object[]{h2.toString()});
        }
        try {
            int i;
            boolean delta = h2.isDelta;
            if (!delta) {
                this.resetNoQuestions();
            }
            if (h2.form4) {
                new BinaryCasSerDes4(this.getTypeSystemImpl(), false).deserialize(this, dis, delta);
                return h2.typeSystemIndexDefIncluded ? SerialFormat.COMPRESSED_TSI : SerialFormat.COMPRESSED;
            }
            if (h2.form6) {
                TypeSystemImpl tsRead;
                CASMgrSerializer cms = embeddedCasMgrSerializer != null ? embeddedCasMgrSerializer : casMgrSerializer;
                TypeSystemImpl typeSystemImpl = tsRead = cms != null ? cms.getTypeSystem() : null;
                if (null != tsRead) {
                    tsRead.commit();
                }
                TypeSystemImpl ts_for_decoding = tsRead != null && embeddedCasMgrSerializer != null ? tsRead : (ts != null ? ts : (f6 != null && f6.getTgtTs() != null ? f6.getTgtTs() : tsRead));
                try {
                    BinaryCasSerDes6 bcsd = f6 != null ? new BinaryCasSerDes6(f6, ts_for_decoding) : new BinaryCasSerDes6((AbstractCas)this, ts_for_decoding);
                    bcsd.deserializeAfterVersion(dis, delta, AllowPreexistingFS.allow);
                    return h2.typeSystemIndexDefIncluded ? SerialFormat.COMPRESSED_FILTERED_TSI : (h2.typeSystemIncluded ? SerialFormat.COMPRESSED_FILTERED_TS : SerialFormat.COMPRESSED_FILTERED);
                }
                catch (ResourceInitializationException e) {
                    throw new CASRuntimeException("DESERIALIZING_COMPRESSED_BINARY_UNSUPPORTED", null, e);
                }
            }
            CommonSerDes.Reading r = h2.reading;
            int fsheapsz = r.readInt();
            int startPos = 0;
            if (!delta) {
                this.getHeap().reinitSizeOnly(fsheapsz);
            } else {
                startPos = this.getHeap().getNextId();
                this.getHeap().grow(fsheapsz);
            }
            for (int i2 = startPos; i2 < fsheapsz + startPos; ++i2) {
                this.getHeap().heap[i2] = r.readInt();
            }
            int stringheapsz = r.readInt();
            StringHeapDeserializationHelper shdh = new StringHeapDeserializationHelper();
            shdh.charHeap = new char[stringheapsz];
            for (int i3 = 0; i3 < stringheapsz; ++i3) {
                shdh.charHeap[i3] = (char)r.readShort();
            }
            shdh.charHeapPos = stringheapsz;
            if (stringheapsz % 2 != 0) {
                dis.readChar();
            }
            int refheapsz = r.readInt();
            --refheapsz;
            refheapsz /= 2;
            shdh.refHeap = new int[3 + (refheapsz *= 3)];
            dis.readInt();
            for (int i4 = shdh.refHeapPos; i4 < shdh.refHeap.length; i4 += 3) {
                shdh.refHeap[i4 + 0] = r.readInt();
                shdh.refHeap[i4 + 1] = r.readInt();
                shdh.refHeap[i4 + 2] = 0;
            }
            shdh.refHeapPos = refheapsz + 3;
            this.getStringHeap().reinit(shdh, delta);
            if (delta) {
                int heapsize = this.getHeap().getNextId();
                IntVector fss = new IntVector(Math.max(128, heapsize >> 6));
                int fsAddr = 1;
                while (fsAddr < heapsize) {
                    fss.add(fsAddr);
                    fsAddr = this.getNextFsHeapAddr(fsAddr);
                }
                fss.add(fsAddr);
                BinDeserSupport.access$3002(bds, fss.toArray());
                int fsmodssz = r.readInt();
                bds.fsStartAddr = -1;
                this.svd.fsTobeAddedbackSingleInUse = true;
                try {
                    for (i = 0; i < fsmodssz; ++i) {
                        int heapAddrBeingModified = r.readInt();
                        this.maybeAddBackAndRemoveFs(heapAddrBeingModified, bds);
                        this.getHeap().heap[heapAddrBeingModified] = r.readInt();
                    }
                    bds.tobeAddedback.addback(bds.lastRemovedFsAddr);
                    BinDeserSupport.access$3002(bds, null);
                }
                finally {
                    this.svd.fsTobeAddedbackSingleInUse = false;
                }
            }
            int fsindexsz = r.readInt();
            int[] fsindexes = new int[fsindexsz];
            for (int i5 = 0; i5 < fsindexsz; ++i5) {
                fsindexes[i5] = r.readInt();
            }
            if (delta) {
                this.reinitDeltaIndexedFSs(fsindexes);
            } else {
                this.reinitIndexedFSs(fsindexes);
            }
            int heapsz = r.readInt();
            if (!delta) {
                this.getByteHeap().heap = new byte[Math.max(16, heapsz)];
                dis.readFully(this.getByteHeap().heap, 0, heapsz);
                this.getByteHeap().heapPos = heapsz;
            } else {
                for (int i6 = 0; i6 < heapsz; ++i6) {
                    this.getByteHeap().addByte(dis.readByte());
                }
            }
            int align = (4 - heapsz % 4) % 4;
            BinaryCasSerDes6.skipBytes(dis, align);
            heapsz = r.readInt();
            if (!delta) {
                this.getShortHeap().heap = new short[Math.max(16, heapsz)];
                for (i = 0; i < heapsz; ++i) {
                    this.getShortHeap().heap[i] = r.readShort();
                }
                this.getShortHeap().heapPos = heapsz;
            } else {
                for (i = 0; i < heapsz; ++i) {
                    this.getShortHeap().addShort(r.readShort());
                }
            }
            if (heapsz % 2 != 0) {
                dis.readShort();
            }
            heapsz = r.readInt();
            if (!delta) {
                this.getLongHeap().heap = new long[Math.max(16, heapsz)];
                for (i = 0; i < heapsz; ++i) {
                    this.getLongHeap().heap[i] = r.readLong();
                }
                this.getLongHeap().heapPos = heapsz;
            } else {
                for (i = 0; i < heapsz; ++i) {
                    this.getLongHeap().addLong(r.readLong());
                }
            }
            if (delta) {
                int i7;
                heapsz = r.readInt();
                if (heapsz > 0) {
                    int[] heapAddrs = new int[heapsz];
                    for (i7 = 0; i7 < heapsz; ++i7) {
                        heapAddrs[i7] = r.readInt();
                    }
                    for (i7 = 0; i7 < heapsz; ++i7) {
                        this.getByteHeap().heap[heapAddrs[i7]] = dis.readByte();
                    }
                }
                align = (4 - heapsz % 4) % 4;
                BinaryCasSerDes6.skipBytes(dis, align);
                heapsz = r.readInt();
                if (heapsz > 0) {
                    int[] heapAddrs = new int[heapsz];
                    for (i7 = 0; i7 < heapsz; ++i7) {
                        heapAddrs[i7] = r.readInt();
                    }
                    for (i7 = 0; i7 < heapsz; ++i7) {
                        this.getShortHeap().heap[heapAddrs[i7]] = r.readShort();
                    }
                }
                if (heapsz % 2 != 0) {
                    dis.readShort();
                }
                if ((heapsz = r.readInt()) > 0) {
                    int[] heapAddrs = new int[heapsz];
                    for (i7 = 0; i7 < heapsz; ++i7) {
                        heapAddrs[i7] = r.readInt();
                    }
                    for (i7 = 0; i7 < heapsz; ++i7) {
                        this.getLongHeap().heap[heapAddrs[i7]] = r.readLong();
                    }
                }
            }
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            CASRuntimeException exception = new CASRuntimeException("BLOB_DESERIALIZATION", new String[]{msg});
            throw exception;
        }
        return h2.typeSystemIndexDefIncluded ? SerialFormat.BINARY_TSI : SerialFormat.BINARY;
    }

    static CASMgrSerializer maybeReadEmbeddedTSI(CommonSerDes.Header h2, DataInputStream dis) {
        if (h2.isTypeSystemIncluded() || h2.isTypeSystemIndexDefIncluded()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(dis);
                return (CASMgrSerializer)ois.readObject();
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CASRuntimeException("UNRECOGNIZED_SERIALIZED_CAS_FORMAT", null, e);
            }
        }
        return null;
    }

    private void maybeAddBackAndRemoveFs(int heapAddr, BinDeserSupport bds) {
        if (bds.fsStartAddr == -1) {
            bds.fssIndex = -1;
            bds.lastRemovedFsAddr = -1;
            bds.tobeAddedback.clear();
        }
        this.findCorrespondingFs(heapAddr, bds);
        if (bds.lastRemovedFsAddr != bds.fsStartAddr) {
            bds.tobeAddedback.addback(bds.lastRemovedFsAddr);
            if (bds.featCodes.length == 0) {
                int typeCode = this.getTypeCode(bds.fsStartAddr);
                assert (this.getTypeSystemImpl().ll_isArrayType(typeCode));
            } else {
                int featCode = bds.featCodes[heapAddr - (bds.fsStartAddr + 1)];
                this.removeFromCorruptableIndexAnyView(bds.lastRemovedFsAddr = bds.fsStartAddr, bds.tobeAddedback, featCode);
            }
        }
    }

    private void findCorrespondingFs(int heapAddr, BinDeserSupport bds) {
        if (bds.fsStartAddr < heapAddr && heapAddr < bds.fsEndAddr) {
            return;
        }
        bds.fssIndex++;
        bds.fsStartAddr = bds.fssAddrArray[bds.fssIndex];
        if (bds.fssIndex + 1 < bds.fssAddrArray.length) {
            bds.fsEndAddr = bds.fssAddrArray[bds.fssIndex + 1];
            if (bds.fsStartAddr < heapAddr && heapAddr < bds.fsEndAddr) {
                BinDeserSupport.access$3502(bds, this.getTypeSystemImpl().ll_getAppropriateFeatures(this.getTypeCode(bds.fsStartAddr)));
                return;
            }
        }
        int result = heapAddr > bds.fsEndAddr ? Arrays.binarySearch(bds.fssAddrArray, bds.fssIndex + 1, bds.fssAddrArray.length, heapAddr) : Arrays.binarySearch(bds.fssAddrArray, 0, bds.fssIndex - 1, heapAddr);
        assert (result < 0);
        bds.fssIndex = -result - 2;
        bds.fsStartAddr = bds.fssAddrArray[bds.fssIndex];
        bds.fsEndAddr = bds.fssAddrArray[bds.fssIndex + 1];
        BinDeserSupport.access$3502(bds, this.getTypeSystemImpl().ll_getAppropriateFeatures(this.getTypeCode(bds.fsStartAddr)));
        assert (bds.fsStartAddr < heapAddr && heapAddr < bds.fsEndAddr);
    }

    private int getNextFsHeapAddr(int fsAddr) {
        boolean isHeapStoredArray;
        TypeSystemImpl tsi = this.getTypeSystemImpl();
        int typeCode = this.getTypeCode(fsAddr);
        Type type = tsi.ll_getTypeForCode(typeCode);
        boolean bl = isHeapStoredArray = typeCode == 8 || typeCode == 7 || typeCode == 6 || typeCode == 9 || TypeSystemImpl.isArrayTypeNameButNotBuiltIn(type.getName());
        if (isHeapStoredArray) {
            return fsAddr + 2 + this.getHeapValue(fsAddr + 1);
        }
        if (type.isArray()) {
            return fsAddr + 3;
        }
        return fsAddr + ((SharedViewData)this.svd).casMetadata.fsSpaceReq[typeCode];
    }

    void reinitIndexedFSs(int[] fsIndex) {
        int numViews = fsIndex[0];
        int loopLen = fsIndex[1];
        for (int i = 2; i < loopLen + 2; ++i) {
            this.indexRepository.addFS(fsIndex[i]);
        }
        int loopStart = loopLen + 2;
        FSIterator<SofaFS> iterator2 = this.svd.baseCAS.getSofaIterator();
        Feature idFeat = this.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID");
        while (iterator2.isValid()) {
            SofaFS sofa = iterator2.get();
            String id = this.ll_getStringValue(((FeatureStructureImpl)((Object)sofa)).getAddress(), ((FeatureImpl)idFeat).getCode());
            if ("_InitialView".equals(id)) {
                this.registerInitialSofa();
                this.svd.sofaNameSet.add(id);
            }
            ((CASImpl)this.getView(sofa)).registerView(sofa);
            iterator2.moveToNext();
        }
        this.getInitialView();
        this.svd.viewCount = numViews;
        for (int viewNbr = 1; viewNbr <= numViews; ++viewNbr) {
            CAS view;
            CAS cAS = view = viewNbr == 1 ? this.getInitialView() : this.getView(viewNbr);
            if (view != null) {
                FSIndexRepositoryImpl loopIndexRep = (FSIndexRepositoryImpl)this.getSofaIndexRepository(viewNbr);
                loopLen = fsIndex[loopStart];
                for (int i = loopStart + 1; i < loopStart + 1 + loopLen; ++i) {
                    loopIndexRep.addFS(fsIndex[i]);
                }
                loopStart += loopLen + 1;
                ((CASImpl)view).updateDocumentAnnotation();
                continue;
            }
            ++loopStart;
        }
    }

    void reinitDeltaIndexedFSs(int[] fsIndex) {
        assert (this.svd.baseCAS == this);
        int numViews = fsIndex[0];
        int loopLen = fsIndex[1];
        for (int i = 2; i < loopLen + 2; ++i) {
            this.indexRepository.addFS(fsIndex[i]);
        }
        int loopStart = loopLen + 2;
        FSIterator<SofaFS> iterator2 = this.getSofaIterator();
        int idFeatCode = ((FeatureImpl)this.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaID")).getCode();
        while (iterator2.isValid()) {
            SofaFS sofa = iterator2.get();
            String id = this.ll_getStringValue(((FeatureStructureImpl)((Object)sofa)).getAddress(), idFeatCode);
            if ("_InitialView".equals(id)) {
                this.registerInitialSofa();
                this.svd.sofaNameSet.add(id);
            }
            ((CASImpl)this.getView(sofa)).registerView(sofa);
            iterator2.moveToNext();
        }
        this.svd.viewCount = numViews;
        for (int viewNbr = 1; viewNbr <= numViews; ++viewNbr) {
            CAS view;
            CAS cAS = view = viewNbr == 1 ? this.getInitialView() : this.getView(viewNbr);
            if (view != null) {
                int i;
                FSIndexRepositoryImpl loopIndexRep = (FSIndexRepositoryImpl)this.getSofaIndexRepository(viewNbr);
                loopLen = fsIndex[loopStart];
                for (i = loopStart + 1; i < loopStart + 1 + loopLen; ++i) {
                    loopIndexRep.addFS(fsIndex[i]);
                }
                loopStart += loopLen + 1;
                loopLen = fsIndex[loopStart];
                for (i = loopStart + 1; i < loopStart + 1 + loopLen; ++i) {
                    loopIndexRep.removeFS(fsIndex[i]);
                }
                loopStart += loopLen + 1;
                loopLen = fsIndex[loopStart];
                loopStart += loopLen + 1;
                ((CASImpl)view).updateDocumentAnnotation();
                continue;
            }
            ++loopStart;
        }
    }

    int[] getIndexedFSs() {
        IntVector v = new IntVector();
        int numViews = this.getBaseSofaCount();
        v.add(numViews);
        int[] fsLoopIndex = ((SharedViewData)this.svd).baseCAS.indexRepository.getIndexedFSs();
        v.add(fsLoopIndex.length);
        v.add(fsLoopIndex, 0, fsLoopIndex.length);
        for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
            FSIndexRepositoryImpl loopIndexRep = (FSIndexRepositoryImpl)this.svd.baseCAS.getSofaIndexRepository(sofaNum);
            fsLoopIndex = loopIndexRep != null ? loopIndexRep.getIndexedFSs() : INT0;
            v.add(fsLoopIndex.length);
            for (int k = 0; k < fsLoopIndex.length; ++k) {
                v.add(fsLoopIndex[k]);
            }
        }
        return v.toArray();
    }

    int[] getDeltaIndexedFSs(MarkerImpl mark) {
        IntVector v = new IntVector();
        int numViews = this.getBaseSofaCount();
        v.add(numViews);
        int[] fsLoopIndex = ((SharedViewData)this.svd).baseCAS.indexRepository.getIndexedFSs();
        IntVector newSofas = new IntVector();
        for (int k = 0; k < fsLoopIndex.length; ++k) {
            if (!mark.isNew(fsLoopIndex[k])) continue;
            newSofas.add(fsLoopIndex[k]);
        }
        v.add(newSofas.size());
        v.add(newSofas.getArray(), 0, newSofas.size());
        for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
            int[] fsReindexed;
            int[] fsDeletedFromIndex;
            FSIndexRepositoryImpl loopIndexRep = (FSIndexRepositoryImpl)this.svd.baseCAS.getSofaIndexRepository(sofaNum);
            if (loopIndexRep != null) {
                fsLoopIndex = loopIndexRep.getAddedFSs();
                fsDeletedFromIndex = loopIndexRep.getDeletedFSs();
                fsReindexed = loopIndexRep.getReindexedFSs();
            } else {
                fsLoopIndex = INT0;
                fsDeletedFromIndex = INT0;
                fsReindexed = INT0;
            }
            v.add(fsLoopIndex.length);
            v.add(fsLoopIndex, 0, fsLoopIndex.length);
            v.add(fsDeletedFromIndex.length);
            v.add(fsDeletedFromIndex, 0, fsDeletedFromIndex.length);
            v.add(fsReindexed.length);
            v.add(fsReindexed, 0, fsReindexed.length);
        }
        return v.toArray();
    }

    void createStringTableFromArray(String[] stringTable) {
        this.getStringHeap().reset();
        for (int i = 1; i < stringTable.length; ++i) {
            this.getStringHeap().addString(stringTable[i]);
        }
    }

    static String mapName(String name, HashMap<String, String> map) {
        String out = map.get(name);
        if (out != null) {
            return out;
        }
        return name;
    }

    public <T extends FeatureStructure> T createFS(int addr) {
        return this.ll_getFSForRef(addr);
    }

    @Override
    public int ll_getArraySize(int arrayFsRef) {
        return this.getHeap().heap[arrayFsRef + 1];
    }

    public final int getArrayStartAddress(int addr) {
        return addr + 2;
    }

    public int getArrayValue(int addr, int index) {
        this.checkArrayBounds(addr, index);
        return this.getHeap().heap[addr + 2 + index];
    }

    void setArrayValue(int addr, int index, int value) throws ArrayIndexOutOfBoundsException {
        int arraySize = this.getHeap().heap[addr + 1];
        if (index < 0 || index >= arraySize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.getHeap().heap[addr + 2 + index] = value;
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(addr, addr + 2 + index, ModifiedHeap.FSHEAP, 1);
        }
    }

    void setArrayValueFromString(int addr, int index, String value) {
        int arrayType = this.getHeap().heap[addr];
        if (arrayType == 8) {
            this.setArrayValue(addr, index, Integer.parseInt(value));
        } else if (arrayType == 7) {
            this.setArrayValue(addr, index, CASImpl.float2int(Float.parseFloat(value)));
        } else if (arrayType == 9) {
            this.setArrayValue(addr, index, this.addString(value));
        } else if (arrayType == 28) {
            this.ll_setBooleanArrayValue(addr, index, Boolean.valueOf(value));
        } else if (arrayType == 29) {
            this.ll_setByteArrayValue(addr, index, Byte.parseByte(value));
        } else if (arrayType == 30) {
            this.ll_setShortArrayValue(addr, index, Short.parseShort(value));
        } else if (arrayType == 31) {
            this.ll_setLongArrayValue(addr, index, Long.parseLong(value));
        } else if (arrayType == 32) {
            this.ll_setDoubleArrayValue(addr, index, Double.parseDouble(value));
        } else if (arrayType == 6) {
            this.setArrayValue(addr, index, Integer.parseInt(value));
        }
    }

    void copyToArray(int addr, int sourceOffset, int[] dest, int destOffset, int length) {
        int arraySize = this.getHeap().heap[addr + 1];
        if (sourceOffset < 0 || length + sourceOffset > arraySize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = addr + 2;
        System.arraycopy(this.getHeap().heap, offset + sourceOffset, dest, destOffset, length);
    }

    void copyFromArray(int[] src, int srcOffset, int addr, int destOffset, int length) {
        int arraySize = this.getHeap().heap[addr + 1];
        if (destOffset < 0 || length + destOffset > arraySize) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = addr + 2;
        System.arraycopy(src, srcOffset, this.getHeap().heap, offset + destOffset, length);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(addr, offset + destOffset, ModifiedHeap.FSHEAP, length);
        }
    }

    public int getTypeCode(int fsAddr) {
        return this.getHeapValue(fsAddr);
    }

    void copyFeatures(int trgAddr, int srcAddr) throws CASRuntimeException {
        int typeCode = this.getHeapValue(trgAddr);
        if (typeCode != this.getHeapValue(srcAddr)) {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_TYPE");
            throw e;
        }
        int[] featcodes = this.getTypeSystem().getLowLevelTypeSystem().ll_getAppropriateFeatures(typeCode);
        for (int i = 0; i < featcodes.length; ++i) {
            Feature feature = this.getTypeSystem().getLowLevelTypeSystem().ll_getFeatureForCode(featcodes[i]);
            Type rangeType = feature.getRange();
            int featCode = ((FeatureImpl)feature).getCode();
            int val = this.getHeapValue(srcAddr + ((SharedViewData)this.svd).casMetadata.featureOffset[featCode]);
            this.setFeatureValueNotJournaled(trgAddr, featCode, this.isStringType(rangeType) ? this.getStringHeap().cloneStringReference(val) : this.getHeapValue(srcAddr + ((SharedViewData)this.svd).casMetadata.featureOffset[featCode]));
        }
    }

    public int getHeapValue(int addr) {
        return this.getHeap().heap[addr];
    }

    public void setFeatureValue(int addr, int feat, int val) {
        boolean wasRemoved = this.checkForInvalidFeatureSetting(addr, feat);
        this.setFeatureValueNotJournaled(addr, feat, val);
        if (wasRemoved) {
            this.maybeAddback(addr);
        }
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(addr, addr + ((SharedViewData)this.svd).casMetadata.featureOffset[feat], ModifiedHeap.FSHEAP, 1);
        }
    }

    void setFeatureValueNoIndexCorruptionCheck(int addr, int feat, int val) {
        this.setFeatureValueNotJournaled(addr, feat, val);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(addr, addr + ((SharedViewData)this.svd).casMetadata.featureOffset[feat], ModifiedHeap.FSHEAP, 1);
        }
    }

    void setFeatureValueNotJournaled(int addr, int feat, int val) {
        this.getHeap().heap[addr + ((SharedViewData)this.svd).casMetadata.featureOffset[feat]] = val;
    }

    public void setStringValue(int addr, int feat, String s2) {
        int stringCode = s2 == null ? 0 : this.getStringHeap().addString(s2);
        this.setFeatureValue(addr, feat, stringCode);
    }

    public void setFloatValue(int addr, int feat, float f) {
        int floatCode = Float.floatToIntBits(f);
        this.setFeatureValue(addr, feat, floatCode);
    }

    public int getFeatureValue(int addr, int feat) {
        return this.getHeap().heap[addr + ((SharedViewData)this.svd).casMetadata.featureOffset[feat]];
    }

    public String getStringValue(int addr, int feat) {
        return this.ll_getStringValue(addr, feat);
    }

    public float getFloatValue(int addr, int feat) {
        return Float.intBitsToFloat(this.getFeatureValue(addr, feat));
    }

    public float getFloatValue(int addr) {
        return Float.intBitsToFloat(this.getHeap().heap[addr]);
    }

    public void setFeatureValue(int addr, int feat, byte v) {
        this.setFeatureValue(addr, feat, (int)v);
    }

    public byte getByteValue(int addr, int feat) {
        return this.ll_getByteValue(addr, feat);
    }

    public void setFeatureValue(int addr, int feat, boolean v) {
        this.setFeatureValue(addr, feat, v ? 1 : 0);
    }

    public boolean getBooleanValue(int addr, int feat) {
        return this.ll_getBooleanValue(addr, feat);
    }

    public void setFeatureValue(int addr, int feat, short s2) {
        this.setFeatureValue(addr, feat, (int)s2);
    }

    public short getShortValue(int addr, int feat) {
        return this.ll_getShortValue(addr, feat);
    }

    public void setFeatureValue(int addr, int feat, long s2) {
        this.ll_setLongValue(addr, feat, s2);
    }

    public long getLongValue(int addr, int feat) {
        return this.ll_getLongValue(addr, feat);
    }

    public void setFeatureValue(int addr, int feat, float f) {
        this.ll_setFloatValue(addr, feat, f);
    }

    public void setFeatureValue(int addr, int feat, double s2) {
        this.ll_setDoubleValue(addr, feat, s2);
    }

    public double getDoubleValue(int addr, int feat) {
        return this.ll_getDoubleValue(addr, feat);
    }

    public String getFeatureValueAsString(int addr, int feat) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        int typeCode = ts.range(feat);
        if (typeCode == 2) {
            return Integer.toString(this.ll_getIntValue(addr, feat));
        }
        if (typeCode == 3) {
            return Float.toString(this.ll_getFloatValue(addr, feat));
        }
        if (ts.subsumes(4, typeCode)) {
            return this.getStringValue(addr, feat);
        }
        if (typeCode == 23) {
            return Boolean.toString(this.getBooleanValue(addr, feat));
        }
        if (typeCode == 24) {
            return Byte.toString(this.getByteValue(addr, feat));
        }
        if (typeCode == 25) {
            return Short.toString(this.getShortValue(addr, feat));
        }
        if (typeCode == 26) {
            return Long.toString(this.getLongValue(addr, feat));
        }
        if (typeCode == 27) {
            return Double.toString(this.getDoubleValue(addr, feat));
        }
        CASRuntimeException e = new CASRuntimeException("INAPPROP_RANGE", new String[]{ts.ll_getFeatureForCode(feat).getName(), ts.ll_getTypeForCode(typeCode).getName()});
        throw e;
    }

    public void setFeatureValueFromString(int fsref, int feat, String value) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        int typeCode = ts.range(feat);
        if (typeCode == 2) {
            this.ll_setIntValue(fsref, feat, Integer.parseInt(value));
        } else if (typeCode == 3) {
            this.setFloatValue(fsref, feat, Float.parseFloat(value));
        } else if (ts.subsumes(4, typeCode)) {
            this.setStringValue(fsref, feat, value);
        } else if (typeCode == 23) {
            this.setFeatureValue(fsref, feat, Boolean.valueOf(value));
        } else if (typeCode == 24) {
            this.setFeatureValue(fsref, feat, Byte.parseByte(value));
        } else if (typeCode == 25) {
            this.setFeatureValue(fsref, feat, Short.parseShort(value));
        } else if (typeCode == 26) {
            this.setFeatureValue(fsref, feat, Long.parseLong(value));
        } else if (typeCode == 27) {
            this.setFeatureValue(fsref, feat, Double.parseDouble(value));
        } else {
            CASRuntimeException e = new CASRuntimeException("INAPPROP_TYPE", new String[]{ts.ll_getFeatureForCode(feat).getName(), ts.ll_getTypeForCode(typeCode).getName()});
            throw e;
        }
    }

    public static final float int2float(int i) {
        return Float.intBitsToFloat(i);
    }

    public static final int float2int(float f) {
        return Float.floatToIntBits(f);
    }

    public static final double long2double(long l) {
        return Double.longBitsToDouble(l);
    }

    public static final long double2long(double d) {
        return Double.doubleToLongBits(d);
    }

    public TypeSystemImpl getTypeSystemImpl() {
        return ((SharedViewData)this.svd).casMetadata.ts;
    }

    public String getStringForCode(int stringCode) {
        return this.getStringHeap().getStringForCode(stringCode);
    }

    final boolean isCreatableType(int typeCode) {
        return ((SharedViewData)this.svd).casMetadata.creatableType[typeCode];
    }

    int addString(String s2) {
        return this.getStringHeap().addString(s2);
    }

    public boolean isStringType(Type type) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        return ts.subsumes(ts.stringType, type);
    }

    public boolean isAbstractArrayType(Type type) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        return ts.subsumes(ts.arrayBaseType, type);
    }

    public boolean isArrayType(Type type) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        return type == ts.fsArrayType || type == ts.intArrayType || type == ts.floatArrayType || type == ts.stringArrayType || type == ts.booleanArrayType || type == ts.byteArrayType || type == ts.shortArrayType || type == ts.doubleArrayType || type == ts.longArrayType;
    }

    public boolean isIntArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.intArrayType;
    }

    public boolean isFloatArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.floatArrayType;
    }

    public boolean isStringArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.stringArrayType;
    }

    public boolean isBooleanArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.booleanArrayType;
    }

    public boolean isByteArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.byteArrayType;
    }

    public boolean isShortArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.shortArrayType;
    }

    public boolean isLongArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.longArrayType;
    }

    public boolean isDoubleArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.doubleArrayType;
    }

    public boolean isFSArrayType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.fsArrayType;
    }

    public boolean isIntType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.intType;
    }

    public boolean isFloatType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.floatType;
    }

    public boolean isStringType(int type) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        return ts.subsumes(4, type);
    }

    public boolean isByteType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.byteType;
    }

    public boolean isBooleanType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.booleanType;
    }

    public boolean isShortType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.shortType;
    }

    public boolean isLongType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.longType;
    }

    public boolean isDoubleType(Type type) {
        return type == ((SharedViewData)this.svd).casMetadata.ts.doubleType;
    }

    public boolean isAbstractArrayType(int type) {
        return ((SharedViewData)this.svd).casMetadata.ts.subsumes(5, type);
    }

    public boolean isArrayType(int type) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        return ts.ll_isArrayType(type);
    }

    public boolean isIntArrayType(int type) {
        return type == 8;
    }

    public boolean isFloatArrayType(int type) {
        return type == 7;
    }

    public boolean isStringArrayType(int type) {
        return type == 9;
    }

    public boolean isByteArrayType(int type) {
        return type == 29;
    }

    public boolean isBooleanArrayType(int type) {
        return type == 28;
    }

    public boolean isShortArrayType(int type) {
        return type == 30;
    }

    public boolean isLongArrayType(int type) {
        return type == 31;
    }

    public boolean isDoubleArrayType(int type) {
        return type == 32;
    }

    public boolean isFSArrayType(int type) {
        return type == 6;
    }

    public boolean isIntType(int type) {
        return type == 2;
    }

    public boolean isFloatType(int type) {
        return type == 3;
    }

    public boolean isByteType(int type) {
        return type == 24;
    }

    public boolean isBooleanType(int type) {
        return type == 23;
    }

    public boolean isShortType(int type) {
        return type == 25;
    }

    public boolean isLongType(int type) {
        return type == 26;
    }

    public boolean isDoubleType(int type) {
        return type == 27;
    }

    public Heap getHeap() {
        return this.svd.heap;
    }

    ByteHeap getByteHeap() {
        return this.svd.byteHeap;
    }

    ShortHeap getShortHeap() {
        return this.svd.shortHeap;
    }

    LongHeap getLongHeap() {
        return this.svd.longHeap;
    }

    StringHeap getStringHeap() {
        return this.svd.stringHeap;
    }

    public int getFeatureOffset(int feat) {
        if (feat < 1 || feat >= ((SharedViewData)this.svd).casMetadata.featureOffset.length) {
            return -1;
        }
        return ((SharedViewData)this.svd).casMetadata.featureOffset[feat];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupTSDefault(TypeSystemImpl ts) {
        if (ts.areBuiltInTypesSetup) {
            return;
        }
        TypeSystemImpl typeSystemImpl = ts;
        synchronized (typeSystemImpl) {
            if (ts.areBuiltInTypesSetup) {
                return;
            }
            Type top = ts.addTopType("uima.cas.TOP");
            Type intT = ts.addType("uima.cas.Integer", top);
            ts.intType = (TypeImpl)intT;
            if (2 != ts.intType.getCode()) {
                throw new RuntimeException();
            }
            Type floatT = ts.addType("uima.cas.Float", top);
            ts.floatType = (TypeImpl)floatT;
            if (3 != ts.floatType.getCode()) {
                throw new RuntimeException();
            }
            Type stringT = ts.addType("uima.cas.String", top);
            ts.stringType = (TypeImpl)stringT;
            if (4 != ts.stringType.getCode()) {
                throw new RuntimeException();
            }
            Type array = ts.addType("uima.cas.ArrayBase", top);
            ts.arrayBaseType = (TypeImpl)array;
            if (5 != ts.arrayBaseType.getCode()) {
                throw new RuntimeException();
            }
            ts.fsArrayType = (TypeImpl)ts.addType("uima.cas.FSArray", array);
            TypeImpl fsArray = ts.fsArrayType;
            if (6 != fsArray.getCode()) {
                throw new RuntimeException();
            }
            ts.floatArrayType = (TypeImpl)ts.addType("uima.cas.FloatArray", array);
            TypeImpl floatArray = ts.floatArrayType;
            if (7 != floatArray.getCode()) {
                throw new RuntimeException();
            }
            ts.intArrayType = (TypeImpl)ts.addType("uima.cas.IntegerArray", array);
            TypeImpl intArray = ts.intArrayType;
            if (8 != intArray.getCode()) {
                throw new RuntimeException();
            }
            ts.stringArrayType = (TypeImpl)ts.addType("uima.cas.StringArray", array);
            TypeImpl stringArray = ts.stringArrayType;
            if (9 != stringArray.getCode()) {
                throw new RuntimeException();
            }
            Type list = ts.addType("uima.cas.ListBase", top);
            Type fsList = ts.addType("uima.cas.FSList", list);
            Type fsEList = ts.addType("uima.cas.EmptyFSList", fsList);
            Type fsNeList = ts.addType("uima.cas.NonEmptyFSList", fsList);
            ts.addFeature("head", fsNeList, top, true);
            ts.addFeature("tail", fsNeList, fsList, true);
            Type floatList = ts.addType("uima.cas.FloatList", list);
            Type floatEList = ts.addType("uima.cas.EmptyFloatList", floatList);
            Type floatNeList = ts.addType("uima.cas.NonEmptyFloatList", floatList);
            ts.addFeature("head", floatNeList, floatT, false);
            ts.addFeature("tail", floatNeList, floatList, true);
            Type intList = ts.addType("uima.cas.IntegerList", list);
            Type intEList = ts.addType("uima.cas.EmptyIntegerList", intList);
            Type intNeList = ts.addType("uima.cas.NonEmptyIntegerList", intList);
            ts.addFeature("head", intNeList, intT, false);
            ts.addFeature("tail", intNeList, intList, true);
            Type stringList = ts.addType("uima.cas.StringList", list);
            Type stringEList = ts.addType("uima.cas.EmptyStringList", stringList);
            Type stringNeList = ts.addType("uima.cas.NonEmptyStringList", stringList);
            ts.addFeature("head", stringNeList, stringT, false);
            ts.addFeature("tail", stringNeList, stringList, true);
            Type booleanT = ts.addType("uima.cas.Boolean", top);
            ts.booleanType = (TypeImpl)booleanT;
            if (23 != ts.booleanType.getCode()) {
                throw new RuntimeException();
            }
            Type byteT = ts.addType("uima.cas.Byte", top);
            ts.byteType = (TypeImpl)byteT;
            if (24 != ts.byteType.getCode()) {
                throw new RuntimeException();
            }
            Type shortT = ts.addType("uima.cas.Short", top);
            ts.shortType = (TypeImpl)shortT;
            if (25 != ts.shortType.getCode()) {
                throw new RuntimeException();
            }
            Type longT = ts.addType("uima.cas.Long", top);
            ts.longType = (TypeImpl)longT;
            if (26 != ts.longType.getCode()) {
                throw new RuntimeException();
            }
            Type doubleT = ts.addType("uima.cas.Double", top);
            ts.doubleType = (TypeImpl)doubleT;
            if (27 != ts.doubleType.getCode()) {
                throw new RuntimeException();
            }
            ts.booleanArrayType = (TypeImpl)ts.addType("uima.cas.BooleanArray", array);
            TypeImpl booleanArray = ts.booleanArrayType;
            if (28 != booleanArray.getCode()) {
                throw new RuntimeException();
            }
            ts.byteArrayType = (TypeImpl)ts.addType("uima.cas.ByteArray", array);
            TypeImpl byteArray = ts.byteArrayType;
            if (29 != byteArray.getCode()) {
                throw new RuntimeException();
            }
            ts.shortArrayType = (TypeImpl)ts.addType("uima.cas.ShortArray", array);
            TypeImpl shortArray = ts.shortArrayType;
            if (30 != shortArray.getCode()) {
                throw new RuntimeException();
            }
            ts.longArrayType = (TypeImpl)ts.addType("uima.cas.LongArray", array);
            TypeImpl longArray = ts.longArrayType;
            if (31 != longArray.getCode()) {
                throw new RuntimeException();
            }
            ts.doubleArrayType = (TypeImpl)ts.addType("uima.cas.DoubleArray", array);
            TypeImpl doubleArray = ts.doubleArrayType;
            if (32 != doubleArray.getCode()) {
                throw new RuntimeException();
            }
            Type sofa = ts.addType("uima.cas.Sofa", top);
            ts.sofaType = (TypeImpl)sofa;
            if (33 != ts.sofaType.getCode()) {
                throw new RuntimeException();
            }
            ts.addFeature("sofaNum", sofa, intT, false);
            ts.addFeature("sofaID", sofa, stringT, false);
            ts.addFeature("mimeType", sofa, stringT, false);
            ts.addFeature("sofaArray", sofa, top, true);
            ts.addFeature("sofaString", sofa, stringT, false);
            ts.addFeature("sofaURI", sofa, stringT, false);
            Type annotBaseType = ts.addType("uima.cas.AnnotationBase", top);
            ts.annotBaseType = (TypeImpl)annotBaseType;
            if (34 != ts.annotBaseType.getCode()) {
                throw new RuntimeException();
            }
            ts.addFeature("sofa", annotBaseType, sofa, false);
            Type annotType = ts.addType("uima.tcas.Annotation", annotBaseType);
            ts.annotType = (TypeImpl)annotType;
            if (35 != ts.annotType.getCode()) {
                throw new RuntimeException();
            }
            ts.addFeature("begin", annotType, intT, false);
            ts.addFeature("end", annotType, intT, false);
            Type docType = ts.addType("uima.tcas.DocumentAnnotation", annotType);
            ts.docType = (TypeImpl)docType;
            ts.addFeature("language", docType, stringT, false);
            CASImpl.setTypeFinal(intT);
            CASImpl.setTypeFinal(floatT);
            CASImpl.setTypeFinal(stringT);
            ((TypeImpl)top).setFeatureFinal();
            CASImpl.setTypeFinal(array);
            CASImpl.setTypeFinal(fsArray);
            CASImpl.setTypeFinal(intArray);
            CASImpl.setTypeFinal(floatArray);
            CASImpl.setTypeFinal(stringArray);
            CASImpl.setTypeFinal(sofa);
            CASImpl.setTypeFinal(byteT);
            CASImpl.setTypeFinal(booleanT);
            CASImpl.setTypeFinal(shortT);
            CASImpl.setTypeFinal(longT);
            CASImpl.setTypeFinal(doubleT);
            CASImpl.setTypeFinal(booleanArray);
            CASImpl.setTypeFinal(byteArray);
            CASImpl.setTypeFinal(shortArray);
            CASImpl.setTypeFinal(longArray);
            CASImpl.setTypeFinal(doubleArray);
            ((TypeImpl)list).setFeatureFinal();
            ((TypeImpl)fsList).setFeatureFinal();
            ((TypeImpl)fsEList).setFeatureFinal();
            ((TypeImpl)fsNeList).setFeatureFinal();
            ((TypeImpl)floatList).setFeatureFinal();
            ((TypeImpl)floatEList).setFeatureFinal();
            ((TypeImpl)floatNeList).setFeatureFinal();
            ((TypeImpl)intList).setFeatureFinal();
            ((TypeImpl)intEList).setFeatureFinal();
            ((TypeImpl)intNeList).setFeatureFinal();
            ((TypeImpl)stringList).setFeatureFinal();
            ((TypeImpl)stringEList).setFeatureFinal();
            ((TypeImpl)stringNeList).setFeatureFinal();
            ((TypeImpl)annotType).setFeatureFinal();
            ((TypeImpl)annotBaseType).setFeatureFinal();
            ts.areBuiltInTypesSetup = true;
        }
    }

    private static void setTypeFinal(Type type) {
        TypeImpl t = (TypeImpl)type;
        t.setFeatureFinal();
        t.setInheritanceFinal();
    }

    @Override
    public void initCASIndexes() throws CASException {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        if (!ts.isCommitted()) {
            throw new CASException("MUST_COMMIT_TYPE_SYSTEM", null);
        }
        FSIndexComparator comp = this.indexRepository.createComparator();
        comp.setType(ts.sofaType);
        comp.addKey(ts.sofaNum, 0);
        this.indexRepository.createIndex(comp, "SofaIndex", 2);
        comp = this.indexRepository.createComparator();
        comp.setType(ts.annotType);
        comp.addKey(ts.startFeat, 0);
        comp.addKey(ts.endFeat, 1);
        comp.addKey(this.indexRepository.getDefaultTypeOrder(), 0);
        this.indexRepository.createIndex(comp, "AnnotationIndex");
    }

    ArrayList<String> getStringTable() {
        return this.svd.baseCAS.getStringList();
    }

    public CAS getView(int sofaNum) {
        return this.getViewFromSofaNbr(sofaNum);
    }

    @Override
    public CAS getCurrentView() {
        return this.getView("_InitialView");
    }

    @Override
    public JCas getJCas() throws CASException {
        if (this.jcas == null) {
            this.jcas = (JCasImpl)JCasImpl.getJCas(this);
        } else {
            this.jcas.maybeInitializeForClassLoader(this.svd.jcasClassLoader);
        }
        return this.jcas;
    }

    public JCas getExistingJCas() {
        return this.jcas;
    }

    @Override
    public JCas getJCas(SofaFS aSofa) throws CASException {
        this.svd.baseCAS.getJCas();
        return this.getView(aSofa).getJCas();
    }

    @Override
    @Deprecated
    public JCas getJCas(SofaID aSofaID) throws CASException {
        SofaFS sofa = this.getSofa(aSofaID);
        return this.getJCas(sofa);
    }

    private CAS getViewFromSofaNbr(int nbr) {
        ArrayList sn2v = this.svd.sofaNbr2ViewMap;
        if (nbr < sn2v.size()) {
            return (CAS)sn2v.get(nbr);
        }
        return null;
    }

    private void setViewForSofaNbr(int nbr, CAS view) {
        ArrayList sn2v = this.svd.sofaNbr2ViewMap;
        while (sn2v.size() <= nbr) {
            sn2v.add(null);
        }
        sn2v.set(nbr, view);
    }

    CAS getInitialView() {
        CAS couldBeThis = this.getViewFromSofaNbr(1);
        if (couldBeThis != null) {
            return couldBeThis;
        }
        CASImpl aView = new CASImpl(this.svd.baseCAS, null, this.isUsedJcasCache);
        this.setViewForSofaNbr(1, aView);
        assert (this.svd.viewCount <= 1);
        this.svd.viewCount = 1;
        return aView;
    }

    @Override
    public CAS createView(String aSofaID) {
        String absoluteSofaName = null;
        if (this.getCurrentComponentInfo() != null) {
            absoluteSofaName = this.getCurrentComponentInfo().mapToSofaID(aSofaID);
        }
        if (absoluteSofaName == null) {
            absoluteSofaName = aSofaID;
        }
        if ("_InitialView".equals(absoluteSofaName)) {
            CASRuntimeException e = new CASRuntimeException("SOFANAME_ALREADY_EXISTS", new String[]{aSofaID});
            throw e;
        }
        SofaFS newSofa = this.createSofa(absoluteSofaName, null);
        CAS newView = this.getView(newSofa);
        ((CASImpl)newView).registerView(newSofa);
        return newView;
    }

    @Override
    public CAS getView(String aSofaID) {
        String absoluteSofaName = null;
        if (this.getCurrentComponentInfo() != null) {
            absoluteSofaName = this.getCurrentComponentInfo().mapToSofaID(aSofaID);
        }
        if (absoluteSofaName == null) {
            absoluteSofaName = aSofaID;
        }
        if ("_InitialView".equals(absoluteSofaName)) {
            return this.getInitialView();
        }
        SofaFS sofa = this.getSofa(absoluteSofaName);
        return this.getView(sofa);
    }

    @Override
    public CAS getView(SofaFS aSofa) {
        int sofaNbr = aSofa.getSofaRef();
        CASImpl aView = (CASImpl)this.getViewFromSofaNbr(sofaNbr);
        if (null == aView) {
            aView = new CASImpl(this.svd.baseCAS, aSofa, this.isUsedJcasCache);
            this.setViewForSofaNbr(sofaNbr, aView);
            this.verifySofaNameUniqueIfDeserializedViewAdded(sofaNbr, aSofa);
            return aView;
        }
        if (0 == aView.mySofaRef) {
            aView.mySofaRef = ((FeatureStructureImpl)((Object)aSofa)).getAddress();
        }
        this.verifySofaNameUniqueIfDeserializedViewAdded(sofaNbr, aSofa);
        return aView;
    }

    boolean isSofaView(int sofaAddr) {
        if (this.mySofaRef == -1) {
            return false;
        }
        return this.mySofaRef == sofaAddr;
    }

    private void verifySofaNameUniqueIfDeserializedViewAdded(int sofaNbr, SofaFS aSofa) {
        int curViewCount = this.svd.viewCount;
        if (curViewCount < sofaNbr) {
            assert (sofaNbr == curViewCount + 1);
            this.svd.viewCount = sofaNbr;
            String id = aSofa.getSofaID();
            if (this.svd.sofaNameSet.contains(id)) {
                CASRuntimeException e = new CASRuntimeException("SOFANAME_ALREADY_EXISTS", new String[]{id});
                throw e;
            }
            this.svd.sofaNameSet.add(id);
        }
    }

    @Override
    public LowLevelTypeSystem ll_getTypeSystem() {
        return ((SharedViewData)this.svd).casMetadata.ts.getLowLevelTypeSystem();
    }

    @Override
    public LowLevelIndexRepository ll_getIndexRepository() {
        return this.indexRepository;
    }

    private final void checkLowLevelParams(int fsRef, int domType, int ranType, int feat) {
        this.checkTypeAt(domType, fsRef);
        this.checkFeature(feat);
        this.checkTypingConditions(domType, ranType, feat);
    }

    private final void checkLowLevelParams(int fsRef, int domType, int feat) {
        this.checkTypeAt(domType, fsRef);
        this.checkFeature(feat);
        this.checkDomTypeConditions(domType, feat);
    }

    private final void checkDomTypeConditions(int domTypeCode, int featCode) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        if (!ts.isApprop(domTypeCode, featCode)) {
            LowLevelException e = new LowLevelException(3);
            e.addArgument(Integer.toString(domTypeCode));
            e.addArgument(ts.ll_getTypeForCode(domTypeCode).getName());
            e.addArgument(Integer.toString(featCode));
            e.addArgument(ts.ll_getFeatureForCode(featCode).getName());
            throw e;
        }
    }

    public final void checkTypingConditions(Type domType, Type ranType, Feature feat) {
        this.checkTypingConditions(((TypeImpl)domType).getCode(), ((TypeImpl)ranType).getCode(), ((FeatureImpl)feat).getCode());
    }

    private final void checkTypingConditions(int domTypeCode, int ranTypeCode, int featCode) {
        this.checkDomTypeConditions(domTypeCode, featCode);
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        if (!ts.subsumes(ts.range(featCode), ranTypeCode)) {
            LowLevelException e = new LowLevelException(4);
            e.addArgument(Integer.toString(featCode));
            e.addArgument(ts.ll_getFeatureForCode(featCode).getName());
            e.addArgument(Integer.toString(ranTypeCode));
            e.addArgument(ts.ll_getTypeForCode(ranTypeCode).getName());
            throw e;
        }
    }

    private final void checkFsRan(int featCode) throws LowLevelException {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        int rangeTypeCode = ts.range(featCode);
        if (!this.ll_isRefType(rangeTypeCode)) {
            LowLevelException e = new LowLevelException(5);
            e.addArgument(Integer.toString(featCode));
            e.addArgument(ts.ll_getFeatureForCode(featCode).getName());
            e.addArgument(ts.ll_getTypeForCode(rangeTypeCode).getName());
            throw e;
        }
    }

    private final void checkFeature(int featureCode) {
        if (!((SharedViewData)this.svd).casMetadata.ts.isFeature(featureCode)) {
            LowLevelException e = new LowLevelException(2);
            e.addArgument(Integer.toString(featureCode));
            throw e;
        }
    }

    private final void checkTypeAt(int typeCode, int fsRef) {
        if (!((SharedViewData)this.svd).casMetadata.ts.isType(typeCode)) {
            LowLevelException e = new LowLevelException(1);
            e.addArgument(Integer.toString(typeCode));
            e.addArgument(Integer.toString(fsRef));
            throw e;
        }
    }

    final void checkFsRef(int fsRef) {
        if (fsRef <= 0 || fsRef >= this.getHeap().heap.length) {
            LowLevelException e = new LowLevelException(0);
            e.addArgument(Integer.toString(fsRef));
            throw e;
        }
    }

    @Override
    public final boolean ll_isRefType(int typeCode) {
        if (typeCode == 2 || typeCode == 3 || typeCode == 4 || typeCode == 24 || typeCode == 23 || typeCode == 25 || typeCode == 26 || typeCode == 27) {
            return false;
        }
        return !this.ll_getTypeSystem().ll_isStringSubtype(typeCode);
    }

    @Override
    public final int ll_getTypeClass(int typeCode) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        if (typeCode == 2) {
            return 1;
        }
        if (typeCode == 3) {
            return 2;
        }
        if (ts.subsumes(4, typeCode)) {
            return 3;
        }
        if (typeCode == 8) {
            return 4;
        }
        if (typeCode == 7) {
            return 5;
        }
        if (typeCode == 9) {
            return 6;
        }
        if (typeCode == 6) {
            return 7;
        }
        if (typeCode == 23) {
            return 9;
        }
        if (typeCode == 24) {
            return 10;
        }
        if (typeCode == 25) {
            return 11;
        }
        if (typeCode == 26) {
            return 12;
        }
        if (typeCode == 27) {
            return 13;
        }
        if (typeCode == 28) {
            return 14;
        }
        if (typeCode == 29) {
            return 15;
        }
        if (typeCode == 30) {
            return 16;
        }
        if (typeCode == 31) {
            return 17;
        }
        if (typeCode == 32) {
            return 18;
        }
        if (this.isArrayType(typeCode)) {
            return 7;
        }
        return 8;
    }

    @Override
    public final int ll_createFS(int typeCode) {
        int fsAddr = this.getHeap().add(((SharedViewData)this.svd).casMetadata.fsSpaceReq[typeCode], typeCode);
        this.svd.cache_not_in_index = fsAddr;
        return fsAddr;
    }

    @Override
    public final int ll_createFS(int typeCode, boolean doCheck) {
        if (!(!doCheck || ((SharedViewData)this.svd).casMetadata.ts.isType(typeCode) && this.isCreatableType(typeCode))) {
            LowLevelException e = new LowLevelException(9);
            e.addArgument(Integer.toString(typeCode));
            throw e;
        }
        return this.ll_createFS(typeCode);
    }

    public int createTempArray(int type, int len) {
        return this.ll_createArray(type, len);
    }

    @Override
    public int ll_createArray(int typeCode, int arrayLength) {
        int addr = this.getHeap().add(2 + arrayLength, typeCode);
        this.getHeap().heap[addr + 1] = arrayLength;
        this.svd.cache_not_in_index = addr;
        return addr;
    }

    public int ll_createAuxArray(int typeCode, int arrayLength) {
        int addr = this.getHeap().add(3, typeCode);
        this.getHeap().heap[addr + 1] = arrayLength;
        this.svd.cache_not_in_index = addr;
        return addr;
    }

    @Override
    public int ll_createByteArray(int arrayLength) {
        int addr = this.ll_createAuxArray(29, arrayLength);
        this.getHeap().heap[addr + 2] = this.getByteHeap().reserve(arrayLength);
        return addr;
    }

    @Override
    public int ll_createBooleanArray(int arrayLength) {
        int addr = this.ll_createAuxArray(28, arrayLength);
        this.getHeap().heap[addr + 2] = this.getByteHeap().reserve(arrayLength);
        return addr;
    }

    @Override
    public int ll_createShortArray(int arrayLength) {
        int addr = this.ll_createAuxArray(30, arrayLength);
        this.getHeap().heap[addr + 2] = this.getShortHeap().reserve(arrayLength);
        return addr;
    }

    @Override
    public int ll_createLongArray(int arrayLength) {
        int addr = this.ll_createAuxArray(31, arrayLength);
        this.getHeap().heap[addr + 2] = this.getLongHeap().reserve(arrayLength);
        return addr;
    }

    @Override
    public int ll_createDoubleArray(int arrayLength) {
        int addr = this.ll_createAuxArray(32, arrayLength);
        this.getHeap().heap[addr + 2] = this.getLongHeap().reserve(arrayLength);
        return addr;
    }

    @Override
    public int ll_createArray(int typeCode, int arrayLength, boolean doChecks) {
        if (doChecks) {
            TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
            if (!ts.isType(typeCode)) {
                LowLevelException e = new LowLevelException(13);
                e.addArgument(Integer.toString(typeCode));
                throw e;
            }
            if (!this.isCreatableArrayType(typeCode)) {
                LowLevelException e = new LowLevelException(11);
                e.addArgument(Integer.toString(typeCode));
                e.addArgument(ts.ll_getTypeForCode(typeCode).getName());
                throw e;
            }
            if (arrayLength < 0) {
                LowLevelException e = new LowLevelException(12);
                e.addArgument(Integer.toString(arrayLength));
                throw e;
            }
        }
        return this.ll_createArray(typeCode, arrayLength);
    }

    private final boolean isCreatableArrayType(int typeCode) {
        int tc = this.ll_getTypeClass(typeCode);
        return tc == 4 || tc == 5 || tc == 6 || tc == 7 || tc == 14 || tc == 15 || tc == 16 || tc == 17 || tc == 18;
    }

    @Override
    public final int ll_getFSRef(FeatureStructure fsImpl) {
        if (null == fsImpl) {
            return 0;
        }
        FeatureStructureImpl fsi = (FeatureStructureImpl)fsImpl;
        if (this != fsi.getCASImpl() && this.getBaseCAS() != fsi.getCASImpl().getBaseCAS()) {
            throw new CASRuntimeException("DEREF_FS_OTHER_CAS", new Object[]{fsi.toString(), this.toString()});
        }
        return fsi.getAddress();
    }

    @Override
    public <T extends FeatureStructure> T ll_getFSForRef(int fsRef) {
        if (fsRef == 0) {
            return null;
        }
        if (this.svd.useFSCache) {
            FeatureStructure fs = null;
            try {
                fs = this.svd.fsArray[fsRef];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            if (fs == null) {
                fs = this.svd.localFsGenerators[this.getHeap().heap[fsRef]].createFS(fsRef, this);
                if (fsRef >= this.svd.fsArray.length) {
                    int newLen;
                    for (newLen = this.svd.fsArray.length * 2; newLen <= fsRef; newLen *= 2) {
                    }
                    FeatureStructure[] newArray = new FeatureStructure[newLen];
                    System.arraycopy(this.svd.fsArray, 0, newArray, 0, this.svd.fsArray.length);
                    SharedViewData.access$4402(this.svd, newArray);
                }
                ((SharedViewData)this.svd).fsArray[fsRef] = fs;
            }
            return (T)fs;
        }
        return this.svd.localFsGenerators[this.getHeap().heap[fsRef]].createFS(fsRef, this);
    }

    @Override
    public final int ll_getIntValue(int fsRef, int featureCode) {
        return this.getHeap().heap[fsRef + ((SharedViewData)this.svd).casMetadata.featureOffset[featureCode]];
    }

    public final int ll_getIntValueFeatOffset(int fsRef, int featureOffset) {
        return this.getHeap().heap[fsRef + featureOffset];
    }

    @Override
    public final float ll_getFloatValue(int fsRef, int featureCode) {
        return CASImpl.int2float(this.ll_getIntValue(fsRef, featureCode));
    }

    @Override
    public final String ll_getStringValue(int fsRef, int featureCode) {
        return this.getStringHeap().getStringForCode(this.ll_getIntValue(fsRef, featureCode));
    }

    public final String ll_getStringValueFeatOffset(int fsRef, int featureOffset) {
        return this.getStringHeap().getStringForCode(this.ll_getIntValueFeatOffset(fsRef, featureOffset));
    }

    @Override
    public final int ll_getRefValue(int fsRef, int featureCode) {
        return this.ll_getIntValue(fsRef, featureCode);
    }

    public final int ll_getRefValueFeatOffset(int fsRef, int featureOffset) {
        return this.ll_getIntValueFeatOffset(fsRef, featureOffset);
    }

    @Override
    public final int ll_getIntValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 2, featureCode);
        }
        return this.ll_getIntValue(fsRef, featureCode);
    }

    @Override
    public final float ll_getFloatValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 3, featureCode);
        }
        return this.ll_getFloatValue(fsRef, featureCode);
    }

    @Override
    public final String ll_getStringValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 4, featureCode);
        }
        return this.ll_getStringValue(fsRef, featureCode);
    }

    @Override
    public final int ll_getRefValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkFsRefConditions(fsRef, featureCode);
        }
        return this.ll_getIntValue(fsRef, featureCode);
    }

    public int ll_getAnnotBegin(int fsRef) {
        return this.ll_getIntValueFeatOffset(fsRef, this.svd.annotFeatOffset_begin);
    }

    public int ll_getAnnotEnd(int fsRef) {
        return this.ll_getIntValueFeatOffset(fsRef, this.svd.annotFeatOffset_end);
    }

    private boolean checkForInvalidFeatureSetting(int fsRef, int featureCode) {
        if (fsRef == this.svd.cache_not_in_index) {
            return false;
        }
        int ssz = this.svd.fssTobeAddedback.size();
        if (IS_DISABLED_PROTECT_INDEXES && ssz == 0) {
            return false;
        }
        boolean wasRemoved = this.removeFromCorruptableIndexAnyView(fsRef, ssz > 0 ? (FSsTobeAddedback)this.svd.fssTobeAddedback.get(ssz - 1) : this.svd.fsTobeAddedbackSingle, featureCode);
        if (wasRemoved && IS_REPORT_FS_UPDATE_CORRUPTS_INDEX && ssz == 0) {
            this.featModWhileInIndexReport(fsRef, featureCode);
        }
        return wasRemoved;
    }

    private void featModWhileInIndexReport(int fsRef, int featureCode) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new Throwable().printStackTrace(pw);
        pw.close();
        String msg = String.format("While FS was in the index, the feature \"%s\", which is used as a key in one or more indexes, was modified\n FS = \"%s\"\n%s%n", this.getTypeSystemImpl().ll_getFeatureForCode(featureCode).getName(), new FeatureStructureImplC(this, fsRef).toString(), sw.toString());
        UIMAFramework.getLogger().log(Level.WARNING, msg);
        if (IS_THROW_EXCEPTION_CORRUPT_INDEX) {
            throw new UIMARuntimeException("illegal_update_indexed_fs", new Object[0]);
        }
    }

    private void maybeAddback(int fsRef) {
        if (!this.svd.fsTobeAddedbackSingleInUse && !IS_DISABLED_PROTECT_INDEXES && this.svd.fssTobeAddedback.size() == 0) {
            this.svd.fsTobeAddedbackSingle.addback(fsRef);
        }
    }

    boolean removeFromCorruptableIndexAnyView(int fsRef, FSsTobeAddedback toBeAdded, int featCode) {
        if (fsRef != this.svd.cache_not_in_index && this.svd.featureCodesInIndexKeys.contains(featCode)) {
            boolean wasRemoved = this.removeFromCorruptableIndexAnyView(fsRef, toBeAdded);
            this.svd.cache_not_in_index = fsRef;
            return wasRemoved;
        }
        return false;
    }

    boolean removeFromCorruptableIndexAnyView(int fsRef, FSsTobeAddedback toBeAdded) {
        int typeCode = this.getTypeCode(fsRef);
        TypeSystemImpl tsi = this.getTypeSystemImpl();
        if (tsi.isAnnotationBaseOrSubtype(typeCode)) {
            CASImpl view;
            int addrOfSofaFS = this.getSofaFeat(fsRef);
            if (addrOfSofaFS == 0) {
                return false;
            }
            if (addrOfSofaFS == this.getSofaRef()) {
                view = this;
            } else {
                int sofaNum = this.ll_getSofaNum(addrOfSofaFS);
                view = (CASImpl)this.getViewFromSofaNbr(sofaNum);
                if (null == view) {
                    return false;
                }
            }
            return this.removeAndRecord(fsRef, view.indexRepository, toBeAdded);
        }
        Iterator<CAS> viewIterator = this.getViewIterator();
        boolean wasRemoved = false;
        while (viewIterator.hasNext()) {
            wasRemoved |= this.removeAndRecord(fsRef, (FSIndexRepositoryImpl)viewIterator.next().getIndexRepository(), toBeAdded);
        }
        return wasRemoved;
    }

    boolean removeFromCorruptableIndexAnyViewSetCache(int fsRef, FSsTobeAddedback toBeAdded) {
        if (fsRef != this.svd.cache_not_in_index) {
            this.svd.cache_not_in_index = fsRef;
            return this.removeFromCorruptableIndexAnyView(fsRef, toBeAdded);
        }
        return false;
    }

    private boolean removeAndRecord(int fsRef, FSIndexRepositoryImpl ir, FSsTobeAddedback toBeAdded) {
        int nbrRemoved = ir.removeIfInCorrputableIndexInThisView(fsRef);
        if (0 < nbrRemoved) {
            toBeAdded.recordRemove(fsRef, ir, nbrRemoved);
        }
        return 0 < nbrRemoved;
    }

    @Override
    public final void ll_setIntValue(int fsRef, int featureCode, int value) {
        this.setFeatureValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setFloatValue(int fsRef, int featureCode, float value) {
        this.setFeatureValue(fsRef, featureCode, CASImpl.float2int(value));
    }

    @Override
    public final void ll_setStringValue(int fsRef, int featureCode, String value) {
        int rc;
        TypeSystemImpl ts;
        Object[] stringSet;
        if (null != value && (stringSet = (ts = ((SharedViewData)this.svd).casMetadata.ts).ll_getStringSet(ts.ll_getRangeType(featureCode))) != null && (rc = Arrays.binarySearch(stringSet, value)) < 0) {
            CASRuntimeException e = new CASRuntimeException("ILLEGAL_STRING_VALUE", new String[]{value, ts.ll_getTypeForCode(ts.ll_getRangeType(featureCode)).getName()});
            throw e;
        }
        int stringAddr = value == null ? 0 : this.getStringHeap().addString(value);
        this.setFeatureValue(fsRef, featureCode, stringAddr);
    }

    @Override
    public final void ll_setRefValue(int fsRef, int featureCode, int value) {
        this.setFeatureValueNoIndexCorruptionCheck(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setIntValue(int fsRef, int featureCode, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 2, featureCode);
        }
        this.ll_setIntValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setFloatValue(int fsRef, int featureCode, float value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 3, featureCode);
        }
        this.ll_setFloatValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setStringValue(int fsRef, int featureCode, String value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 4, featureCode);
        }
        this.ll_setStringValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setCharBufferValue(int fsRef, int featureCode, char[] buffer, int start, int length, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 4, featureCode);
        }
        this.ll_setCharBufferValue(fsRef, featureCode, buffer, start, length);
    }

    @Override
    public final void ll_setCharBufferValue(int fsRef, int featureCode, char[] buffer, int start, int length) {
        int stringCode = this.getStringHeap().addCharBuffer(buffer, start, length);
        this.ll_setIntValue(fsRef, featureCode, stringCode);
    }

    @Override
    public int ll_copyCharBufferValue(int fsRef, int featureCode, char[] buffer, int start) {
        int stringCode = this.ll_getIntValue(fsRef, featureCode);
        if (stringCode == 0) {
            return -1;
        }
        return this.getStringHeap().copyCharsToBuffer(stringCode, buffer, start);
    }

    @Override
    public int ll_getCharBufferValueSize(int fsRef, int featureCode) {
        int stringCode = this.ll_getIntValue(fsRef, featureCode);
        if (stringCode == 0) {
            return -1;
        }
        return this.getStringHeap().getCharArrayLength(stringCode);
    }

    @Override
    public final void ll_setRefValue(int fsRef, int featureCode, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkFsRefConditions(fsRef, featureCode);
            this.checkFsRef(value);
        }
        this.ll_setRefValue(fsRef, featureCode, value);
    }

    @Override
    public final int ll_getIntArrayValue(int fsRef, int position) {
        int pos = this.getArrayStartAddress(fsRef) + position;
        return this.getHeap().heap[pos];
    }

    @Override
    public final float ll_getFloatArrayValue(int fsRef, int position) {
        int pos = this.getArrayStartAddress(fsRef) + position;
        return CASImpl.int2float(this.getHeap().heap[pos]);
    }

    @Override
    public final String ll_getStringArrayValue(int fsRef, int position) {
        int pos = this.getArrayStartAddress(fsRef) + position;
        return this.getStringForCode(this.getHeap().heap[pos]);
    }

    @Override
    public final int ll_getRefArrayValue(int fsRef, int position) {
        int pos = this.getArrayStartAddress(fsRef) + position;
        return this.getHeap().heap[pos];
    }

    private void throwAccessTypeError(int fsRef, int typeCode) {
        LowLevelException e = new LowLevelException(6);
        e.addArgument(Integer.toString(fsRef));
        e.addArgument(Integer.toString(typeCode));
        e.addArgument(((SharedViewData)this.svd).casMetadata.ts.ll_getTypeForCode(typeCode).getName());
        e.addArgument(((SharedViewData)this.svd).casMetadata.ts.ll_getTypeForCode(this.ll_getFSRefType(fsRef)).getName());
        throw e;
    }

    public final void checkArrayBounds(int fsRef, int pos) {
        int arrayLength = this.ll_getArraySize(fsRef);
        if (pos < 0 || pos >= arrayLength) {
            throw new ArrayIndexOutOfBoundsException(pos);
        }
    }

    public final void checkArrayBounds(int fsRef, int pos, int length) {
        int arrayLength = this.ll_getArraySize(fsRef);
        if (pos < 0 || length < 0 || pos + length > arrayLength) {
            LowLevelException e = new LowLevelException(8);
            e.addArgument(Integer.toString(pos));
            e.addArgument(Integer.toString(length));
            throw e;
        }
    }

    private final void checkNonArrayConditions(int fsRef, int typeCode, int featureCode) {
        this.checkFsRef(fsRef);
        int domTypeCode = this.getHeap().heap[fsRef];
        this.checkLowLevelParams(fsRef, domTypeCode, typeCode, featureCode);
        this.checkFsRef(fsRef + ((SharedViewData)this.svd).casMetadata.featureOffset[featureCode]);
    }

    private final void checkFsRefConditions(int fsRef, int featureCode) {
        this.checkFsRef(fsRef);
        int domTypeCode = this.getHeap().heap[fsRef];
        this.checkLowLevelParams(fsRef, domTypeCode, featureCode);
        this.checkFsRan(featureCode);
        this.checkFsRef(fsRef + ((SharedViewData)this.svd).casMetadata.featureOffset[featureCode]);
    }

    private final void checkPrimitiveArrayConditions(int fsRef, int typeCode, int position) {
        if (typeCode != this.ll_getFSRefType(fsRef)) {
            this.throwAccessTypeError(fsRef, typeCode);
        }
        this.checkArrayBounds(fsRef, position);
    }

    @Override
    public final int ll_getIntArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 8, position);
        }
        return this.ll_getIntArrayValue(fsRef, position);
    }

    @Override
    public float ll_getFloatArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 7, position);
        }
        return this.ll_getFloatArrayValue(fsRef, position);
    }

    @Override
    public String ll_getStringArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 9, position);
        }
        return this.ll_getStringArrayValue(fsRef, position);
    }

    @Override
    public int ll_getRefArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 6, position);
        }
        return this.ll_getRefArrayValue(fsRef, position);
    }

    @Override
    public void ll_setIntArrayValue(int fsRef, int position, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 8, position);
        }
        this.ll_setIntArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setFloatArrayValue(int fsRef, int position, float value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 7, position);
        }
        this.ll_setFloatArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setStringArrayValue(int fsRef, int position, String value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 9, position);
        }
        this.ll_setStringArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setRefArrayValue(int fsRef, int position, int value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 6, position);
            this.checkFsRef(value);
        }
        this.ll_setRefArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setIntArrayValue(int fsRef, int position, int value) {
        int pos = this.getArrayStartAddress(fsRef) + position;
        this.getHeap().heap[pos] = value;
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, pos, ModifiedHeap.FSHEAP, 1);
        }
    }

    @Override
    public void ll_setFloatArrayValue(int fsRef, int position, float value) {
        int pos = this.getArrayStartAddress(fsRef) + position;
        this.getHeap().heap[pos] = CASImpl.float2int(value);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, pos, ModifiedHeap.FSHEAP, 1);
        }
    }

    @Override
    public void ll_setStringArrayValue(int fsRef, int position, String value) {
        int stringCode;
        int pos = this.getArrayStartAddress(fsRef) + position;
        this.getHeap().heap[pos] = stringCode = value == null ? 0 : this.addString(value);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, pos, ModifiedHeap.FSHEAP, 1);
        }
    }

    @Override
    public void ll_setRefArrayValue(int fsRef, int position, int value) {
        int pos = this.getArrayStartAddress(fsRef) + position;
        this.getHeap().heap[pos] = value;
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, pos, ModifiedHeap.FSHEAP, 1);
        }
    }

    @Override
    public int ll_getFSRefType(int fsRef) {
        return this.getHeap().heap[fsRef];
    }

    @Override
    public int ll_getFSRefType(int fsRef, boolean doChecks) {
        if (doChecks) {
            this.checkFsRef(fsRef);
            this.checkTypeAt(this.ll_getFSRefType(fsRef), fsRef);
        }
        return this.ll_getFSRefType(fsRef);
    }

    @Override
    public LowLevelCAS getLowLevelCAS() {
        return this;
    }

    @Override
    public int size() {
        return this.getHeap().heap.length * 6;
    }

    @Override
    public ClassLoader getJCasClassLoader() {
        return this.svd.jcasClassLoader;
    }

    @Override
    public void setJCasClassLoader(ClassLoader classLoader) {
        this.svd.previousJCasClassLoader = classLoader;
        this.svd.jcasClassLoader = classLoader;
    }

    public void switchClassLoaderLockCas(Object userCode) {
        this.switchClassLoaderLockCasCL(userCode.getClass().getClassLoader());
    }

    public void switchClassLoaderLockCasCL(ClassLoader newClassLoader) {
        this.enableReset(false);
        this.switchClassLoader(newClassLoader);
    }

    public void switchClassLoader(ClassLoader newClassLoader) {
        if (null == newClassLoader) {
            return;
        }
        if (newClassLoader != this.svd.jcasClassLoader) {
            if (this.svd.jcasClassLoader != this.svd.previousJCasClassLoader) {
                throw new CASRuntimeException("SWITCH_CLASS_LOADER_NESTED", new Object[]{this.svd.previousJCasClassLoader, this.svd.jcasClassLoader, newClassLoader});
            }
            this.svd.jcasClassLoader = newClassLoader;
            if (null != this.jcas) {
                this.jcas.switchClassLoader(newClassLoader);
            }
        }
    }

    public boolean usingBaseClassLoader() {
        return this.svd.jcasClassLoader == this.svd.previousJCasClassLoader;
    }

    public void restoreClassLoaderUnlockCas() {
        this.enableReset(true);
        if (null == this.svd.previousJCasClassLoader) {
            return;
        }
        if (this.svd.previousJCasClassLoader != this.svd.jcasClassLoader) {
            this.svd.jcasClassLoader = this.svd.previousJCasClassLoader;
            if (null != this.jcas) {
                this.jcas.switchClassLoader(this.svd.previousJCasClassLoader);
            }
        }
    }

    @Override
    public FeatureValuePath createFeatureValuePath(String featureValuePath) throws CASRuntimeException {
        return FeatureValuePathImpl.getFeaturePath(featureValuePath);
    }

    @Override
    public void setOwner(CasOwner aCasOwner) {
        CASImpl baseCas = this.getBaseCAS();
        if (baseCas != this) {
            baseCas.setOwner(aCasOwner);
        } else {
            super.setOwner(aCasOwner);
        }
    }

    @Override
    public void release() {
        CASImpl baseCas = this.getBaseCAS();
        if (baseCas != this) {
            baseCas.release();
        } else {
            super.release();
        }
    }

    @Override
    public ByteArrayFS createByteArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return (ByteArrayFS)this.createFS(this.ll_createByteArray(length));
    }

    @Override
    public BooleanArrayFS createBooleanArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return (BooleanArrayFS)this.createFS(this.ll_createBooleanArray(length));
    }

    @Override
    public ShortArrayFS createShortArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return (ShortArrayFS)this.createFS(this.ll_createShortArray(length));
    }

    @Override
    public LongArrayFS createLongArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return (LongArrayFS)this.createFS(this.ll_createLongArray(length));
    }

    @Override
    public DoubleArrayFS createDoubleArrayFS(int length) throws CASRuntimeException {
        this.checkArrayPreconditions(length);
        return (DoubleArrayFS)this.createFS(this.ll_createDoubleArray(length));
    }

    @Override
    public byte ll_getByteValue(int fsRef, int featureCode) {
        return (byte)this.ll_getIntValue(fsRef, featureCode);
    }

    @Override
    public byte ll_getByteValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 24, featureCode);
        }
        return this.ll_getByteValue(fsRef, featureCode);
    }

    @Override
    public boolean ll_getBooleanValue(int fsRef, int featureCode) {
        return 1 == this.ll_getIntValue(fsRef, featureCode);
    }

    @Override
    public boolean ll_getBooleanValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 23, featureCode);
        }
        return this.ll_getBooleanValue(fsRef, featureCode);
    }

    @Override
    public short ll_getShortValue(int fsRef, int featureCode) {
        return (short)this.ll_getIntValue(fsRef, featureCode);
    }

    @Override
    public short ll_getShortValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 25, featureCode);
        }
        return this.ll_getShortValue(fsRef, featureCode);
    }

    public long ll_getLongValue(int offset) {
        return this.getLongHeap().getHeapValue(offset);
    }

    @Override
    public long ll_getLongValue(int fsRef, int featureCode) {
        int offset = this.getHeap().heap[fsRef + ((SharedViewData)this.svd).casMetadata.featureOffset[featureCode]];
        long val = this.getLongHeap().getHeapValue(offset);
        return val;
    }

    public long ll_getLongValueFeatOffset(int fsRef, int featureOffset) {
        int offset = this.getHeap().heap[fsRef + featureOffset];
        long val = this.getLongHeap().getHeapValue(offset);
        return val;
    }

    @Override
    public long ll_getLongValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 26, featureCode);
        }
        return this.ll_getLongValue(fsRef, featureCode);
    }

    @Override
    public double ll_getDoubleValue(int fsRef, int featureCode) {
        int offset = this.getHeap().heap[fsRef + ((SharedViewData)this.svd).casMetadata.featureOffset[featureCode]];
        long val = this.getLongHeap().getHeapValue(offset);
        return Double.longBitsToDouble(val);
    }

    public double ll_getDoubleValueFeatOffset(int fsRef, int featureOffset) {
        int offset = this.getHeap().heap[fsRef + featureOffset];
        long val = this.getLongHeap().getHeapValue(offset);
        return Double.longBitsToDouble(val);
    }

    @Override
    public double ll_getDoubleValue(int fsRef, int featureCode, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 27, featureCode);
        }
        return this.ll_getDoubleValue(fsRef, featureCode);
    }

    @Override
    public void ll_setBooleanValue(int fsRef, int featureCode, boolean value) {
        this.setFeatureValue(fsRef, featureCode, value ? 1 : 0);
    }

    @Override
    public void ll_setBooleanValue(int fsRef, int featureCode, boolean value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 23, featureCode);
        }
        this.ll_setBooleanValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setByteValue(int fsRef, int featureCode, byte value) {
        this.setFeatureValue(fsRef, featureCode, value);
    }

    @Override
    public void ll_setByteValue(int fsRef, int featureCode, byte value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 24, featureCode);
        }
        this.ll_setByteValue(fsRef, featureCode, value);
    }

    @Override
    public final void ll_setShortValue(int fsRef, int featureCode, short value) {
        this.setFeatureValue(fsRef, featureCode, value);
    }

    @Override
    public void ll_setShortValue(int fsRef, int featureCode, short value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 23, featureCode);
        }
        this.ll_setShortValue(fsRef, featureCode, value);
    }

    @Override
    public void ll_setLongValue(int fsRef, int featureCode, long value) {
        int offset = this.getLongHeap().addLong(value);
        this.setFeatureValue(fsRef, featureCode, offset);
    }

    @Override
    public void ll_setLongValue(int fsRef, int featureCode, long value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 26, featureCode);
        }
        this.ll_setLongValue(fsRef, featureCode, value);
    }

    @Override
    public void ll_setDoubleValue(int fsRef, int featureCode, double value) {
        long val = Double.doubleToLongBits(value);
        int offset = this.getLongHeap().addLong(val);
        this.setFeatureValue(fsRef, featureCode, offset);
    }

    @Override
    public void ll_setDoubleValue(int fsRef, int featureCode, double value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkNonArrayConditions(fsRef, 27, featureCode);
        }
        this.ll_setDoubleValue(fsRef, featureCode, value);
    }

    @Override
    public byte ll_getByteArrayValue(int fsRef, int position) {
        int pos = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        return this.getByteHeap().getHeapValue(pos + position);
    }

    @Override
    public byte ll_getByteArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 29, position);
        }
        return this.ll_getByteArrayValue(fsRef, position);
    }

    @Override
    public boolean ll_getBooleanArrayValue(int fsRef, int position) {
        int pos = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        return 1 == this.getByteHeap().getHeapValue(pos + position);
    }

    @Override
    public boolean ll_getBooleanArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 28, position);
        }
        return this.ll_getBooleanArrayValue(fsRef, position);
    }

    @Override
    public short ll_getShortArrayValue(int fsRef, int position) {
        int pos = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        return this.getShortHeap().getHeapValue(pos + position);
    }

    @Override
    public short ll_getShortArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 30, position);
        }
        return this.ll_getShortArrayValue(fsRef, position);
    }

    @Override
    public long ll_getLongArrayValue(int fsRef, int position) {
        int pos = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        return this.getLongHeap().getHeapValue(pos + position);
    }

    @Override
    public long ll_getLongArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 31, position);
        }
        return this.ll_getLongArrayValue(fsRef, position);
    }

    @Override
    public double ll_getDoubleArrayValue(int fsRef, int position) {
        int pos = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        long val = this.getLongHeap().getHeapValue(pos + position);
        return Double.longBitsToDouble(val);
    }

    @Override
    public double ll_getDoubleArrayValue(int fsRef, int position, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 32, position);
        }
        return this.ll_getDoubleArrayValue(fsRef, position);
    }

    @Override
    public void ll_setByteArrayValue(int fsRef, int position, byte value) {
        int offset = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        this.getByteHeap().setHeapValue(value, offset + position);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, offset + position, ModifiedHeap.BYTEHEAP, 1);
        }
    }

    @Override
    public void ll_setByteArrayValue(int fsRef, int position, byte value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 29, position);
        }
        this.ll_setByteArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setBooleanArrayValue(int fsRef, int position, boolean b) {
        byte value = (byte)(b ? 1 : 0);
        int offset = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        this.getByteHeap().setHeapValue(value, offset + position);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, offset + position, ModifiedHeap.BYTEHEAP, 1);
        }
    }

    @Override
    public void ll_setBooleanArrayValue(int fsRef, int position, boolean value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 28, position);
        }
        this.ll_setBooleanArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setShortArrayValue(int fsRef, int position, short value) {
        int offset = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        this.getShortHeap().setHeapValue(value, offset + position);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, offset + position, ModifiedHeap.SHORTHEAP, 1);
        }
    }

    @Override
    public void ll_setShortArrayValue(int fsRef, int position, short value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 30, position);
        }
        this.ll_setShortArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setLongArrayValue(int fsRef, int position, long value) {
        int offset = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        this.getLongHeap().setHeapValue(value, offset + position);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, offset + position, ModifiedHeap.LONGHEAP, 1);
        }
    }

    @Override
    public void ll_setLongArrayValue(int fsRef, int position, long value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 31, position);
        }
        this.ll_setLongArrayValue(fsRef, position, value);
    }

    @Override
    public void ll_setDoubleArrayValue(int fsRef, int position, double d) {
        int offset = this.getHeap().heap[this.getArrayStartAddress(fsRef)];
        long value = Double.doubleToLongBits(d);
        this.getLongHeap().setHeapValue(value, offset + position);
        if (this.svd.trackingMark != null) {
            this.logFSUpdate(fsRef, offset + position, ModifiedHeap.LONGHEAP, 1);
        }
    }

    @Override
    public void ll_setDoubleArrayValue(int fsRef, int position, double value, boolean doTypeChecks) {
        if (doTypeChecks) {
            this.checkPrimitiveArrayConditions(fsRef, 32, position);
        }
        this.ll_setDoubleArrayValue(fsRef, position, value);
    }

    public boolean isAnnotationType(Type t) {
        return this.getTypeSystem().subsumes(this.getAnnotationType(), t);
    }

    public boolean isSubtypeOfAnnotationBaseType(int t) {
        return ((SharedViewData)this.svd).casMetadata.ts.subsumes(34, t);
    }

    @Override
    public AnnotationFS createAnnotation(Type type, int begin, int end) {
        if (this == this.svd.baseCAS) {
            CASRuntimeException e = new CASRuntimeException("INVALID_BASE_CAS_METHOD", new String[]{"createAnnotation(Type, int, int)"});
            throw e;
        }
        Object fs = this.createFS(type);
        int addr = this.ll_getFSRef((FeatureStructure)fs);
        this.setFeatureValueNotJournaled(addr, 16, begin);
        this.setFeatureValueNotJournaled(addr, 17, end);
        return (AnnotationFS)fs;
    }

    public int ll_createAnnotation(int typeCode, int begin, int end) {
        int addr = this.ll_createFSAnnotCheck(typeCode);
        this.setFeatureValueNotJournaled(addr, 16, begin);
        this.setFeatureValueNotJournaled(addr, 17, end);
        return addr;
    }

    @Override
    public <T extends AnnotationFS> AnnotationIndex<T> getAnnotationIndex() {
        return new AnnotationIndexImpl(this.getIndexRepository().getIndex("AnnotationIndex"));
    }

    @Override
    public <T extends AnnotationFS> AnnotationIndex<T> getAnnotationIndex(Type type) {
        return new AnnotationIndexImpl(this.getIndexRepository().getIndex("AnnotationIndex", type));
    }

    @Override
    public Type getAnnotationType() {
        return ((SharedViewData)this.svd).casMetadata.ts.annotType;
    }

    @Override
    public Feature getEndFeature() {
        return ((SharedViewData)this.svd).casMetadata.ts.endFeat;
    }

    @Override
    public Feature getBeginFeature() {
        return ((SharedViewData)this.svd).casMetadata.ts.startFeat;
    }

    private <T extends AnnotationFS> T createDocumentAnnotation(int length) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        FSIterator it = this.getAnnotationIndex(ts.docType).iterator();
        ArrayList list = new ArrayList();
        while (it.isValid()) {
            list.add(it.get());
            it.moveToNext();
        }
        for (int i = 0; i < list.size(); ++i) {
            this.getIndexRepository().removeFS((FeatureStructure)list.get(i));
        }
        return (T)((AnnotationFS)this.ll_getFSForRef(this.ll_createDocumentAnnotation(length)));
    }

    public int ll_createDocumentAnnotation(int length) {
        int fsRef = this.ll_createDocumentAnnotationNoIndex(0, length);
        this.ll_getIndexRepository().ll_addFS(fsRef);
        return fsRef;
    }

    public int ll_createDocumentAnnotationNoIndex(int begin, int end) {
        TypeSystemImpl ts = ((SharedViewData)this.svd).casMetadata.ts;
        int fsRef = this.ll_createAnnotation(ts.docType.getCode(), begin, end);
        this.ll_setStringValue(fsRef, ts.langFeat.getCode(), "x-unspecified");
        return fsRef;
    }

    public void updateDocumentAnnotation() {
        if (!this.mySofaIsValid() || this == this.svd.baseCAS) {
            return;
        }
        String newDoc = this.ll_getSofaDataString(this.mySofaRef);
        if (null != newDoc) {
            int docAnnot = this.ll_getDocumentAnnotation();
            if (docAnnot != 0) {
                boolean wasRemoved = this.removeFromCorruptableIndexAnyViewSetCache(docAnnot, this.getAddbackSingle());
                this.setFeatureValueNoIndexCorruptionCheck(docAnnot, 17, newDoc.length());
                if (wasRemoved) {
                    this.addbackSingle(docAnnot);
                } else {
                    this.svd.fsTobeAddedbackSingleInUse = false;
                }
            } else {
                this.createDocumentAnnotation(newDoc.length());
            }
        }
    }

    @Override
    public <T extends AnnotationFS> T getDocumentAnnotation() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        FSIterator it = this.getAnnotationIndex(((SharedViewData)this.svd).casMetadata.ts.docType).iterator();
        if (it.isValid()) {
            return (T)((AnnotationFS)it.get());
        }
        return this.createDocumentAnnotation(0);
    }

    public int ll_getDocumentAnnotation() {
        if (this == this.svd.baseCAS) {
            return 0;
        }
        LowLevelIterator it = this.ll_getIndexRepository().ll_getIndex("AnnotationIndex", ((SharedViewData)this.svd).casMetadata.ts.docType.getCode()).ll_iterator();
        if (it.isValid()) {
            return it.ll_get();
        }
        return 0;
    }

    @Override
    public String getDocumentLanguage() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        int docAnnotAddr = this.ll_getFSRef((FeatureStructure)this.getDocumentAnnotation());
        return this.ll_getStringValue(docAnnotAddr, 18);
    }

    @Override
    public String getDocumentText() {
        return this.getSofaDataString();
    }

    @Override
    public String getSofaDataString() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        if (this.mySofaIsValid()) {
            return this.ll_getSofaDataString(this.mySofaRef);
        }
        return null;
    }

    @Override
    public FeatureStructure getSofaDataArray() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        if (this.mySofaIsValid()) {
            return this.ll_getFSForRef(this.ll_getRefValue(this.mySofaRef, 12));
        }
        return null;
    }

    @Override
    public String getSofaDataURI() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        if (this.mySofaIsValid()) {
            return this.getSofa(this.mySofaRef).getSofaURI();
        }
        return null;
    }

    @Override
    public InputStream getSofaDataStream() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        return this.getSofaDataStream(this.getSofa());
    }

    @Override
    public String getSofaMimeType() {
        if (this == this.svd.baseCAS) {
            return null;
        }
        if (this.mySofaIsValid()) {
            return this.getSofa(this.mySofaRef).getSofaMime();
        }
        return null;
    }

    @Override
    public SofaFS getSofa() {
        if (this.mySofaRef > 0) {
            return this.getSofa(this.mySofaRef);
        }
        return null;
    }

    @Override
    public int ll_getSofa() {
        return this.mySofaRef > 0 ? this.mySofaRef : 0;
    }

    @Override
    public String getViewName() {
        if (this == this.getViewFromSofaNbr(1)) {
            return "_InitialView";
        }
        if (this.mySofaRef > 0) {
            return this.ll_getSofaID(this.mySofaRef);
        }
        return null;
    }

    private boolean mySofaIsValid() {
        return this.mySofaRef > 0;
    }

    void setDocTextFromDeserializtion(String text) {
        if (this.mySofaIsValid()) {
            int SofaStringCode = this.ll_getTypeSystem().ll_getCodeForFeature(this.getTypeSystem().getFeatureByFullName("uima.cas.Sofa:sofaString"));
            this.ll_setStringValue(this.getSofaRef(), SofaStringCode, text);
        }
    }

    @Override
    public void setDocumentLanguage(String languageCode) {
        if (this == this.svd.baseCAS) {
            CASRuntimeException e = new CASRuntimeException("INVALID_BASE_CAS_METHOD", new String[]{"setDocumentLanguage(String)"});
            throw e;
        }
        CASImpl llc = this;
        int docAnnotAddr = llc.ll_getFSRef((FeatureStructure)this.getDocumentAnnotation());
        languageCode = Language.normalize(languageCode);
        llc.ll_setStringValue(docAnnotAddr, 18, languageCode);
    }

    @Override
    public void setDocumentText(String text) {
        if (this == this.svd.baseCAS) {
            CASRuntimeException e = new CASRuntimeException("INVALID_BASE_CAS_METHOD", new String[]{"setDocumentText(String)"});
            throw e;
        }
        this.setSofaDataString(text, "text");
    }

    @Override
    public void setSofaDataString(String text, String mime) throws CASRuntimeException {
        if (this == this.svd.baseCAS) {
            CASRuntimeException e = new CASRuntimeException("INVALID_BASE_CAS_METHOD", new String[]{"setDocumentText(String)"});
            throw e;
        }
        if (!this.mySofaIsValid()) {
            this.createInitialSofa(null);
        }
        this.getSofa(this.mySofaRef).setLocalSofaData(text);
        this.ll_setStringValue(this.mySofaRef, 11, mime);
    }

    @Override
    public void setSofaDataArray(FeatureStructure array, String mime) throws CASRuntimeException {
        if (this == this.svd.baseCAS) {
            CASRuntimeException e = new CASRuntimeException("INVALID_BASE_CAS_METHOD", new String[]{"setSofaDataArray(FeatureStructure, mime)"});
            throw e;
        }
        if (!this.mySofaIsValid()) {
            this.createInitialSofa(null);
        }
        this.getSofa(this.mySofaRef).setLocalSofaData(array);
        this.ll_setStringValue(this.mySofaRef, 11, mime);
    }

    @Override
    public void setSofaDataURI(String uri, String mime) throws CASRuntimeException {
        if (this == this.svd.baseCAS) {
            CASRuntimeException e = new CASRuntimeException("INVALID_BASE_CAS_METHOD", new String[]{"setSofaDataURI(String, String)"});
            throw e;
        }
        if (!this.mySofaIsValid()) {
            this.createInitialSofa(null);
        }
        this.getSofa(this.mySofaRef).setRemoteSofaURI(uri);
        this.ll_setStringValue(this.mySofaRef, 11, mime);
    }

    @Override
    public void setCurrentComponentInfo(ComponentInfo info) {
        this.svd.componentInfo = info;
    }

    ComponentInfo getCurrentComponentInfo() {
        return this.svd.componentInfo;
    }

    @Override
    public void addFsToIndexes(FeatureStructure fs) {
        this.indexRepository.addFS(fs);
    }

    @Override
    public void removeFsFromIndexes(FeatureStructure fs) {
        this.indexRepository.removeFS(fs);
    }

    @Override
    public CASImpl ll_getSofaCasView(int addr) {
        int addrOfSofaFS = this.getSofaFeat(addr);
        if (addrOfSofaFS > 0 && addrOfSofaFS != this.getSofaRef()) {
            return (CASImpl)this.getView(this.ll_getSofaNum(addrOfSofaFS));
        }
        return this;
    }

    @Override
    public Iterator<CAS> getViewIterator() {
        return new Iterator<CAS>(){
            final CASImpl initialView;
            boolean testInitView;
            final FSIterator<SofaFS> sofaIter;
            {
                this.initialView = (CASImpl)CASImpl.this.getInitialView();
                this.testInitView = !this.initialView.mySofaIsValid();
                this.sofaIter = CASImpl.this.getSofaIterator();
            }

            @Override
            public boolean hasNext() {
                if (this.testInitView) {
                    return true;
                }
                return this.sofaIter.hasNext();
            }

            @Override
            public CAS next() {
                if (this.testInitView) {
                    this.testInitView = false;
                    return this.initialView;
                }
                return CASImpl.this.getView((SofaFS)this.sofaIter.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<CAS> getViewIterator(String localViewNamePrefix) {
        String absolutePrefix = null;
        if (this.getCurrentComponentInfo() != null) {
            absolutePrefix = this.getCurrentComponentInfo().mapToSofaID(localViewNamePrefix);
        }
        if (absolutePrefix == null) {
            absolutePrefix = localViewNamePrefix;
        }
        ArrayList<CAS> viewList = new ArrayList<CAS>();
        FSIterator<SofaFS> sofaIter = this.getSofaIterator();
        while (sofaIter.hasNext()) {
            SofaFS sofa = (SofaFS)sofaIter.next();
            String sofaId = sofa.getSofaID();
            if (!sofaId.startsWith(absolutePrefix) || sofaId.length() != absolutePrefix.length() && sofaId.charAt(absolutePrefix.length()) != '.') continue;
            viewList.add(this.getView(sofa));
        }
        return viewList.iterator();
    }

    public final boolean doUseJcasCache() {
        return this.isUsedJcasCache;
    }

    @Override
    public AutoCloseable protectIndexes() {
        FSsTobeAddedback r = FSsTobeAddedback.createMultiple(this);
        this.svd.fssTobeAddedback.add(r);
        return r;
    }

    void dropProtectIndexesLevel() {
        this.svd.fssTobeAddedback.remove(this.svd.fssTobeAddedback.size() - 1);
    }

    void addbackModifiedFSs(FSsTobeAddedback addbacks) {
        ArrayList s2 = this.svd.fssTobeAddedback;
        if (s2.get(s2.size() - 1) == addbacks) {
            s2.remove(s2.size());
        } else {
            int pos = s2.indexOf(addbacks);
            if (pos >= 0) {
                for (int i = s2.size() - 1; i > pos; --i) {
                    FSsTobeAddedback toAddBack = (FSsTobeAddedback)s2.remove(i);
                    toAddBack.addback();
                }
            }
        }
        addbacks.addback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void protectIndexes(Runnable r) {
        AutoCloseable addbacks = this.protectIndexes();
        try {
            r.run();
        }
        finally {
            this.addbackModifiedFSs((FSsTobeAddedback)addbacks);
        }
    }

    @Override
    public Marker createMarker() {
        if (!this.svd.flushEnabled) {
            throw new CASAdminException(9);
        }
        this.svd.trackingMark = new MarkerImpl(this.getHeap().getNextId(), this.getStringHeap().getSize(), this.getByteHeap().getSize(), this.getShortHeap().getSize(), this.getLongHeap().getSize(), this);
        if (this.svd.modifiedPreexistingFSs == null) {
            this.svd.modifiedPreexistingFSs = new IntVector();
        } else {
            this.errorMultipleMarkers();
        }
        if (this.svd.modifiedFSHeapCells == null) {
            this.svd.modifiedFSHeapCells = new IntVector();
        } else {
            this.errorMultipleMarkers();
        }
        if (this.svd.modifiedByteHeapCells == null) {
            this.svd.modifiedByteHeapCells = new IntVector();
        } else {
            this.errorMultipleMarkers();
        }
        if (this.svd.modifiedShortHeapCells == null) {
            this.svd.modifiedShortHeapCells = new IntVector();
        } else {
            this.errorMultipleMarkers();
        }
        if (this.svd.modifiedLongHeapCells == null) {
            this.svd.modifiedLongHeapCells = new IntVector();
        } else {
            this.errorMultipleMarkers();
        }
        if (this.svd.trackingMarkList == null) {
            this.svd.trackingMarkList = new ArrayList();
        } else {
            this.errorMultipleMarkers();
        }
        this.svd.trackingMarkList.add(this.svd.trackingMark);
        return this.svd.trackingMark;
    }

    private void errorMultipleMarkers() {
        throw new CASRuntimeException("MULTIPLE_CREATE_MARKER");
    }

    private void logFSUpdate(int fsaddr, int position, ModifiedHeap whichheap, int howmany) {
        if (this.svd.trackingMark != null && !this.svd.trackingMark.isNew(fsaddr)) {
            int lastModifiedFS = -1;
            if (this.svd.modifiedPreexistingFSs.size() > 0) {
                lastModifiedFS = this.svd.modifiedPreexistingFSs.get(this.svd.modifiedPreexistingFSs.size() - 1);
            }
            if (lastModifiedFS != fsaddr) {
                this.svd.modifiedPreexistingFSs.add(fsaddr);
            }
            switch (whichheap) {
                case FSHEAP: {
                    for (int i = 0; i < howmany; ++i) {
                        this.svd.modifiedFSHeapCells.add(position + i);
                    }
                    break;
                }
                case BYTEHEAP: {
                    for (int i = 0; i < howmany; ++i) {
                        this.svd.modifiedByteHeapCells.add(position + i);
                    }
                    break;
                }
                case SHORTHEAP: {
                    for (int i = 0; i < howmany; ++i) {
                        this.svd.modifiedShortHeapCells.add(position + i);
                    }
                    break;
                }
                case LONGHEAP: {
                    for (int i = 0; i < howmany; ++i) {
                        this.svd.modifiedLongHeapCells.add(position + i);
                    }
                    break;
                }
            }
        }
    }

    public MarkerImpl getCurrentMark() {
        return this.svd.trackingMark;
    }

    IntVector getModifiedFSList() {
        return this.svd.modifiedPreexistingFSs;
    }

    IntVector getModifiedFSHeapAddrs() {
        return this.svd.modifiedFSHeapCells;
    }

    IntVector getModifiedByteHeapAddrs() {
        return this.svd.modifiedByteHeapCells;
    }

    IntVector getModifiedShortHeapAddrs() {
        return this.svd.modifiedShortHeapCells;
    }

    IntVector getModifiedLongHeapAddrs() {
        return this.svd.modifiedLongHeapCells;
    }

    public String toString() {
        String sofa = this.mySofaRef == -1 ? "_InitialView" : (this.mySofaRef == 0 ? "no Sofa" : this.getSofa(this.mySofaRef).getSofaID());
        return "CASImpl [view: " + sofa + "]";
    }

    int getCasResets() {
        return this.svd.casResets.get();
    }

    int getCasId() {
        return this.svd.casId;
    }

    void traceFSCreate(FeatureStructureImpl fs) {
        StringBuilder b = this.svd.traceFScreationSb;
        if (b.length() > 0) {
            this.traceFSflush();
        }
        this.traceFSfs(fs);
        this.svd.traceFSisCreate = true;
        if (fs.getType().isArray()) {
            int arraySize = this.ll_getArraySize(fs.getAddress());
            b.append(" l:").append(arraySize);
        }
        if (fs.getAddress() > 190000 && fs.getAddress() < 200000 && fs.getType().getShortName().equals("Passage")) {
            traceOut.println("Passage callback: " + MiscImpl.getCallers(3, 10));
        }
    }

    void traceFSfs(FeatureStructureImpl fs) {
        StringBuilder b = this.svd.traceFScreationSb;
        this.svd.traceFSid = fs.getAddress();
        b.append("c:").append(String.format("%-3d", this.getCasId()));
        String viewName = fs.getCAS().getViewName();
        if (null == viewName) {
            viewName = "base";
        }
        b.append(" v:").append(MiscImpl.elide(viewName, 8));
        b.append(" i:").append(String.format("%-5s", fs.getAddress()));
        b.append(" t:").append(MiscImpl.elide(fs.getType().getShortName(), 10));
    }

    void traceFSfeat(FeatureStructure fs, FeatureImpl fi, int v) {
        StringBuilder b = this.svd.traceFScreationSb;
        FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
        if (fsi.getAddress() != this.svd.traceFSid) {
            this.traceFSfeatUpdate(fsi);
        }
        String fn = fi.getShortName();
        String fv = this.getTraceRepOfObj(fi, v);
        int i_v = Math.max(0, 10 - fn.length());
        int i_n = Math.max(0, 10 - fv.length());
        fn = MiscImpl.elide(fn, 10 + i_n, false);
        fv = MiscImpl.elide(fv, 10 + i_v, false);
        b.append(' ').append(MiscImpl.elide(fn + ':' + fv, 21));
    }

    private String getTraceRepOfObj(FeatureImpl fi, int v) {
        TypeImpl range = (TypeImpl)fi.getRange();
        int rangeCode = range.getCode();
        if (this.ll_isRefType(rangeCode)) {
            if (v == 0) {
                return "null";
            }
            Type type = this.getTypeSystemImpl().ll_getTypeForCode(this.getTypeCode(v));
            return (type == null ? "unknwn" : MiscImpl.elide(type.getShortName(), 5, false)) + ':' + v;
        }
        if (this.isStringType(rangeCode)) {
            String s2 = this.getStringHeap().getStringForCode(v);
            s2 = MiscImpl.elide(s2, 50, false);
            return MiscImpl.replaceWhiteSpace(s2, "_");
        }
        if (this.isFloatType(rangeCode)) {
            return Float.toString(CASImpl.int2float(v));
        }
        if (this.isBooleanType(rangeCode)) {
            return v == 1 ? "true" : "false";
        }
        if (this.isLongType(rangeCode)) {
            return Long.toString(this.getLongHeap().getHeapValue(v));
        }
        if (this.isDoubleType(rangeCode)) {
            return Double.toString(CASImpl.long2double(this.getLongHeap().getHeapValue(v)));
        }
        return Integer.toString(v);
    }

    void traceFSfeatUpdate(FeatureStructureImpl fs) {
        this.traceFSflush();
        this.traceFSfs(fs);
        this.svd.traceFSisCreate = false;
    }

    StringBuilder traceFSflush() {
        StringBuilder b = this.svd.traceFScreationSb;
        if (b.length() > 0) {
            traceOut.println((this.svd.traceFSisCreate ? "cr: " : "up: ") + b);
            b.setLength(0);
        }
        return b;
    }

    static {
        try {
            traceOut = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        casIdProvider = new AtomicInteger(0);
        INT0 = new int[0];
        IS_THROW_EXCEPTION_CORRUPT_INDEX = Misc.getNoValueSystemProperty(THROW_EXCEPTION_FS_UPDATES_CORRUPTS);
        IS_REPORT_FS_UPDATE_CORRUPTS_INDEX = IS_THROW_EXCEPTION_CORRUPT_INDEX || Misc.getNoValueSystemProperty(REPORT_FS_UPDATES_CORRUPTS);
        IS_DISABLED_PROTECT_INDEXES = Misc.getNoValueSystemProperty(DISABLE_PROTECT_INDEXES) && !IS_REPORT_FS_UPDATE_CORRUPTS_INDEX && !IS_THROW_EXCEPTION_CORRUPT_INDEX;
        new DebugNameValuePair(null, null);
        new DebugFSLogicalStructure();
    }

    private class BinDeserSupport {
        private int fsStartAddr;
        private int fsEndAddr;
        private int[] fssAddrArray;
        private int fssIndex;
        private int lastRemovedFsAddr;
        private int[] featCodes;
        private FSsTobeAddedback tobeAddedback = FSsTobeAddedback.createSingle();

        private BinDeserSupport() {
        }

        static /* synthetic */ int[] access$3002(BinDeserSupport x0, int[] x1) {
            x0.fssAddrArray = x1;
            return x1;
        }

        static /* synthetic */ int[] access$3502(BinDeserSupport x0, int[] x1) {
            x0.featCodes = x1;
            return x1;
        }
    }

    private static class SharedViewData {
        private final Heap heap;
        private final StringHeap stringHeap = new StringHeap();
        private final ByteHeap byteHeap = new ByteHeap();
        private final ShortHeap shortHeap = new ShortHeap();
        private final LongHeap longHeap = new LongHeap();
        private int annotFeatOffset_begin;
        private int annotFeatOffset_end;
        private final CASImpl baseCAS;
        private int cache_not_in_index = 0;
        private final PositiveIntSet_impl featureCodesInIndexKeys = new PositiveIntSet_impl();
        private Map<Integer, FSIndexRepository> sofa2indexMap;
        private ArrayList<CAS> sofaNbr2ViewMap;
        private Set<String> sofaNameSet;
        private boolean initialSofaCreated = false;
        private int viewCount;
        private ClassLoader jcasClassLoader;
        private ClassLoader previousJCasClassLoader = this.jcasClassLoader = this.getClass().getClassLoader();
        private boolean flushEnabled = true;
        private final boolean useFSCache;
        private FeatureStructure[] fsArray;
        private CASMetadata casMetadata;
        private ComponentInfo componentInfo;
        private FSGenerator<? extends FeatureStructure>[] localFsGenerators;
        private MarkerImpl trackingMark;
        private IntVector modifiedPreexistingFSs;
        private IntVector modifiedFSHeapCells;
        private IntVector modifiedByteHeapCells;
        private IntVector modifiedShortHeapCells;
        private IntVector modifiedLongHeapCells;
        private List<MarkerImpl> trackingMarkList;
        private final ArrayList<FSsTobeAddedback> fssTobeAddedback = new ArrayList();
        private final FSsTobeAddedback.FSsTobeAddedbackSingle fsTobeAddedbackSingle = (FSsTobeAddedback.FSsTobeAddedbackSingle)FSsTobeAddedback.createSingle();
        private boolean fsTobeAddedbackSingleInUse = false;
        private final AtomicInteger casResets = new AtomicInteger(0);
        private final int casId;
        private final StringBuilder traceFScreationSb = null;
        private int traceFSid = 0;
        private boolean traceFSisCreate;

        private SharedViewData(boolean useFSCache, Heap heap, CASImpl baseCAS, CASMetadata casMetadata) {
            this.useFSCache = useFSCache;
            this.heap = heap;
            this.baseCAS = baseCAS;
            this.casMetadata = casMetadata;
            this.casId = casIdProvider.incrementAndGet();
        }

        static /* synthetic */ FSGenerator[] access$1702(SharedViewData x0, FSGenerator[] x1) {
            x0.localFsGenerators = x1;
            return x1;
        }

        static /* synthetic */ FeatureStructure[] access$4402(SharedViewData x0, FeatureStructure[] x1) {
            x0.fsArray = x1;
            return x1;
        }
    }

    private static enum ModifiedHeap {
        FSHEAP,
        BYTEHEAP,
        SHORTHEAP,
        LONGHEAP;

    }
}

