/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.uima.UIMARuntimeException;

public class CommonSerDes {
    int version1;
    int version2;
    boolean isDelta;
    boolean isCompressed;

    public static Header createHeader() {
        return new Header();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBinaryHeader(DataInputStream dis) {
        dis.mark(4);
        byte[] bytebuf = new byte[4];
        try {
            bytebuf[0] = dis.readByte();
            bytebuf[1] = dis.readByte();
            bytebuf[2] = dis.readByte();
            bytebuf[3] = dis.readByte();
            String s2 = new String(bytebuf, "UTF-8");
            boolean bl = s2.equals("UIMA") || s2.equals("AMIU");
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                dis.reset();
            }
            catch (IOException e) {
                throw new UIMARuntimeException(e);
            }
        }
    }

    public static Header readHeader(DataInputStream dis) throws IOException {
        Reading r;
        Header h2 = new Header();
        byte[] bytebuf = new byte[]{dis.readByte(), dis.readByte(), dis.readByte(), dis.readByte()};
        h2.swap = bytebuf[0] != 85;
        h2.reading = r = new Reading(dis, h2.swap);
        int v = h2.v = r.readInt();
        h2.isDelta = (v & 2) != 0;
        h2.isCompressed = (v & 4) != 0;
        h2.typeSystemIndexDefIncluded = (v & 8) != 0;
        h2.typeSystemIncluded = (v & 0x10) != 0;
        h2.seqVersionNbr = (byte)((v & 0xFF00) >> 8);
        boolean bl = h2.isV3 = (v & 0x10000) != 0;
        if (h2.isCompressed) {
            v = r.readInt();
            h2.form4 = v == 0;
            h2.form6 = v == 1;
        }
        return h2;
    }

    public static DataOutputStream maybeWrapToDataOutputStream(OutputStream os) {
        if (os instanceof DataOutputStream) {
            return (DataOutputStream)os;
        }
        return new DataOutputStream(os);
    }

    public static DataInputStream maybeWrapToDataInputStream(InputStream os) {
        if (os instanceof DataInputStream) {
            return (DataInputStream)os;
        }
        return new DataInputStream(os);
    }

    public static class Reading {
        final DataInputStream dis;
        final boolean swap;

        Reading(DataInputStream dis, boolean swap) {
            this.dis = dis;
            this.swap = swap;
        }

        long readLong() throws IOException {
            long v = this.dis.readLong();
            return this.swap ? Long.reverseBytes(v) : v;
        }

        int readInt() throws IOException {
            int v = this.dis.readInt();
            return this.swap ? Integer.reverseBytes(v) : v;
        }

        short readShort() throws IOException {
            short v = this.dis.readShort();
            return this.swap ? Short.reverseBytes(v) : v;
        }
    }

    public static class Header {
        boolean isDelta;
        boolean isCompressed;
        boolean form4;
        boolean form6;
        boolean typeSystemIncluded;
        boolean typeSystemIndexDefIncluded;
        byte seqVersionNbr;
        boolean isV3;
        boolean swap;
        int v;
        Reading reading;

        public Header delta() {
            this.isDelta = true;
            return this;
        }

        public Header delta(boolean v2) {
            this.isDelta = v2;
            return this;
        }

        public Header form4() {
            this.form4 = true;
            this.isCompressed = true;
            this.form6 = false;
            return this;
        }

        public Header form6() {
            this.form6 = true;
            this.isCompressed = true;
            this.form4 = false;
            return this;
        }

        public Header typeSystemIncluded(boolean f) {
            this.typeSystemIncluded = f;
            return this;
        }

        public Header typeSystemIndexDefIncluded(boolean f) {
            this.typeSystemIndexDefIncluded = f;
            return this;
        }

        public Header seqVer(int v2) {
            assert (v2 >= 0 && v2 < 256);
            this.seqVersionNbr = (byte)v2;
            return this;
        }

        public Header v3() {
            this.isV3 = true;
            return this;
        }

        public void write(DataOutputStream dos) throws IOException {
            int n = this.v = !this.isCompressed && !this.isDelta ? 1 : 0;
            if (this.isDelta) {
                this.v |= 2;
            }
            if (this.isCompressed) {
                this.v |= 4;
            }
            if (this.typeSystemIndexDefIncluded) {
                this.v |= 8;
            }
            if (this.typeSystemIncluded) {
                this.v |= 0x10;
            }
            this.v |= this.seqVersionNbr << 8;
            if (this.isV3) {
                this.v |= 0x10000;
            }
            byte[] uima = new byte[]{85, 73, 77, 65};
            ByteBuffer buf = ByteBuffer.wrap(uima);
            int key = buf.asIntBuffer().get();
            dos.writeInt(key);
            dos.writeInt(this.v);
            if (this.isCompressed) {
                dos.writeInt(this.form6 ? 1 : 0);
            }
        }

        public boolean isDelta() {
            return this.isDelta;
        }

        public boolean isCompressed() {
            return this.isCompressed;
        }

        public boolean isForm4() {
            return this.form4;
        }

        public boolean isForm6() {
            return this.form6;
        }

        public boolean isTypeSystemIndexDefIncluded() {
            return this.typeSystemIndexDefIncluded;
        }

        public boolean isTypeSystemIncluded() {
            return this.typeSystemIncluded;
        }

        public byte getSeqVersionNbr() {
            return this.seqVersionNbr;
        }

        public boolean isV3() {
            return this.isV3;
        }
    }
}

