/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.Subiterator;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.internal.util.Int2IntArrayMapFixedSize;
import org.apache.uima.util.Misc;

public class FSIndexFlat<T extends FeatureStructure> {
    public static final boolean enabled = false;
    static final boolean trace = false;
    private static final boolean smalltrace = false;
    private static final boolean tune = Misc.getNoValueSystemProperty("uima.measure.flatten_index");
    private static final boolean debugTypeCodeUnstable = false;
    public static final int THRESHOLD_FOR_FLATTENING = 50;
    private static final int NUMBER_DISCARDED_RESETABLE_MAX = 100;
    private static final AtomicLong flattenTime = new AtomicLong(0L);
    private final FSIndexRepositoryImpl.IndexIteratorCachePair<T> iicp;
    private volatile SoftReference<T[]> fsa = new SoftReference<Object>(null);
    private final AtomicBoolean isLocked = new AtomicBoolean(false);
    private int iteratorReorderingCount = 0;
    final Int2IntArrayMapFixedSize indexUpdateCountsResetValues;
    private AtomicBoolean isInIteratedSortedIndexes = new AtomicBoolean(false);
    private static final AtomicInteger numberFlattened = new AtomicInteger(0);
    private static final AtomicInteger numberDiscardedDueToUpdates = new AtomicInteger(0);
    private volatile int numberDiscardedResetable = 0;
    private static final AtomicInteger numberFlatIterators = new AtomicInteger(0);
    volatile int casResetCount;
    final int casId;
    private final int debugTypeCode;
    private static final Thread dumpMeasurements;

    void incrementReorderingCount() {
        ++this.iteratorReorderingCount;
    }

    void incrementReorderingCount(int n) {
        this.iteratorReorderingCount += n;
    }

    public FSIndexFlat(FSIndexRepositoryImpl.IndexIteratorCachePair<T> iicp) {
        this.iicp = iicp;
        this.indexUpdateCountsResetValues = iicp.createIndexUpdateCountsAtReset();
        this.debugTypeCode = iicp.getFsLeafIndex().getTypeCode();
        this.casResetCount = iicp.getCASImpl().getCasResets();
        this.casId = iicp.getCASImpl().getCasId();
    }

    void flush() {
        this.fsa.clear();
        this.captureIndexUpdateCounts();
        this.isInIteratedSortedIndexes.set(false);
        this.numberDiscardedResetable = 0;
    }

    private String idInfo() {
        return String.format("Thread = %s, CasId = %d, CasReset = %d, newCasResetCount = %d", Thread.currentThread().getName(), this.casId, this.casResetCount, this.iicp.getCASImpl().getCasResets());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createFlattened() {
        if (this.isLocked.get()) {
            return false;
        }
        if (!this.isLocked.compareAndSet(false, true)) {
            return false;
        }
        try {
            long flattenStartTime = 0L;
            if (tune) {
                flattenStartTime = System.nanoTime();
            }
            if (this.fsa.get() != null) {
                boolean bl = true;
                return bl;
            }
            FeatureStructure[] localFsa = null;
            try {
                this.captureIndexUpdateCounts();
                int size = this.iicp.size();
                localFsa = new FeatureStructure[size];
                long startTime = 0L;
                this.iicp.fillFlatArray(localFsa);
            }
            catch (Exception e) {
                boolean bl = false;
                this.isLocked.set(false);
                return bl;
            }
            this.fsa = new SoftReference<FeatureStructure[]>(localFsa);
            if (tune) {
                numberFlattened.incrementAndGet();
            }
            if (this.isInIteratedSortedIndexes.compareAndSet(false, true)) {
                this.iicp.addToIteratedSortedIndexes();
            }
            this.iteratorReorderingCount = 0;
            if (tune) {
                flattenTime.addAndGet(System.nanoTime() - flattenStartTime);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.isLocked.set(false);
        }
    }

    String verifyFsaSubsumes(FeatureStructure[] localFsa) {
        boolean resetOK;
        boolean bl = resetOK = this.casResetCount == this.iicp.getCASImpl().getCasResets();
        if (!resetOK) {
            System.out.println(String.format("Detected cas reset while iterating in %s", this.idInfo()));
            return null;
        }
        int topCode = this.iicp.getFsLeafIndex().getTypeCode();
        String m3 = topCode != this.debugTypeCode || topCode != this.iicp.getFsLeafIndex().getTypeCode() ? String.format("TypeCodesWrong: iicp[0]: %d, original=%d, leafindex=%d%n", topCode, this.debugTypeCode, this.iicp.getFsLeafIndex().getTypeCode()) : "topCode still OK, was " + topCode;
        int i = 0;
        for (FeatureStructure fs : localFsa) {
            if (fs == null) {
                return "Found null fs in flat array";
            }
            int typecode = this.iicp.getCASImpl().getTypeCode(fs.hashCode());
            if (0 == typecode) {
                return "invalid typecode of 0 in fs in flat array, heap addr = " + fs.hashCode();
            }
            if (!this.iicp.subsumes(topCode, typecode)) {
                TypeSystemImpl tsi = this.iicp.getCASImpl().getTypeSystemImpl();
                return String.format("WrongFlatTypeCode on %d th element, Java class = %s, Top type for index is %s, Type of item is %s, %s%n%s%s", i, fs.getClass().getName(), tsi.ll_getTypeForCode(topCode).getName(), tsi.ll_getTypeForCode(typecode).getName(), this.idInfo(), m3, this.iicp.toString());
            }
            ++i;
        }
        return null;
    }

    void captureIndexUpdateCounts() {
        this.iteratorReorderingCount = 0;
        this.iicp.captureIndexUpdateCounts();
    }

    public FSIterator<T> iterator() {
        return this.iterator(null);
    }

    public FSIteratorFlat<T> iterator(FeatureStructure fs) {
        return null;
    }

    private FSIteratorFlat<T> tryFlatIterator(FeatureStructure fs) {
        FeatureStructure[] localFsa = (FeatureStructure[])this.fsa.get();
        if (localFsa != null) {
            if (this.iicp.isUpdateFreeSinceLastCounterReset()) {
                return this.iteratorCore(fs, localFsa);
            }
            this.discardFlattened();
            return null;
        }
        return null;
    }

    private void discardFlattened() {
        if (this.numberDiscardedResetable < 100) {
            ++this.numberDiscardedResetable;
        }
        if (tune) {
            numberDiscardedDueToUpdates.incrementAndGet();
        }
        this.fsa.clear();
        this.captureIndexUpdateCounts();
    }

    private FSIteratorFlat<T> iteratorCore(FeatureStructure fs, T[] localFsa) {
        FSIteratorFlat it = new FSIteratorFlat(this, localFsa);
        if (fs != null) {
            it.moveTo(fs);
        }
        return it;
    }

    boolean hasFlatIndex() {
        return false;
    }

    static {
        Thread thread2 = dumpMeasurements = tune ? new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println(String.format("Time to flatten was %,d microseconds", flattenTime.get() / 1000L));
                System.out.println(String.format("Flatten tuning, threshold: %d, creations: %,d uses: %d, discards: %d", 50, numberFlattened.get(), numberFlatIterators.get(), numberDiscardedDueToUpdates.get()));
            }
        }) : null;
        if (tune) {
            Runtime.getRuntime().addShutdownHook(dumpMeasurements);
        }
    }

    public static class FSIteratorFlat<TI extends FeatureStructure>
    extends FSIteratorImplBase<TI>
    implements LowLevelIterator {
        private final TI[] ifsa;
        private final FSIndexFlat<TI> fsIndexFlat;
        private final FSIndexRepositoryImpl.IndexIteratorCachePair<TI> iicp;
        private int pos;
        private final int iteratorCasResets;

        FSIteratorFlat(FSIndexFlat<TI> fsIndexFlat, TI[] fsa) {
            this.fsIndexFlat = fsIndexFlat;
            this.iicp = ((FSIndexFlat)fsIndexFlat).iicp;
            this.ifsa = fsa;
            this.iteratorCasResets = 0;
            if (tune) {
                numberFlatIterators.incrementAndGet();
            }
            this.moveToFirst();
        }

        public String toString() {
            return String.format("FlatIterator [size=%,d, type=%s, pos=%s, %s]", this.ifsa.length, this.iicp.getFsLeafIndex().getType().getName(), this.pos, this.idInfo());
        }

        @Override
        public TI next() {
            TI v = this.get();
            ++this.pos;
            return v;
        }

        @Override
        public boolean isValid() {
            return this.pos >= 0 && this.pos < this.ifsa.length;
        }

        @Override
        public TI get() throws NoSuchElementException {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            TI fs = this.ifsa[this.pos];
            int typeCode = ((FeatureStructureImpl)fs).getavoidcollisionTypeCode();
            if (this.iicp.isUpdateFreeSinceLastCounterReset(typeCode)) {
                return fs;
            }
            throw new ConcurrentModificationException();
        }

        @Override
        public void moveToNext() {
            if (this.isValid()) {
                ++this.pos;
            }
        }

        @Override
        public void moveToPrevious() {
            if (this.isValid()) {
                --this.pos;
            }
        }

        @Override
        public void moveToFirst() {
            this.pos = 0;
        }

        @Override
        public void moveToLast() {
            this.pos = this.ifsa.length - 1;
        }

        @Override
        public void moveTo(FeatureStructure fs) {
            this.moveToCommon(this.iicp.getFsLeafIndex(), fs);
        }

        @Override
        void moveTo(int begin, int end) {
            this.moveToCommon(Subiterator.getAnnotationBeginEndComparator(begin, end), null);
        }

        private void moveToCommon(Comparator<TI> comparator, TI fs) {
            block4: {
                block3: {
                    this.pos = Arrays.binarySearch(this.ifsa, fs, comparator);
                    if (this.pos < 0) {
                        this.pos = -this.pos - 1;
                        return;
                    }
                    if (!this.isValid()) {
                        return;
                    }
                    TI foundFs = this.get();
                    do {
                        this.moveToPrevious();
                        if (!this.isValid()) break block3;
                    } while (comparator.compare(this.get(), foundFs) == 0);
                    this.moveToNext();
                    break block4;
                }
                this.moveToFirst();
            }
        }

        @Override
        public FSIteratorFlat<TI> copy() {
            FSIteratorFlat it2 = new FSIteratorFlat(this.fsIndexFlat, this.ifsa);
            it2.pos = this.pos;
            return it2;
        }

        public boolean isUpdateFreeSinceLastCounterReset() {
            return false;
        }

        String verifyFsaSubsumes() {
            return this.fsIndexFlat.verifyFsaSubsumes((FeatureStructure[])this.ifsa);
        }

        String idInfo() {
            return String.format("local Iterator CasReset = %d, %s", this.iteratorCasResets, ((FSIndexFlat)this.fsIndexFlat).idInfo());
        }

        @Override
        public int ll_get() throws NoSuchElementException {
            return ((FeatureStructureImpl)this.get()).getAddress();
        }

        @Override
        public void moveTo(int fsRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ll_indexSize() {
            return this.ifsa.length;
        }

        @Override
        public LowLevelIndex ll_getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        int getBegin() {
            AnnotationFS fs = (AnnotationFS)this.ifsa[this.pos];
            return fs.getBegin();
        }

        @Override
        int getEnd() {
            AnnotationFS fs = (AnnotationFS)this.ifsa[this.pos];
            return fs.getEnd();
        }
    }
}

