/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SofaFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.FSIndexRepositoryMgr;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.admin.LinearTypeOrderBuilder;
import org.apache.uima.cas.impl.AnnotationBaseImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSBagIndex;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexFlat;
import org.apache.uima.cas.impl.FSIndexImpl;
import org.apache.uima.cas.impl.FSIntArrayIndex;
import org.apache.uima.cas.impl.FSIntIteratorImplBase;
import org.apache.uima.cas.impl.FSIteratorAggregate;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.impl.FSIteratorWrapper;
import org.apache.uima.cas.impl.FSLeafIndexImpl;
import org.apache.uima.cas.impl.FSRBTSetIndex;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LLUnambiguousIteratorImpl;
import org.apache.uima.cas.impl.LinearTypeOrderBuilderImpl;
import org.apache.uima.cas.impl.LowLevelException;
import org.apache.uima.cas.impl.LowLevelIndex;
import org.apache.uima.cas.impl.LowLevelIndexRepository;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.cas.impl.LowLevelIteratorAggregate;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.Int2IntArrayMapFixedSize;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.util.Misc;

public class FSIndexRepositoryImpl
implements FSIndexRepositoryMgr,
LowLevelIndexRepository {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_INDEX_SIZE = 16;
    public static final String ALLOW_DUP_ADD_TO_INDEXES = "uima.allow_duplicate_add_to_indexes";
    public static final boolean IS_ALLOW_DUP_ADD_2_INDEXES = Misc.getNoValueSystemProperty("uima.allow_duplicate_add_to_indexes");
    public static final String DISABLE_ENHANCED_WRONG_INDEX = "uima.disable_enhanced_check_wrong_add_to_index";
    private static final boolean IS_DISABLE_ENHANCED_WRONG_INDEX_CHECK = Misc.getNoValueSystemProperty("uima.disable_enhanced_check_wrong_add_to_index");
    private static final FSIterator emptyFSIterator = new FSIteratorImplBase<FeatureStructure>(){

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public FeatureStructure get() throws NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public void moveToNext() {
        }

        @Override
        public void moveToPrevious() {
        }

        @Override
        public void moveToFirst() {
        }

        @Override
        public void moveToLast() {
        }

        @Override
        public void moveTo(FeatureStructure fs) {
        }

        @Override
        public FSIterator<FeatureStructure> copy() {
            return this;
        }

        @Override
        <TT extends AnnotationFS> void moveTo(int begin, int end) {
        }
    };
    private static final LowLevelIterator emptyLlIterator = new FSIntIteratorImplBase<FeatureStructure>(null, null){

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public int get() {
            throw new NoSuchElementException();
        }

        @Override
        public void moveTo(int i) {
        }

        @Override
        public void moveToFirst() {
        }

        @Override
        public void moveToLast() {
        }

        @Override
        public Object copy() {
            return this;
        }

        @Override
        public void moveToNext() {
        }

        @Override
        public void moveToPrevious() {
        }

        @Override
        public int ll_indexSize() {
            return 0;
        }
    };
    private final CASImpl cas;
    private boolean locked = false;
    private final ArrayList<IndexIteratorCachePair<? extends FeatureStructure>>[] indexArray;
    final int[] detectIllegalIndexUpdates;
    private final HashMap<String, IndexIteratorCachePair<? extends FeatureStructure>> name2indexMap;
    private final IntVector indexUpdates;
    private final BitSet indexUpdateOperation;
    private boolean logProcessed;
    private final IntVector usedIndexes;
    private final boolean[] isUsed;
    private final List<IndexIteratorCachePair<? extends FeatureStructure>> iteratedSortedIndexes = Collections.synchronizedList(new ArrayList());
    private final SharedIndexInfo sii;
    private ProcessedIndexInfo mPii;

    IntPointerIterator createPointerIterator(IndexIteratorCachePair<? extends FeatureStructure> iicp) {
        return this.createPointerIterator(iicp, false);
    }

    <T extends FeatureStructure> IntPointerIterator createPointerIterator(IndexIteratorCachePair<? extends FeatureStructure> iicp, boolean is_unordered) {
        ((IndexIteratorCachePair)iicp).createIndexIteratorCache();
        if (((IndexIteratorCachePair)iicp).cachedSubFsLeafIndexes.size() > 1) {
            int strat = ((IndexIteratorCachePair)iicp).fsLeafIndex.getIndexingStrategy();
            if (strat == 2 || strat == 1 || is_unordered) {
                return new PointerIteratorUnordered(iicp);
            }
            return new PointerIterator(iicp);
        }
        return this.createLeafPointerIterator(iicp);
    }

    <T extends FeatureStructure> IntPointerIterator createPointerIterator(IndexIteratorCachePair<? extends FeatureStructure> iicp, int fs) {
        return this.createPointerIterator(iicp, false, fs);
    }

    <T extends FeatureStructure> IntPointerIterator createPointerIterator(IndexIteratorCachePair<? extends FeatureStructure> iicp, boolean is_unordered, int fs) {
        IntPointerIterator it = this.createPointerIterator(iicp, is_unordered);
        it.moveTo(fs);
        return it;
    }

    private <T extends FeatureStructure> IntPointerIterator createLeafPointerIterator(IndexIteratorCachePair<? extends FeatureStructure> iicp) {
        FSLeafIndexImpl leafIndex = ((IndexIteratorCachePair)iicp).fsLeafIndex;
        return leafIndex.pointerIterator(leafIndex, this.detectIllegalIndexUpdates, leafIndex.getTypeCode());
    }

    <T extends FeatureStructure> ArrayList<IndexIteratorCachePair<T>> getIndexesForType(int typeCode) {
        return this.indexArray[typeCode];
    }

    private FSIndexRepositoryImpl() {
        this.cas = null;
        this.sii = null;
        this.name2indexMap = null;
        this.indexArray = null;
        this.detectIllegalIndexUpdates = null;
        this.indexUpdates = null;
        this.indexUpdateOperation = null;
        this.usedIndexes = null;
        this.isUsed = null;
    }

    FSIndexRepositoryImpl(CASImpl cas) {
        this.cas = cas;
        this.sii = new SharedIndexInfo(cas.getTypeSystemImpl());
        TypeSystemImpl ts = this.sii.tsi;
        int numTypes = ts.getNumberOfTypes() + 1;
        this.detectIllegalIndexUpdates = new int[numTypes];
        this.name2indexMap = new HashMap();
        this.indexUpdates = new IntVector();
        this.indexUpdateOperation = new BitSet();
        this.logProcessed = false;
        this.indexArray = new ArrayList[this.sii.tsi.getNumberOfTypes() + 1];
        this.usedIndexes = new IntVector();
        this.isUsed = new boolean[numTypes];
        this.init();
    }

    FSIndexRepositoryImpl(CASImpl cas, FSIndexRepositoryImpl baseIndexRepo) {
        this.cas = cas;
        this.sii = baseIndexRepo.sii;
        this.sii.isSetUpFromBaseCAS = true;
        TypeSystemImpl ts = this.sii.tsi;
        int numTypes = ts.getNumberOfTypes() + 1;
        this.detectIllegalIndexUpdates = new int[numTypes];
        this.name2indexMap = new HashMap();
        this.indexUpdates = new IntVector();
        this.indexUpdateOperation = new BitSet();
        this.logProcessed = false;
        this.indexArray = new ArrayList[numTypes];
        this.usedIndexes = new IntVector();
        this.isUsed = new boolean[numTypes];
        this.init();
        Set<String> keys2 = baseIndexRepo.name2indexMap.keySet();
        if (!keys2.isEmpty()) {
            for (String key : keys2) {
                IndexIteratorCachePair<? extends FeatureStructure> iicp = baseIndexRepo.name2indexMap.get(key);
                this.createIndexNoQuestionsAsked(((IndexIteratorCachePair)iicp).fsLeafIndex.getComparator(), key, ((IndexIteratorCachePair)iicp).fsLeafIndex.getIndexingStrategy());
            }
        }
    }

    private void init() {
        TypeSystemImpl ts = this.sii.tsi;
        int numTypes = ts.getNumberOfTypes() + 1;
        for (int i = 1; i < numTypes; ++i) {
            this.indexArray[i] = new ArrayList();
        }
        this.resetDetectIllegalIndexUpdates();
        this.mPii = new ProcessedIndexInfo();
    }

    private void resetDetectIllegalIndexUpdates() {
        for (int i = 0; i < this.detectIllegalIndexUpdates.length; ++i) {
            this.detectIllegalIndexUpdates[i] = Integer.MIN_VALUE;
        }
    }

    public void flush() {
        if (!this.locked) {
            return;
        }
        if (this.usedIndexes.size() == 0) {
            return;
        }
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            this.isUsed[this.usedIndexes.get((int)i)] = false;
            ArrayList<IndexIteratorCachePair<? extends FeatureStructure>> v = this.indexArray[this.usedIndexes.get(i)];
            int max = v.size();
            for (int j = 0; j < max; ++j) {
                IndexIteratorCachePair<? extends FeatureStructure> iicp = v.get(j);
                ((IndexIteratorCachePair)iicp).fsLeafIndex.flush();
            }
        }
        this.clearIteratedSortedIndexes();
        this.indexUpdates.removeAllElements();
        this.indexUpdateOperation.clear();
        this.mPii = new ProcessedIndexInfo();
        this.logProcessed = false;
        this.usedIndexes.removeAllElements();
    }

    private void clearIteratedSortedIndexes() {
        int sz = this.iteratedSortedIndexes.size();
        for (IndexIteratorCachePair<? extends FeatureStructure> iicp : this.iteratedSortedIndexes) {
            ((IndexIteratorCachePair)iicp).flatIndex.flush();
        }
        if (this.iteratedSortedIndexes.size() != sz) {
            throw new RuntimeException("Index Flush flatIndex, size not the same, before = " + sz + ", after = " + this.iteratedSortedIndexes.size());
        }
        this.iteratedSortedIndexes.clear();
    }

    public void addFS(int fsRef) {
        this.ll_addFS(fsRef);
    }

    private IndexIteratorCachePair<? extends FeatureStructure> addNewIndex(FSIndexComparator comparator, int indexType) {
        return this.addNewIndex(comparator, 16, indexType);
    }

    private <T extends FeatureStructure> IndexIteratorCachePair<T> addNewIndex(FSIndexComparator comparator, int initialSize, int indexType) {
        FSLeafIndexImpl<T> fsLeafIndex = this.addNewIndexCore(comparator, initialSize, indexType);
        IndexIteratorCachePair iicp = new IndexIteratorCachePair(fsLeafIndex);
        Type type = comparator.getType();
        int typeCode = ((TypeImpl)type).getCode();
        if (indexType == 0) {
            this.indexArray[typeCode].add(0, iicp);
        } else {
            this.indexArray[typeCode].add(iicp);
        }
        return iicp;
    }

    private <T extends FeatureStructure> FSLeafIndexImpl<T> addNewIndexCore(FSIndexComparator comparator, int initialSize, int indexType) {
        FSLeafIndexImpl ind;
        Type type = comparator.getType();
        switch (indexType) {
            case 1: {
                ind = new FSRBTSetIndex(this.cas, type, indexType);
                break;
            }
            case 2: 
            case 3: {
                ind = new FSBagIndex(this.cas, type, initialSize, indexType);
                break;
            }
            default: {
                ind = new FSIntArrayIndex(this.cas, type, initialSize, 0, this.isAnnotationIndex(type, comparator));
            }
        }
        ind.init(comparator);
        return ind;
    }

    private boolean isAnnotationIndex(Type type, FSIndexComparator comp) {
        TypeSystemImpl tsi = this.cas.getTypeSystemImpl();
        return type == tsi.annotType && comp.getNumberOfKeys() == 3 && comp.getKeyType(0) == 0 && comp.getKeyType(1) == 0 && comp.getKeyType(2) == 1 && comp.getKeyComparator(0) == 0 && comp.getKeyComparator(1) == 1 && comp.getKeyComparator(2) == 0 && comp.getKeyFeature(0) == tsi.startFeat && comp.getKeyFeature(1) == tsi.endFeat;
    }

    private IndexIteratorCachePair<? extends FeatureStructure> addNewIndexRecursive(FSIndexComparator comparator, int indexType) {
        FSIndexComparatorImpl compCopy = ((FSIndexComparatorImpl)comparator).copy();
        return this.addNewIndexRec(compCopy, indexType);
    }

    private static final <T extends FeatureStructure> int findIndex(ArrayList<IndexIteratorCachePair<T>> indexes, FSIndexComparator comp, int indexType) {
        int max = indexes.size();
        for (int i = 0; i < max; ++i) {
            FSIndexComparator indexComp;
            FSLeafIndexImpl index = ((IndexIteratorCachePair)indexes.get(i)).fsLeafIndex;
            if (index.getIndexingStrategy() != indexType || !comp.equals(indexComp = index.getComparator())) continue;
            return i;
        }
        return -1;
    }

    private IndexIteratorCachePair<? extends FeatureStructure> addNewIndexRec(FSIndexComparator comparator, int indexType) {
        IndexIteratorCachePair<? extends FeatureStructure> iicp = this.addNewIndex(comparator, indexType);
        if (indexType == 3) {
            return iicp;
        }
        Type superType = comparator.getType();
        Vector<Type> types = this.sii.tsi.getDirectlySubsumedTypes(superType);
        int max = types.size();
        for (int i = 0; i < max; ++i) {
            FSIndexComparatorImpl compCopy = ((FSIndexComparatorImpl)comparator).copy();
            compCopy.setType(types.get(i));
            this.addNewIndexRec(compCopy, indexType);
        }
        return iicp;
    }

    private static final ArrayList<Type> getAllSubsumedTypes(Type t, TypeSystem ts) {
        ArrayList<Type> v = new ArrayList<Type>();
        FSIndexRepositoryImpl.addAllSubsumedTypes(t, ts, v);
        return v;
    }

    private static final void addAllSubsumedTypes(Type t, TypeSystem ts, ArrayList<Type> v) {
        v.add(t);
        Iterator<Type> it = ((TypeSystemImpl)ts).getDirectSubtypesIterator(t);
        while (it.hasNext()) {
            FSIndexRepositoryImpl.addAllSubsumedTypes(it.next(), ts, v);
        }
    }

    @Override
    public void commit() {
        this.getDefaultTypeOrder();
        this.locked = true;
    }

    @Override
    public LinearTypeOrder getDefaultTypeOrder() {
        if (this.sii.defaultTypeOrder == null) {
            if (this.sii.defaultOrderBuilder == null) {
                this.sii.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.sii.tsi);
            }
            try {
                this.sii.defaultTypeOrder = this.sii.defaultOrderBuilder.getOrder();
            }
            catch (CASException cASException) {
                // empty catch block
            }
        }
        return this.sii.defaultTypeOrder;
    }

    @Override
    public LinearTypeOrderBuilder getDefaultOrderBuilder() {
        if (this.sii.defaultOrderBuilder == null) {
            this.sii.defaultOrderBuilder = new LinearTypeOrderBuilderImpl(this.sii.tsi);
        }
        return this.sii.defaultOrderBuilder;
    }

    void setDefaultTypeOrder(LinearTypeOrder order) {
        this.sii.defaultTypeOrder = order;
    }

    @Override
    public boolean createIndex(FSIndexComparator comp, String label, int indexType) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException(0);
        }
        return this.createIndexNoQuestionsAsked(comp, label, indexType);
    }

    public boolean createIndexNoQuestionsAsked(FSIndexComparator comp, String label, int indexType) {
        IndexIteratorCachePair<? extends FeatureStructure> cp = this.name2indexMap.get(label);
        if (cp == null) {
            cp = this.addNewIndexRecursive(comp, indexType);
            if (!this.sii.isSetUpFromBaseCAS) {
                int nKeys = comp.getNumberOfKeys();
                for (int i = 0; i < nKeys; ++i) {
                    if (comp.getKeyType(i) != 0) continue;
                    int featCode = ((FeatureImpl)comp.getKeyFeature(i)).getCode();
                    this.cas.featureCodesInIndexKeysAdd(featCode);
                }
            }
            this.name2indexMap.put(label, cp);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<FSIndex<FeatureStructure>> getIndexes() {
        ArrayList indexList = new ArrayList();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            indexList.add(this.getIndex(label));
        }
        return indexList.iterator();
    }

    @Override
    public Iterator<LowLevelIndex> ll_getIndexes() {
        ArrayList<LowLevelIndex> indexList = new ArrayList<LowLevelIndex>();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            indexList.add(this.ll_getIndex(label));
        }
        return indexList.iterator();
    }

    @Override
    public Iterator<String> getLabels() {
        return this.name2indexMap.keySet().iterator();
    }

    public Iterator<String> getLabels(FSIndexComparator comp) {
        ArrayList<String> labels = new ArrayList<String>();
        Iterator<String> it = this.getLabels();
        while (it.hasNext()) {
            String label = it.next();
            if (!((IndexIteratorCachePair)this.name2indexMap.get(label)).fsLeafIndex.getComparator().equals(comp)) continue;
            labels.add(label);
        }
        return labels.iterator();
    }

    @Override
    public <T extends FeatureStructure> FSIndex<T> getIndex(String label, Type type) {
        Type componentType;
        IndexIteratorCachePair<? extends FeatureStructure> iicp = this.name2indexMap.get(label);
        if (iicp == null) {
            return null;
        }
        if (type.isArray() && (componentType = type.getComponentType()) != null && !componentType.isPrimitive() && !componentType.getName().equals("uima.cas.TOP")) {
            return null;
        }
        Type indexType = ((IndexIteratorCachePair)iicp).fsLeafIndex.getType();
        if (!this.sii.tsi.subsumes(indexType, type)) {
            CASRuntimeException cre = new CASRuntimeException("TYPE_NOT_IN_INDEX", new String[]{label, type.getName(), indexType.getName()});
            throw cre;
        }
        int typeCode = ((TypeImpl)type).getCode();
        ArrayList<IndexIteratorCachePair<T>> inds = this.getIndexesForType(typeCode);
        int indexCode = FSIndexRepositoryImpl.findIndex(inds, ((IndexIteratorCachePair)iicp).fsLeafIndex.getComparator(), ((IndexIteratorCachePair)iicp).fsLeafIndex.getIndexingStrategy());
        if (indexCode < 0) {
            return null;
        }
        return new IndexImpl((IndexIteratorCachePair)inds.get(indexCode));
    }

    @Override
    public <T extends FeatureStructure> FSIndex<T> getIndex(String label) {
        IndexIteratorCachePair<? extends FeatureStructure> iicp = this.name2indexMap.get(label);
        if (iicp == null) {
            return null;
        }
        return new IndexImpl((IndexIteratorCachePair)iicp);
    }

    public IntPointerIterator getIntIteratorForIndex(String label) {
        IndexImpl index = (IndexImpl)this.getIndex(label);
        if (index == null) {
            return null;
        }
        return this.createPointerIterator(index.iicp);
    }

    public IntPointerIterator getIntIteratorForIndex(String label, Type type) {
        IndexImpl index = (IndexImpl)this.getIndex(label, type);
        if (index == null) {
            return null;
        }
        return this.createPointerIterator(index.iicp);
    }

    public int getIndexSize(Type type) {
        int typeCode = ((TypeImpl)type).getCode();
        ArrayList<IndexIteratorCachePair<? extends FeatureStructure>> indexVector = this.indexArray[typeCode];
        if (indexVector.size() == 0) {
            return 0;
        }
        int numFSs = ((IndexIteratorCachePair)indexVector.get(0)).fsLeafIndex.size();
        Vector<Type> typeVector = this.sii.tsi.getDirectlySubsumedTypes(type);
        int max = typeVector.size();
        for (int i = 0; i < max; ++i) {
            numFSs += this.getIndexSize(typeVector.get(i));
        }
        return numFSs;
    }

    @Override
    public void removeAllExcludingSubtypes(Type type) {
        int typeCode = ((TypeImpl)type).getCode();
        this.incrementIllegalIndexUpdateDetector(typeCode);
        ArrayList<IndexIteratorCachePair<? extends FeatureStructure>> allIndexesForType = this.indexArray[typeCode];
        for (IndexIteratorCachePair<? extends FeatureStructure> iicp : allIndexesForType) {
            ((IndexIteratorCachePair)iicp).fsLeafIndex.flush();
        }
    }

    @Override
    public void removeAllIncludingSubtypes(Type type) {
        this.removeAllExcludingSubtypes(type);
        List<Type> subtypes = this.sii.tsi.getDirectSubtypes(type);
        for (Type subtype : subtypes) {
            this.removeAllIncludingSubtypes(subtype);
        }
    }

    @Override
    public FSIndexComparator createComparator() {
        return new FSIndexComparatorImpl(this.cas);
    }

    @Override
    public boolean isCommitted() {
        return this.locked;
    }

    @Override
    public boolean createIndex(FSIndexComparator comp, String label) throws CASAdminException {
        return this.createIndex(comp, label, 0);
    }

    public int[] getIndexedFSs() {
        IntVector v = new IntVector();
        IntVector indexedFSs = new IntVector();
        for (int i = 0; i < this.usedIndexes.size(); ++i) {
            ArrayList<IndexIteratorCachePair<? extends FeatureStructure>> iv = this.indexArray[this.usedIndexes.get(i)];
            int jMax = iv.size();
            IndexIteratorCachePair<? extends FeatureStructure> anIndex = null;
            for (int j = 0; j < jMax; ++j) {
                IndexIteratorCachePair<? extends FeatureStructure> iicp = iv.get(j);
                int indStrat = ((IndexIteratorCachePair)iicp).fsLeafIndex.getIndexingStrategy();
                if (indStrat == 1) continue;
                anIndex = iicp;
                break;
            }
            assert (anIndex != null);
            if (IS_ALLOW_DUP_ADD_2_INDEXES) {
                indexedFSs.removeAllElements();
                IntPointerIterator it = ((IndexIteratorCachePair)anIndex).fsLeafIndex.refIterator();
                while (it.isValid()) {
                    indexedFSs.add(it.get());
                    it.inc();
                }
                indexedFSs.sortDedup();
                v.add(indexedFSs.getArray(), 0, indexedFSs.size());
                continue;
            }
            ((IndexIteratorCachePair)anIndex).fsLeafIndex.bulkAddTo(v);
        }
        return v.toArray();
    }

    @Override
    public void addFS(FeatureStructure fs) {
        this.addFS(((FeatureStructureImpl)fs).getAddress());
    }

    private void incrementIllegalIndexUpdateDetector(int typeCode) {
        int n = typeCode;
        this.detectIllegalIndexUpdates[n] = this.detectIllegalIndexUpdates[n] + 1;
    }

    @Override
    public void removeFS(FeatureStructure fs) {
        this.ll_removeFS(this.cas.ll_getFSRef(fs));
    }

    public void removeFS(int fsRef) {
        this.ll_removeFS(fsRef);
    }

    @Override
    public LinearTypeOrderBuilder createTypeSortOrder() {
        LinearTypeOrderBuilderImpl orderBuilder = new LinearTypeOrderBuilderImpl(this.sii.tsi);
        if (this.sii.defaultOrderBuilder == null) {
            this.sii.defaultOrderBuilder = orderBuilder;
        }
        return orderBuilder;
    }

    @Override
    public LowLevelIndex ll_getIndex(String indexName) {
        return (LowLevelIndex)((Object)this.getIndex(indexName));
    }

    @Override
    public LowLevelIndex ll_getIndex(String indexName, int typeCode) {
        if (!this.sii.tsi.isType(typeCode) || !this.cas.ll_isRefType(typeCode)) {
            LowLevelException e = new LowLevelException(10);
            e.addArgument(Integer.toString(typeCode));
            throw e;
        }
        return (LowLevelIndex)((Object)this.getIndex(indexName, this.sii.tsi.ll_getTypeForCode(typeCode)));
    }

    @Override
    public final void ll_addFS(int fsRef, boolean doChecks) {
        if (doChecks) {
            this.cas.checkFsRef(fsRef);
            this.cas.ll_isRefType(this.cas.ll_getFSRefType(fsRef));
        }
        this.ll_addFS(fsRef);
    }

    @Override
    public void ll_addFS(int fsRef) {
        this.ll_addFS_common(fsRef, false, 1);
    }

    public void ll_addback(int fsRef, int count) {
        this.ll_addFS_common(fsRef, true, count);
    }

    private void ll_addFS_common(int fsRef, boolean isAddback, int count) {
        this.cas.maybeClearCacheNotInIndex(fsRef);
        int typeCode = this.cas.getTypeCode(fsRef);
        if (!isAddback && !IS_DISABLE_ENHANCED_WRONG_INDEX_CHECK && this.sii.tsi.isAnnotationBaseOrSubtype(typeCode)) {
            int sofaAddr = this.cas.getSofaFeat(fsRef);
            if (sofaAddr == 0) {
                throw new CASRuntimeException("SOFAREF_NOT_SET", new String[]{((FeatureStructureImpl)this.cas.ll_getFSForRef(fsRef)).toString()});
            }
            if (!this.cas.isSofaView(sofaAddr)) {
                AnnotationBaseImpl fs_abi = new AnnotationBaseImpl(fsRef, this.cas);
                SofaFS annotSofaFS = this.cas.getSofa(sofaAddr);
                SofaFS viewSofaFS = this.cas.getSofa(this.cas.getSofaRef());
                CASRuntimeException e = new CASRuntimeException("ANNOTATION_IN_WRONG_INDEX", new String[]{fs_abi.toString(), annotSofaFS.getSofaID(), viewSofaFS.getSofaID()});
                throw e;
            }
        }
        this.incrementIllegalIndexUpdateDetector(typeCode);
        ArrayList<IndexIteratorCachePair<? extends FeatureStructure>> indexes = this.indexArray[typeCode];
        boolean noIndexOrOnlySetindexes = true;
        for (IndexIteratorCachePair<? extends FeatureStructure> iicp : indexes) {
            int indexingStrategy = ((IndexIteratorCachePair)iicp).fsLeafIndex.getIndexingStrategy();
            if (isAddback) {
                if (indexingStrategy == 2) continue;
                ((IndexIteratorCachePair)iicp).fsLeafIndex.insert(fsRef, count);
            } else {
                ((IndexIteratorCachePair)iicp).fsLeafIndex.insert(fsRef);
            }
            if (!noIndexOrOnlySetindexes) continue;
            noIndexOrOnlySetindexes = indexingStrategy == 1;
        }
        if (this.cas.getCurrentMark() != null) {
            this.logIndexOperation(fsRef, true);
        }
        if (isAddback) {
            return;
        }
        if (noIndexOrOnlySetindexes) {
            Type type = this.sii.tsi.ll_getTypeForCode(typeCode);
            String defIndexName = FSIndexRepositoryImpl.getAutoIndexNameForType(type);
            FSIndexComparator comparator = this.createComparator();
            comparator.setType(type);
            this.createIndexNoQuestionsAsked(comparator, defIndexName, 3);
            ((IndexIteratorCachePair)indexes.get(indexes.size() - 1)).fsLeafIndex.insert(fsRef);
        }
        if (!this.isUsed[typeCode]) {
            this.isUsed[typeCode] = true;
            this.usedIndexes.add(typeCode);
        }
    }

    private static final String getAutoIndexNameForType(Type type) {
        return "_" + type.getName() + "_GeneratedIndex";
    }

    boolean ll_removeFS_ret(int fsRef) {
        int typeCode = this.cas.ll_getFSRefType(fsRef);
        this.incrementIllegalIndexUpdateDetector(typeCode);
        ArrayList<IndexIteratorCachePair<? extends FeatureStructure>> idxList = this.indexArray[typeCode];
        int max = idxList.size();
        boolean atLeastOneRemoved = false;
        for (int i = 0; i < max; ++i) {
            atLeastOneRemoved |= ((IndexIteratorCachePair)idxList.get(i)).fsLeafIndex.remove(fsRef);
        }
        if (atLeastOneRemoved && this.cas.getCurrentMark() != null) {
            this.logIndexOperation(fsRef, false);
        }
        return atLeastOneRemoved;
    }

    int ll_removeFS_all_ret(int fsRef) {
        boolean wasRemoved;
        int countOfRemoved = 0;
        do {
            if (!(wasRemoved = this.ll_removeFS_ret(fsRef))) continue;
            ++countOfRemoved;
        } while (wasRemoved);
        return countOfRemoved;
    }

    @Override
    public void ll_removeFS(int fsRef) {
        this.ll_removeFS_ret(fsRef);
    }

    public LowLevelIterator ll_getAllIndexedFS(Type type) {
        ArrayList<LowLevelIterator> iteratorList = new ArrayList<LowLevelIterator>();
        this.ll_getAllIndexedFS(type, iteratorList);
        return iteratorList.size() == 0 ? emptyLlIterator : (iteratorList.size() == 1 ? (LowLevelIterator)iteratorList.get(0) : new LowLevelIteratorAggregate(iteratorList));
    }

    private final void ll_getAllIndexedFS(Type type, List<LowLevelIterator> iteratorList) {
        ArrayList iicps = this.getIndexesForType(((TypeImpl)type).getCode());
        IndexIteratorCachePair iicpSorted = null;
        IndexIteratorCachePair iicpBag = null;
        IndexIteratorCachePair iicpDefaultBag = null;
        for (IndexIteratorCachePair iicp : iicps) {
            int indexKind = iicp.fsLeafIndex.getIndexingStrategy();
            if (indexKind == 0) {
                FSIndexFlat.FSIteratorFlat flatIterator;
                if (iicp.hasFlatIndex() && (flatIterator = (FSIndexFlat.FSIteratorFlat)iicp.flatIndex.iterator()) != null) {
                    iteratorList.add(flatIterator);
                    return;
                }
                iicpSorted = iicp;
                continue;
            }
            if (null != iicpSorted) break;
            if (indexKind == 2) {
                iicpBag = iicp;
                break;
            }
            if (indexKind != 3) continue;
            iicpDefaultBag = iicp;
            break;
        }
        if (null != iicpSorted) {
            if (iicpSorted.has1OrMoreEntries()) {
                iteratorList.add(new IndexImpl(iicpSorted, IteratorExtraFunction.UNORDERED).ll_iterator());
            }
            return;
        }
        if (null != iicpBag) {
            if (iicpBag.has1OrMoreEntries()) {
                iteratorList.add(new IndexImpl(iicpBag).ll_iterator());
            }
            return;
        }
        if (iicpDefaultBag != null) {
            iteratorList.add(new IndexImpl(iicpDefaultBag).ll_iterator());
            this.ll_addDirectSubtypes(type, iteratorList);
            return;
        }
        this.ll_addDirectSubtypes(type, iteratorList);
    }

    @Override
    public <T extends FeatureStructure> FSIterator<T> getAllIndexedFS(Type type) {
        ArrayList<FSIteratorImplBase<T>> iteratorList = new ArrayList<FSIteratorImplBase<T>>();
        this.getAllIndexedFS(type, iteratorList);
        return iteratorList.size() == 0 ? emptyFSIterator : (iteratorList.size() == 1 ? (FSIteratorImplBase)iteratorList.get(0) : new FSIteratorAggregate<T>(iteratorList));
    }

    private final <T extends FeatureStructure> void getAllIndexedFS(Type type, List<FSIteratorImplBase<T>> iteratorList) {
        ArrayList<IndexIteratorCachePair<T>> iicps = this.getIndexesForType(((TypeImpl)type).getCode());
        IndexIteratorCachePair<T> iicpSorted = null;
        IndexIteratorCachePair<T> iicpBag = null;
        IndexIteratorCachePair<T> iicpDefaultBag = null;
        for (IndexIteratorCachePair<T> iicp : iicps) {
            int indexKind = ((IndexIteratorCachePair)iicp).fsLeafIndex.getIndexingStrategy();
            if (indexKind == 0) {
                FSIterator flatIterator;
                if (((IndexIteratorCachePair)iicp).hasFlatIndex() && (flatIterator = ((IndexIteratorCachePair)iicp).flatIndex.iterator()) != null) {
                    iteratorList.add((FSIteratorImplBase)flatIterator);
                    return;
                }
                iicpSorted = iicp;
                continue;
            }
            if (null != iicpSorted) break;
            if (indexKind == 2) {
                iicpBag = iicp;
                break;
            }
            if (indexKind != 3) continue;
            iicpDefaultBag = iicp;
            break;
        }
        if (null != iicpSorted) {
            if (iicpSorted.has1OrMoreEntries()) {
                iteratorList.add((FSIteratorImplBase)new IndexImpl(iicpSorted, IteratorExtraFunction.UNORDERED).iterator());
                FSIndexFlat flatindex = ((IndexIteratorCachePair)iicpSorted).flatIndex;
                if (flatindex != null) {
                    int iicpsize = iicpSorted.guessedSize();
                    flatindex.incrementReorderingCount(iicpsize);
                }
            }
            return;
        }
        if (null != iicpBag) {
            if (iicpBag.has1OrMoreEntries()) {
                iteratorList.add((FSIteratorImplBase)new IndexImpl((IndexIteratorCachePair)iicpBag).iterator());
            }
            return;
        }
        if (iicpDefaultBag != null) {
            iteratorList.add((FSIteratorImplBase)new IndexImpl((IndexIteratorCachePair)iicpDefaultBag).iterator());
            this.addDirectSubtypes(type, iteratorList);
            return;
        }
        this.addDirectSubtypes(type, iteratorList);
    }

    private <T extends FeatureStructure> void addDirectSubtypes(Type type, List<FSIteratorImplBase<T>> iteratorList) {
        Iterator<Type> typeIterator = this.sii.tsi.getDirectSubtypesIterator(type);
        while (typeIterator.hasNext()) {
            this.getAllIndexedFS(typeIterator.next(), iteratorList);
        }
    }

    private void ll_addDirectSubtypes(Type type, List<LowLevelIterator> iteratorList) {
        Iterator<Type> typeIterator = this.sii.tsi.getDirectSubtypesIterator(type);
        while (typeIterator.hasNext()) {
            Type nextType = typeIterator.next();
            this.ll_getAllIndexedFS(nextType, iteratorList);
        }
    }

    public boolean isInSetOrSortedIndexInThisView(int fsAddr) {
        int typeCode = this.cas.getTypeCode(fsAddr);
        if (this.sii.tsi.isAnnotationOrSubtype(typeCode)) {
            return this.getAnnotationIndexNoSubtypes(typeCode).ll_containsEq(fsAddr);
        }
        ArrayList<IndexIteratorCachePair<? extends FeatureStructure>> indexesForType = this.indexArray[typeCode];
        FSBagIndex index_bag = null;
        boolean found_in_bag = false;
        ArrayList<FSRBTSetIndex> setindexes = null;
        for (IndexIteratorCachePair<? extends FeatureStructure> iicp : indexesForType) {
            FSLeafIndexImpl index_for_this_typeCode = ((IndexIteratorCachePair)iicp).fsLeafIndex;
            int kind = index_for_this_typeCode.getIndexingStrategy();
            if (kind == 0) {
                return ((FSIntArrayIndex)index_for_this_typeCode).ll_containsEq(fsAddr);
            }
            if (kind == 2 && !found_in_bag) {
                if (FSBagIndex.USE_POSITIVE_INT_SET) {
                    found_in_bag = ((FSBagIndex)index_for_this_typeCode).ll_contains(fsAddr);
                    if (found_in_bag) continue;
                    return false;
                }
                index_bag = (FSBagIndex)index_for_this_typeCode;
                continue;
            }
            if (setindexes == null) {
                setindexes = new ArrayList<FSRBTSetIndex>();
            }
            setindexes.add((FSRBTSetIndex)index_for_this_typeCode);
        }
        if (setindexes == null) {
            return false;
        }
        if (setindexes.size() == 1) {
            return ((FSRBTSetIndex)setindexes.get(0)).ll_contains(fsAddr);
        }
        if (found_in_bag) {
            return true;
        }
        if (index_bag != null) {
            return index_bag.ll_contains(fsAddr);
        }
        for (FSRBTSetIndex index_set : setindexes) {
            if (!index_set.ll_contains(fsAddr)) continue;
            return true;
        }
        return false;
    }

    int removeIfInCorrputableIndexInThisView(int fsAddr) {
        int typeCode = this.cas.getTypeCode(fsAddr);
        if (this.sii.tsi.isAnnotationOrSubtype(typeCode)) {
            return this.ll_removeFS_all(fsAddr);
        }
        for (IndexIteratorCachePair<? extends FeatureStructure> iicp : this.indexArray[typeCode]) {
            FSLeafIndexImpl index_for_this_typeCode = ((IndexIteratorCachePair)iicp).fsLeafIndex;
            int kind = index_for_this_typeCode.getIndexingStrategy();
            if (kind != 0 && kind != 1) continue;
            return this.ll_removeFS_all(fsAddr);
        }
        return 0;
    }

    int ll_removeFS_all(int fsAddr) {
        return IS_ALLOW_DUP_ADD_2_INDEXES ? this.ll_removeFS_all_ret(fsAddr) : (this.ll_removeFS_ret(fsAddr) ? 1 : 0);
    }

    private <T extends FeatureStructure> FSIntArrayIndex<T> getAnnotationIndexNoSubtypes(int typeCode) {
        IndexIteratorCachePair<? extends FeatureStructure> annotation_iicp = this.name2indexMap.get("AnnotationIndex");
        ArrayList<IndexIteratorCachePair<T>> iicps_for_type = this.getIndexesForType(typeCode);
        FSLeafIndexImpl ri = ((IndexIteratorCachePair)annotation_iicp).fsLeafIndex;
        int ii = FSIndexRepositoryImpl.findIndex(iicps_for_type, ri.getComparator(), 0);
        return (FSIntArrayIndex)((IndexIteratorCachePair)iicps_for_type.get(ii)).fsLeafIndex;
    }

    private void logIndexOperation(int fsRef, boolean added) {
        this.indexUpdates.add(fsRef);
        if (added) {
            this.indexUpdateOperation.set(this.indexUpdates.size() - 1, added);
        }
        this.logProcessed = false;
    }

    private void processIndexUpdates() {
        ProcessedIndexInfo pii = this.mPii;
        int len = this.indexUpdates.size();
        for (int i = 0; i < len; ++i) {
            boolean wasRemoved;
            int fsRef = this.indexUpdates.get(i);
            boolean added = this.indexUpdateOperation.get(i);
            if (added) {
                wasRemoved = pii.fsDeletedFromIndex.remove(fsRef);
                if (wasRemoved) {
                    pii.fsReindexed.add(fsRef);
                    continue;
                }
                if (pii.fsReindexed.contains(fsRef)) continue;
                pii.fsAddedToIndex.add(fsRef);
                continue;
            }
            wasRemoved = pii.fsAddedToIndex.remove(fsRef);
            if (wasRemoved) continue;
            pii.fsReindexed.remove(fsRef);
            pii.fsDeletedFromIndex.add(fsRef);
        }
        this.logProcessed = true;
        this.indexUpdates.removeAllElements();
        this.indexUpdateOperation.clear();
    }

    public int[] getUpdatedFSs(PositiveIntSet items) {
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        return items.toIntArray();
    }

    public int[] getAddedFSs() {
        return this.getUpdatedFSs(this.mPii.fsAddedToIndex);
    }

    public int[] getDeletedFSs() {
        return this.getUpdatedFSs(this.mPii.fsDeletedFromIndex);
    }

    public int[] getReindexedFSs() {
        return this.getUpdatedFSs(this.mPii.fsReindexed);
    }

    public boolean isModified() {
        ProcessedIndexInfo pii;
        if (!this.logProcessed) {
            this.processIndexUpdates();
        }
        return (pii = this.mPii).fsAddedToIndex.size() > 0 || pii.fsDeletedFromIndex.size() > 0 || pii.fsReindexed.size() > 0;
    }

    public String toString() {
        return "FSIndexRepositoryImpl [" + this.cas + "]";
    }

    Comparator<AnnotationFS> getAnnotationFsComparator() {
        Comparator r = this.sii.annotationFsComparator;
        if (null == r) {
            final CASImpl ci = this.cas;
            TypeSystemImpl tsi = ci.getTypeSystemImpl();
            final int beginOffset = ci.getFeatureOffset(16);
            final int endOffset = ci.getFeatureOffset(17);
            final LinearTypeOrder typeOrder = this.getDefaultTypeOrder();
            return this.sii.annotationFsComparator = new Comparator<AnnotationFS>(){

                @Override
                public int compare(AnnotationFS o1, AnnotationFS o2) {
                    int tc2;
                    int e2;
                    int b2;
                    int fs2;
                    int fs1 = ((FeatureStructureImpl)((Object)o1)).getAddress();
                    if (fs1 == (fs2 = ((FeatureStructureImpl)((Object)o2)).getAddress())) {
                        return 0;
                    }
                    int b1 = ci.getHeapValue(fs1 + beginOffset);
                    if (b1 < (b2 = ci.getHeapValue(fs2 + beginOffset))) {
                        return -1;
                    }
                    if (b1 > b2) {
                        return 1;
                    }
                    int e1 = ci.getHeapValue(fs1 + endOffset);
                    if (e1 > (e2 = ci.getHeapValue(fs2 + endOffset))) {
                        return -1;
                    }
                    if (e1 < e2) {
                        return 1;
                    }
                    int tc1 = ci.getTypeCode(fs1);
                    return tc1 == (tc2 = ci.getTypeCode(fs2)) ? 0 : (typeOrder.lessThan(ci.getTypeCode(fs1), ci.getTypeCode(fs2)) ? -1 : 1);
                }
            };
        }
        return r;
    }

    IntComparator getAnnotationIntComparator() {
        IntComparator r = this.sii.annotationComparator;
        if (null == r) {
            final CASImpl ci = this.cas;
            final int beginOffset = ci.getFeatureOffset(16);
            final int endOffset = ci.getFeatureOffset(17);
            final LinearTypeOrder typeOrder = this.getDefaultTypeOrder();
            return this.sii.annotationComparator = new IntComparator(){

                @Override
                public int compare(int fs1, int fs2) {
                    int tc2;
                    int e2;
                    int b2;
                    if (fs1 == fs2) {
                        return 0;
                    }
                    int b1 = ci.getHeapValue(fs1 + beginOffset);
                    if (b1 < (b2 = ci.getHeapValue(fs2 + beginOffset))) {
                        return -1;
                    }
                    if (b1 > b2) {
                        return 1;
                    }
                    int e1 = ci.getHeapValue(fs1 + endOffset);
                    if (e1 > (e2 = ci.getHeapValue(fs2 + endOffset))) {
                        return -1;
                    }
                    if (e1 < e2) {
                        return 1;
                    }
                    int tc1 = ci.getTypeCode(fs1);
                    if (tc1 == (tc2 = ci.getTypeCode(fs2))) {
                        return 0;
                    }
                    return typeOrder.lessThan(tc1, tc2) ? -1 : 1;
                }
            };
        }
        return r;
    }

    private static class ProcessedIndexInfo {
        private final PositiveIntSet fsAddedToIndex = new PositiveIntSet_impl();
        private final PositiveIntSet fsDeletedFromIndex = new PositiveIntSet_impl();
        private final PositiveIntSet fsReindexed = new PositiveIntSet_impl();

        private ProcessedIndexInfo() {
        }
    }

    private static class SharedIndexInfo {
        private LinearTypeOrderBuilder defaultOrderBuilder = null;
        private LinearTypeOrder defaultTypeOrder = null;
        private final TypeSystemImpl tsi;
        private Comparator<AnnotationFS> annotationFsComparator = null;
        private IntComparator annotationComparator = null;
        private boolean isSetUpFromBaseCAS = false;

        SharedIndexInfo(TypeSystemImpl typeSystem) {
            this.tsi = typeSystem;
        }
    }

    class IndexImpl<T extends FeatureStructure>
    implements FSIndex<T>,
    FSIndexImpl {
        private final IndexIteratorCachePair<T> iicp;
        private final boolean is_with_snapshot_iterators;
        private final boolean is_unordered;

        private IndexImpl(IndexIteratorCachePair<T> iicp) {
            this.iicp = iicp;
            this.is_with_snapshot_iterators = false;
            this.is_unordered = false;
        }

        private IndexImpl(IndexIteratorCachePair<T> iicp, IteratorExtraFunction extraFn) {
            this.iicp = iicp;
            this.is_with_snapshot_iterators = extraFn == IteratorExtraFunction.SNAPSHOT;
            this.is_unordered = extraFn == IteratorExtraFunction.UNORDERED;
        }

        @Override
        public int ll_compare(int ref1, int ref2) {
            return ((IndexIteratorCachePair)this.iicp).fsLeafIndex.ll_compare(ref1, ref2);
        }

        @Override
        public int getIndexingStrategy() {
            return ((IndexIteratorCachePair)this.iicp).fsLeafIndex.getIndexingStrategy();
        }

        @Override
        public FSIndexComparator getComparator() {
            return ((IndexIteratorCachePair)this.iicp).fsLeafIndex.getComparator();
        }

        @Override
        public void flush() {
            ((IndexIteratorCachePair)this.iicp).fsLeafIndex.flush();
        }

        @Override
        public int compare(FeatureStructure fs1, FeatureStructure fs2) {
            return ((IndexIteratorCachePair)this.iicp).fsLeafIndex.compare(fs1, fs2);
        }

        @Override
        public boolean contains(FeatureStructure fs) {
            FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
            IntPointerIterator it = FSIndexRepositoryImpl.this.createPointerIterator(this.iicp);
            it.moveTo(fsi.getAddress());
            return it.isValid() && 0 == ((IndexIteratorCachePair)this.iicp).fsLeafIndex.ll_compare(fsi.getAddress(), it.get());
        }

        @Override
        public FeatureStructure find(FeatureStructure fs) {
            FeatureStructureImpl fsi = (FeatureStructureImpl)fs;
            IntPointerIterator it = FSIndexRepositoryImpl.this.createPointerIterator(this.iicp);
            it.moveTo(fsi.getAddress());
            if (it.isValid()) {
                int v = it.get();
                return 0 == ((IndexIteratorCachePair)this.iicp).fsLeafIndex.ll_compare(fsi.getAddress(), v) ? (FeatureStructure)this.iicp.getCASImpl().createFS(v) : null;
            }
            return null;
        }

        @Override
        public Type getType() {
            return ((IndexIteratorCachePair)this.iicp).fsLeafIndex.getType();
        }

        @Override
        public FSIterator<T> iterator() {
            return this.iterator(null);
        }

        @Override
        public FSIterator<T> iterator(FeatureStructure fs) {
            FSIndexFlat.FSIteratorFlat flatIterator;
            if (((IndexIteratorCachePair)this.iicp).flatIndex != null && (flatIterator = ((IndexIteratorCachePair)this.iicp).flatIndex.iterator(fs)) != null) {
                return flatIterator;
            }
            return this.nonFlatIterator(fs, true);
        }

        private FSIterator<T> nonFlatIterator(FeatureStructure fs, boolean respectUnordered) {
            if (null != fs) {
                int fsAddr = ((FeatureStructureImpl)fs).getAddress();
                return new FSIteratorWrapper(this.is_with_snapshot_iterators ? new SnapshotPointerIterator(this.iicp, fsAddr) : FSIndexRepositoryImpl.this.createPointerIterator(this.iicp, fsAddr), FSIndexRepositoryImpl.this.cas);
            }
            return new FSIteratorWrapper(this.is_with_snapshot_iterators ? new SnapshotPointerIterator(this.iicp) : FSIndexRepositoryImpl.this.createPointerIterator(this.iicp, respectUnordered && this.is_unordered), FSIndexRepositoryImpl.this.cas);
        }

        @Override
        public IntPointerIterator getIntIterator() {
            return FSIndexRepositoryImpl.this.createPointerIterator(this.iicp, this.is_unordered);
        }

        @Override
        public int size() {
            return this.iicp.size();
        }

        @Override
        public LowLevelIterator ll_iterator() {
            return (LowLevelIterator)((Object)(this.is_with_snapshot_iterators ? new SnapshotPointerIterator(this.iicp) : FSIndexRepositoryImpl.this.createPointerIterator(this.iicp, this.is_unordered)));
        }

        @Override
        public LowLevelIterator ll_rootIterator() {
            ((IndexIteratorCachePair)this.iicp).createIndexIteratorCache();
            return (LowLevelIterator)((Object)(this.is_with_snapshot_iterators ? new SnapshotPointerIterator(this.iicp, true) : FSIndexRepositoryImpl.this.createLeafPointerIterator(this.iicp)));
        }

        @Override
        public LowLevelIterator ll_iterator(boolean ambiguous) {
            if (ambiguous) {
                return this.ll_iterator();
            }
            return new LLUnambiguousIteratorImpl(this.ll_iterator(), ((IndexIteratorCachePair)this.iicp).fsLeafIndex.lowLevelCAS);
        }

        @Override
        public FSIndex<T> withSnapshotIterators() {
            return new IndexImpl<T>(this.iicp, IteratorExtraFunction.SNAPSHOT);
        }

        FSIndexRepositoryImpl getFsRepositoryImpl() {
            return this.iicp.getCASImpl().indexRepository;
        }
    }

    private class SnapshotPointerIterator<T extends FeatureStructure>
    implements IntPointerIterator,
    LowLevelIterator {
        private final FSIntArrayIndex<T> sortedLeafIndex;
        private final int[] snapshot;
        private final int size;
        private int pos = 0;

        public String toString() {
            return "SnapshotPointerIterator[size: " + this.snapshot.length + ", position: " + this.pos + "]";
        }

        private SnapshotPointerIterator(IndexIteratorCachePair<T> iicp0) {
            this(iicp0, false);
        }

        private SnapshotPointerIterator(IndexIteratorCachePair<T> iicp0, boolean isRootOnly) {
            FSLeafIndexImpl leafIndex = ((IndexIteratorCachePair)iicp0).fsLeafIndex;
            FSIndexComparator comp = leafIndex.getComparator();
            int size = iicp0.size();
            this.sortedLeafIndex = (FSIntArrayIndex)FSIndexRepositoryImpl.this.addNewIndexCore(comp, size, 0);
            this.snapshot = this.sortedLeafIndex.getVector().getArray();
            this.size = size;
            this.flattenCopy(iicp0, isRootOnly);
            this.sortedLeafIndex.getVector().setSize(size);
            this.moveToFirst();
        }

        private SnapshotPointerIterator(IndexIteratorCachePair<T> iicp0, int fs) {
            this(iicp0);
            this.moveTo(fs);
        }

        private void flattenCopy(IndexIteratorCachePair<T> iicp0, boolean isRootOnly) {
            LowLevelIterator it = (LowLevelIterator)((Object)(isRootOnly ? FSIndexRepositoryImpl.this.createLeafPointerIterator(iicp0) : FSIndexRepositoryImpl.this.createPointerIterator(iicp0)));
            int i = 0;
            while (it.isValid()) {
                this.snapshot[i++] = it.ll_get();
                it.moveToNext();
            }
        }

        @Override
        public boolean isValid() {
            return 0 <= this.pos && this.pos < this.size;
        }

        @Override
        public void moveToLast() {
            this.pos = this.size - 1;
        }

        @Override
        public void moveToFirst() {
            this.pos = 0;
        }

        @Override
        public void moveToNext() {
            ++this.pos;
        }

        @Override
        public void moveToPrevious() {
            --this.pos;
        }

        @Override
        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        @Override
        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return this.snapshot[this.pos];
        }

        @Override
        public void moveTo(int fs) {
            this.moveTo(fs, false);
        }

        void moveTo(int fs, boolean isExact) {
            if (this.sortedLeafIndex.getComparator().getNumberOfKeys() == 0) {
                int i;
                for (i = 0; i < this.size && fs != this.snapshot[i]; ++i) {
                }
                this.pos = i;
            } else {
                int position;
                int n = position = isExact ? this.sortedLeafIndex.findEq(fs) : this.sortedLeafIndex.findLeftmost(fs);
                if (position >= 0) {
                    this.pos = position;
                } else {
                    if (isExact) {
                        throw new UIMARuntimeException();
                    }
                    this.pos = -(position + 1);
                }
            }
        }

        @Override
        public void inc() {
            ++this.pos;
        }

        @Override
        public void dec() {
            --this.pos;
        }

        @Override
        public int ll_indexSize() {
            return this.size;
        }

        @Override
        public Object copy() {
            IndexIteratorCachePair iicp = new IndexIteratorCachePair(this.sortedLeafIndex);
            if (this.isValid()) {
                SnapshotPointerIterator it = new SnapshotPointerIterator(iicp);
                it.moveTo(this.get(), true);
                return it;
            }
            SnapshotPointerIterator pi = new SnapshotPointerIterator(iicp);
            pi.pos = -1;
            return pi;
        }

        @Override
        public LowLevelIndex ll_getIndex() {
            return this.sortedLeafIndex;
        }
    }

    private class PointerIteratorUnordered
    extends PointerIterator {
        private PointerIteratorUnordered(IndexIteratorCachePair<? extends FeatureStructure> iicp) {
            super(iicp);
        }

        private PointerIteratorUnordered(IndexIteratorCachePair<? extends FeatureStructure> iicp, int fs) {
            super(iicp);
            this.moveTo(fs);
        }

        @Override
        public boolean isValid() {
            return this.lastValidIndex >= 0 && this.lastValidIndex < this.iterators.length;
        }

        @Override
        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return this.checkConcurrentModification(this.lastValidIndex).get();
        }

        @Override
        public void moveToFirst() {
            for (int i = 0; i < this.iterators.length; ++i) {
                FSIntIteratorImplBase it = (FSIntIteratorImplBase)this.iterators[i];
                it.moveToFirst();
                it.resetConcurrentModification();
                if (!it.isValid()) continue;
                this.lastValidIndex = i;
                return;
            }
            this.lastValidIndex = -1;
        }

        @Override
        public void moveToLast() {
            for (int i = this.iterators.length - 1; i >= 0; --i) {
                FSIntIteratorImplBase it = (FSIntIteratorImplBase)this.iterators[i];
                it.moveToLast();
                it.resetConcurrentModification();
                if (!it.isValid()) continue;
                this.lastValidIndex = i;
                return;
            }
            this.lastValidIndex = -1;
        }

        @Override
        public void moveToNext() {
            if (!this.isValid()) {
                return;
            }
            ComparableIntPointerIterator it = this.checkConcurrentModification(this.lastValidIndex);
            it.inc();
            while (!it.isValid()) {
                ++this.lastValidIndex;
                if (this.lastValidIndex == this.iterators.length) {
                    return;
                }
                it = this.iterators[this.lastValidIndex];
                it.moveToFirst();
            }
        }

        @Override
        public void moveToPrevious() {
            if (!this.isValid()) {
                return;
            }
            ComparableIntPointerIterator it = this.checkConcurrentModification(this.lastValidIndex);
            it.dec();
            while (!it.isValid()) {
                --this.lastValidIndex;
                if (this.lastValidIndex < 0) {
                    return;
                }
                it = this.iterators[this.lastValidIndex];
                it.moveToLast();
            }
        }

        @Override
        public Object copy() {
            if (this.isValid()) {
                return new PointerIteratorUnordered(this.getIicp(), this.get());
            }
            PointerIteratorUnordered pi = new PointerIteratorUnordered(this.getIicp());
            pi.moveToFirst();
            pi.moveToPrevious();
            return pi;
        }

        @Override
        public void moveTo(int fs) {
            this.moveTo(fs, false);
        }

        @Override
        void moveTo(int fs, boolean isExact) {
            IndexIteratorCachePair<? extends FeatureStructure> iicp = this.getIicp();
            int kind = ((IndexIteratorCachePair)iicp).fsLeafIndex.getIndexingStrategy();
            for (int i = 0; i < this.iterators.length; ++i) {
                if (kind == 0) {
                    FSIntArrayIndex sortedIndex = (FSIntArrayIndex)((FSIntIteratorImplBase)this.iterators[i]).getFSLeafIndexImpl();
                    if ((isExact ? sortedIndex.findEq(fs) : sortedIndex.findLeftmost(fs)) < 0) continue;
                }
                FSIntIteratorImplBase li = (FSIntIteratorImplBase)this.iterators[i];
                li.moveTo(fs);
                if (!li.isValid() || 0 != ((IndexIteratorCachePair)iicp).fsLeafIndex.compare(fs, li.get())) continue;
                this.lastValidIndex = i;
                li.resetConcurrentModification();
                return;
            }
            this.moveToFirst();
            this.moveToPrevious();
        }
    }

    private class PointerIterator
    implements IntPointerIterator,
    LowLevelIterator {
        static final int SORTED_SECTION = 3;
        private final IndexIteratorCachePair<? extends FeatureStructure> iicp;
        protected ComparableIntPointerIterator[] iterators;
        int lastValidIndex;
        protected boolean wentForward;
        private final IntComparator iteratorComparator;

        protected IndexIteratorCachePair<? extends FeatureStructure> getIicp() {
            return this.iicp;
        }

        private ComparableIntPointerIterator[] initPointerIterator() {
            ArrayList cachedSubIndexes = ((IndexIteratorCachePair)this.iicp).cachedSubFsLeafIndexes;
            int length = cachedSubIndexes.size();
            ArrayList pia = new ArrayList(cachedSubIndexes.size());
            for (int i = 0; i < length; ++i) {
                FSLeafIndexImpl leafIndex = (FSLeafIndexImpl)cachedSubIndexes.get(i);
                if (leafIndex.size() <= 0 && (i != length - 1 || 0 != pia.size())) continue;
                pia.add(leafIndex.pointerIterator(this.iteratorComparator, FSIndexRepositoryImpl.this.detectIllegalIndexUpdates, ((TypeImpl)leafIndex.getType()).getCode()));
            }
            ComparableIntPointerIterator[] piaa = new ComparableIntPointerIterator[pia.size()];
            return pia.toArray(piaa);
        }

        private PointerIterator(IndexIteratorCachePair<? extends FeatureStructure> iicp) {
            this.iicp = iicp;
            this.iteratorComparator = (IntComparator)((IndexIteratorCachePair)iicp).cachedSubFsLeafIndexes.get(0);
            this.iterators = this.initPointerIterator();
            this.moveToFirst();
        }

        private PointerIterator(IndexIteratorCachePair<? extends FeatureStructure> iicp, int fs) {
            this.iicp = iicp;
            this.iteratorComparator = (IntComparator)((IndexIteratorCachePair)iicp).cachedSubFsLeafIndexes.get(0);
            this.iterators = this.initPointerIterator();
            this.moveTo(fs);
        }

        @Override
        public boolean isValid() {
            return this.lastValidIndex >= 0;
        }

        protected ComparableIntPointerIterator<?> checkConcurrentModification(int i) {
            FSIntIteratorImplBase cipi = (FSIntIteratorImplBase)this.iterators[i];
            cipi.checkConcurrentModification();
            return cipi;
        }

        private boolean is_before(ComparableIntPointerIterator l, ComparableIntPointerIterator r, int dir) {
            int ir;
            int il = l.get();
            int d = this.iteratorComparator.compare(il, ir = r.get());
            if (d == 0) {
                d = il - ir;
            }
            return d * dir < 0;
        }

        private void heapify_up(ComparableIntPointerIterator it, int idx, int dir) {
            int nidx;
            FSIndexFlat flatIndexInfo = ((IndexIteratorCachePair)this.iicp).flatIndex;
            if (null != flatIndexInfo) {
                flatIndexInfo.incrementReorderingCount();
            }
            while (idx > 3) {
                nidx = idx + 3 - 1 >> 1;
                if (!this.is_before(it, this.iterators[nidx], dir)) {
                    this.iterators[idx] = it;
                    return;
                }
                this.iterators[idx] = this.iterators[nidx];
                idx = nidx;
            }
            while (idx > 0) {
                nidx = idx - 1;
                if (!this.is_before(it, this.iterators[nidx], dir)) {
                    this.iterators[idx] = it;
                    return;
                }
                this.iterators[idx] = this.iterators[nidx];
                idx = nidx;
            }
            this.iterators[idx] = it;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void heapify_down(ComparableIntPointerIterator it, int dir) {
            int num;
            FSIndexFlat flatIndexInfo = ((IndexIteratorCachePair)this.iicp).flatIndex;
            if (null != flatIndexInfo) {
                flatIndexInfo.incrementReorderingCount();
            }
            if (!it.isValid()) {
                ComparableIntPointerIterator<?> itl = this.checkConcurrentModification(this.lastValidIndex);
                this.iterators[this.lastValidIndex] = it;
                this.iterators[0] = itl;
                --this.lastValidIndex;
                it = itl;
            }
            if ((num = this.lastValidIndex) < 1 || !this.is_before(this.checkConcurrentModification(1), it, dir)) {
                return;
            }
            int idx = 1;
            this.iterators[0] = this.iterators[1];
            int end = Math.min(num, 3);
            int nidx = idx + 1;
            try {
                while (nidx <= end) {
                    if (!this.is_before(this.checkConcurrentModification(nidx), it, dir)) {
                        return;
                    }
                    this.iterators[idx] = this.iterators[nidx];
                    idx = nidx;
                    nidx = idx + 1;
                }
                nidx = 4;
                while (nidx <= num) {
                    if (nidx < num && this.is_before(this.checkConcurrentModification(nidx + 1), this.checkConcurrentModification(nidx), dir)) {
                        ++nidx;
                    }
                    if (!this.is_before(this.iterators[nidx], it, dir)) {
                        return;
                    }
                    this.iterators[idx] = this.iterators[nidx];
                    idx = nidx;
                    nidx = (nidx << 1) - 2;
                }
            }
            finally {
                this.iterators[idx] = it;
            }
        }

        @Override
        public void moveToFirst() {
            int lvi = this.iterators.length - 1;
            int i = 0;
            while (i <= lvi) {
                FSIntIteratorImplBase it = (FSIntIteratorImplBase)this.iterators[i];
                it.resetConcurrentModification();
                it.moveToFirst();
                if (it.isValid()) {
                    this.heapify_up(it, i, 1);
                    ++i;
                    continue;
                }
                this.iterators[i] = this.iterators[lvi];
                this.iterators[lvi] = it;
                --lvi;
            }
            this.wentForward = true;
            this.lastValidIndex = lvi;
        }

        @Override
        public void moveToLast() {
            int lvi = this.iterators.length - 1;
            int i = 0;
            while (i <= lvi) {
                FSIntIteratorImplBase it = (FSIntIteratorImplBase)this.iterators[i];
                it.resetConcurrentModification();
                it.moveToLast();
                if (it.isValid()) {
                    this.heapify_up(it, i, -1);
                    ++i;
                    continue;
                }
                this.iterators[i] = this.iterators[lvi];
                this.iterators[lvi] = it;
                --lvi;
            }
            this.wentForward = false;
            this.lastValidIndex = lvi;
        }

        @Override
        public void moveToNext() {
            if (!this.isValid()) {
                return;
            }
            ComparableIntPointerIterator<?> it0 = this.checkConcurrentModification(0);
            if (this.wentForward) {
                it0.inc();
                this.heapify_down(it0, 1);
            } else {
                int lvi = this.iterators.length - 1;
                int i = 1;
                while (i <= lvi) {
                    ComparableIntPointerIterator<?> it = this.checkConcurrentModification(i);
                    if (!it.isValid()) {
                        it.moveToFirst();
                    }
                    while (it.isValid() && this.is_before(it, it0, 1)) {
                        it.inc();
                    }
                    if (it.isValid()) {
                        this.heapify_up(it, i, 1);
                        ++i;
                        continue;
                    }
                    this.iterators[i] = this.iterators[lvi];
                    this.iterators[lvi] = it;
                    --lvi;
                }
                this.lastValidIndex = lvi;
                this.wentForward = true;
                it0.inc();
                this.heapify_down(it0, 1);
            }
        }

        @Override
        public void moveToPrevious() {
            if (!this.isValid()) {
                return;
            }
            ComparableIntPointerIterator<?> it0 = this.checkConcurrentModification(0);
            if (!this.wentForward) {
                it0.dec();
                this.heapify_down(it0, -1);
            } else {
                int lvi = this.iterators.length - 1;
                int i = 1;
                while (i <= lvi) {
                    ComparableIntPointerIterator<?> it = this.checkConcurrentModification(i);
                    if (!it.isValid()) {
                        it.moveToLast();
                    }
                    while (it.isValid() && this.is_before(it, it0, -1)) {
                        it.dec();
                    }
                    if (it.isValid()) {
                        this.heapify_up(it, i, -1);
                        ++i;
                        continue;
                    }
                    this.iterators[i] = this.iterators[lvi];
                    this.iterators[lvi] = it;
                    --lvi;
                }
                this.lastValidIndex = lvi;
                this.wentForward = false;
                it0.dec();
                this.heapify_down(it0, -1);
            }
        }

        @Override
        public int get() throws NoSuchElementException {
            return this.ll_get();
        }

        @Override
        public int ll_get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return this.checkConcurrentModification(0).get();
        }

        @Override
        public Object copy() {
            if (this.isValid()) {
                PointerIterator it = new PointerIterator(this.iicp);
                this.moveTo(this.get());
                return it;
            }
            PointerIterator pi = new PointerIterator(this.iicp);
            pi.moveToFirst();
            pi.moveToPrevious();
            return pi;
        }

        @Override
        public void moveTo(int fs) {
            this.moveTo(fs, false);
        }

        void moveTo(int fs, boolean isExact) {
            int lvi = this.iterators.length - 1;
            int i = 0;
            while (i <= lvi) {
                FSIntIteratorImplBase it = (FSIntIteratorImplBase)this.iterators[i];
                it.moveTo(fs, isExact);
                if (it.isValid()) {
                    this.heapify_up(it, i, 1);
                    ++i;
                    continue;
                }
                this.iterators[i] = this.iterators[lvi];
                this.iterators[lvi] = it;
                --lvi;
            }
            this.wentForward = true;
            this.lastValidIndex = lvi;
        }

        @Override
        public void inc() {
            this.moveToNext();
        }

        @Override
        public void dec() {
            this.moveToPrevious();
        }

        @Override
        public int ll_indexSize() {
            return this.iicp.size();
        }

        @Override
        public LowLevelIndex ll_getIndex() {
            return ((IndexIteratorCachePair)this.iicp).fsLeafIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + " [iicp=" + this.iicp + ", indexes=\n");
            int i = 0;
            for (ComparableIntPointerIterator item : this.iterators) {
                sb.append("  ").append(i++).append("  ").append(item).append('\n');
                if (i > 4) break;
            }
            if (i < this.iterators.length) {
                sb.append("  and ").append(this.iterators.length - i).append(" more.\n");
            }
            sb.append("  lastValidIndex=" + this.lastValidIndex + ", wentForward=" + this.wentForward + ", iteratorComparator=" + this.iteratorComparator + "]");
            return sb.toString();
        }
    }

    class IndexIteratorCachePair<T extends FeatureStructure>
    implements Comparable<IndexIteratorCachePair<? extends FeatureStructure>> {
        private final FSLeafIndexImpl<T> fsLeafIndex;
        private ArrayList<FSLeafIndexImpl<? extends T>> cachedSubFsLeafIndexes = null;
        private volatile boolean isIteratorCacheSetup = false;
        private FSIndexFlat<T> flatIndex = null;
        int[] sortedTypeCodes;

        FSLeafIndexImpl<T> getFsLeafIndex() {
            return this.fsLeafIndex;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("IndexIteratorCachePair, index=");
            sb.append(this.fsLeafIndex).append('\n');
            if (!this.isIteratorCacheSetup) {
                sb.append(" cache not set up yet");
            } else {
                int len = Math.min(3, this.cachedSubFsLeafIndexes.size());
                for (int i = 0; i < len; ++i) {
                    FSLeafIndexImpl<? extends T> lii = this.cachedSubFsLeafIndexes.get(i);
                    sb.append("  cache ").append(i++);
                    sb.append("  ").append(lii).append('\n');
                }
                if (this.cachedSubFsLeafIndexes.size() > 3) {
                    sb.append(" ... and " + (this.cachedSubFsLeafIndexes.size() - 3) + " more\n");
                }
            }
            return sb.toString();
        }

        private IndexIteratorCachePair(FSLeafIndexImpl<T> fsLeafIndex) {
            this.fsLeafIndex = fsLeafIndex;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IndexIteratorCachePair)) {
                return false;
            }
            IndexIteratorCachePair iicp = (IndexIteratorCachePair)o;
            return this.fsLeafIndex.getComparator().equals(iicp.fsLeafIndex.getComparator()) && this.fsLeafIndex.getIndexingStrategy() == iicp.fsLeafIndex.getIndexingStrategy();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.fsLeafIndex.getComparator().hashCode();
            result = 31 * result + this.fsLeafIndex.getIndexingStrategy();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndexIteratorCache() {
            if (this.isIteratorCacheSetup) {
                return;
            }
            IndexIteratorCachePair indexIteratorCachePair = this;
            synchronized (indexIteratorCachePair) {
                if (this.isIteratorCacheSetup) {
                    return;
                }
                Type rootType = this.fsLeafIndex.getComparator().getType();
                int indexKind = this.fsLeafIndex.getIndexingStrategy();
                ArrayList allTypes = null;
                if (indexKind == 3) {
                    allTypes = new ArrayList();
                    allTypes.add(rootType);
                } else {
                    allTypes = FSIndexRepositoryImpl.getAllSubsumedTypes(rootType, FSIndexRepositoryImpl.this.sii.tsi);
                }
                ArrayList<FSLeafIndexImpl<T>> tempSubIndexCache = new ArrayList<FSLeafIndexImpl<T>>();
                int len = allTypes.size();
                if (indexKind == 0) {
                    this.sortedTypeCodes = new int[len];
                }
                for (int i = 0; i < len; ++i) {
                    int typeCode = ((TypeImpl)allTypes.get(i)).getCode();
                    ArrayList indexList = FSIndexRepositoryImpl.this.indexArray[typeCode];
                    int indexPos = indexList.indexOf(this);
                    FSLeafIndexImpl<T> leafIndex = ((IndexIteratorCachePair)indexList.get((int)indexPos)).fsLeafIndex;
                    if (indexPos < 0) {
                        throw new RuntimeException("never happen");
                    }
                    tempSubIndexCache.add(leafIndex);
                    if (indexKind != 0) continue;
                    this.sortedTypeCodes[i] = leafIndex.getTypeCode();
                }
                this.cachedSubFsLeafIndexes = tempSubIndexCache;
                if (this.fsLeafIndex.getIndexingStrategy() == 0) {
                    Arrays.sort(this.sortedTypeCodes);
                    this.flatIndex = null;
                }
                this.isIteratorCacheSetup = true;
            }
        }

        @Override
        public int compareTo(IndexIteratorCachePair<? extends FeatureStructure> cp) {
            int typeCode2;
            int typeCode1 = ((TypeImpl)this.fsLeafIndex.getType()).getCode();
            if (typeCode1 < (typeCode2 = ((TypeImpl)cp.fsLeafIndex.getType()).getCode())) {
                return -1;
            }
            if (typeCode1 > typeCode2) {
                return 1;
            }
            return this.fsLeafIndex.getComparator().compareTo(cp.fsLeafIndex.getComparator());
        }

        int size() {
            int size = 0;
            this.createIndexIteratorCache();
            ArrayList<FSLeafIndexImpl<T>> localIc = this.cachedSubFsLeafIndexes;
            int len = localIc.size();
            for (int i = 0; i < len; ++i) {
                size += localIc.get(i).size();
            }
            return size;
        }

        boolean has1OrMoreEntries() {
            this.createIndexIteratorCache();
            ArrayList<FSLeafIndexImpl<T>> localIc = this.cachedSubFsLeafIndexes;
            int len = localIc.size();
            for (int i = 0; i < len; ++i) {
                if (localIc.get(i).size() <= 0) continue;
                return true;
            }
            return false;
        }

        int guessedSize() {
            ArrayList<FSLeafIndexImpl<T>> localIc = this.cachedSubFsLeafIndexes;
            int len = localIc.size();
            int lim = Math.min(3, len);
            int size = 0;
            for (int i = 0; i < lim; ++i) {
                size += localIc.get(i).size();
            }
            return size += len - lim;
        }

        public void fillFlatArray(FeatureStructure[] flatArray) {
            LowLevelIterator it = (LowLevelIterator)((Object)FSIndexRepositoryImpl.this.createPointerIterator(this));
            int i = 0;
            while (it.isValid()) {
                if (i >= flatArray.length) {
                    throw new ConcurrentModificationException();
                }
                flatArray[i++] = FSIndexRepositoryImpl.this.cas.createFS(it.ll_get());
                it.moveToNext();
            }
            if (i != flatArray.length) {
                throw new ConcurrentModificationException();
            }
        }

        Int2IntArrayMapFixedSize createIndexUpdateCountsAtReset() {
            Int2IntArrayMapFixedSize m3 = new Int2IntArrayMapFixedSize(this.sortedTypeCodes.length);
            this.captureIndexUpdateCounts(m3);
            return m3;
        }

        void captureIndexUpdateCounts() {
            this.captureIndexUpdateCounts(this.flatIndex.indexUpdateCountsResetValues);
        }

        private void captureIndexUpdateCounts(Int2IntArrayMapFixedSize m3) {
            int[] localSortedTypeCodes = this.sortedTypeCodes;
            for (int i = 0; i < localSortedTypeCodes.length; ++i) {
                m3.putAtIndex(i, FSIndexRepositoryImpl.this.detectIllegalIndexUpdates[localSortedTypeCodes[i]]);
            }
        }

        boolean isUpdateFreeSinceLastCounterReset() {
            Int2IntArrayMapFixedSize typeCode2updateCount = this.flatIndex.indexUpdateCountsResetValues;
            int[] localSortedTypeCodes = this.sortedTypeCodes;
            for (int i = 0; i < localSortedTypeCodes.length; ++i) {
                if (typeCode2updateCount.getAtIndex(i) == FSIndexRepositoryImpl.this.detectIllegalIndexUpdates[localSortedTypeCodes[i]]) continue;
                return false;
            }
            return true;
        }

        boolean isUpdateFreeSinceLastCounterReset(int typeCode) {
            return this.flatIndex.indexUpdateCountsResetValues.get(typeCode, this.sortedTypeCodes) == FSIndexRepositoryImpl.this.detectIllegalIndexUpdates[typeCode];
        }

        boolean subsumes(int superType, int subType) {
            return FSIndexRepositoryImpl.this.cas.getTypeSystemImpl().subsumes(superType, subType);
        }

        CASImpl getCASImpl() {
            return FSIndexRepositoryImpl.this.cas;
        }

        void addToIteratedSortedIndexes() {
            FSIndexRepositoryImpl.this.iteratedSortedIndexes.add(this);
        }

        private boolean hasFlatIndex() {
            return false;
        }
    }

    public static enum IteratorExtraFunction {
        SNAPSHOT,
        UNORDERED;

    }
}

