/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.text;

public class Language {
    public static final String UNSPECIFIED_LANGUAGE = "x-unspecified";
    public static final Language ZH = new Language("zh");
    public static final Language ZH_CN = new Language("zh-cn");
    public static final Language ZH_TW = new Language("zh-tw");
    public static final char CANONICAL_LANG_SEPARATOR = '-';
    private String lang;
    private String langPart = null;
    private String territoryPart = null;

    public Language(String language) {
        this.lang = Language.normalize(language);
        this.parseLanguage();
    }

    public static final String normalize(String lang) {
        if (lang == null) {
            return UNSPECIFIED_LANGUAGE;
        }
        lang = lang.toLowerCase();
        lang = lang.replace('_', '-');
        return lang;
    }

    public String getLanguagePart() {
        return this.langPart;
    }

    public String getTerritoryPart() {
        return this.territoryPart;
    }

    public String getFullLanguage() {
        return this.lang;
    }

    private final void parseLanguage() {
        int pos = this.lang.indexOf(45);
        if (pos < 0) {
            this.langPart = this.lang;
            return;
        }
        this.langPart = this.lang.substring(0, pos);
        if (++pos < this.lang.length()) {
            this.territoryPart = this.lang.substring(pos);
        }
    }

    public String toString() {
        return "Full language string: " + this.getFullLanguage() + ", language part: " + this.getLanguagePart() + ", territory part: " + this.getTerritoryPart();
    }

    public static void main(String[] args2) {
        System.out.println(ZH);
        System.out.println(ZH_CN);
        System.out.println(new Language("en_US_NY"));
    }
}

