/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.vinci.util.VinciSaxParser;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.FeatureStructure;
import org.apache.uima.cas_data.FeatureValue;
import org.apache.uima.cas_data.PrimitiveValue;
import org.apache.uima.cas_data.impl.CasDataImpl;
import org.apache.uima.cas_data.impl.FeatureStructureImpl;
import org.apache.uima.cas_data.impl.PrimitiveValueImpl;
import org.apache.uima.cas_data.impl.vinci.VinciCasDataConverter;
import org.apache.uima.collection.impl.base_cpm.container.ServiceConnectionException;
import org.apache.uima.collection.impl.cpm.container.deployer.FencedProcessReaper;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.vinci.DATACasUtils;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.resource.ResourceServiceException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.SaxDeserializer;
import org.apache.uima.util.UimaTimer;
import org.apache.vinci.transport.BaseClient;
import org.apache.vinci.transport.Frame;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.ServiceDownException;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VNSException;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.context.VinciContext;
import org.apache.vinci.transport.document.AFrame;

public class VinciTAP {
    private String serviceHost;
    private String servicePort;
    private String fencedProcessPID = null;
    private String vnsHost;
    private String vnsPort;
    private String serviceName;
    private BaseClient conn = null;
    private int timeout = 300;
    private long totalCasToFrameTime = 0L;
    private long totalAnnotationTime = 0L;
    private long totalFrameToCasTime = 0L;
    private long totalSerializeTime = 0L;
    private long totalDeSerializeTime = 0L;
    private long totalRoundTripTime = 0L;
    private UimaTimer uimaTimer = null;
    private String contentTag = "Detag:DetagContent";
    private String[] keys2Drop = new String[]{""};
    private VinciCasDataConverter vinciCasDataConverter = new VinciCasDataConverter("uima.cpm.DocumentMetadata", "ID", "uima.cpm.DocumentText", "value", this.contentTag, true);

    public void setContentTag(String aContentTag) {
        this.contentTag = aContentTag;
    }

    public void setTimer(UimaTimer aTimer) {
        this.uimaTimer = aTimer;
    }

    public void setKeys2Drop(String[] aKeys2Drop) {
        this.keys2Drop = aKeys2Drop;
    }

    public void connect(String aHost, int aPort) throws ConnectException {
        int attemptCount = 0;
        int maxConnectRetryCount = 300;
        if (System.getProperty("CONNECT_RETRY_COUNT") != null) {
            try {
                maxConnectRetryCount = Integer.parseInt(System.getProperty("CONNECT_RETRY_COUNT"));
            }
            catch (Exception e) {
                throw new ConnectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_retry_count__WARNING", new Object[]{Thread.currentThread().getName(), aHost, String.valueOf(aPort)}));
            }
        }
        while (attemptCount++ < maxConnectRetryCount) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_set_service_timeout__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.timeout)});
            }
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connect_to_service__FINEST", new Object[]{Thread.currentThread().getName(), aHost, String.valueOf(aPort)});
                }
                this.conn = new BaseClient(aHost, aPort);
                this.conn.setSocketTimeout(this.timeout);
                this.conn.setRetry(false);
                this.serviceHost = this.conn.getHost();
                this.servicePort = String.valueOf(this.conn.getPort());
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connected_to_service__FINEST", new Object[]{Thread.currentThread().getName(), aHost, String.valueOf(aPort)});
                }
                if (this.conn.isOpen()) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_testing_connection__FINEST", new Object[]{Thread.currentThread().getName()});
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    this.getAnalysisEngineMetaData();
                    try {
                        VinciFrame query = new VinciFrame();
                        query.fadd("vinci:COMMAND", "GetPid");
                        AFrame resp = (AFrame)this.conn.sendAndReceive(query);
                        if (resp.fgetString("vinci:STATUS") != null && resp.fgetString("vinci:STATUS").equals("OK")) {
                            this.fencedProcessPID = resp.fgetString("PID");
                            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_pid__FINEST", new Object[]{Thread.currentThread().getName(), this.fencedProcessPID});
                            }
                        }
                    }
                    catch (Exception ex) {}
                } else if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connection_closed__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connection_validated__FINEST", new Object[]{Thread.currentThread().getName(), aHost, String.valueOf(aPort)});
                }
                return;
            }
            catch (Exception e) {
                if (e instanceof ConnectException) {
                    if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connection_not_established__WARNING", new Object[]{Thread.currentThread().getName(), aHost, String.valueOf(aPort)});
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception ex) {}
                    continue;
                }
                e.printStackTrace();
                if (!UIMAFramework.getLogger().isLoggable(Level.SEVERE)) continue;
                UIMAFramework.getLogger(this.getClass()).log(Level.SEVERE, "", e);
            }
        }
        if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connection_failed__WARNING", new Object[]{Thread.currentThread().getName(), aHost, String.valueOf(aPort)});
        }
        throw new ConnectException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_unable_to_connect__WARNING", new Object[]{Thread.currentThread().getName(), aHost, String.valueOf(aPort)}));
    }

    public void setTimeout(int aTimeout) {
        this.timeout = aTimeout;
    }

    public void connect(String aServiceName) throws ServiceConnectionException {
        if (this.getVNSHost() == null || this.getVNSPort() == null) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_vns_not_provided__SEVERE", new Object[]{Thread.currentThread().getName()});
            }
            throw new ServiceConnectionException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_vinci_vns_cfg_invalid__WARNING", new Object[]{Thread.currentThread().getName()}));
        }
        System.setProperty("VNS_HOST", this.getVNSHost());
        System.setProperty("VNS_PORT", this.getVNSPort());
        try {
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_locating_service__FINEST", new Object[]{Thread.currentThread().getName(), aServiceName, System.getProperty("VNS_HOST"), System.getProperty("VNS_PORT")});
            }
            VinciContext vctx = new VinciContext(InetAddress.getLocalHost().getCanonicalHostName(), 0);
            vctx.setVNSHost(this.getVNSHost());
            vctx.setVNSPort(Integer.parseInt(this.getVNSPort()));
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName() + " Connecting to::" + aServiceName + " VinciContext.getVNSHost():" + vctx.getVNSHost() + " VinciContext.getVNSPort():" + vctx.getVNSPort());
            }
            this.conn = new VinciClient(aServiceName, vctx);
            this.conn.setSocketTimeout(this.timeout);
            this.conn.setRetry(false);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_set_service_timeout__FINEST", new Object[]{Thread.currentThread().getName(), aServiceName + ":" + String.valueOf(this.timeout)});
            }
            this.serviceHost = this.conn.getHost();
            this.servicePort = String.valueOf(this.conn.getPort());
            this.serviceName = aServiceName;
            return;
        }
        catch (Exception e) {
            if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_connection_failed__WARNING", new Object[]{Thread.currentThread().getName(), aServiceName, ""});
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, Thread.currentThread().getName(), e);
            }
            throw new ServiceConnectionException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_unable_to_connect_toservice__WARNING", new Object[]{Thread.currentThread().getName(), aServiceName}));
        }
    }

    private void testAndReconnect() throws ServiceException, ServiceConnectionException {
        if (this.conn == null || !this.conn.isOpen()) {
            try {
                if (this.serviceName != null) {
                    if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_down__INFO", new Object[]{Thread.currentThread().getName(), this.serviceName});
                    }
                    this.connect(this.serviceName);
                } else if (this.serviceHost != null && this.servicePort != null) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_down_onhost__INFO", new Object[]{Thread.currentThread().getName(), this.serviceHost, this.servicePort});
                    this.connect(this.serviceHost, Integer.parseInt(this.servicePort));
                }
            }
            catch (ConnectException ce) {
                if (this.serviceName != null) {
                    throw new ServiceException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_unable_to_connect_toservice__WARNING", new Object[]{Thread.currentThread().getName(), this.serviceName}));
                }
                throw new ServiceException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_unable_to_connect__WARNING", new Object[]{Thread.currentThread().getName(), this.serviceHost, this.servicePort}));
            }
            catch (ServiceConnectionException ce) {
                throw ce;
            }
        }
    }

    public AFrame sendAndReceive(AFrame aFrame) throws ServiceException, ServiceConnectionException {
        int currentTimeout = 0;
        currentTimeout = this.conn.getSocketTimeout();
        if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_sending_process_req__FINEST", new Object[]{Thread.currentThread().getName(), this.serviceHost, this.servicePort, String.valueOf(currentTimeout)});
        }
        try {
            AFrame responseFrame = null;
            if (System.getProperty("TEST_BEFORE_SEND") != null) {
                this.testAndReconnect();
            }
            long memStart = Runtime.getRuntime().freeMemory();
            if (System.getProperty("SHOW_MEMORY") != null) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_memory_before_call__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().totalMemory() / 1024L), String.valueOf(memStart / 1024L)});
            }
            responseFrame = (AFrame)this.conn.sendAndReceive(aFrame, AFrame.getAFrameFactory(), this.timeout);
            if (System.getProperty("SHOW_MEMORY") != null) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_memory_after_call__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(Runtime.getRuntime().totalMemory() / 1024L), String.valueOf(Runtime.getRuntime().freeMemory() / 1024L)});
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_received_response__FINEST", new Object[]{Thread.currentThread().getName(), this.serviceHost, this.servicePort});
            }
            return responseFrame;
        }
        catch (VNSException vnse) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_failed_service_request__WARNING", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort())});
            UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, Thread.currentThread().getName(), vnse);
            this.conn.close();
            throw new ServiceException(vnse.getMessage());
        }
        catch (ServiceDownException sde) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_failed_service_request__WARNING", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort())});
            UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, Thread.currentThread().getName(), sde);
            this.conn.close();
            throw new ServiceConnectionException(sde.getMessage());
        }
        catch (ServiceException sde) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_failed_service_request__WARNING", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort())});
            UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, Thread.currentThread().getName(), sde);
            if (sde.getMessage().equals("Unknown command") && aFrame != null) {
                UIMAFramework.getLogger(this.getClass()).log(Level.INFO, aFrame.toXML());
            }
            throw new ServiceConnectionException(sde.getMessage());
        }
        catch (IOException e) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_failed_service_request__WARNING", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort())});
            UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, Thread.currentThread().getName(), e);
            this.conn.close();
            if (System.getProperty("TEST_BEFORE_SEND") != null) {
                this.testAndReconnect();
            }
            if (e instanceof SocketTimeoutException) {
                UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, Thread.currentThread().getName() + "  Exception Cause::" + e.getClass().getName());
                throw new ServiceConnectionException(e);
            }
            throw new ServiceConnectionException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_service_timeout__WARNING", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort()), String.valueOf(currentTimeout)}));
        }
        catch (Exception e) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_failed_service_request__WARNING", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort())});
            UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, Thread.currentThread().getName(), e);
            this.conn.close();
            throw new ServiceException(e.getMessage());
        }
    }

    public static CasData addKeysToDataCas(CasData dataCas, AFrame aFrame) throws Exception {
        try {
            aFrame = aFrame.fgetAFrame("KEYS");
            int frameCount = aFrame.getKeyValuePairCount();
            for (int i = 0; i < frameCount; ++i) {
                KeyValuePair kvp = aFrame.getKeyValuePair(i);
                String featureStructureType = kvp.getKey();
                if (featureStructureType.indexOf(":") > -1) {
                    featureStructureType = StringUtils.replaceAll(featureStructureType, ":", "_colon_");
                }
                if (featureStructureType.indexOf("-") > -1) {
                    featureStructureType = StringUtils.replaceAll(featureStructureType, "-", "_dash_");
                }
                FeatureStructureImpl vfs = new FeatureStructureImpl();
                vfs.setType(featureStructureType);
                FrameLeaf leafFrame = kvp.getValueAsLeaf();
                PrimitiveValueImpl pv = new PrimitiveValueImpl(leafFrame.toString());
                vfs.setFeatureValue(featureStructureType, pv);
                dataCas.addFeatureStructure(vfs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return dataCas;
    }

    private static void dumpFeatures(CasData aCAS) {
        try {
            Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
            while (it.hasNext()) {
                FeatureStructure object = it.next();
                if (!(object instanceof FeatureStructure)) continue;
                FeatureStructure fs = object;
                String s2 = "\nCAS FEATURE STRUCTURE TYPE:" + fs.getType();
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(VinciTAP.class).log(Level.FINEST, s2);
                }
                String[] names = fs.getFeatureNames();
                for (int i = 0; names != null && i < names.length; ++i) {
                    FeatureValue fValue = fs.getFeatureValue(names[i]);
                    if (fValue == null) continue;
                    s2 = "\n\t\tCAS FEATURE NAME::" + names[i] + " CAS FEATURE VALUE::" + fValue.toString();
                    if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                    UIMAFramework.getLogger(VinciTAP.class).log(Level.FINEST, s2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void produceXCASRequestFrame(CasData aCasData, AFrame dataFrame, String[] aDropKeyList) throws Exception {
        AFrame keysFrame = new AFrame();
        dataFrame.fadd("KEYS", keysFrame);
        String ueid = DATACasUtils.getFeatureValueByType(aCasData, "uima.cpm.DocumentMetadata", "ID");
        keysFrame.fadd("UEID", ueid);
        AFrame keyFrame = null;
        try {
            Iterator<FeatureStructure> it = aCasData.getFeatureStructures();
            while (it.hasNext()) {
                FeatureStructure fs = it.next();
                boolean skipTheFeature = false;
                if (aDropKeyList != null) {
                    for (int i = 0; i < aDropKeyList.length; ++i) {
                        if (!aDropKeyList[i].equalsIgnoreCase(fs.getType())) continue;
                        skipTheFeature = true;
                        break;
                    }
                    if (skipTheFeature) continue;
                }
                keyFrame = new AFrame();
                FeatureValue value = null;
                String[] keys2 = fs.getFeatureNames();
                for (int i = 0; i < keys2.length; ++i) {
                    value = fs.getFeatureValue(keys2[i]);
                    if (!(value instanceof PrimitiveValueImpl) && !(value instanceof PrimitiveValue)) continue;
                    keyFrame.add("", new FrameLeaf(value.toString()));
                }
                String type = fs.getType();
                if (type.indexOf("_colon_") > -1) {
                    type = StringUtils.replaceAll(type, "_colon_", ":");
                }
                if (type.indexOf("_dash_") > -1) {
                    type = StringUtils.replaceAll(type, "_dash_", "-");
                }
                keysFrame.fadd(type, keyFrame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static boolean isText(String feature) {
        return "Doc:SpannedText".equals(feature) || "Detag:Content".equals(feature) || "Detag:DetagContent".equals(feature) || "uima.cpm.DocumentText".equals(feature);
    }

    public CasData analyze(CasData aCas, ProcessTrace aPT, String aResourceName) throws ServiceException, ServiceConnectionException {
        AFrame query = new AFrame();
        try {
            int casToFrameTime;
            int annotationTime;
            aPT.startEvent(aResourceName, "CAS to Vinci Request Frame", "");
            query.fadd("vinci:COMMAND", "Annotate");
            AFrame dataFrame = new AFrame();
            this.vinciCasDataConverter.casDataToVinciFrame(aCas, dataFrame);
            query.fadd("DATA", dataFrame);
            aPT.endEvent(aResourceName, "CAS to Vinci Request Frame", "");
            aPT.startEvent(aResourceName, "Vinci Call", "");
            AFrame responseFrame = this.sendAndReceive(query);
            aPT.endEvent(aResourceName, "Vinci Call", "");
            aPT.startEvent(aResourceName, "Vinci Response Frame to CAS", "");
            CasDataImpl newCasData = new CasDataImpl();
            FeatureStructure casDataFs = this.getDocTextFeatureStructure(aCas);
            if (casDataFs != null) {
                newCasData.addFeatureStructure(casDataFs);
            }
            this.vinciCasDataConverter.appendVinciFrameToCasData(responseFrame.fgetAFrame("DATA").fgetAFrame("KEYS"), newCasData);
            aCas = newCasData;
            aPT.endEvent(aResourceName, "Vinci Response Frame to CAS", "");
            int frameToCasTime = responseFrame.fgetVinciFrame("DATA").fgetInt("TAE:FrameToCasTime");
            if (frameToCasTime > 0) {
                this.totalFrameToCasTime += (long)frameToCasTime;
                aPT.addEvent(aResourceName, "TAE:FrameToCasTime", "", frameToCasTime, "success");
            }
            if ((annotationTime = responseFrame.fgetVinciFrame("DATA").fgetInt("TAE:AnnotationTime")) > 0) {
                this.totalAnnotationTime += (long)annotationTime;
                aPT.addEvent(aResourceName, "ANALYSIS", "", annotationTime, "success");
            }
            if ((casToFrameTime = responseFrame.fgetVinciFrame("DATA").fgetInt("TAE:CasToFrameTime")) > 0) {
                this.totalCasToFrameTime += (long)casToFrameTime;
                aPT.addEvent(aResourceName, "TAE:CasToFrameTime", "", casToFrameTime, "success");
            }
            return aCas;
        }
        catch (ServiceException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
            throw e;
        }
        catch (ServiceConnectionException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), ex.getMessage()});
                UIMAFramework.getLogger(this.getClass()).log(Level.FINER, "", ex);
            }
            throw new ServiceException(ex.getMessage());
        }
    }

    private void dropNamedTypes(AFrame aKeyFrame, String[] aDropKeyList) {
        if (aDropKeyList != null && aKeyFrame != null) {
            ArrayList keyList = aKeyFrame.fkeys();
            for (int inx = 0; inx < keyList.size(); ++inx) {
                if (System.getProperty("SHOWKEYS") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_drop_key__FINEST", new Object[]{Thread.currentThread().getName(), (String)keyList.get(inx)});
                }
                if (DATACasUtils.dropIt((String)keyList.get(inx), aDropKeyList)) {
                    if (System.getProperty("SHOWKEYS") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, " = YES");
                    }
                    aKeyFrame.fdrop((String)keyList.get(inx));
                    continue;
                }
                if (System.getProperty("SHOWKEYS") == null || !UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, " = NO");
            }
        }
    }

    public CasData[] analyze(CasData[] aCasList, ProcessTrace aPT, String aResourceName) throws ServiceException, ServiceConnectionException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_analyze_bundle__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(aCasList.length)});
        }
        AFrame query = new AFrame();
        try {
            aPT.startEvent(aResourceName, "Vinci Call", "");
            query.fadd("vinci:COMMAND", "Annotate");
            for (int i = 0; i < aCasList.length && aCasList[i] != null; ++i) {
                AFrame dataFrame = new AFrame();
                if (System.getProperty("SHOWKEYS") != null) {
                    Iterator<FeatureStructure> it = aCasList[i].getFeatureStructures();
                    while (it.hasNext()) {
                        FeatureStructure fs = it.next();
                        if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_dump_casdata__FINEST", new Object[]{Thread.currentThread().getName(), fs.getType()});
                    }
                }
                if (DATACasUtils.isCasEmpty(aCasList[i])) {
                    if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_no_cas__FINEST", new Object[]{Thread.currentThread().getName()});
                    continue;
                }
                long sTime = this.uimaTimer.getTimeInMillis();
                if (System.getProperty("WF_SERIALIZER") != null) {
                    this.produceXCASRequestFrame(aCasList[i], dataFrame, this.keys2Drop);
                } else {
                    this.vinciCasDataConverter.casDataToVinciFrame(aCasList[i], dataFrame);
                    this.dropNamedTypes(dataFrame.fgetAFrame("KEYS"), this.keys2Drop);
                }
                this.totalSerializeTime += this.uimaTimer.getTimeInMillis() - sTime;
                query.fadd("DATA", dataFrame);
            }
            if (this.serviceName != null && System.getProperty("SHOW_NAME") != null && UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_send_casdata_to_service__FINEST", new Object[]{Thread.currentThread().getName(), this.serviceName});
            }
            if (System.getProperty("SHOW_REQFRAME") != null) {
                UIMAFramework.getLogger(this.getClass()).log(Level.INFO, " queryFrame-" + query.toXML());
            }
            long t = this.uimaTimer.getTimeInMillis();
            AFrame responseFrame = this.sendAndReceive(query);
            query = null;
            this.totalRoundTripTime += this.uimaTimer.getTimeInMillis() - t;
            if (responseFrame != null && responseFrame.fgetString("Error") != null) {
                throw new ServiceException(responseFrame.fgetString("Error"));
            }
            if (System.getProperty("SHOW_RAW_RESPFRAME") != null) {
                UIMAFramework.getLogger(this.getClass()).log(Level.INFO, " responseFrame from service::" + this.serviceName + "\n" + responseFrame.toXML());
            }
            if (responseFrame != null && responseFrame.fgetAFrame("DATA") == null) {
                return aCasList;
            }
            ArrayList d = new ArrayList();
            if (responseFrame != null) {
                d = responseFrame.fget("DATA");
            }
            int instanceCount = 0;
            AFrame dataFrame = null;
            while (!d.isEmpty()) {
                dataFrame = (AFrame)d.remove(0);
                try {
                    if (System.getProperty("SHOW_RESPFRAME") != null) {
                        UIMAFramework.getLogger(this.getClass()).log(Level.INFO, " Converting XCAS in responseFrame to CasData.XCAS=" + dataFrame.toXML());
                    }
                    long eTime = this.uimaTimer.getTimeInMillis();
                    if (System.getProperty("WF_SERIALIZER") != null) {
                        VinciTAP.addKeysToDataCas(aCasList[instanceCount], dataFrame);
                    } else {
                        CasDataImpl newCasData = new CasDataImpl();
                        FeatureStructure casDataFs = this.getDocTextFeatureStructure(aCasList[instanceCount]);
                        if (casDataFs != null) {
                            newCasData.addFeatureStructure(casDataFs);
                        }
                        this.vinciCasDataConverter.appendVinciFrameToCasData(dataFrame.fgetAFrame("KEYS"), newCasData);
                        aCasList[instanceCount] = newCasData;
                    }
                    this.totalDeSerializeTime += this.uimaTimer.getTimeInMillis() - eTime;
                    if (System.getProperty("SHOWFRAME") != null) {
                        UIMAFramework.getLogger(this.getClass()).log(Level.INFO, " dumping CasData-\n");
                        VinciTAP.dumpFeatures(aCasList[instanceCount]);
                    }
                    if (dataFrame != null) {
                        String cas2FrameTime;
                        String annotationTime;
                        FeatureStructureImpl vfs = new FeatureStructureImpl();
                        vfs.setType("Analysis:PerformanceStats");
                        String frame2CasTime = dataFrame.fgetString("TAE:FrameToCasTime");
                        if (frame2CasTime != null) {
                            PrimitiveValueImpl pv = new PrimitiveValueImpl(frame2CasTime);
                            vfs.setFeatureValue("TAE:FrameToCasTime", pv);
                        }
                        if ((annotationTime = dataFrame.fgetString("TAE:AnnotationTime")) != null) {
                            PrimitiveValueImpl pv = new PrimitiveValueImpl(annotationTime);
                            vfs.setFeatureValue("TAE:AnnotationTime", pv);
                        }
                        if ((cas2FrameTime = dataFrame.fgetString("TAE:CasToFrameTime")) != null) {
                            PrimitiveValueImpl pv = new PrimitiveValueImpl(cas2FrameTime);
                            vfs.setFeatureValue("TAE:CasToFrameTime", pv);
                        }
                        aCasList[instanceCount].addFeatureStructure(vfs);
                    }
                    ++instanceCount;
                }
                catch (Exception e) {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINER)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_exception__FINER", new Object[]{Thread.currentThread().getName(), e.getMessage(), dataFrame.toXML()});
                        e.printStackTrace();
                    }
                    dataFrame.toXML();
                }
            }
            aPT.endEvent(aResourceName, "Vinci Call", "");
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_analyzing_bundle__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(aCasList.length)});
            }
            return aCasList;
        }
        catch (ServiceException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_exception__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
            e.printStackTrace();
            throw e;
        }
        catch (ServiceConnectionException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_connection_exception__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
            e.printStackTrace();
            throw e;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex.getMessage());
        }
    }

    public ProcessingResourceMetaData getAnalysisEngineMetaData() throws ResourceServiceException {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_request_metadata__FINEST", new Object[]{Thread.currentThread().getName(), this.serviceName, this.conn.getHost(), String.valueOf(this.conn.getPort())});
        }
        AFrame resultFrame = null;
        try {
            VinciFrame queryFrame = new VinciFrame();
            queryFrame.fadd("vinci:COMMAND", "GetMeta");
            resultFrame = (AFrame)this.conn.sendAndReceive(queryFrame, AFrame.getAFrameFactory(), this.timeout);
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_return_meta__FINEST", new Object[]{Thread.currentThread().getName(), this.serviceName, this.conn.getHost(), String.valueOf(this.conn.getPort())});
            }
            SaxDeserializer saxDeser = UIMAFramework.getXMLParser().newSaxDeserializer();
            VinciSaxParser vinciSaxParser = new VinciSaxParser();
            vinciSaxParser.setContentHandler(saxDeser);
            vinciSaxParser.parse(resultFrame);
            ProcessingResourceMetaData metadata = (ProcessingResourceMetaData)saxDeser.getObject();
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_done_parsing_meta__FINEST", new Object[]{Thread.currentThread().getName(), this.serviceName, this.conn.getHost(), String.valueOf(this.conn.getPort())});
            }
            return metadata;
        }
        catch (ServiceException e) {
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_exception__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
            if ("No Such Command supported.".equals(e.getMessage().trim())) {
                return null;
            }
            e.printStackTrace();
            throw new ResourceServiceException(e);
        }
        catch (Exception e) {
            if ("No Such Command supported".equals(e.getMessage())) {
                if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_rejected_requested__WARNING", new Object[]{Thread.currentThread().getName(), this.serviceName, resultFrame.toXML()});
                }
                return null;
            }
            if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_exception__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            }
            e.printStackTrace();
            throw new ResourceServiceException(e);
        }
    }

    public void batchProcessComplete() throws ResourceServiceException {
        if (System.getProperty("FILTER_BATCH") != null) {
            return;
        }
        try {
            if (this.conn != null && this.conn.isOpen()) {
                VinciFrame query = new VinciFrame();
                query.fadd("vinci:COMMAND", "BatchProcessComplete");
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_send_batch_complete__FINEST", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort()), query.toXML()});
                }
                this.conn.send(query);
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_exception__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            e.printStackTrace();
            throw new ResourceServiceException(e);
        }
    }

    public void collectionProcessComplete() throws ResourceServiceException {
        try {
            if (this.conn != null && this.conn.isOpen()) {
                VinciFrame query = new VinciFrame();
                query.fadd("vinci:COMMAND", "CollectionProcessComplete");
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_send_collection_complete__FINEST", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort()), query.toXML()});
                    UIMAFramework.getLogger(this.getClass()).log(Level.INFO, " Sending COLLECTION PROCESS COMPLETE TO Service\n" + query.toXML());
                }
                this.conn.sendAndReceive(query);
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_exception__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
            e.printStackTrace();
            throw new ResourceServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean shutdownService, boolean aDoSendNotification) {
        block20: {
            if (System.getProperty("SHOW_STATS") != null) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_time_spent_serializing_xcas__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.totalSerializeTime)});
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_time_spent_deserializing_xcas__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.totalDeSerializeTime)});
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_time_spent_in_transit__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(this.totalRoundTripTime)});
            }
            try {
                Object query;
                if (!this.isConnected()) break block20;
                if (aDoSendNotification) {
                    this.collectionProcessComplete();
                }
                if (!shutdownService) break block20;
                try {
                    query = new VinciFrame();
                    ((Frame)query).fadd("vinci:COMMAND", "Shutdown");
                    if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_stopping_service__INFO", new Object[]{Thread.currentThread().getName(), this.conn.getHost(), String.valueOf(this.conn.getPort()), ((Frame)query).toXML()});
                    }
                    this.conn.send((Transportable)query);
                }
                finally {
                    query = this.conn;
                    synchronized (query) {
                        this.conn.wait(500L);
                    }
                    if (this.fencedProcessPID != null) {
                        new FencedProcessReaper().killProcess(this.fencedProcessPID);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_exception__SEVERE", new Object[]{Thread.currentThread().getName(), ex.getMessage()});
                boolean bl = false;
                return bl;
            }
            finally {
                if (this.conn != null) {
                    if (shutdownService) {
                        this.waitForServiceShutdown();
                    }
                    this.conn.close();
                }
            }
        }
        return true;
    }

    private void waitForServiceShutdown() {
        int retry = 10;
        do {
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_waiting_for_service_shutdown__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(10 - retry), "10"});
                }
                Thread.sleep(100L);
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, " Resuming CPE shutdown.Service should be down now.");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (retry-- > 0 && this.conn.isOpen());
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_shutdown_completed__FINEST", new Object[]{Thread.currentThread().getName()});
        }
    }

    public boolean isConnected() {
        return this.conn != null && this.conn.isOpen();
    }

    public void setVNSPort(String aVNSPort) {
        System.setProperty("VNS_PORT", aVNSPort);
        this.vnsPort = aVNSPort;
    }

    public void setVNSHost(String aVNSHost) {
        this.vnsHost = aVNSHost;
        System.setProperty("VNS_HOST", aVNSHost);
    }

    public int getServicePort() {
        return Integer.valueOf(this.servicePort);
    }

    public String getServiceHost() {
        return this.serviceHost;
    }

    public String getVNSPort() {
        return this.vnsPort;
    }

    public String getVNSHost() {
        return this.vnsHost;
    }

    private FeatureStructure getDocTextFeatureStructure(CasData aCasData) {
        Iterator<FeatureStructure> fsIterator = aCasData.getFeatureStructures();
        if (fsIterator.hasNext()) {
            FeatureStructure casDataFs = fsIterator.next();
            if (VinciTAP.isText(casDataFs.getType())) {
                return casDataFs;
            }
            if (fsIterator.hasNext() && VinciTAP.isText((casDataFs = fsIterator.next()).getType())) {
                return casDataFs;
            }
        }
        return null;
    }
}

