/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer.vns;

import java.io.IOException;
import java.net.BindException;
import java.net.PortUnreachableException;
import java.net.ServerSocket;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.impl.cpm.engine.BoundedWorkQueue;
import org.apache.uima.util.Level;
import org.apache.vinci.transport.BaseClient;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.VinciServableAdapter;
import org.apache.vinci.transport.VinciServer;

public class LocalVNS
extends VinciServableAdapter
implements Runnable {
    private int onport;
    private int startport = 11111;
    private int maxport = 12331;
    private int vnsPort = 9001;
    private VinciServer server = null;
    private BoundedWorkQueue portQueue = null;

    public LocalVNS() {
    }

    public LocalVNS(String aStartPort, String aEndPort, String aVNSPort) throws PortUnreachableException {
        if (aStartPort != null) {
            try {
                this.startport = Integer.parseInt(aStartPort);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (aEndPort != null) {
            try {
                this.maxport = Integer.parseInt(aEndPort);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (aVNSPort != null) {
            try {
                this.vnsPort = Integer.parseInt(aVNSPort);
                boolean vnsPortAvailable = false;
                int currentRetryCount = 0;
                while (!vnsPortAvailable) {
                    if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_test_vns_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.vnsPort)});
                    }
                    vnsPortAvailable = this.isAvailable(this.vnsPort);
                    if (currentRetryCount > 100) {
                        throw new PortUnreachableException("Unable to aquire a port for VNS Service");
                    }
                    if (!vnsPortAvailable) {
                        ++this.vnsPort;
                    }
                    ++currentRetryCount;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_vns_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.vnsPort)});
        }
        this.onport = this.startport;
    }

    public LocalVNS(int aStartPort, int aEndPort, int aVNSPort) throws PortUnreachableException {
        this.startport = aStartPort;
        this.maxport = aEndPort;
        this.vnsPort = aVNSPort;
        boolean vnsPortAvailable = false;
        int currentRetryCount = 0;
        while (!vnsPortAvailable) {
            if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_test_vns_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.vnsPort)});
            }
            vnsPortAvailable = this.isAvailable(this.vnsPort);
            if (currentRetryCount > 100) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_vns_port_not_available__SEVERE", new Object[]{Thread.currentThread().getName(), String.valueOf(this.vnsPort)});
                throw new PortUnreachableException("Unable to aquire a port for VNS Service");
            }
            if (!vnsPortAvailable) {
                ++this.vnsPort;
            }
            ++currentRetryCount;
        }
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_activating_vns_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.vnsPort)});
        }
        this.onport = this.startport;
    }

    public synchronized void setConnectionPool(BoundedWorkQueue pQueue) {
        this.portQueue = pQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isAvailable(int port) {
        boolean bl;
        ServerSocket socket;
        block15: {
            socket = null;
            socket = new ServerSocket(port);
            bl = true;
            if (socket == null) break block15;
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_test_local_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(port)});
                }
                socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return bl;
        catch (Exception e) {
            if (socket != null) {
                try {
                    if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_test_local_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(port)});
                    }
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_test_local_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(port)});
                        }
                        socket.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return false;
    }

    public int getVNSPort() {
        return this.vnsPort;
    }

    public synchronized int getPort() throws PortUnreachableException {
        boolean portAvailable = false;
        int retryCount = 0;
        while (!portAvailable) {
            ++this.onport;
            if (this.onport > this.maxport) {
                this.onport = this.startport;
                ++retryCount;
            }
            if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_test_local_port__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.onport)});
            }
            portAvailable = this.isAvailable(this.onport);
            if (retryCount <= 3) continue;
            throw new PortUnreachableException("Unable to aquire any of the ports in configured range:[" + this.startport + ".." + this.maxport + "]");
        }
        return this.onport;
    }

    @Override
    public synchronized Transportable eval(Transportable in) throws ServiceException {
        try {
            String cmd;
            VinciFrame input = (VinciFrame)in;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger().log(Level.FINEST, input.toXML());
            }
            if ((cmd = input.fgetString("vinci:COMMAND")).equals("shutdown")) {
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_deactivating_vns_port__INFO", new Object[]{Thread.currentThread().getName()});
                }
                this.cleanExit();
                return input;
            }
            if (cmd.equals("serveon")) {
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_vns_process_serveon__FINEST", new Object[]{Thread.currentThread().getName()});
                }
                int port = this.getPort();
                input.fdrop("vinci:COMMAND");
                input.fadd("IP", "127.0.0.1");
                input.fadd("PORT", port);
                try {
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_assign_service_port__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(port)});
                    }
                    this.portQueue.enqueue(String.valueOf(port));
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_assign_service_port_complete__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(port)});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, input.toXML());
                    UIMAFramework.getLogger().log(Level.FINEST, input.toXML());
                }
                return input;
            }
            if (cmd.equals("resolve")) {
                String publicVNSHost = System.getProperty("PVNS_HOST");
                String publicVNSPort = System.getProperty("PVNS_PORT");
                if (publicVNSHost == null || publicVNSHost.trim().length() == 0 || publicVNSPort == null || publicVNSPort.trim().length() == 0) {
                    if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unknown_vns_command__WARNING", new Object[]{Thread.currentThread().getName()});
                    }
                    VinciFrame rtn = new VinciFrame();
                    rtn.fadd("vinci:EXCEPTION", "CPM Reply:Public VNS not known. Verify CPMs startup param include -DVNS_HOST and -DVNS_PORT");
                    return rtn;
                }
                int pvnsPort = -1;
                try {
                    pvnsPort = Integer.parseInt(publicVNSPort);
                }
                catch (NumberFormatException e) {
                    if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unknown_vns_command__WARNING", new Object[]{Thread.currentThread().getName()});
                    }
                    VinciFrame rtn = new VinciFrame();
                    rtn.fadd("vinci:EXCEPTION", "CPM Reply: Invalid VNS Port value::" + publicVNSPort);
                    return rtn;
                }
                if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_vns_redirect__FINEST", new Object[]{Thread.currentThread().getName(), publicVNSHost, publicVNSPort});
                }
                BaseClient client = new BaseClient(publicVNSHost, pvnsPort);
                return client.sendAndReceive(in);
            }
            if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_unknown_vns_command__WARNING", new Object[]{Thread.currentThread().getName()});
            }
            VinciFrame rtn = new VinciFrame();
            rtn.fadd("vinci:EXCEPTION", "Unknown command");
            return rtn;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex.getMessage());
        }
    }

    public void shutdown() {
        if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_vns_shutdown__INFO", new Object[]{Thread.currentThread().getName()});
        }
        try {
            this.cleanExit();
            if (this.server != null) {
                this.server.shutdownServing();
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_vns_stopped_serving__INFO", new Object[]{Thread.currentThread().getName()});
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
            UIMAFramework.getLogger(this.getClass()).log(Level.FINEST, "*************Finalizing VNS***************");
        }
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void run() {
        boolean done = false;
        Thread.currentThread().setName("VNS-Thread");
        while (!done) {
            try {
                if (UIMAFramework.getLogger().isLoggable(Level.INFO)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.INFO, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_launching_local_vns__INFO", new Object[]{Thread.currentThread().getName(), String.valueOf(this.vnsPort)});
                }
                this.server = new VinciServer(this);
                this.server.serve(this.vnsPort);
                done = true;
            }
            catch (BindException e) {
                ++this.vnsPort;
            }
            catch (Exception e) {
                if (UIMAFramework.getLogger().isLoggable(Level.SEVERE)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.SEVERE, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_launching_local_vns_failed__SEVERE", new Object[]{Thread.currentThread().getName(), e.getMessage()});
                }
                e.printStackTrace();
            }
        }
    }
}

