/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer.vns;

import java.net.ConnectException;
import java.util.ArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.impl.cpm.container.deployer.vns.VinciServiceInfo;
import org.apache.uima.util.Level;
import org.apache.vinci.transport.BaseClient;
import org.apache.vinci.transport.VinciFrame;

public class VNSQuery {
    private VinciVNSQuery vnsQuery = null;

    public VNSQuery(String aVnsHost, int aVnsPort) throws Exception {
        this.vnsQuery = new VinciVNSQuery(aVnsHost, aVnsPort);
    }

    public ArrayList getServices(String aName) throws Exception {
        return this.vnsQuery.getVinciServices(aName);
    }

    public ArrayList getUnassignedServices(String aName, ArrayList assignedServices) throws Exception {
        ArrayList newList = this.getServices(aName);
        VNSQuery.findUnassigned(assignedServices, newList);
        return newList;
    }

    public static int findUnassigned(ArrayList oldList, ArrayList newList) {
        int newServiceCount = 0;
        for (int i = 0; i < newList.size(); ++i) {
            VinciServiceInfo service = (VinciServiceInfo)newList.get(i);
            if (!VNSQuery.newService(service, oldList)) {
                ((VinciServiceInfo)newList.get(i)).setAvailable(false);
                continue;
            }
            ++newServiceCount;
        }
        return newServiceCount;
    }

    private static boolean newService(VinciServiceInfo aService, ArrayList oldList) {
        for (int i = 0; i < oldList.size(); ++i) {
            VinciServiceInfo service = (VinciServiceInfo)oldList.get(i);
            if (!aService.getHost().equals(service.getHost()) || aService.getPort() != service.getPort() || service.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args2) {
        try {
            VNSQuery vq = new VNSQuery(args2[0], Integer.parseInt(args2[1]));
            ArrayList list = vq.getServices(args2[2]);
            System.out.println("Got::" + list.size() + " Services");
            BaseClient client = null;
            for (int i = 0; i < list.size(); ++i) {
                Object ob = list.get(i);
                if (ob == null) continue;
                System.out.println(((VinciServiceInfo)ob).toString());
                VinciServiceInfo serviceInfo = (VinciServiceInfo)ob;
                if (serviceInfo == null) continue;
                try {
                    client = new BaseClient(serviceInfo.getHost(), serviceInfo.getPort());
                    if (!client.isOpen()) continue;
                    System.out.println("Service::" + serviceInfo.getServiceName() + " is alive");
                    continue;
                }
                catch (ConnectException ce) {
                    System.out.println("Service::" + serviceInfo.getServiceName() + " is down");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class VinciVNSQuery {
        private String vnsHost;
        private int vnsPort;
        BaseClient vnsConnection = null;

        public VinciVNSQuery(String aVnsHost, int aVnsPort) throws Exception {
            this.vnsHost = aVnsHost;
            this.vnsPort = aVnsPort;
            this.vnsConnection = new BaseClient(this.vnsHost, this.vnsPort);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList getVinciServices(String aVinciServiceName) throws Exception {
            ArrayList<VinciServiceInfo> serviceList = new ArrayList<VinciServiceInfo>();
            BaseClient client = null;
            if (this.vnsConnection != null && this.vnsConnection.isOpen()) {
                VinciFrame queryFrame = new VinciFrame();
                queryFrame.fadd("vinci:COMMAND", "getlist");
                queryFrame.fadd("PREFIX", aVinciServiceName);
                VinciFrame response = (VinciFrame)this.vnsConnection.sendAndReceive(queryFrame);
                ArrayList serviceFrames = response.fget("SERVICE");
                for (int i = 0; i < serviceFrames.size(); ++i) {
                    VinciFrame serviceFrame = (VinciFrame)serviceFrames.get(i);
                    VinciServiceInfo serviceInfo = this.getServiceInfo(serviceFrame);
                    if (serviceInfo == null) continue;
                    try {
                        client = new BaseClient(serviceInfo.getHost(), serviceInfo.getPort());
                        if (!client.isOpen()) continue;
                        if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                            UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_active_on_port__FINEST", new Object[]{Thread.currentThread().getName(), serviceInfo.getServiceName(), serviceInfo.getHost(), String.valueOf(serviceInfo.getPort())});
                        }
                        serviceList.add(serviceInfo);
                        continue;
                    }
                    catch (ConnectException ce) {
                        if (!UIMAFramework.getLogger().isLoggable(Level.WARNING)) continue;
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_service_not_active_on_port__WARNING", new Object[]{Thread.currentThread().getName(), serviceInfo.getServiceName(), serviceInfo.getHost(), String.valueOf(serviceInfo.getPort())});
                        continue;
                    }
                    finally {
                        if (client != null) {
                            try {
                                client.close();
                            }
                            catch (Exception ex) {}
                        }
                    }
                }
            }
            return serviceList;
        }

        private VinciServiceInfo getServiceInfo(VinciFrame aServiceFrame) {
            String serviceName = aServiceFrame.fgetString("NAME");
            String service_host_IP = aServiceFrame.fgetString("IP");
            int service_port = aServiceFrame.fgetInt("PORT");
            VinciServiceInfo serviceInfo = new VinciServiceInfo(serviceName, service_host_IP, service_port);
            return serviceInfo;
        }
    }
}

