/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.vinci;

import java.util.Iterator;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.FeatureStructure;
import org.apache.uima.cas_data.FeatureValue;
import org.apache.uima.cas_data.PrimitiveValue;
import org.apache.vinci.transport.BaseClient;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.TransportableFactory;
import org.apache.vinci.transport.VinciClient;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.document.AFrame;

public class Vinci {
    public static final String VNS_HOST = "VNS_HOST";
    public static final String VNS_PORT = "VNS_PORT";

    private AFrame getAFrame() {
        return new AFrame();
    }

    public VinciFrame replyWithError(String errorMsg) {
        AFrame aFrame = this.getAFrame();
        aFrame.fadd("Error", errorMsg);
        return aFrame;
    }

    public static AFrame replyWithAnalysis(BaseClient conn, VinciFrame requestFrame) throws Exception {
        AFFactory af = new AFFactory();
        return (AFrame)conn.sendAndReceive((Transportable)requestFrame, af);
    }

    public static AFrame replyWithAnalysis(VinciClient conn, VinciFrame requestFrame) throws Exception {
        AFFactory af = new AFFactory();
        return (AFrame)conn.sendAndReceive((Transportable)requestFrame, af);
    }

    public static AFrame produceAFrame(String cmd, String content) {
        AFrame query = new AFrame();
        query.fadd("vinci:COMMAND", "Annotate");
        AFrame keys2 = new AFrame();
        keys2.fadd("Detag:DetagContent", content);
        AFrame data = new AFrame();
        data.fadd("KEYS", keys2);
        query.fadd("DATA", data);
        return query;
    }

    public static String extractKEYSAsString(AFrame frame) {
        String keys2 = "";
        if (frame == null) {
            return keys2;
        }
        String frameAsString = frame.toXML();
        if (frameAsString.indexOf("KEYS") > -1 && frameAsString.indexOf("</KEYS>") > -1) {
            keys2 = frameAsString.substring(frameAsString.indexOf("KEYS") + 5, frameAsString.indexOf("</KEYS>"));
        }
        return keys2;
    }

    public static String getFeatureValueByType(CasData aCAS, String featureName) {
        if (aCAS == null) {
            return "";
        }
        Iterator<FeatureStructure> it = aCAS.getFeatureStructures();
        String featureValue = null;
        while (it.hasNext()) {
            FeatureStructure fs = it.next();
            FeatureValue fValue = fs.getFeatureValue(featureName);
            if (fValue == null) continue;
            featureValue = fValue.toString();
            break;
        }
        return featureValue;
    }

    public static String getContentFromDATACas(CasData aCas) {
        Iterator<FeatureStructure> it = aCas.getFeatureStructures();
        while (it.hasNext()) {
            FeatureStructure fs = it.next();
            if (!"uima.cpm.DocumentText".equals(fs.getType())) continue;
            return ((PrimitiveValue)fs.getFeatureValue("value")).toString();
        }
        return "";
    }

    public static String stripVinciFrame(VinciFrame aFrame) {
        String contentFrame = aFrame.toXML();
        int pos = contentFrame.indexOf(">");
        int end = contentFrame.lastIndexOf("</vinci:FRAME>");
        if (pos == -1 || end == -1) {
            return null;
        }
        return contentFrame.substring(pos + 1, end - 1);
    }

    public static class AFFactory
    implements TransportableFactory {
        @Override
        public Transportable makeTransportable() {
            return new AFrame();
        }
    }
}

