/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cas;

import java.util.Arrays;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class PersonTitleAnnotator
extends CasAnnotator_ImplBase {
    private Type mPersonTitleType;
    private Type mContainingType;
    private Feature mPersonTitleKindFeature;
    private String[] mCivilianTitles;
    private String[] mMilitaryTitles;
    private String[] mGovernmentTitles;
    private boolean warningMsgShown = false;
    private Logger logger;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mCivilianTitles = (String[])this.getContext().getConfigParameterValue("CivilianTitles");
        this.mMilitaryTitles = (String[])this.getContext().getConfigParameterValue("MilitaryTitles");
        this.mGovernmentTitles = (String[])this.getContext().getConfigParameterValue("GovernmentTitles");
        this.logger = this.getContext().getLogger();
        this.logger.log(Level.CONFIG, "PersonTitleAnnotator initialized");
        this.logger.log(Level.CONFIG, "CivilianTitles = " + Arrays.asList(this.mCivilianTitles));
        this.logger.log(Level.CONFIG, "MilitaryTitles = " + Arrays.asList(this.mMilitaryTitles));
        this.logger.log(Level.CONFIG, "GovernmentTitles = " + Arrays.asList(this.mGovernmentTitles));
    }

    @Override
    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        this.mPersonTitleType = aTypeSystem.getType("example.PersonTitle");
        if (this.mPersonTitleType == null) {
            throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{this.getClass().getName(), "example.PersonTitle"});
        }
        this.mPersonTitleKindFeature = this.mPersonTitleType.getFeatureByBaseName("Kind");
        if (this.mPersonTitleKindFeature == null) {
            throw new AnalysisEngineProcessException("annotator_ex_feature_not_found", new Object[]{this.getClass().getName(), "example.PersonTitle:Kind"});
        }
        String containingTypeName = (String)this.getContext().getConfigParameterValue("ContainingAnnotationType");
        if (containingTypeName != null) {
            this.mContainingType = aTypeSystem.getType(containingTypeName);
            if (this.mContainingType == null) {
                throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{this.getClass().getName(), containingTypeName});
            }
        }
    }

    @Override
    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        try {
            if (!this.getResultSpecification().containsType("example.PersonTitle", aCAS.getDocumentLanguage())) {
                if (!this.warningMsgShown) {
                    String m3 = String.format("No output is being produced by the PersonTitleAnnotator because the Result Specification did not contain a request for the type example.PersonTitle with the language '%s'%n  (Note: this message will only be shown once.)%n", aCAS.getDocumentLanguage());
                    System.err.println(m3);
                    this.logger.log(Level.WARNING, m3);
                    this.warningMsgShown = true;
                }
                return;
            }
            if (this.mContainingType == null) {
                String text = aCAS.getDocumentText();
                this.annotateRange(aCAS, text, 0);
            } else {
                FSIterator it = aCAS.getAnnotationIndex(this.mContainingType).iterator();
                while (it.isValid()) {
                    AnnotationFS annot = (AnnotationFS)it.get();
                    String coveredText = annot.getCoveredText();
                    int annotBegin = annot.getBegin();
                    this.annotateRange(aCAS, coveredText, annotBegin);
                    it.moveToNext();
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    protected void annotateRange(CAS aCAS, String aText, int aBeginPos) {
        this.annotateRange(aCAS, aText, aBeginPos, "Civilian", this.mCivilianTitles);
        this.annotateRange(aCAS, aText, aBeginPos, "Military", this.mMilitaryTitles);
        this.annotateRange(aCAS, aText, aBeginPos, "Government", this.mGovernmentTitles);
    }

    protected void annotateRange(CAS aCAS, String aText, int aBeginPos, String aTitleType, String[] aTitles) {
        for (int i = 0; i < aTitles.length; ++i) {
            int start = aText.indexOf(aTitles[i]);
            while (start >= 0) {
                int end = start + aTitles[i].length();
                int absStart = aBeginPos + start;
                int absEnd = aBeginPos + end;
                this.getContext().getLogger().log(Level.FINER, "Found \"" + aTitles[i] + "\" at (" + absStart + "," + absEnd + ")");
                this.createAnnotation(aCAS, absStart, absEnd, aTitleType);
                start = aText.indexOf(aTitles[i], end);
            }
        }
    }

    protected void createAnnotation(CAS aCAS, int aBeginPos, int aEndPos, String aTitleType) {
        AnnotationFS title = aCAS.createAnnotation(this.mPersonTitleType, aBeginPos, aEndPos);
        if (this.getResultSpecification().containsFeature("example.PersonTitle:Kind", aCAS.getDocumentLanguage())) {
            title.setStringValue(this.mPersonTitleKindFeature, aTitleType);
        }
        aCAS.getIndexRepository().addFS(title);
    }
}

