/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.casMultiplier;

import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.examples.SourceDocumentInformation;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;

public class SimpleTextSegmenter
extends JCasMultiplier_ImplBase {
    private String mDoc;
    private int mPos;
    private int mSegmentSize;
    private String mDocUri;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mSegmentSize = (Integer)aContext.getConfigParameterValue("SegmentSize");
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        this.mDoc = aJCas.getDocumentText();
        this.mPos = 0;
        FSIterator it = aJCas.getAnnotationIndex(SourceDocumentInformation.type).iterator();
        if (it.hasNext()) {
            SourceDocumentInformation fileLoc = (SourceDocumentInformation)it.next();
            this.mDocUri = fileLoc.getUri();
        } else {
            this.mDocUri = null;
        }
    }

    @Override
    public boolean hasNext() throws AnalysisEngineProcessException {
        return this.mPos < this.mDoc.length();
    }

    @Override
    public AbstractCas next() throws AnalysisEngineProcessException {
        int breakAt = this.mPos + this.mSegmentSize;
        if (breakAt > this.mDoc.length()) {
            breakAt = this.mDoc.length();
        }
        while (breakAt < this.mDoc.length() && this.mDoc.charAt(breakAt - 1) != '\n') {
            ++breakAt;
        }
        JCas jcas = this.getEmptyJCas();
        try {
            jcas.setDocumentText(this.mDoc.substring(this.mPos, breakAt));
            if (this.mDocUri != null) {
                SourceDocumentInformation sdi = new SourceDocumentInformation(jcas);
                sdi.setUri(this.mDocUri);
                sdi.setOffsetInSource(this.mPos);
                sdi.setDocumentSize(breakAt - this.mPos);
                sdi.addToIndexes();
                if (breakAt == this.mDoc.length()) {
                    sdi.setLastSegment(true);
                }
            }
            this.mPos = breakAt;
            return jcas;
        }
        catch (Exception e) {
            jcas.release();
            throw new AnalysisEngineProcessException(e);
        }
    }
}

