/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cpe;

import java.io.IOException;
import java.util.List;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionProcessingManager;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.XMLInputSource;

public class SimpleRunCPM
extends Thread {
    private CollectionProcessingManager mCPM;
    private long mStartTime = System.currentTimeMillis();

    public SimpleRunCPM(String[] args2) throws UIMAException, IOException {
        if (args2.length < 3) {
            SimpleRunCPM.printUsageMessage();
            System.exit(1);
        }
        System.out.println("Initializing Collection Reader");
        CollectionReaderDescription colReaderSpecifier = UIMAFramework.getXMLParser().parseCollectionReaderDescription(new XMLInputSource(args2[0]));
        CollectionReader collectionReader = UIMAFramework.produceCollectionReader(colReaderSpecifier);
        System.out.println("Initializing AnalysisEngine");
        ResourceSpecifier aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(args2[1]));
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(aeSpecifier);
        System.out.println("Initializing CAS Consumer");
        CasConsumerDescription consumerSpecifier = UIMAFramework.getXMLParser().parseCasConsumerDescription(new XMLInputSource(args2[2]));
        CasConsumer casConsumer = UIMAFramework.produceCasConsumer(consumerSpecifier);
        this.mCPM = UIMAFramework.newCollectionProcessingManager();
        this.mCPM.setAnalysisEngine(ae);
        this.mCPM.addCasConsumer(casConsumer);
        this.mCPM.addStatusCallbackListener(new StatusCallbackListenerImpl());
        this.mCPM.setPauseOnException(false);
        this.mCPM.process(collectionReader, 10);
    }

    private static void printUsageMessage() {
        System.out.println(" Arguments to the program are as follows : \nargs[0] : Collection Reader descriptor file \n args[1] : Analysis Engine descriptor file. \nargs[2] : CAS Consumer descriptor file");
    }

    public static void main(String[] args2) throws UIMAException, IOException {
        new SimpleRunCPM(args2);
    }

    class StatusCallbackListenerImpl
    implements StatusCallbackListener {
        int entityCount = 0;
        long size = 0L;

        StatusCallbackListenerImpl() {
        }

        @Override
        public void initializationComplete() {
            System.out.println("CPM Initialization Complete");
        }

        @Override
        public void batchProcessComplete() {
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long elapsedTime = System.currentTimeMillis() - SimpleRunCPM.this.mStartTime;
            System.out.println("Time Elapsed : " + elapsedTime + " ms ");
        }

        @Override
        public void collectionProcessComplete() {
            System.out.print("Completed " + this.entityCount + " documents");
            if (this.size > 0L) {
                System.out.print("; " + this.size + " characters");
            }
            System.out.println();
            long elapsedTime = System.currentTimeMillis() - SimpleRunCPM.this.mStartTime;
            System.out.println("Time Elapsed : " + elapsedTime + " ms ");
            System.out.println("\n\n ------------------ PERFORMANCE REPORT ------------------\n");
            System.out.println(SimpleRunCPM.this.mCPM.getPerformanceReport().toString());
        }

        @Override
        public void paused() {
            System.out.println("Paused");
        }

        @Override
        public void resumed() {
            System.out.println("Resumed");
        }

        @Override
        public void aborted() {
            System.out.println("Aborted");
        }

        @Override
        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
            if (aStatus.isException()) {
                List<Exception> exceptions = aStatus.getExceptions();
                for (int i = 0; i < exceptions.size(); ++i) {
                    ((Throwable)exceptions.get(i)).printStackTrace();
                }
                return;
            }
            ++this.entityCount;
            String docText = aCas.getDocumentText();
            if (docText != null) {
                this.size += (long)docText.length();
            }
        }
    }
}

