/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.flow.CasFlowController_ImplBase;
import org.apache.uima.flow.CasFlow_ImplBase;
import org.apache.uima.flow.FinalStep;
import org.apache.uima.flow.Flow;
import org.apache.uima.flow.FlowControllerContext;
import org.apache.uima.flow.SimpleStep;
import org.apache.uima.flow.Step;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class WhiteboardFlowController2
extends CasFlowController_ImplBase {
    private Collection mComponentInfo = new ArrayList();
    private Logger mLogger;

    @Override
    public void initialize(FlowControllerContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mLogger = aContext.getLogger();
    }

    @Override
    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(aTypeSystem);
        for (Map.Entry<String, AnalysisEngineMetaData> entry : this.getContext().getAnalysisEngineMetaDataMap().entrySet()) {
            String aeKey = entry.getKey();
            AnalysisEngineMetaData md = entry.getValue();
            Capability[] capabilities = md.getCapabilities();
            ComponentInfo compInfo = new ComponentInfo();
            compInfo.key = aeKey;
            compInfo.inputTypesByCapability = new Type[capabilities.length][];
            for (int i = 0; i < capabilities.length; ++i) {
                ArrayList<Type> inputTypes = new ArrayList<Type>();
                TypeOrFeature[] inputs = capabilities[i].getInputs();
                for (int j = 0; j < inputs.length; ++j) {
                    Type typeHandle;
                    if (!inputs[j].isType() || (typeHandle = aTypeSystem.getType(inputs[j].getName())) == null) continue;
                    inputTypes.add(typeHandle);
                }
                compInfo.inputTypesByCapability[i] = new Type[inputTypes.size()];
                inputTypes.toArray(compInfo.inputTypesByCapability[i]);
            }
            this.mComponentInfo.add(compInfo);
        }
    }

    @Override
    public Flow computeFlow(CAS aCAS) throws AnalysisEngineProcessException {
        WhiteboardFlow flow = new WhiteboardFlow();
        return flow;
    }

    private static class ComponentInfo {
        String key;
        Type[][] inputTypesByCapability;

        private ComponentInfo() {
        }
    }

    class WhiteboardFlow
    extends CasFlow_ImplBase {
        private Set mAlreadyCalled = new HashSet();

        WhiteboardFlow() {
        }

        @Override
        public Step next() throws AnalysisEngineProcessException {
            CAS cas = this.getCas();
            for (ComponentInfo componentInfo : WhiteboardFlowController2.this.mComponentInfo) {
                if (this.mAlreadyCalled.contains(componentInfo.key)) continue;
                boolean satisfied = false;
                for (int i = 0; i < componentInfo.inputTypesByCapability.length && !(satisfied = this.casContainsTypes(cas, componentInfo.inputTypesByCapability[i])); ++i) {
                }
                if (!satisfied) continue;
                this.mAlreadyCalled.add(componentInfo.key);
                if (WhiteboardFlowController2.this.mLogger.isLoggable(Level.FINEST)) {
                    WhiteboardFlowController2.this.getContext().getLogger().log(Level.FINEST, "Next AE is: " + componentInfo.key);
                }
                return new SimpleStep(componentInfo.key);
            }
            WhiteboardFlowController2.this.getContext().getLogger().log(Level.FINEST, "Flow Complete.");
            return new FinalStep();
        }

        private boolean casContainsTypes(CAS aCAS, Type[] aTypes) {
            for (int i = 0; i < aTypes.length; ++i) {
                FSIterator iter = aCAS.getIndexRepository().getAllIndexedFS(aTypes[i]);
                if (iter.hasNext()) continue;
                return false;
            }
            return true;
        }
    }
}

