/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.CompositeResourceFactory;
import org.apache.uima.ResourceFactory;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionProcessingManager;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.impl.CompositeResourceFactory_impl;
import org.apache.uima.impl.ResourceSpecifierFactory_impl;
import org.apache.uima.impl.UimaVersion;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.SimpleResourceFactory;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.impl.XMLParser_impl;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class UIMAFramework_impl
extends UIMAFramework {
    public static final boolean debug = false;
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final String LOGGER_CLASS_SYSTEM_PROPERTY = "org.apache.uima.logger.class";
    private static final Class<UIMAFramework_impl> CLASS_NAME = UIMAFramework_impl.class;
    private CompositeResourceFactory mResourceFactory;
    private ResourceSpecifierFactory mResourceSpecifierFactory;
    private XMLParser mXMLParser;
    private Class mLoggerClass;
    private Logger mDefaultLogger;
    private String mCpmImplClassName;
    private String mResourceManagerImplClassName;
    private String mResourceManagerPearWrapperImplClassName;
    private String mConfigurationManagerImplClassName;
    private String mUimaContextImplClassName;
    private String mCpeClassName;
    private String mTimerClassName;
    private Properties mDefaultPerformanceTuningProperties;
    private ConcurrentHashMap<String, Logger> mLoggers;

    @Override
    protected void _initialize() throws Exception {
        Introspector.setBeanInfoSearchPath(new String[0]);
        this.mResourceFactory = new CompositeResourceFactory_impl();
        this.mXMLParser = new XMLParser_impl();
        this.mResourceSpecifierFactory = new ResourceSpecifierFactory_impl();
        this.parseFactoryConfig();
        this.mDefaultPerformanceTuningProperties = new Properties();
        this.mDefaultPerformanceTuningProperties.load(UIMAFramework_impl.class.getResourceAsStream("performanceTuning.properties"));
        this.mLoggers = new ConcurrentHashMap(200, 1.0f);
    }

    @Override
    public short _getMajorVersion() {
        return UimaVersion.getMajorVersion();
    }

    @Override
    public short _getMinorVersion() {
        return UimaVersion.getMinorVersion();
    }

    @Override
    public short _getBuildRevision() {
        return UimaVersion.getBuildRevision();
    }

    @Override
    protected CompositeResourceFactory _getResourceFactory() {
        return this.mResourceFactory;
    }

    @Override
    protected ResourceSpecifierFactory _getResourceSpecifierFactory() {
        return this.mResourceSpecifierFactory;
    }

    @Override
    protected XMLParser _getXMLParser() {
        return this.mXMLParser;
    }

    @Override
    protected CollectionProcessingManager _newCollectionProcessingManager(ResourceManager aResourceManager) {
        try {
            Class<?> cpmClass = Class.forName(this.mCpmImplClassName);
            Constructor<?> constructor = cpmClass.getConstructor(ResourceManager.class);
            return (CollectionProcessingManager)constructor.newInstance(aResourceManager);
        }
        catch (InvocationTargetException e) {
            throw new UIMARuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected Logger _getLogger() {
        return this.mDefaultLogger;
    }

    protected Logger _getLogger(Class component) {
        Logger o = this.mLoggers.get(component.getName());
        if (o == null) {
            Class[] argumentTypes = new Class[]{Class.class};
            Object[] arguments = new Object[]{component};
            try {
                Method instanceMethod = this.mLoggerClass.getMethod("getInstance", argumentTypes);
                o = (Logger)instanceMethod.invoke(null, arguments);
            }
            catch (NoSuchMethodException e) {
                throw new UIMARuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new UIMARuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new UIMARuntimeException(e);
            }
            this.mLoggers.put(component.getName(), o);
        }
        return o;
    }

    @Override
    protected Logger _newLogger() {
        try {
            Method instanceMethod = this.mLoggerClass.getMethod("getInstance", new Class[0]);
            return (Logger)instanceMethod.invoke(null, (Object[])new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new UIMARuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected ResourceManager _newDefaultResourceManager() {
        try {
            return (ResourceManager)Class.forName(this.mResourceManagerImplClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UIMARuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected ResourceManager _newDefaultResourceManagerPearWrapper() {
        try {
            return (ResourceManager)Class.forName(this.mResourceManagerPearWrapperImplClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UIMARuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected ConfigurationManager _newConfigurationManager() {
        try {
            return (ConfigurationManager)Class.forName(this.mConfigurationManagerImplClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UIMARuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected UimaContextAdmin _newUimaContext() {
        try {
            return (UimaContextAdmin)Class.forName(this.mUimaContextImplClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UIMARuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected UimaTimer _newTimer() {
        try {
            return (UimaTimer)Class.forName(this.mTimerClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UIMARuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected CollectionProcessingEngine _produceCollectionProcessingEngine(CpeDescription aCpeDescription, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        try {
            CollectionProcessingEngine cpe = (CollectionProcessingEngine)Class.forName(this.mCpeClassName).newInstance();
            cpe.initialize(aCpeDescription, aAdditionalParams);
            return cpe;
        }
        catch (InstantiationException e) {
            throw new UIMARuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new UIMARuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new UIMARuntimeException(e);
        }
    }

    @Override
    protected Properties _getDefaultPerformanceTuningProperties() {
        return (Properties)this.mDefaultPerformanceTuningProperties.clone();
    }

    protected void parseFactoryConfig() throws ParserConfigurationException, SAXException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        FactoryConfigParseHandler handler = new FactoryConfigParseHandler();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        reader.parse(new InputSource(UIMAFramework_impl.class.getResourceAsStream("factoryConfig.xml")));
    }

    class FactoryConfigParseHandler
    extends DefaultHandler {
        static final int CONTEXT_NONE = 0;
        static final int CONTEXT_FACTORY_CONFIG = 1;
        static final int CONTEXT_RESOURCE_SPECIFIER = 2;
        static final int CONTEXT_RESOURCE = 3;
        static final int CONTEXT_SIMPLE_FACTORY = 4;
        private int context;
        private SimpleResourceFactory simpleFactory;
        private String simpleFactorySpecifierType;

        FactoryConfigParseHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.context = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("logger".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<logger>"}));
                }
                try {
                    String loggerClass = System.getProperty(UIMAFramework_impl.LOGGER_CLASS_SYSTEM_PROPERTY);
                    if (loggerClass == null) {
                        loggerClass = attributes.getValue("class");
                    }
                    UIMAFramework_impl.this.mLoggerClass = Class.forName(loggerClass);
                    Method instanceMethod = UIMAFramework_impl.this.mLoggerClass.getMethod("getInstance", new Class[0]);
                    UIMAFramework_impl.this.mDefaultLogger = (Logger)instanceMethod.invoke(null, (Object[])new Class[0]);
                    return;
                }
                catch (Exception e) {
                    throw new SAXException(e);
                }
            } else if ("cpm".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<cpm>"}));
                }
                UIMAFramework_impl.this.mCpmImplClassName = attributes.getValue("class");
                return;
            } else if ("resourceManager".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<resourceManager>"}));
                }
                UIMAFramework_impl.this.mResourceManagerImplClassName = attributes.getValue("class");
                return;
            } else if ("resourceManagerPearWrapper".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<resourceManagerPearWrapper>"}));
                }
                UIMAFramework_impl.this.mResourceManagerPearWrapperImplClassName = attributes.getValue("class");
                return;
            } else if ("configurationManager".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<configurationManager>"}));
                }
                UIMAFramework_impl.this.mConfigurationManagerImplClassName = attributes.getValue("class");
                return;
            } else if ("uimaContext".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<uimaContext>"}));
                }
                UIMAFramework_impl.this.mUimaContextImplClassName = attributes.getValue("class");
                return;
            } else if ("cpe".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<cpe>"}));
                }
                UIMAFramework_impl.this.mCpeClassName = attributes.getValue("class");
                return;
            } else if ("timer".equals(qName)) {
                if (this.context != 1) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<timer>"}));
                }
                UIMAFramework_impl.this.mTimerClassName = attributes.getValue("class");
                return;
            } else if ("resourceSpecifier".equals(qName)) {
                if (UIMAFramework_impl.this.mLoggerClass == null) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "expected_x_but_found_y", new Object[]{"<logger>", "<resourceSpecifier>"}));
                }
                this.context = 2;
                return;
            } else if ("resource".equals(qName)) {
                if (UIMAFramework_impl.this.mLoggerClass == null) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "expected_x_but_found_y", new Object[]{"<logger>", "<resource>"}));
                }
                this.context = 3;
                return;
            } else if ("simpleFactory".equals(qName)) {
                if (this.context != 3) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<simpleFactory>"}));
                }
                this.simpleFactory = new SimpleResourceFactory();
                this.simpleFactorySpecifierType = attributes.getValue("specifier");
                this.context = 4;
                return;
            } else if ("binding".equals(qName)) {
                if (this.context == 2) {
                    try {
                        UIMAFramework_impl.this.mXMLParser.addMapping(attributes.getValue("element"), attributes.getValue("class"));
                        UIMAFramework_impl.this.mResourceSpecifierFactory.addMapping(attributes.getValue("interface"), attributes.getValue("class"));
                        return;
                    }
                    catch (ClassNotFoundException e) {}
                    return;
                } else {
                    if (this.context != 4) throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<binding>"}));
                    try {
                        this.simpleFactory.addMapping(attributes.getValue("specifier"), attributes.getValue("resource"));
                        return;
                    }
                    catch (ClassNotFoundException e) {}
                }
                return;
            } else if ("customFactory".equals(qName)) {
                if (this.context != 3) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<customFactory>"}));
                }
                try {
                    Class<?> specifierClass = Class.forName(attributes.getValue("specifier"));
                    Class<?> factoryClass = Class.forName(attributes.getValue("factoryClass"));
                    ResourceFactory factory = (ResourceFactory)factoryClass.newInstance();
                    UIMAFramework_impl.this.mResourceFactory.registerFactory(specifierClass, factory);
                    return;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    return;
                }
            } else {
                if (!"factoryConfig".equals(qName)) throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "sax_unknown_element", new Object[]{qName}));
                if (this.context != 0) {
                    throw new SAXException(I18nUtil.localizeMessage("org.apache.uima.UIMAException_Messages", Locale.getDefault(), "element_unexpected_in_context", new Object[]{"<factoryConfig>"}));
                }
                this.context = 1;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("factoryConfig".equals(qName)) {
                this.context = 0;
            } else if ("resourceSpecifier".equals(qName) || "resource".equals(qName)) {
                this.context = 1;
            } else if ("simpleFactory".equals(qName)) {
                try {
                    Class<?> specifierClass = Class.forName(this.simpleFactorySpecifierType);
                    UIMAFramework_impl.this.mResourceFactory.registerFactory(specifierClass, this.simpleFactory);
                }
                catch (ClassNotFoundException e) {
                    UIMAFramework.getLogger(CLASS_NAME).logrb(Level.INFO, CLASS_NAME.getName(), "endElement", UIMAFramework_impl.LOG_RESOURCE_BUNDLE, "UIMA_class_in_framework_config_not_found__INFO", e.getLocalizedMessage());
                }
                this.context = 3;
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            if (UIMAFramework_impl.this._getLogger() != null) {
                UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "warning", UIMAFramework_impl.LOG_RESOURCE_BUNDLE, "UIMA_factory_config_parse__WARNING", e.getLocalizedMessage());
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new UIMARuntimeException(e);
        }
    }
}

