/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.ComponentInfo;
import org.apache.uima.cas.SofaID;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.impl.ChildUimaContext_impl;
import org.apache.uima.impl.SofaID_impl;
import org.apache.uima.impl.Util;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.CasManager;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.impl.ConfigurationManager_impl;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.util.Level;
import org.apache.uima.util.Settings;
import org.apache.uima.util.UriUtils;

public abstract class UimaContext_ImplBase
implements UimaContextAdmin {
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final String[] EMPTY_STRINGS = new String[0];
    private final ComponentInfo mComponentInfo = new ComponentInfoImpl();
    protected final String mQualifiedContextName;
    protected final Map<String, String> mSofaMappings;
    protected volatile int mCasPoolSize = 0;
    private volatile Properties mPerformanceTuningSettings;
    private volatile boolean mSofaAware;
    private volatile boolean mCasPoolCreated = false;
    protected final Set<CAS> mOutstandingCASes = Collections.newSetFromMap(new ConcurrentHashMap());
    protected final AnalysisEngineManagementImpl mMBean = new AnalysisEngineManagementImpl();
    private final String uniqueIdentifier;

    public UimaContext_ImplBase() {
        this.mQualifiedContextName = "/";
        this.uniqueIdentifier = this.constructUniqueName();
        this.mSofaMappings = new TreeMap<String, String>();
    }

    public UimaContext_ImplBase(String contextName, Map<String, String> sofaMappings) {
        this.mQualifiedContextName = contextName;
        this.uniqueIdentifier = this.constructUniqueName();
        this.mSofaMappings = sofaMappings;
    }

    private String constructUniqueName() {
        String u = new UID().toString();
        StringBuilder sb = new StringBuilder(u.length());
        sb.append(u);
        for (int i = u.length() - 1; i >= 0; --i) {
            char c = sb.charAt(i);
            if (c != ':' && c != '-') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    @Override
    public String getUniqueName() {
        return this.getQualifiedContextName() + "_" + this.uniqueIdentifier;
    }

    @Override
    public UimaContextAdmin createChild(String aContextName, Map<String, String> aSofaMappings) {
        ChildUimaContext_impl child = new ChildUimaContext_impl(this, aContextName, this.combineSofaMappings(aSofaMappings));
        this.mMBean.addComponent(aContextName, child.mMBean);
        return child;
    }

    public Map<String, String> combineSofaMappings(Map<String, String> aSofaMappings) {
        TreeMap<String, String> childSofaMap = new TreeMap<String, String>();
        childSofaMap.putAll(this.mSofaMappings);
        if (aSofaMappings != null) {
            for (Map.Entry<String, String> entry : aSofaMappings.entrySet()) {
                String childSofaName = entry.getKey();
                String thisContextSofaName = entry.getValue();
                String absoluteSofaName = this.mSofaMappings.get(thisContextSofaName);
                if (absoluteSofaName == null) {
                    absoluteSofaName = thisContextSofaName;
                }
                childSofaMap.put(childSofaName, absoluteSofaName);
            }
        }
        return childSofaMap;
    }

    @Override
    public Object getConfigParameterValue(String aName) {
        return this.getConfigurationManager().getConfigParameterValue(this.makeQualifiedName(aName));
    }

    @Override
    public Object getConfigParameterValue(String aGroupName, String aParamName) {
        return this.getConfigurationManager().getConfigParameterValue(this.makeQualifiedName(aParamName), aGroupName);
    }

    @Override
    public String getSharedSettingValue(String name) throws ResourceConfigurationException {
        Settings settings = this.getRootContext().getExternalOverrides();
        return settings == null ? null : settings.getSetting(name);
    }

    @Override
    public String[] getSharedSettingArray(String name) throws ResourceConfigurationException {
        Settings settings = this.getRootContext().getExternalOverrides();
        return settings == null ? null : settings.getSettingArray(name);
    }

    @Override
    public String[] getSharedSettingNames() {
        Settings settings = this.getRootContext().getExternalOverrides();
        if (settings == null) {
            return null;
        }
        Set<String> names = settings.getKeys();
        return names.toArray(new String[names.size()]);
    }

    @Override
    public URL getResourceURL(String aKey) throws ResourceAccessException {
        URL result = this.getResourceManager().getResourceURL(this.makeQualifiedName(aKey));
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceURL", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            return unmanagedResourceUrl;
        }
        return null;
    }

    @Override
    public URI getResourceURI(String aKey) throws ResourceAccessException {
        return this.getResourceURIfromURL(this.getResourceURL(aKey));
    }

    private URI getResourceURIfromURL(URL resourceUrl) throws ResourceAccessException {
        if (resourceUrl != null) {
            try {
                return UriUtils.quote(resourceUrl);
            }
            catch (URISyntaxException e) {
                throw new ResourceAccessException(e);
            }
        }
        return null;
    }

    @Override
    public String getResourceFilePath(String aKey) throws ResourceAccessException {
        URI resourceUri = this.getResourceURI(aKey);
        if (resourceUri != null) {
            if ("file".equals(resourceUri.getScheme())) {
                return resourceUri.getPath();
            }
            throw new ResourceAccessException();
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String aKey) throws ResourceAccessException {
        InputStream result = this.getResourceManager().getResourceAsStream(this.makeQualifiedName(aKey));
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceAsStream", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            try {
                return unmanagedResourceUrl.openStream();
            }
            catch (IOException e) {
                throw new ResourceAccessException(e);
            }
        }
        return null;
    }

    @Override
    public Object getResourceObject(String aKey) throws ResourceAccessException {
        return this.getResourceManager().getResource(this.makeQualifiedName(aKey));
    }

    @Override
    public InputStream getResourceAsStream(String aKey, String[] aParams) throws ResourceAccessException {
        InputStream result = this.getResourceManager().getResourceAsStream(this.makeQualifiedName(aKey), aParams);
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceAsStream", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            try {
                return unmanagedResourceUrl.openStream();
            }
            catch (IOException e) {
                throw new ResourceAccessException(e);
            }
        }
        return null;
    }

    @Override
    public Object getResourceObject(String aKey, String[] aParams) throws ResourceAccessException {
        return this.getResourceManager().getResource(this.makeQualifiedName(aKey), aParams);
    }

    @Override
    public URL getResourceURL(String aKey, String[] aParams) throws ResourceAccessException {
        URL result = this.getResourceManager().getResourceURL(this.makeQualifiedName(aKey), aParams);
        if (result != null) {
            return result;
        }
        URL unmanagedResourceUrl = null;
        try {
            unmanagedResourceUrl = this.getResourceManager().resolveRelativePath(aKey);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (unmanagedResourceUrl != null) {
            UIMAFramework.getLogger().logrb(Level.WARNING, this.getClass().getName(), "getResourceURL", LOG_RESOURCE_BUNDLE, "UIMA_unmanaged_resource__WARNING", new Object[]{aKey});
            return unmanagedResourceUrl;
        }
        return null;
    }

    @Override
    public URI getResourceURI(String aKey, String[] aParams) throws ResourceAccessException {
        return this.getResourceURIfromURL(this.getResourceURL(aKey, aParams));
    }

    @Override
    public String getResourceFilePath(String aKey, String[] aParams) throws ResourceAccessException {
        URI resourceUri = this.getResourceURI(aKey, aParams);
        if (resourceUri != null) {
            if ("file".equals(resourceUri.getScheme())) {
                return resourceUri.getPath();
            }
            throw new ResourceAccessException();
        }
        return null;
    }

    @Override
    public String getDataPath() {
        return this.getResourceManager().getDataPath();
    }

    protected String makeQualifiedName(String name) {
        return this.mQualifiedContextName + name;
    }

    @Override
    public String getQualifiedContextName() {
        return this.mQualifiedContextName;
    }

    @Override
    public String[] getConfigurationGroupNames() {
        ConfigurationGroup[] groups2 = this.getConfigurationManager().getConfigParameterDeclarations(this.getQualifiedContextName()).getConfigurationGroups();
        if (groups2 == null) {
            return EMPTY_STRINGS;
        }
        TreeSet<String> names = new TreeSet<String>();
        for (int i = 0; i < groups2.length; ++i) {
            names.addAll(Arrays.asList(groups2[i].getNames()));
        }
        String[] nameArray = new String[names.size()];
        names.toArray(nameArray);
        return nameArray;
    }

    @Override
    public String[] getConfigParameterNames() {
        ConfigurationParameter[] params = this.getConfigurationManager().getConfigParameterDeclarations(this.getQualifiedContextName()).getConfigurationParameters();
        if (params == null) {
            return EMPTY_STRINGS;
        }
        String[] names = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            names[i] = params[i].getName();
        }
        return names;
    }

    @Override
    public String[] getConfigParameterNames(String aGroup) {
        int i;
        ConfigurationGroup[] groups2 = this.getConfigurationManager().getConfigParameterDeclarations(this.getQualifiedContextName()).getConfigurationGroupDeclarations(aGroup);
        if (groups2.length == 0) {
            return EMPTY_STRINGS;
        }
        ArrayList<String> names = new ArrayList<String>();
        ConfigurationParameter[] commonParams = this.getConfigurationManager().getConfigParameterDeclarations(this.getQualifiedContextName()).getCommonParameters();
        if (commonParams != null) {
            for (i = 0; i < commonParams.length; ++i) {
                names.add(commonParams[i].getName());
            }
        }
        for (i = 0; i < groups2.length; ++i) {
            ConfigurationParameter[] groupParams = groups2[i].getConfigurationParameters();
            for (int j = 0; j < groupParams.length; ++j) {
                names.add(groupParams[j].getName());
            }
        }
        String[] nameArray = new String[names.size()];
        names.toArray(nameArray);
        return nameArray;
    }

    @Override
    public Settings getExternalOverrides() {
        return this.getRootContext().getExternalOverrides();
    }

    @Override
    public void setExternalOverrides(Settings externalOverrides) {
        this.getRootContext().setExternalOverrides(externalOverrides);
    }

    @Override
    public SofaID mapToSofaID(String aSofaName) {
        int index = aSofaName.indexOf(".");
        String nameToMap = aSofaName;
        String absoluteSofaName = null;
        if (index < 0) {
            absoluteSofaName = this.mSofaMappings.get(nameToMap);
            if (absoluteSofaName == null) {
                absoluteSofaName = nameToMap;
            }
        } else {
            nameToMap = aSofaName.substring(0, index);
            String rest = aSofaName.substring(index);
            String absoluteRoot = this.mSofaMappings.get(nameToMap);
            if (absoluteRoot == null) {
                absoluteRoot = nameToMap;
            }
            absoluteSofaName = absoluteRoot + rest;
        }
        SofaID_impl sofaid = new SofaID_impl();
        sofaid.setSofaID(absoluteSofaName);
        return sofaid;
    }

    @Override
    public String mapSofaIDToComponentSofaName(String aSofaID) {
        String componentSofaName = aSofaID;
        SofaID[] sofaArr = this.getSofaMappings();
        for (int i = 0; i < sofaArr.length; ++i) {
            if (!aSofaID.equals(sofaArr[i].getSofaID())) continue;
            return sofaArr[i].getComponentSofaName();
        }
        return componentSofaName;
    }

    @Override
    public SofaID[] getSofaMappings() {
        Set<Map.Entry<String, String>> sofamap = this.mSofaMappings.entrySet();
        Iterator<Map.Entry<String, String>> iter = sofamap.iterator();
        SofaID[] sofaArr = new SofaID_impl[sofamap.size()];
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry<String, String> elem = iter.next();
            SofaID_impl sofaid = new SofaID_impl();
            sofaid.setComponentSofaName(elem.getKey());
            sofaid.setSofaID(elem.getValue());
            sofaArr[i] = sofaid;
            ++i;
        }
        return sofaArr;
    }

    @Override
    public Map<String, String> getSofaMap() {
        return Collections.unmodifiableMap(this.mSofaMappings);
    }

    @Override
    public void defineCasPool(int aSize, Properties aPerformanceTuningSettings, boolean aSofaAware) throws ResourceInitializationException {
        this.mCasPoolSize = aSize;
        this.mPerformanceTuningSettings = aPerformanceTuningSettings;
        this.mSofaAware = aSofaAware;
    }

    @Override
    public void returnedCAS(AbstractCas aCAS) {
        CASImpl baseCas = null;
        if (aCAS instanceof JCas) {
            baseCas = ((JCas)aCAS).getCasImpl().getBaseCAS();
        } else if (aCAS instanceof CASImpl) {
            baseCas = ((CASImpl)aCAS).getBaseCAS();
        }
        this.mOutstandingCASes.remove(baseCas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AbstractCas> T getEmptyCas(Class<T> aCasInterface) {
        if (!this.mCasPoolCreated) {
            UimaContext_ImplBase uimaContext_ImplBase = this;
            synchronized (uimaContext_ImplBase) {
                if (!this.mCasPoolCreated) {
                    try {
                        this.getResourceManager().getCasManager().defineCasPool(this, this.mCasPoolSize, this.mPerformanceTuningSettings);
                    }
                    catch (ResourceInitializationException e) {
                        throw new UIMARuntimeException(e);
                    }
                    this.mCasPoolCreated = true;
                }
            }
        }
        CAS cas = null;
        Set<CAS> set = this.mOutstandingCASes;
        synchronized (set) {
            if (this.mOutstandingCASes.size() >= this.mCasPoolSize) {
                throw new UIMARuntimeException("requested_too_many_cas_instances", new Object[]{this.getQualifiedContextName(), Integer.toString(this.mCasPoolSize + 1), Integer.toString(this.mCasPoolSize)});
            }
            CasManager casManager = this.getResourceManager().getCasManager();
            cas = casManager.getCas(this.getUniqueName());
            this.mOutstandingCASes.add(((CASImpl)cas).getBaseCAS());
        }
        return Util.setupViewSwitchClassLoaders(cas, this.mSofaAware, this.getComponentInfo(), this.getResourceManager(), aCasInterface);
    }

    @Override
    public ComponentInfo getComponentInfo() {
        return this.mComponentInfo;
    }

    @Override
    public AnalysisEngineManagement getManagementInterface() {
        return this.mMBean;
    }

    public void setSharedParam(String parameterName, Object value) {
        ConfigurationManager configManager = this.getConfigurationManager();
        if (configManager instanceof ConfigurationManager_impl) {
            ConfigurationManager_impl configManagerImpl = (ConfigurationManager_impl)configManager;
            configManagerImpl.setSharedParam(parameterName, value);
        } else {
            this.getLogger().log(Level.CONFIG, "" + this.getComponentInfo() + " doesn't support modify parameters after initialization.");
        }
    }

    class ComponentInfoImpl
    implements ComponentInfo {
        ComponentInfoImpl() {
        }

        @Override
        public String mapToSofaID(String aSofaName) {
            int index = aSofaName.indexOf(".");
            String nameToMap = aSofaName;
            String absoluteSofaName = null;
            if (index < 0) {
                absoluteSofaName = UimaContext_ImplBase.this.mSofaMappings.get(nameToMap);
                if (absoluteSofaName == null) {
                    absoluteSofaName = nameToMap;
                }
            } else {
                nameToMap = aSofaName.substring(0, index);
                String rest = aSofaName.substring(index);
                String absoluteRoot = UimaContext_ImplBase.this.mSofaMappings.get(nameToMap);
                if (absoluteRoot == null) {
                    absoluteRoot = nameToMap;
                }
                absoluteSofaName = absoluteRoot + rest;
            }
            return absoluteSofaName;
        }
    }
}

