/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.Stack;
import org.apache.uima.internal.util.IntStack;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;

class IntRBTNode {
    private static final boolean RED = true;
    private static final boolean BLACK = false;
    private int key;
    private boolean color;
    private IntRBTNode parent;
    IntRBTNode left;
    IntRBTNode right;
    int element;
    private static final int indentInc = 2;

    private IntRBTNode(int key, boolean color, IntRBTNode parent, IntRBTNode left, IntRBTNode right, int element) {
        this.key = key;
        this.color = color;
        this.parent = parent;
        this.left = left;
        this.right = right;
        this.element = element;
    }

    IntRBTNode(int key, int element) {
        this(key, false, null, null, null, element);
    }

    static final IntRBTNode find(IntRBTNode x, int key) {
        while (x != null && x.key != key) {
            if (key < x.key) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        return x;
    }

    final IntRBTNode successor() {
        IntRBTNode x = this;
        if (x.right != null) {
            x = x.right;
            while (x.left != null) {
                x = x.left;
            }
            return x;
        }
        IntRBTNode y = x.parent;
        while (y != null && x == y.right) {
            x = y;
            y = x.parent;
        }
        return y;
    }

    static final boolean insert(IntRedBlackTree tree, IntRBTNode x) {
        if (!IntRBTNode.treeInsert(tree, x)) {
            return false;
        }
        x.color = true;
        while (x != tree.root && x.parent.color) {
            IntRBTNode y;
            if (x.parent == x.parent.parent.left) {
                y = x.parent.parent.right;
                if (IntRBTNode.colorOf(y)) {
                    x.parent.color = false;
                    IntRBTNode.setColor(y, false);
                    x.parent.parent.color = true;
                    x = x.parent.parent;
                    continue;
                }
                if (x == x.parent.right) {
                    x = x.parent;
                    x.leftRotate(tree);
                }
                x.parent.color = false;
                x.parent.parent.color = true;
                x.parent.parent.rightRotate(tree);
                continue;
            }
            y = x.parent.parent.left;
            if (IntRBTNode.colorOf(y)) {
                x.parent.color = false;
                IntRBTNode.setColor(y, false);
                x.parent.parent.color = true;
                x = x.parent.parent;
                continue;
            }
            if (x == x.parent.left) {
                x = x.parent;
                x.rightRotate(tree);
            }
            x.parent.color = false;
            x.parent.parent.color = true;
            x.parent.parent.leftRotate(tree);
        }
        tree.root.color = false;
        return true;
    }

    private static final boolean treeInsert(IntRedBlackTree tree, IntRBTNode z) {
        IntRBTNode y = null;
        IntRBTNode x = tree.root;
        while (x != null) {
            y = x;
            if (z.key < x.key) {
                x = x.left;
                continue;
            }
            if (z.key > x.key) {
                x = x.right;
                continue;
            }
            x.element = z.element;
            return false;
        }
        z.parent = y;
        if (y == null) {
            tree.root = z;
        } else if (z.key < y.key) {
            y.left = z;
        } else {
            y.right = z;
        }
        return true;
    }

    private final void leftRotate(IntRedBlackTree tree) {
        IntRBTNode y = this.right;
        this.right = y.left;
        if (y.left != null) {
            y.left.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.left) {
            this.parent.left = y;
        } else {
            this.parent.right = y;
        }
        y.left = this;
        this.parent = y;
    }

    private final void rightRotate(IntRedBlackTree tree) {
        IntRBTNode y = this.left;
        this.left = y.right;
        if (y.right != null) {
            y.right.parent = this;
        }
        y.parent = this.parent;
        if (this.parent == null) {
            tree.root = y;
        } else if (this == this.parent.right) {
            this.parent.right = y;
        } else {
            this.parent.left = y;
        }
        y.right = this;
        this.parent = y;
    }

    static final void delete(IntRedBlackTree tree, IntRBTNode z) {
        IntRBTNode xParent = null;
        IntRBTNode y = z.left == null || z.right == null ? z : z.successor();
        IntRBTNode x = y.left != null ? y.left : y.right;
        if (x != null) {
            x.parent = y.parent;
        } else {
            xParent = y.parent;
        }
        if (y.parent == null) {
            tree.root = x;
        } else if (y == y.parent.left) {
            y.parent.left = x;
        } else {
            y.parent.right = x;
        }
        if (y != z) {
            z.key = y.key;
            z.element = y.element;
        }
        if (!y.color) {
            if (x == null) {
                IntRBTNode.deleteFixupNull(tree, xParent);
            } else {
                IntRBTNode.deleteFixup(tree, x);
            }
        }
    }

    private static final void deleteFixup(IntRedBlackTree tree, IntRBTNode x) {
        while (x != tree.root && !x.color) {
            IntRBTNode w;
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w.color) {
                    w.color = false;
                    x.parent.color = true;
                    x.parent.leftRotate(tree);
                    w = x.parent.right;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    x = x.parent;
                    continue;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    w.rightRotate(tree);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                x.parent.leftRotate(tree);
                x = tree.root;
                continue;
            }
            w = x.parent.left;
            if (w.color) {
                w.color = false;
                x.parent.color = true;
                x.parent.rightRotate(tree);
                w = x.parent.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                x = x.parent;
                continue;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                w.leftRotate(tree);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            x.parent.rightRotate(tree);
            x = tree.root;
        }
        x.color = false;
    }

    private static final void deleteFixupNull(IntRedBlackTree tree, IntRBTNode x) {
        IntRBTNode w;
        if (x == null) {
            return;
        }
        if (x.left == null) {
            w = x.right;
            if (w.color) {
                w.color = false;
                x.color = true;
                x.leftRotate(tree);
                w = x.right;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                w.color = true;
            } else {
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    w.rightRotate(tree);
                    w = x.right;
                }
                w.color = x.color;
                x.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                x.leftRotate(tree);
                x = tree.root;
            }
        } else {
            w = x.left;
            if (w.color) {
                w.color = false;
                x.color = true;
                x.rightRotate(tree);
                w = x.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
            } else {
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                    w.color = true;
                    w.leftRotate(tree);
                    w = x.left;
                }
                w.color = x.color;
                x.color = false;
                if (w.left != null) {
                    w.left.color = false;
                }
                x.rightRotate(tree);
                x = tree.root;
            }
        }
        while (x != tree.root && !x.color) {
            if (x == x.parent.left) {
                w = x.parent.right;
                if (w.color) {
                    w.color = false;
                    x.parent.color = true;
                    x.parent.leftRotate(tree);
                    w = x.parent.right;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w)) && !IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    x = x.parent;
                    continue;
                }
                if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w))) {
                    w.color = true;
                    w.rightRotate(tree);
                    w = x.parent.right;
                }
                w.color = x.parent.color;
                x.parent.color = false;
                if (w.right != null) {
                    w.right.color = false;
                }
                x.parent.leftRotate(tree);
                x = tree.root;
                continue;
            }
            w = x.parent.left;
            if (w.color) {
                w.color = false;
                x.parent.color = true;
                x.parent.rightRotate(tree);
                w = x.parent.left;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.rightOf(w)) && !IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                x = x.parent;
                continue;
            }
            if (!IntRBTNode.colorOf(IntRBTNode.leftOf(w))) {
                w.color = true;
                w.leftRotate(tree);
                w = x.parent.left;
            }
            w.color = x.parent.color;
            x.parent.color = false;
            if (w.left != null) {
                w.left.color = false;
            }
            x.parent.rightRotate(tree);
            x = tree.root;
        }
        x.color = false;
    }

    int keys(int pos, int[] keys2) {
        int cur = pos;
        if (this.left != null) {
            cur = this.left.keys(cur, keys2);
        }
        keys2[cur] = this.key;
        ++cur;
        if (this.right != null) {
            cur = this.right.keys(cur, keys2);
        }
        return cur;
    }

    int[] toArray(int offset) {
        IntVector v = new IntVector();
        Stack<IntRBTNode> nodeStack = new Stack<IntRBTNode>();
        IntStack addressStack = new IntStack();
        IntRBTNode node = this;
        while (true) {
            if (node.left != null || node.right != null) {
                v.add(node.key);
                v.add(node.element);
                if (node.left != null) {
                    if (node.right != null) {
                        v.add(3);
                        addressStack.push(v.size());
                        v.add(-1);
                        nodeStack.push(node.right);
                    } else {
                        v.add(1);
                    }
                    node = node.left;
                    continue;
                }
                v.add(2);
                node = node.right;
                continue;
            }
            v.add(node.key);
            v.add(node.element);
            v.add(0);
            if (addressStack.empty()) {
                node = null;
            } else {
                node = (IntRBTNode)nodeStack.pop();
                int address = addressStack.pop();
                v.set(address, v.size() + offset);
            }
            if (node == null) break;
        }
        return v.toArray();
    }

    private static final boolean colorOf(IntRBTNode x) {
        return x == null ? false : x.color;
    }

    private static final void setColor(IntRBTNode x, boolean c) {
        if (x != null) {
            x.color = c;
        }
    }

    private static final IntRBTNode leftOf(IntRBTNode x) {
        return x == null ? null : x.left;
    }

    private static final IntRBTNode rightOf(IntRBTNode x) {
        return x == null ? null : x.right;
    }

    public void printKeys(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.print(this.key);
        System.out.print(':');
        if (this.color) {
            System.out.println("red");
        } else {
            System.out.println("black");
        }
        indent += 2;
        if (this.left != null) {
            this.left.printKeys(indent);
        }
        if (this.right != null) {
            this.right.printKeys(indent);
        }
    }

    public void printElements(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.println(this.element);
        indent += 2;
        if (this.left != null) {
            this.left.printElements(indent);
        }
        if (this.right != null) {
            this.right.printElements(indent);
        }
    }

    IntRBTNode copyNode(IntRBTNode parent) {
        IntRBTNode copyOfNode = new IntRBTNode(this.key, this.color, parent, null, null, this.element);
        copyOfNode.left = IntRBTNode.copyNode(copyOfNode, this.left);
        copyOfNode.right = IntRBTNode.copyNode(copyOfNode, this.right);
        return copyOfNode;
    }

    static IntRBTNode copyNode(IntRBTNode parent, IntRBTNode n) {
        if (null == n) {
            return null;
        }
        return n.copyNode(parent);
    }
}

