/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.uima.UIMAFramework;
import org.apache.uima.internal.util.I18nUtil;
import org.apache.uima.pear.tools.InstallationDescriptor;
import org.apache.uima.pear.tools.InstallationDescriptorHandler;
import org.apache.uima.pear.tools.InstallationProcessor;
import org.apache.uima.pear.tools.InstallationTester;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.pear.tools.PackageInstallerException;
import org.apache.uima.pear.tools.PackageSelectorGUI;
import org.apache.uima.pear.tools.SimplePackageSelector;
import org.apache.uima.pear.util.FileUtil;
import org.apache.uima.pear.util.MessageRouter;
import org.apache.uima.pear.util.StringUtil;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.util.FileUtils;
import org.xml.sax.SAXException;

public class InstallationController {
    public static final String INSTALLATION_IN_PROGRESS = "installation_in_progress";
    public static final String INSTALLATION_FAILED = "installation_failed";
    public static final String INSTALLATION_COMPLETED = "installation_completed";
    public static final String VERIFICATION_IN_PROGRESS = "verification_in_progress";
    public static final String VERIFICATION_FAILED = "verification_failed";
    public static final String VERIFICATION_COMPLETED = "verification_completed";
    public static final String VERIFICATION_CANCELLED = "verification_cancelled";
    protected static final String INSTALLATION_TESTER_APP = "org.apache.uima.pear.tools.InstallationTester";
    private static final String PEAR_MESSAGE_RESOURCE_BUNDLE = "org.apache.uima.pear.pear_messages";
    public static final String PACKAGE_CONFIG_FILE = "metadata/PEAR.properties";
    public static final String PACKAGE_METADATA_DIR = "metadata";
    public static final String PACKAGE_BIN_DIR = "bin";
    public static final String PACKAGE_CONF_DIR = "conf";
    public static final String PACKAGE_DATA_DIR = "data";
    public static final String PACKAGE_DESC_DIR = "desc";
    public static final String PACKAGE_DOC_DIR = "doc";
    public static final String PACKAGE_LIB_DIR = "lib";
    public static final String PACKAGE_RESOURCES_DIR = "resources";
    public static final String PACKAGE_SOURCES_DIR = "src";
    public static final String SET_ENV_FILE = "metadata/setenv.txt";
    public static final String PEAR_DESC_FILE_POSTFIX = "_pear.xml";
    protected static final String UIMA_HOME_ENV = "UIMA_HOME";
    protected static final String UIMA_LIB_DIR = "/lib";
    protected static final String VINCI_LIB_DIR = "/lib/vinci";
    protected static final String JAR_FILE_EXT = ".jar";
    public static final String CLASSPATH_VAR = "classpath";
    protected static final String PATH_VAR = "path";
    protected static final String LOCAL_OPT = "-local";
    protected static final String INSTALL_IN_ROOT_OPT = "-root";
    private static boolean __inLocalMode = false;
    private static String __osName = null;
    private String _mainComponentId;
    private String _installationDirPath;
    private File _installationDir;
    private boolean _cleanInstallDir = true;
    private String _mainComponentRootPath;
    private File _mainComponentRoot;
    private String _mainPearFileLocation = null;
    private Hashtable<String, String> _installationTable = new Hashtable();
    private Hashtable<String, InstallationDescriptor> _installationInsDs = new Hashtable();
    private InstallationDescriptor _insdObject;
    private String _hostIpAddress;
    private String _uimaHomePath;
    private String _installationMsg;
    private String _verificationMsg;
    private MessageRouter _msgRouter = null;
    private MessageRouter.StdChannelListener _defaultMsgListener = null;
    private PackageSelector _packageSelector = null;
    private InstallationMonitor _installationMonitor = null;

    protected static StringBuffer addListOfJarFiles(File libDir, StringBuffer listBuffer) throws IOException {
        if (libDir.isDirectory()) {
            Collection<File> fileList = FileUtil.createFileList(libDir);
            for (File file : fileList) {
                if (!file.getName().toLowerCase().endsWith(JAR_FILE_EXT)) continue;
                if (listBuffer.length() > 0) {
                    listBuffer.append(File.pathSeparatorChar);
                }
                listBuffer.append(file.getAbsolutePath().replace('\\', '/'));
            }
        }
        return listBuffer;
    }

    protected static boolean addToSystemEnvTable(Properties sysEnvTable, String localKey, String localValue) {
        boolean done = false;
        Enumeration<Object> sysKeys = sysEnvTable.keys();
        while (sysKeys.hasMoreElements() && !done) {
            String sysKey = (String)sysKeys.nextElement();
            if (!sysKey.equalsIgnoreCase(localKey)) continue;
            String sysValue = sysEnvTable.getProperty(sysKey);
            sysEnvTable.setProperty(sysKey, localValue + File.pathSeparator + sysValue);
            done = true;
        }
        return done;
    }

    public static String[] buildArrayOfNetworkParams(InstallationDescriptor insdObject) {
        String[] paramsArray = new String[]{};
        ArrayList<String> paramsList = new ArrayList<String>();
        StringBuffer itemBuffer = new StringBuffer();
        Set<String> pNames = insdObject.getMainComponentNetworkParamNames();
        if (pNames != null) {
            for (String pName : pNames) {
                Properties param = insdObject.getMainComponentNetworkParam(pName);
                Enumeration<Object> keys2 = param.keys();
                while (keys2.hasMoreElements()) {
                    String key = (String)keys2.nextElement();
                    String value = param.getProperty(key);
                    if (value.length() <= 0) continue;
                    itemBuffer.setLength(0);
                    itemBuffer.append("-D");
                    itemBuffer.append(key.trim());
                    itemBuffer.append('=');
                    itemBuffer.append(value.trim());
                    paramsList.add(itemBuffer.toString());
                }
            }
        }
        if (paramsList.size() > 0) {
            paramsArray = new String[paramsList.size()];
            paramsList.toArray(paramsArray);
        }
        return paramsArray;
    }

    public static String buildComponentClassPath(String compRootDirPath, InstallationDescriptor insdObject, boolean addLibDir) throws IOException {
        File compLibDir = new File(compRootDirPath, PACKAGE_LIB_DIR);
        StringBuffer cpBuffer = new StringBuffer();
        if (addLibDir) {
            cpBuffer = InstallationController.addListOfJarFiles(compLibDir, cpBuffer);
        }
        for (InstallationDescriptor.ActionInfo actInfo : insdObject.getInstallationActions("set_env_variable")) {
            if (actInfo.params == null) continue;
            String varName = actInfo.params.getProperty("VAR_NAME");
            String varValue = actInfo.params.getProperty("VAR_VALUE");
            if (varName == null || varValue == null || !varName.equalsIgnoreCase(CLASSPATH_VAR)) continue;
            if (cpBuffer.length() > 0) {
                cpBuffer.append(File.pathSeparatorChar);
            }
            cpBuffer.append(varValue.replace('\\', '/'));
        }
        return cpBuffer.toString();
    }

    public static String buildComponentPath(String compRootDirPath, InstallationDescriptor insdObject) {
        File compBinDir = new File(compRootDirPath, PACKAGE_BIN_DIR);
        StringBuffer pBuffer = new StringBuffer();
        if (compBinDir.isDirectory()) {
            pBuffer.append(compBinDir.getAbsolutePath().replace('\\', '/'));
        }
        for (InstallationDescriptor.ActionInfo actInfo : insdObject.getInstallationActions("set_env_variable")) {
            if (actInfo.params == null) continue;
            String varName = actInfo.params.getProperty("VAR_NAME");
            String varValue = actInfo.params.getProperty("VAR_VALUE");
            if (varName == null || varValue == null || !varName.equalsIgnoreCase(PATH_VAR)) continue;
            if (pBuffer.length() > 0) {
                pBuffer.append(File.pathSeparatorChar);
            }
            pBuffer.append(varValue.replace('\\', '/'));
        }
        return pBuffer.toString();
    }

    public static String buildListOfEnvVars(InstallationDescriptor insdObject) {
        Properties envVarsTable = InstallationController.buildTableOfEnvVars(insdObject);
        StringBuffer envBuffer = new StringBuffer();
        Enumeration<Object> names = envVarsTable.keys();
        while (names.hasMoreElements()) {
            String varName = (String)names.nextElement();
            String varValue = envVarsTable.getProperty(varName);
            if (varName.length() <= 0 || varValue == null || varValue.length() <= 0) continue;
            if (envBuffer.length() > 0) {
                envBuffer.append(' ');
            }
            envBuffer.append("-D");
            envBuffer.append(varName);
            envBuffer.append('=');
            envBuffer.append(varValue);
        }
        return envBuffer.toString();
    }

    public static String buildListOfNetworkParams(InstallationDescriptor insdObject) {
        StringBuffer paramsBuffer = new StringBuffer();
        String[] paramsArray = InstallationController.buildArrayOfNetworkParams(insdObject);
        for (int i = 0; i < paramsArray.length; ++i) {
            paramsBuffer.append(paramsArray[i]);
            paramsBuffer.append(' ');
        }
        return paramsBuffer.toString();
    }

    public static Properties buildTableOfEnvVars(InstallationDescriptor insdObject) {
        Properties envVarsTable = new Properties();
        for (InstallationDescriptor.ActionInfo actInfo : insdObject.getInstallationActions("set_env_variable")) {
            String varName = actInfo.params.getProperty("VAR_NAME");
            String varValue = actInfo.params.getProperty("VAR_VALUE");
            if (varName == null || varValue == null || varName.equalsIgnoreCase(CLASSPATH_VAR) || varName.equalsIgnoreCase(PATH_VAR)) continue;
            String curValue = envVarsTable.getProperty(varName);
            if (curValue != null) {
                curValue = curValue + File.pathSeparator + varValue;
                envVarsTable.setProperty(varName, curValue);
                continue;
            }
            envVarsTable.setProperty(varName, varValue);
        }
        return envVarsTable;
    }

    public static String buildUIMAClassPath(String uimaHomeEnv) {
        try {
            StringBuffer cpBuffer = new StringBuffer();
            File uimaLibDir = new File(uimaHomeEnv + UIMA_LIB_DIR);
            cpBuffer = InstallationController.addListOfJarFiles(uimaLibDir, cpBuffer);
            File vinciLibDir = new File(uimaHomeEnv + VINCI_LIB_DIR);
            cpBuffer = InstallationController.addListOfJarFiles(vinciLibDir, cpBuffer);
            return cpBuffer.toString();
        }
        catch (IOException exc) {
            return File.pathSeparator;
        }
    }

    public static boolean deleteInstalledFiles(String componentId, File parentDir, boolean includeDelegates) throws IOException {
        boolean done = true;
        File rootDir = new File(parentDir, componentId);
        if (!rootDir.isDirectory()) {
            return false;
        }
        if (includeDelegates) {
            InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
            File insdFile = new File(rootDir, "metadata/install.xml");
            try {
                insdHandler.parse(insdFile);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception err) {
                throw new IOException(err.getMessage());
            }
            InstallationDescriptor insdObject = insdHandler.getInstallationDescriptor();
            Hashtable<String, InstallationDescriptor.ComponentInfo> dlgComponents = insdObject.getDelegateComponents();
            Enumeration<String> dlgCompIds = dlgComponents.keys();
            while (dlgCompIds.hasMoreElements()) {
                String dlgCompId = dlgCompIds.nextElement();
                if (InstallationController.deleteInstalledFiles(dlgCompId, parentDir, true)) continue;
                done = false;
            }
        }
        if (!FileUtil.deleteDirectory(rootDir)) {
            done = false;
        }
        return done;
    }

    public static String extractFilesFromPEARFile(String pearFileLocation, String fileExt, File targetDir, boolean cleanTarget) throws IOException {
        return InstallationController.extractFilesFromPEARFile(pearFileLocation, fileExt, targetDir, null, cleanTarget);
    }

    protected static String extractFilesFromPEARFile(String pearFileLocation, String fileExt, File targetDir, InstallationController controller, boolean cleanTarget) throws IOException {
        long fileSize = FileUtil.getFileSize(pearFileLocation);
        if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
            String message = I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_controller_error_creating_install_dir", new Object[]{targetDir.getAbsolutePath()});
            throw new IOException(message);
        }
        if (cleanTarget) {
            if (FileUtils.deleteRecursive(targetDir)) {
                if (!targetDir.mkdirs()) {
                    String message = I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_controller_error_creating_install_dir", new Object[]{targetDir.getAbsolutePath()});
                    throw new IOException(message);
                }
            } else {
                String message = I18nUtil.localizeMessage(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_controller_error_cleaning_install_dir", new Object[]{targetDir.getAbsolutePath()});
                throw new IOException(message);
            }
        }
        File pearFile = null;
        boolean removeLocalCopy = false;
        boolean done = false;
        ZipFile jarFile = null;
        try {
            long totalBytes;
            pearFile = new File(pearFileLocation);
            if (!pearFile.isFile()) {
                URL pearFileUrl = new URL(pearFileLocation);
                if (controller != null) {
                    controller.getOutMsgWriter().println("[InstallationController]: copying " + fileSize + " bytes from " + pearFileUrl.toExternalForm() + " to " + targetDir.getAbsolutePath());
                } else {
                    System.out.println("[InstallationController]: copying " + fileSize + " bytes from " + pearFileUrl.toExternalForm() + " to " + targetDir.getAbsolutePath());
                }
                String pearFileName = new File(pearFileUrl.getFile()).getName();
                pearFile = new File(targetDir, pearFileName);
                if (!FileUtil.copyFile(pearFileUrl, pearFile)) {
                    throw new IOException("cannot copy " + pearFileUrl + " to file " + pearFile.getAbsolutePath());
                }
                removeLocalCopy = true;
            }
            if (controller != null) {
                controller.getOutMsgWriter().println("[InstallationController]: extracting " + pearFile.getAbsolutePath());
            } else {
                System.out.println("[InstallationController]: extracting " + pearFile.getAbsolutePath());
            }
            jarFile = new JarFile(pearFile);
            long l = totalBytes = fileExt == null ? FileUtil.extractFilesFromJar((JarFile)jarFile, targetDir) : FileUtil.extractFilesWithExtFromJar((JarFile)jarFile, fileExt, targetDir);
            if (controller != null) {
                controller.getOutMsgWriter().println("[InstallationController]: " + totalBytes + " bytes extracted");
            } else {
                System.out.println("[InstallationController]: " + totalBytes + " bytes extracted");
            }
            if (removeLocalCopy && !pearFile.delete()) {
                pearFile.deleteOnExit();
            }
            done = true;
        }
        catch (MalformedURLException urlExc) {
            throw new FileNotFoundException(pearFileLocation);
        }
        catch (IOException ioExc) {
            throw ioExc;
        }
        catch (Throwable err) {
            throw new IOException(err.toString());
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ioe) {
                    IOException e = new IOException("Can't close open PEAR file :" + jarFile.getName());
                    e.initCause(ioe);
                    throw e;
                }
            }
        }
        return done ? targetDir.getAbsolutePath() : null;
    }

    public static String extractPEARFile(String pearFileLocation, File installationDir, boolean cleanTarget) throws IOException {
        return InstallationController.extractFilesFromPEARFile(pearFileLocation, null, installationDir, cleanTarget);
    }

    protected static String extractPEARFile(String pearFileLocation, File installationDir, InstallationController controller, boolean cleanTarget) throws IOException {
        return InstallationController.extractFilesFromPEARFile(pearFileLocation, null, installationDir, controller, cleanTarget);
    }

    protected static Hashtable<String, InstallationDescriptor> getDelegateInstallationDescriptors(Hashtable<String, String> installationTable) throws IOException {
        Enumeration<String> dlgIdList = installationTable.keys();
        Hashtable<String, InstallationDescriptor> dlgInsdObjects = new Hashtable<String, InstallationDescriptor>();
        while (dlgIdList.hasMoreElements()) {
            String dlgId = dlgIdList.nextElement();
            String dlgRootPath = installationTable.get(dlgId);
            PackageBrowser dlgBrowser = new PackageBrowser(new File(dlgRootPath));
            InstallationDescriptor dlgInsdObject = dlgBrowser.getInstallationDescriptor();
            dlgInsdObjects.put(dlgId, dlgInsdObject);
        }
        return dlgInsdObjects;
    }

    public static String getHostIpAddress() {
        String hostAddress = "127.0.0.1";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hostAddress;
    }

    protected static String getInstalledComponentRootPath(String componentId, PackageSelector pkgSelector) {
        String componentRootPath = null;
        PackageSelector packageSelector = pkgSelector != null ? pkgSelector : new SimplePackageSelector();
        File componentRootDir = packageSelector.selectPackageDirectory(componentId);
        if (componentRootDir != null) {
            componentRootPath = componentRootDir.getAbsolutePath();
        }
        return componentRootPath;
    }

    protected static String getPEARFileLocation(String componentId, PackageSelector pkgSelector) {
        String pearFileLocation = null;
        PackageSelector packageSelector = pkgSelector != null ? pkgSelector : new SimplePackageSelector();
        File pearFile = packageSelector.selectPackageFile(componentId);
        if (pearFile != null) {
            pearFileLocation = pearFile.getAbsolutePath();
        } else {
            URL pearFileUrl = packageSelector.selectPackageUrl(componentId);
            if (pearFileUrl != null) {
                pearFileLocation = pearFileUrl.toString();
            }
        }
        return pearFileLocation;
    }

    public static void main(String[] args2) {
        if (args2.length < 1) {
            System.err.println("usage: InstallationController {-local pear_file | main_component_id} [-root] [installation_dir]");
            return;
        }
        File localPearFile = null;
        String mainComponentId = null;
        boolean installInRootDir = false;
        File installationDir = null;
        int argNo = 0;
        if (args2[argNo].equals(LOCAL_OPT)) {
            InstallationController.setLocalMode(true);
            if (args2.length > argNo + 1) {
                localPearFile = new File(args2[++argNo]);
            }
        } else {
            mainComponentId = args2[argNo++];
        }
        for (int i = argNo; i < args2.length; ++i) {
            if (args2[i].equals(INSTALL_IN_ROOT_OPT)) {
                installInRootDir = true;
                continue;
            }
            installationDir = new File(args2[i]);
        }
        if (localPearFile == null && mainComponentId == null) {
            System.err.println("usage: InstallationController {-local pear_file | main_component_id} [-root] [installation_dir]");
            return;
        }
        if (localPearFile != null && !localPearFile.exists()) {
            System.err.println("[InstallationController]: " + localPearFile.getAbsolutePath() + " file not found");
        }
        if (installationDir == null) {
            installationDir = new File(".");
        } else if (!installationDir.isDirectory()) {
            System.err.println("[InstallationController]: " + installationDir.getAbsolutePath() + " directory not found");
            return;
        }
        if (__inLocalMode) {
            try {
                JarFile jarFile = new JarFile(localPearFile);
                InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
                insdHandler.parseInstallationDescriptor(jarFile);
                InstallationDescriptor insd = insdHandler.getInstallationDescriptor();
                if (insd == null) {
                    throw new FileNotFoundException("installation descriptor not found");
                }
                mainComponentId = insd.getMainComponentId();
            }
            catch (Exception err) {
                System.err.println("[InstallationController]: terminated \n" + err.toString());
                return;
            }
        }
        InstallationController controller = __inLocalMode ? new InstallationController(mainComponentId, localPearFile, installationDir, installInRootDir) : new InstallationController(mainComponentId, installationDir.getAbsolutePath(), installInRootDir);
        controller.setPackageSelector(new PackageSelectorGUI());
        if (controller.installComponent() == null) {
            controller.getErrMsgWriter().println("[InstallationController]: installation of " + mainComponentId + " failed => \n" + controller.getInstallationMsg());
        } else {
            try {
                controller.getOutMsgWriter().println("[InstallationController]: installation of " + mainComponentId + " completed");
                if (controller.verifyComponent()) {
                    controller.getOutMsgWriter().println("[InstallationController]: verification of " + mainComponentId + " completed");
                    controller.getOutMsgWriter().println("[InstallationController]: " + mainComponentId + " installed in the " + controller._mainComponentRootPath + " directory.");
                } else {
                    controller.getOutMsgWriter().println("[InstallationController]: verification of " + mainComponentId + " failed => \n" + controller.getVerificationMsg());
                }
            }
            catch (Exception exc) {
                System.err.println("Error in InstallationController.main(): " + exc.toString());
                exc.printStackTrace(System.err);
            }
        }
        controller.terminate();
        System.exit(0);
    }

    public static synchronized void setLocalMode(boolean inLocalMode) {
        __inLocalMode = inLocalMode;
    }

    public static synchronized TestStatus verifyComponentInstallation(PackageBrowser pkgBrowser) {
        try {
            if (pkgBrowser != null) {
                if (pkgBrowser.getInstallationDescriptor() == null) {
                    throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_install_desc_not_available");
                }
                if (pkgBrowser.getInstallationDescriptor().getMainComponentDesc() == null) {
                    throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_main_desc_not_available", new Object[]{pkgBrowser.getInstallationDescriptor().getMainComponentId()});
                }
                if (pkgBrowser.getInstallationDescriptor().getMainComponentRoot() == null) {
                    throw new PackageInstallerException(PEAR_MESSAGE_RESOURCE_BUNDLE, "installation_verification_main_root_not_available", new Object[]{pkgBrowser.getInstallationDescriptor().getMainComponentId()});
                }
            }
            InstallationTester installTester = new InstallationTester(pkgBrowser);
            return installTester.doTest();
        }
        catch (Throwable exc) {
            StringWriter strWriter = new StringWriter();
            PrintWriter oWriter = new PrintWriter(strWriter);
            exc.printStackTrace(oWriter);
            TestStatus status = new TestStatus();
            status.setRetCode(-1);
            status.setMessage(strWriter.toString());
            return status;
        }
    }

    public InstallationController(String componentId, String rootDirPath) {
        this(componentId, rootDirPath, false);
    }

    public InstallationController(String componentId, String rootDirPath, boolean installInRootDir) {
        this(componentId, rootDirPath, installInRootDir, null);
    }

    public InstallationController(String componentId, String rootDirPath, boolean installInRootDir, MessageRouter.StdChannelListener msgListener) {
        this(componentId, rootDirPath, installInRootDir, null, msgListener, true);
        this.getOutMsgWriter().println("[InstallationController]: OS - " + __osName + ", Host - " + this._hostIpAddress);
        if (__inLocalMode) {
            this.getOutMsgWriter().println("[InstallationController]: working in 'local' mode");
        }
    }

    protected InstallationController(String componentId, String rootDirPath, boolean installInRootDir, MessageRouter msgRouter, MessageRouter.StdChannelListener msgListener, boolean cleanInstallDir) {
        this._msgRouter = msgRouter == null ? new MessageRouter() : msgRouter;
        this._defaultMsgListener = msgListener == null ? new MessageRouter.StdChannelListener(){

            @Override
            public void errMsgPosted(String errMsg) {
                System.err.print(errMsg);
                System.err.flush();
            }

            @Override
            public void outMsgPosted(String outMsg) {
                System.out.print(outMsg);
                System.out.flush();
            }
        } : msgListener;
        this.addMsgListener(this._defaultMsgListener);
        if (!this._msgRouter.isRunning()) {
            this._msgRouter.start();
        }
        this._mainComponentId = componentId;
        this._cleanInstallDir = cleanInstallDir;
        if (installInRootDir) {
            this._mainComponentRootPath = rootDirPath;
            this._mainComponentRoot = new File(this._mainComponentRootPath);
            this._installationDir = this._mainComponentRoot.getParentFile();
            this._installationDirPath = this._installationDir.getAbsolutePath();
        } else {
            this._installationDirPath = rootDirPath;
            this._installationDir = new File(this._installationDirPath);
            this._mainComponentRoot = new File(this._installationDir, componentId);
            this._mainComponentRootPath = this._mainComponentRoot.getAbsolutePath();
        }
        this._uimaHomePath = System.getProperty(UIMA_HOME_ENV);
        if (this._uimaHomePath != null) {
            this._uimaHomePath = this._uimaHomePath.replace('\\', '/');
        }
        if (__osName == null) {
            __osName = System.getProperty("os.name");
        }
        this._hostIpAddress = InstallationController.getHostIpAddress();
        this._packageSelector = new SimplePackageSelector(this.getOutMsgWriter(), this.getErrMsgWriter());
    }

    public InstallationController(String componentId, File localPearFile, File rootDir) {
        this(componentId, rootDir.getAbsolutePath(), false, null, null, true);
        this._mainPearFileLocation = localPearFile.getAbsolutePath();
    }

    public InstallationController(String componentId, File localPearFile, File rootDir, boolean installInRootDir, boolean cleanInstallDir) {
        this(componentId, rootDir.getAbsolutePath(), installInRootDir, null, null, cleanInstallDir);
        this._mainPearFileLocation = localPearFile.getAbsolutePath();
    }

    public InstallationController(String componentId, File localPearFile, File rootDir, boolean installInRootDir) {
        this(componentId, rootDir.getAbsolutePath(), installInRootDir, null, null, true);
        this._mainPearFileLocation = localPearFile.getAbsolutePath();
    }

    public InstallationController(String componentId, File localPearFile, File rootDir, boolean installInRootDir, MessageRouter.StdChannelListener msgListener) {
        this(componentId, rootDir.getAbsolutePath(), installInRootDir, null, msgListener, true);
        this._mainPearFileLocation = localPearFile.getAbsolutePath();
    }

    public InstallationController(String componentId, File localPearFile, File rootDir, boolean installInRootDir, MessageRouter.StdChannelListener msgListener, boolean cleanInstallDir) {
        this(componentId, rootDir.getAbsolutePath(), installInRootDir, null, msgListener, cleanInstallDir);
        this._mainPearFileLocation = localPearFile.getAbsolutePath();
    }

    public void addMsgListener(MessageRouter.StdChannelListener listener) {
        this._msgRouter.addChannelListener(listener);
    }

    public String buildComponentClassPath() throws IOException {
        if (this._insdObject != null) {
            StringBuffer cpBuffer = new StringBuffer();
            String mainClassPath = InstallationController.buildComponentClassPath(this._mainComponentRootPath, this._insdObject, true);
            cpBuffer.append(mainClassPath);
            if (this._installationTable.size() > 0) {
                Enumeration<String> dlgIdList = this._installationTable.keys();
                while (dlgIdList.hasMoreElements()) {
                    InstallationDescriptor dlgInsD;
                    String dlgId = dlgIdList.nextElement();
                    String dlgRootPath = this._installationTable.get(dlgId);
                    String dlgClassPath = InstallationController.buildComponentClassPath(dlgRootPath, dlgInsD = this._installationInsDs.get(dlgId), true);
                    if (dlgClassPath.length() <= 0) continue;
                    if (cpBuffer.length() > 0 && cpBuffer.charAt(cpBuffer.length() - 1) != File.pathSeparatorChar) {
                        cpBuffer.append(File.pathSeparatorChar);
                    }
                    cpBuffer.append(dlgClassPath);
                }
            }
            return cpBuffer.toString();
        }
        return null;
    }

    public String buildComponentPath() {
        if (this._insdObject != null) {
            StringBuffer pBuffer = new StringBuffer();
            String mainPath = InstallationController.buildComponentPath(this._mainComponentRootPath, this._insdObject);
            pBuffer.append(mainPath);
            if (this._installationTable.size() > 0) {
                Enumeration<String> dlgIdList = this._installationTable.keys();
                while (dlgIdList.hasMoreElements()) {
                    InstallationDescriptor dlgInsD;
                    String dlgId = dlgIdList.nextElement();
                    String dlgRootPath = this._installationTable.get(dlgId);
                    String dlgPath = InstallationController.buildComponentPath(dlgRootPath, dlgInsD = this._installationInsDs.get(dlgId));
                    if (dlgPath.length() <= 0) continue;
                    if (pBuffer.length() > 0 && pBuffer.charAt(pBuffer.length() - 1) != File.pathSeparatorChar) {
                        pBuffer.append(File.pathSeparatorChar);
                    }
                    pBuffer.append(dlgPath);
                }
            }
            return pBuffer.toString();
        }
        return null;
    }

    public Properties buildTableOfEnvVars() {
        if (this._insdObject != null) {
            Properties envVars = InstallationController.buildTableOfEnvVars(this._insdObject);
            if (this._installationTable.size() > 0) {
                Enumeration<String> dlgIdList = this._installationTable.keys();
                while (dlgIdList.hasMoreElements()) {
                    String dlgId = dlgIdList.nextElement();
                    InstallationDescriptor dlgInsD = this._installationInsDs.get(dlgId);
                    Properties dlgEnvVars = InstallationController.buildTableOfEnvVars(dlgInsD);
                    envVars = StringUtil.appendProperties(envVars, dlgEnvVars, false);
                }
            }
            return envVars;
        }
        return null;
    }

    protected void finalize() {
        this._msgRouter.terminate();
    }

    public synchronized InstallationDescriptor installComponent() {
        try {
            if (this._installationMonitor != null) {
                this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_IN_PROGRESS);
            }
            if (this._mainPearFileLocation == null) {
                this._mainPearFileLocation = InstallationController.getPEARFileLocation(this._mainComponentId, this._packageSelector);
            }
            if (InstallationController.extractPEARFile(this._mainPearFileLocation, this._mainComponentRoot, this, this._cleanInstallDir) == null) {
                this.setInstallationError(new IOException("PEAR extraction failed"));
                if (this._installationMonitor != null) {
                    this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_FAILED);
                }
                return null;
            }
            InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
            File insdFile = new File(this._mainComponentRoot, "metadata/install.xml");
            insdHandler.parse(insdFile);
            this._insdObject = insdHandler.getInstallationDescriptor();
            this.installDelegateComponents();
            InstallationProcessor processor = new InstallationProcessor(this._mainComponentRootPath, this._installationTable, this);
            processor.process();
            this._insdObject = processor.getInstallationDescriptor();
            this.saveInstallationDescriptorFile();
            this.generatePackageConfigFile();
            this.generateSetEnvFile();
            InstallationController.generatePearSpecifier(this._mainComponentRootPath, this._mainComponentId);
            this.getOutMsgWriter().println("[InstallationController]: the metadata/setenv.txt file contains required environment variables for this component");
            this.getOutMsgWriter().println("[InstallationController]: component " + this._mainComponentId + " installation completed.");
            if (this._installationMonitor != null) {
                this._installationMonitor.setInstallationLocation(this._mainComponentId, this._mainComponentRootPath);
                this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_COMPLETED);
            }
        }
        catch (Exception exc) {
            this.getErrMsgWriter().println("Error in InstallationController: " + exc);
            exc.printStackTrace(this.getErrMsgWriter());
            this.setInstallationError(exc);
            if (this._installationMonitor != null) {
                this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_FAILED);
            }
            return null;
        }
        return this._insdObject;
    }

    public synchronized InstallationDescriptor installComponentDescriptors() {
        try {
            if (this._mainPearFileLocation == null) {
                this._mainPearFileLocation = InstallationController.getPEARFileLocation(this._mainComponentId, this._packageSelector);
            }
            if (InstallationController.extractFilesFromPEARFile(this._mainPearFileLocation, ".xml", this._mainComponentRoot, this, this._cleanInstallDir) == null) {
                this.setInstallationError(new IOException("PEAR extraction failed"));
                return null;
            }
            InstallationDescriptorHandler insdHandler = new InstallationDescriptorHandler();
            File insdFile = new File(this._mainComponentRoot, "metadata/install.xml");
            insdHandler.parse(insdFile);
            this._insdObject = insdHandler.getInstallationDescriptor();
            this.installDelegateComponentsDescriptors();
            InstallationProcessor processor = new InstallationProcessor(this._mainComponentRootPath, this._installationTable);
            processor.process();
            this._insdObject = processor.getInstallationDescriptor();
            this.getOutMsgWriter().println("[InstallationController]: component " + this._mainComponentId + " descriptors installation completed.");
        }
        catch (Exception exc) {
            this.getErrMsgWriter().println("Error in InstallationController: " + exc);
            exc.printStackTrace(this.getErrMsgWriter());
            this.setInstallationError(exc);
            return null;
        }
        return this._insdObject;
    }

    protected synchronized void installDelegateComponents() {
        Enumeration<String> dlgList = this._insdObject.getDelegateComponents().keys();
        while (dlgList.hasMoreElements()) {
            InstallationDescriptor dlgInsdObject;
            String componentId = dlgList.nextElement();
            String componentRootPath = null;
            try {
                componentRootPath = InstallationController.getInstalledComponentRootPath(componentId, this._packageSelector);
            }
            catch (Exception e) {
                this.getErrMsgWriter().println("[InstallationController]: failed to query " + componentId + " location - " + e);
            }
            if (componentRootPath == null) {
                InstallationController dlgController = new InstallationController(componentId, this._installationDirPath, false, this._msgRouter, this._defaultMsgListener, this._cleanInstallDir);
                dlgController.setPackageSelector(this._packageSelector);
                dlgInsdObject = dlgController.installComponent();
                if (dlgInsdObject == null) {
                    this.getErrMsgWriter().println("[InstallationController]: failed to install dlg component " + componentId);
                    throw new RuntimeException("failed to install dlg component " + componentId);
                }
                componentRootPath = dlgInsdObject.getMainComponentRoot();
                this._installationTable.put(componentId, componentRootPath);
                this._installationInsDs.put(componentId, dlgInsdObject);
                continue;
            }
            this._installationTable.put(componentId, componentRootPath);
            try {
                PackageBrowser dlgBrowser = new PackageBrowser(new File(componentRootPath));
                dlgInsdObject = dlgBrowser.getInstallationDescriptor();
                this._installationInsDs.put(componentId, dlgInsdObject);
            }
            catch (IOException e) {}
        }
    }

    protected synchronized void installDelegateComponentsDescriptors() {
        Enumeration<String> dlgList = this._insdObject.getDelegateComponents().keys();
        while (dlgList.hasMoreElements()) {
            String componentId = dlgList.nextElement();
            InstallationController dlgController = new InstallationController(componentId, this._installationDirPath, false, this._msgRouter, this._defaultMsgListener, this._cleanInstallDir);
            dlgController.setPackageSelector(this._packageSelector);
            InstallationDescriptor dlgInsdObject = dlgController.installComponentDescriptors();
            if (dlgInsdObject == null) {
                this.getErrMsgWriter().println("[InstallationController]: failed to install descriptors for dlg component " + componentId);
                throw new RuntimeException("failed to install descriptors for dlg component " + componentId);
            }
            String componentRootPath = dlgInsdObject.getMainComponentRoot();
            this._installationTable.put(componentId, componentRootPath);
            this._installationInsDs.put(componentId, dlgInsdObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static synchronized void generatePearSpecifier(String mainComponentRootPath, String mainComponentId) throws IOException, SAXException {
        PearSpecifier pearSpec = UIMAFramework.getResourceSpecifierFactory().createPearSpecifier();
        pearSpec.setPearPath(mainComponentRootPath);
        File outputFile = new File(mainComponentRootPath, mainComponentId + PEAR_DESC_FILE_POSTFIX);
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(outputFile);
            pearSpec.toXML(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void generateSetEnvFile() throws IOException {
        File setEnvFile = new File(this._mainComponentRoot, SET_ENV_FILE);
        PrintWriter fWriter = null;
        try {
            String path;
            fWriter = new PrintWriter(new FileWriter(setEnvFile));
            fWriter.println("### Add the following environment variables");
            fWriter.println("### to appropriate existing environment variables");
            fWriter.println("### to run the " + this._mainComponentId + " component");
            fWriter.println();
            String classPath = this.buildComponentClassPath();
            if (classPath.length() > 0) {
                fWriter.println("CLASSPATH=" + classPath);
            }
            if ((path = this.buildComponentPath()).length() > 0) {
                fWriter.println("PATH=" + path);
            }
            Properties envVarTable = this.buildTableOfEnvVars();
            Enumeration<Object> envVarList = envVarTable.keys();
            while (envVarList.hasMoreElements()) {
                String varName = (String)envVarList.nextElement();
                String varValue = envVarTable.getProperty(varName);
                if (varName.length() <= 0 || varValue.length() <= 0 || varName.equalsIgnoreCase(CLASSPATH_VAR) || varName.equalsIgnoreCase(PATH_VAR)) continue;
                fWriter.println(varName + "=" + varValue);
            }
        }
        finally {
            if (fWriter != null) {
                try {
                    fWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void generatePackageConfigFile() throws IOException {
        Properties packageConfig = new Properties();
        File packageConfigFile = new File(this._mainComponentRoot, PACKAGE_CONFIG_FILE);
        if (packageConfigFile.exists()) {
            FileInputStream iStream = null;
            try {
                iStream = new FileInputStream(packageConfigFile);
                packageConfig.load(iStream);
            }
            finally {
                if (iStream != null) {
                    try {
                        ((InputStream)iStream).close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        packageConfig.setProperty("$main_root", this._mainComponentRootPath.replace('\\', '/'));
        for (String id : this._installationTable.keySet()) {
            String idRoot = "$" + id + "$root";
            packageConfig.setProperty(idRoot, this._installationTable.get(id).replace('\\', '/'));
        }
        OutputStream oStream = null;
        try {
            String header = this._mainComponentId;
            oStream = new FileOutputStream(packageConfigFile);
            packageConfig.store(oStream, header);
        }
        finally {
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (Exception e) {}
            }
        }
    }

    protected PrintWriter getErrMsgWriter() {
        return this._msgRouter.errWriter();
    }

    public String getInstallationMsg() {
        return this._installationMsg;
    }

    protected PrintWriter getOutMsgWriter() {
        return this._msgRouter.outWriter();
    }

    public String getVerificationMsg() {
        return this._verificationMsg;
    }

    public void removeMsgListener(MessageRouter.StdChannelListener listener) {
        this._msgRouter.removeChannelListener(listener);
    }

    public synchronized void saveInstallationDescriptorFile() throws IOException {
        if (this._insdObject != null) {
            File insdFile = this._insdObject.getInstallationDescriptorFile();
            InstallationDescriptorHandler.saveInstallationDescriptor(this._insdObject, insdFile);
        }
    }

    protected synchronized void setInstallationError(Exception error) {
        this._installationMsg = StringUtil.errorStackTraceContent(error);
    }

    public synchronized void setInstallationMonitor(InstallationMonitor monitor) {
        if (monitor != null) {
            this._installationMonitor = monitor;
        }
    }

    public synchronized void setPackageSelector(PackageSelector selector) {
        if (selector != null) {
            this._packageSelector = selector;
        }
    }

    protected synchronized void setVerificationError(Exception error) {
        this._verificationMsg = StringUtil.errorStackTraceContent(error);
    }

    public synchronized void setUimaHomePath(String uimaHomePath) {
        this._uimaHomePath = uimaHomePath.replace('\\', '/');
    }

    public void terminate() {
        this._msgRouter.terminate();
    }

    public synchronized boolean verifyComponent() {
        boolean success;
        block10: {
            success = false;
            try {
                PackageBrowser installedPear;
                TestStatus status;
                if (this._installationMonitor != null) {
                    this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_IN_PROGRESS);
                }
                if ((status = InstallationController.verifyComponentInstallation(installedPear = new PackageBrowser(this._mainComponentRoot))).getRetCode() == 0) {
                    success = true;
                    this._verificationMsg = null;
                    if (this._installationMonitor != null) {
                        this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_COMPLETED);
                    }
                } else if (status.getRetCode() == -1) {
                    this._verificationMsg = status.getMessage();
                    if (this._installationMonitor != null) {
                        this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_FAILED);
                    }
                } else {
                    this._verificationMsg = status.getMessage();
                    if (this._installationMonitor != null) {
                        this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_CANCELLED);
                    }
                }
            }
            catch (Exception err) {
                this._verificationMsg = err.toString();
                if (this._installationMonitor == null) break block10;
                this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_FAILED);
            }
        }
        return success;
    }

    public static class TestStatus {
        public static final int TEST_SUCCESSFUL = 0;
        public static final int TEST_NOT_SUCCESSFUL = -1;
        private int retCode = -1;
        private String message = null;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getRetCode() {
            return this.retCode;
        }

        public void setRetCode(int retCode) {
            this.retCode = retCode;
        }
    }

    public static interface PackageSelector {
        public File selectPackageDirectory(String var1);

        public File selectPackageFile(String var1);

        public URL selectPackageUrl(String var1);
    }

    public static interface InstallationMonitor {
        public void setInstallationStatus(String var1, String var2);

        public void setInstallationLocation(String var1, String var2);
    }
}

