/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.Session;
import org.apache.uima.resource.metadata.ConfigurationGroup;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.Settings;

public abstract class ConfigurationManagerImplBase
implements ConfigurationManager {
    protected static final char GROUP_SEPARATOR = '$';
    protected static final String SESSION_CONFIGURATION_KEY = "config";
    private final Map<String, ConfigurationParameterDeclarations> mContextNameToParamDeclsMap = new LinkedHashMap<String, ConfigurationParameterDeclarations>();
    protected final Map<String, String> mLinkMap = new LinkedHashMap<String, String>();
    private volatile Session mSession = null;

    @Override
    public void setSession(Session aSession) {
        this.mSession = aSession;
    }

    @Override
    public synchronized void createContext(String aContextName, ResourceMetaData aResourceMetaData, Settings externalOverrides) throws ResourceConfigurationException {
        ConfigurationGroup[] groups2;
        if (this.mContextNameToParamDeclsMap.containsKey(aContextName)) {
            return;
        }
        aResourceMetaData.validateConfigurationParameterSettings();
        ConfigurationParameterDeclarations paramDecls = aResourceMetaData.getConfigurationParameterDeclarations();
        ConfigurationParameterSettings settings = aResourceMetaData.getConfigurationParameterSettings();
        ConfigurationParameter[] paramsInNoGroup = paramDecls.getConfigurationParameters();
        if (paramsInNoGroup.length > 0) {
            this.declareParameters(null, paramsInNoGroup, settings, aContextName, externalOverrides);
        }
        if ((groups2 = paramDecls.getConfigurationGroups()) != null) {
            for (int i = 0; i < groups2.length; ++i) {
                String[] names = groups2[i].getNames();
                for (int j = 0; j < names.length; ++j) {
                    ConfigurationParameter[] params;
                    ConfigurationParameter[] commonParams = paramDecls.getCommonParameters();
                    if (commonParams != null) {
                        this.declareParameters(names[j], commonParams, settings, aContextName, externalOverrides);
                    }
                    if ((params = groups2[i].getConfigurationParameters()) == null) continue;
                    this.declareParameters(names[j], params, settings, aContextName, externalOverrides);
                }
            }
        }
        this.mContextNameToParamDeclsMap.put(aContextName, paramDecls);
        this.validateConfigurationParameterSettings(aContextName);
    }

    @Override
    public Object getConfigParameterValue(String aQualifiedParameterName) {
        Object val = this.lookup(aQualifiedParameterName);
        if (val != null) {
            return val;
        }
        String defaultGroup = null;
        ConfigurationParameterDeclarations decls = this.mContextNameToParamDeclsMap.get(this.computeParentContextName(aQualifiedParameterName));
        if (decls != null) {
            defaultGroup = decls.getDefaultGroupName();
        }
        if (defaultGroup != null) {
            return this.getConfigParameterValue(aQualifiedParameterName, defaultGroup);
        }
        return null;
    }

    @Override
    public Object getConfigParameterValue(String aQualifiedParameterName, String aGroupName) {
        ConfigurationParameterDeclarations decls = this.mContextNameToParamDeclsMap.get(this.computeParentContextName(aQualifiedParameterName));
        if (decls != null) {
            return this.getConfigParameterValue(aQualifiedParameterName, aGroupName, decls.getSearchStrategy(), decls.getDefaultGroupName());
        }
        return this.getConfigParameterValue(aQualifiedParameterName, aGroupName, null, null);
    }

    @Override
    public void setConfigParameterValue(String aQualifiedParamName, Object aValue) {
        this.setSessionParam(aQualifiedParamName, aValue);
    }

    @Override
    public void setConfigParameterValue(String aQualifiedParamName, String aGroupName, Object aValue) {
        if (aGroupName == null) {
            this.setConfigParameterValue(aQualifiedParamName, aValue);
        } else {
            String completeName = aQualifiedParamName + '$' + aGroupName;
            this.setSessionParam(completeName, aValue);
        }
    }

    @Override
    public void reconfigure(String aContextName) throws ResourceConfigurationException {
        this.validateConfigurationParameterSettings(aContextName);
    }

    @Override
    public ConfigurationParameterDeclarations getConfigParameterDeclarations(String aContextName) {
        return this.mContextNameToParamDeclsMap.get(aContextName);
    }

    @Override
    public ConfigurationParameterSettings getCurrentConfigParameterSettings(String aContextName) {
        ConfigurationParameterDeclarations decls = this.mContextNameToParamDeclsMap.get(aContextName);
        ConfigurationParameterSettings settings = UIMAFramework.getResourceSpecifierFactory().createConfigurationParameterSettings();
        ConfigurationParameter[] paramsInNoGroup = decls.getConfigurationParameters();
        if (paramsInNoGroup.length > 0) {
            settings.setParameterSettings(this.getParamSettings(null, paramsInNoGroup, aContextName));
        } else {
            ConfigurationGroup[] groups2 = decls.getConfigurationGroups();
            if (groups2 != null) {
                for (int i = 0; i < groups2.length; ++i) {
                    String[] names = groups2[i].getNames();
                    for (int j = 0; j < names.length; ++j) {
                        NameValuePair[] commonParamSettings = this.getParamSettings(names[j], decls.getCommonParameters(), aContextName);
                        NameValuePair[] specificParamSettings = this.getParamSettings(names[j], groups2[i].getConfigurationParameters(), aContextName);
                        NameValuePair[] mergedSettings = new NameValuePair[commonParamSettings.length + specificParamSettings.length];
                        System.arraycopy(commonParamSettings, 0, mergedSettings, 0, commonParamSettings.length);
                        System.arraycopy(specificParamSettings, 0, mergedSettings, commonParamSettings.length, specificParamSettings.length);
                        settings.getSettingsForGroups().put(names[j], mergedSettings);
                    }
                }
            }
        }
        return settings;
    }

    protected Object lookup(String aCompleteName) {
        Object val;
        String linkedTo = this.getLink(aCompleteName);
        if (linkedTo != null && (val = this.lookup(linkedTo)) != null) {
            return val;
        }
        val = this.getSessionParam(aCompleteName);
        if (val == null) {
            val = this.lookupSharedParamNoLinks(aCompleteName);
        }
        return val;
    }

    protected void declareParameters(String aGroupName, ConfigurationParameter[] aParams, ConfigurationParameterSettings aSettings, String aContextName, Settings aExternalOverrides) throws ResourceConfigurationException {
        if (aParams != null) {
            for (int i = 0; i < aParams.length; ++i) {
                ConfigurationParameter param = aParams[i];
                String qname = this.makeQualifiedName(aContextName, param.getName(), aGroupName);
                String[] overrides = param.getOverrides();
                for (int j = 0; j < overrides.length; ++j) {
                    this.mLinkMap.put(this.makeQualifiedName(aContextName, overrides[j], aGroupName), qname);
                }
            }
        }
    }

    protected String getLink(String aCompleteName) {
        return this.mLinkMap.get(aCompleteName);
    }

    protected abstract Object lookupSharedParamNoLinks(String var1);

    private NameValuePair[] getParamSettings(String aGroupName, ConfigurationParameter[] aParams, String aContextName) {
        ArrayList<NameValuePair> result = new ArrayList<NameValuePair>();
        if (aParams != null) {
            for (int i = 0; i < aParams.length; ++i) {
                ConfigurationParameter param = aParams[i];
                NameValuePair nvp = UIMAFramework.getResourceSpecifierFactory().createNameValuePair();
                nvp.setName(param.getName());
                String qualifiedName = this.makeQualifiedName(aContextName, param.getName(), aGroupName);
                nvp.setValue(this.lookup(qualifiedName));
                result.add(nvp);
            }
        }
        NameValuePair[] resultArr = new NameValuePair[result.size()];
        result.toArray(resultArr);
        return resultArr;
    }

    protected String makeQualifiedName(String aContextName, String aParamName, String aGroupName) {
        String name = aContextName + aParamName;
        if (aGroupName != null) {
            name = name + '$' + aGroupName;
        }
        return name;
    }

    private String computeParentContextName(String aContextName) {
        String nameWithoutSlash = aContextName.substring(0, aContextName.length() - 1);
        int lastSlash = nameWithoutSlash.lastIndexOf(47);
        if (lastSlash == -1) {
            return null;
        }
        return aContextName.substring(0, lastSlash + 1);
    }

    private void validateConfigurationParameterSettings(String aContext) throws ResourceConfigurationException {
        ConfigurationParameterDeclarations decls = this.mContextNameToParamDeclsMap.get(aContext);
        ConfigurationParameter[] params = decls.getConfigurationParameters();
        if (params.length > 0) {
            this.validateConfigurationParameterSettings(aContext, params, null);
        } else {
            ConfigurationParameter[] commonParams = decls.getCommonParameters();
            ConfigurationGroup[] groups2 = decls.getConfigurationGroups();
            if (groups2 != null) {
                for (int i = 0; i < groups2.length; ++i) {
                    ConfigurationParameter[] paramsInGroup = groups2[i].getConfigurationParameters();
                    String[] names = groups2[i].getNames();
                    for (int j = 0; j < names.length; ++j) {
                        if (paramsInGroup != null) {
                            this.validateConfigurationParameterSettings(aContext, paramsInGroup, names[j]);
                        }
                        if (commonParams == null) continue;
                        this.validateConfigurationParameterSettings(aContext, commonParams, names[j]);
                    }
                }
            }
        }
    }

    private void validateConfigurationParameterSettings(String aContext, ConfigurationParameter[] aParams, String aGroupName) throws ResourceConfigurationException {
        for (int i = 0; i < aParams.length; ++i) {
            Object val = this.getConfigParameterValue(aContext + aParams[i].getName(), aGroupName);
            if (val == null && aParams[i].isMandatory()) {
                if (aGroupName != null) {
                    throw new ResourceConfigurationException("mandatory_value_missing_in_group", new Object[]{aParams[i].getName(), aGroupName, aContext});
                }
                throw new ResourceConfigurationException("mandatory_value_missing", new Object[]{aParams[i].getName(), aContext});
            }
            this.validateConfigurationParameterDataTypeMatch(aParams[i], val, aContext);
        }
    }

    private void validateConfigurationParameterDataTypeMatch(ConfigurationParameter aParam, Object aValue, String aContextName) throws ResourceConfigurationException {
        if (aValue != null) {
            Class<?> valClass = aValue.getClass();
            if (aParam.isMultiValued() && !valClass.isArray()) {
                throw new ResourceConfigurationException("array_required", new Object[]{aParam.getName(), aContextName});
            }
            if (!valClass.equals(this.getParameterExpectedValueClass(aParam))) {
                throw new ResourceConfigurationException("parameter_type_mismatch", new Object[]{aContextName, valClass.getName(), aParam.getName(), aParam.getType()});
            }
        }
    }

    protected Class<?> getParameterExpectedValueClass(ConfigurationParameter aParam) {
        String paramType = aParam.getType();
        if (aParam.isMultiValued()) {
            if ("String".equals(paramType)) {
                return String[].class;
            }
            if ("Boolean".equals(paramType)) {
                return Boolean[].class;
            }
            if ("Integer".equals(paramType)) {
                return Integer[].class;
            }
            if ("Float".equals(paramType)) {
                return Float[].class;
            }
        } else {
            if ("String".equals(paramType)) {
                return String.class;
            }
            if ("Boolean".equals(paramType)) {
                return Boolean.class;
            }
            if ("Integer".equals(paramType)) {
                return Integer.class;
            }
            if ("Float".equals(paramType)) {
                return Float.class;
            }
        }
        throw new UIMARuntimeException();
    }

    private Object getConfigParameterValue(String aQualifiedParameterName, String aGroupName, String aSearchStrategy, String aDefaultGroup) {
        if ("default_fallback".equals(aSearchStrategy)) {
            Object value = this.getConfigParameterValue(aQualifiedParameterName, aGroupName, "none", null);
            if (value != null) {
                return value;
            }
            return this.getConfigParameterValue(aQualifiedParameterName, aDefaultGroup, "none", null);
        }
        if ("language_fallback".equals(aSearchStrategy)) {
            Object value = this.getConfigParameterValue(aQualifiedParameterName, aGroupName, "none", null);
            while (value == null && aGroupName != null) {
                int lastHyphen;
                int lastUnderscore = aGroupName.lastIndexOf(95);
                int truncateAt = lastUnderscore > (lastHyphen = aGroupName.lastIndexOf(45)) ? lastUnderscore : lastHyphen;
                if ((aGroupName = truncateAt == -1 ? null : aGroupName.substring(0, truncateAt)) == null) continue;
                value = this.getConfigParameterValue(aQualifiedParameterName, aGroupName, "none", null);
            }
            if (value == null) {
                value = this.getConfigParameterValue(aQualifiedParameterName, aDefaultGroup, "none", null);
            }
            return value;
        }
        return this.lookup(aGroupName == null ? aQualifiedParameterName : aQualifiedParameterName + '$' + aGroupName);
    }

    private Object getSessionParam(String aCompleteName) {
        Map m3;
        if (this.mSession != null && (m3 = (Map)this.mSession.get(SESSION_CONFIGURATION_KEY)) != null) {
            return m3.get(aCompleteName);
        }
        return null;
    }

    private void setSessionParam(String aCompleteName, Object aValue) {
        if (this.mSession == null) {
            throw new UIMA_IllegalStateException();
        }
        Map<String, Object> m3 = (Map<String, Object>)this.mSession.get(SESSION_CONFIGURATION_KEY);
        if (m3 == null) {
            m3 = Collections.synchronizedMap(new HashMap());
            this.mSession.put(SESSION_CONFIGURATION_KEY, m3);
        }
        m3.put(aCompleteName, aValue);
    }
}

