/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.components;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDetagger
extends CasAnnotator_ImplBase {
    public static final String PARAM_TEXT_TAG = "XmlTagContainingText";
    private SAXParserFactory parserFactory = SAXParserFactory.newInstance();
    private Type sourceDocInfoType;
    private String mXmlTagContainingText = null;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mXmlTagContainingText = (String)this.getContext().getConfigParameterValue(PARAM_TEXT_TAG);
    }

    @Override
    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        this.sourceDocInfoType = aTypeSystem.getType("org.apache.uima.examples.SourceDocumentInformation");
    }

    @Override
    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        CAS xmlCas = aCAS.getView("xmlDocument");
        InputStream xmlStream = xmlCas.getSofa().getSofaDataStream();
        DetagHandler handler = new DetagHandler();
        try {
            SAXParser parser = this.parserFactory.newSAXParser();
            parser.parse(xmlStream, (DefaultHandler)handler);
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException(e);
        }
        CAS plainTextView = aCAS.createView("plainTextDocument");
        plainTextView.setDocumentText(handler.getDetaggedText());
        plainTextView.setDocumentLanguage(aCAS.getView("_InitialView").getDocumentLanguage());
        FSIterator iter = xmlCas.getAnnotationIndex(this.sourceDocInfoType).iterator();
        if (iter.hasNext()) {
            FeatureStructure sourceDocInfoFs = (FeatureStructure)iter.next();
            plainTextView.getIndexRepository().addFS(sourceDocInfoFs);
        }
    }

    public static AnalysisEngineDescription getDescription() throws InvalidXMLException {
        InputStream descStream = XmlDetagger.class.getResourceAsStream("XmlDetagger.xml");
        return UIMAFramework.getXMLParser().parseAnalysisEngineDescription(new XMLInputSource(descStream, null));
    }

    public static URL getDescriptorURL() {
        return XmlDetagger.class.getResource("XmlDetagger.xml");
    }

    class DetagHandler
    extends DefaultHandler {
        private StringBuffer detaggedText = new StringBuffer();
        private boolean insideTextTag;

        public DetagHandler() {
            this.insideTextTag = XmlDetagger.this.mXmlTagContainingText == null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase(XmlDetagger.this.mXmlTagContainingText)) {
                this.insideTextTag = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase(XmlDetagger.this.mXmlTagContainingText)) {
                this.insideTextTag = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideTextTag) {
                this.detaggedText.append(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (this.insideTextTag) {
                this.detaggedText.append(ch, start, length);
            }
        }

        String getDetaggedText() {
            return this.detaggedText.toString();
        }
    }
}

