/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.tools.cvd.FSTreeModel;
import org.apache.uima.tools.cvd.FSTreeNode;

public class FSNode
extends FSTreeNode {
    private static final int maxStringLength = 100;
    private final FSTreeModel fSTreeModel;
    static final int INT_FS = 0;
    static final int FLOAT_FS = 1;
    static final int STRING_FS = 2;
    static final int ARRAY_FS = 3;
    static final int STD_FS = 4;
    static final int DISPLAY_NODE = 5;
    static final int BYTE_FS = 6;
    static final int BOOL_FS = 7;
    static final int SHORT_FS = 8;
    static final int LONG_FS = 9;
    static final int DOUBLE_FS = 10;
    private final int nodeClass;
    private final long addr;
    private final Feature feat;
    private final int arrayElem;
    private final boolean isArrayElem;
    private boolean isShortenedString = false;

    FSNode(FSTreeModel fSTreeModel, int nodeClass, long addr, Feature feat) {
        this.fSTreeModel = fSTreeModel;
        this.nodeClass = nodeClass;
        this.addr = addr;
        this.feat = feat;
        this.arrayElem = 0;
        this.isArrayElem = false;
    }

    FSNode(FSTreeModel fSTreeModel, int nodeClass, long addr, int elem) {
        this.fSTreeModel = fSTreeModel;
        this.nodeClass = nodeClass;
        this.addr = addr;
        this.feat = null;
        this.arrayElem = elem;
        this.isArrayElem = true;
    }

    int getNodeClass() {
        return this.nodeClass;
    }

    @Override
    protected void initChildren() {
        if (this.children != null) {
            return;
        }
        if (this.nodeClass != 4 && this.nodeClass != 3) {
            return;
        }
        if (this.addr == 0L) {
            return;
        }
        Type type = this.getType();
        CASImpl cas = this.fSTreeModel.getCas();
        if (this.fSTreeModel.getCas().isArrayType(type)) {
            int arrayLength = cas.ll_getArraySize((int)this.addr);
            FSNode node = null;
            int arrayPos = cas.getArrayStartAddress((int)this.addr);
            int nodeClass1 = cas.isIntArrayType(type) ? 0 : (cas.isFloatArrayType(type) ? 1 : (cas.isStringArrayType(type) ? 2 : (cas.isByteArrayType(type) ? 6 : (cas.isBooleanArrayType(type) ? 7 : (cas.isShortArrayType(type) ? 8 : (cas.isLongArrayType(type) ? 9 : (cas.isDoubleArrayType(type) ? 10 : 4)))))));
            ArrayList<FSNode> arrayNodes = new ArrayList<FSNode>(arrayLength);
            if (nodeClass1 == 0 || nodeClass1 == 1 || nodeClass1 == 2 || nodeClass1 == 4) {
                for (int i = 0; i < arrayLength; ++i) {
                    node = new FSNode(this.fSTreeModel, nodeClass1, (long)cas.getHeapValue(arrayPos), i);
                    arrayNodes.add(node);
                    ++arrayPos;
                }
            } else if (nodeClass1 == 6) {
                for (int i = 0; i < arrayLength; ++i) {
                    node = new FSNode(this.fSTreeModel, nodeClass1, (long)cas.ll_getByteArrayValue((int)this.addr, i), i);
                    arrayNodes.add(node);
                    ++arrayPos;
                }
            } else if (nodeClass1 == 8) {
                for (int i = 0; i < arrayLength; ++i) {
                    node = new FSNode(this.fSTreeModel, nodeClass1, (long)cas.ll_getShortArrayValue((int)this.addr, i), i);
                    arrayNodes.add(node);
                    ++arrayPos;
                }
            } else if (nodeClass1 == 7) {
                for (int i = 0; i < arrayLength; ++i) {
                    int temp = cas.ll_getBooleanArrayValue((int)this.addr, i) ? 1 : 0;
                    node = new FSNode(this.fSTreeModel, nodeClass1, (long)temp, i);
                    arrayNodes.add(node);
                    ++arrayPos;
                }
            } else if (nodeClass1 == 9) {
                for (int i = 0; i < arrayLength; ++i) {
                    long temp = cas.ll_getLongArrayValue((int)this.addr, i);
                    node = new FSNode(this.fSTreeModel, nodeClass1, temp, i);
                    arrayNodes.add(node);
                    ++arrayPos;
                }
            } else if (nodeClass1 == 10) {
                for (int i = 0; i < arrayLength; ++i) {
                    double temp = cas.ll_getDoubleArrayValue((int)this.addr, i);
                    node = new FSNode(this.fSTreeModel, nodeClass1, CASImpl.double2long(temp), i);
                    arrayNodes.add(node);
                    ++arrayPos;
                }
            }
            this.children = FSTreeModel.createArrayChildren(0, arrayLength, arrayNodes, this.fSTreeModel);
        } else {
            this.children = new ArrayList();
            List<Feature> feats = type.getFeatures();
            for (int i = 0; i < feats.size(); ++i) {
                FeatureImpl feat1 = (FeatureImpl)feats.get(i);
                long featAddr = cas.getHeapValue((int)this.addr + cas.getFeatureOffset(feat1.getCode()));
                if (cas.isDoubleType(feat1.getRange()) || cas.isLongType(feat1.getRange())) {
                    featAddr = cas.ll_getLongValue((int)featAddr);
                }
                FSNode childNode = new FSNode(this.fSTreeModel, this.fSTreeModel.getNodeType((int)this.addr, feat1), featAddr, feat1);
                this.children.add(childNode);
            }
        }
    }

    public String toString() {
        if (this.nodeClass == 5) {
            return this.fSTreeModel.getRootString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("<html>");
        if (this.isArrayElem) {
            buf.append('[');
            buf.append(this.arrayElem);
            buf.append("] = ");
        } else if (this.feat != null) {
            buf.append(this.getFeatureString());
            buf.append(" = ");
        }
        buf.append(this.getValueString());
        buf.append("</html>");
        return buf.toString();
    }

    private String getFeatureString() {
        return "<i>" + this.feat.getShortName() + "</i>";
    }

    boolean isShortenedString() {
        return this.isShortenedString;
    }

    String getFullString() {
        if (this.getNodeClass() != 2) {
            return null;
        }
        return this.fSTreeModel.getCas().getStringForCode((int)this.addr);
    }

    private String getValueString() {
        CASImpl cas = this.fSTreeModel.getCas();
        switch (this.nodeClass) {
            case 0: 
            case 6: 
            case 8: {
                return Long.toString(this.addr);
            }
            case 1: {
                return Float.toString(CASImpl.int2float((int)this.addr));
            }
            case 7: {
                return 0L == this.addr ? "false" : "true";
            }
            case 9: {
                return Long.toString(this.addr);
            }
            case 10: {
                return Double.toString(CASImpl.long2double(this.addr));
            }
            case 2: {
                String s1;
                if (this.addr == 0L) {
                    return this.getNullString();
                }
                String s2 = cas.getStringForCode((int)this.addr);
                this.isShortenedString = s2 != (s1 = FSNode.shortenString(s2));
                return "\"" + FSNode.escapeLt(s1) + "\"";
            }
            case 3: {
                if (cas.getHeapValue((int)this.addr) == 0) {
                    return this.getNullString();
                }
                return "<font color=blue>" + this.getType().getName() + "</font>[" + cas.ll_getArraySize((int)this.addr) + "]";
            }
            case 4: {
                if (cas.getHeapValue((int)this.addr) == 0) {
                    return this.getNullString();
                }
                return "<font color=blue>" + this.getType().getName() + "</font>";
            }
        }
        return null;
    }

    private static final String shortenString(String s2) {
        if (s2.length() <= 100) {
            return s2;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(s2.substring(0, 100));
        buf.append("...");
        return buf.toString();
    }

    private static final String escapeLt(String s2) {
        int i;
        int max = s2.length();
        for (i = 0; i < max && s2.charAt(i) != '<'; ++i) {
        }
        if (i == max) {
            return s2;
        }
        StringBuffer buf = new StringBuffer(s2.substring(0, i));
        while (i < max) {
            if (s2.charAt(i) == '<') {
                buf.append("&lt;");
            } else {
                buf.append(s2.charAt(i));
            }
            ++i;
        }
        return buf.toString();
    }

    private String getNullString() {
        return "&lt;null&gt;";
    }

    int getArrayPos() {
        return this.arrayElem;
    }

    Type getType() {
        CASImpl cas = this.fSTreeModel.getCas();
        return cas.getTypeSystemImpl().ll_getTypeForCode(cas.getHeapValue((int)this.addr));
    }

    public boolean isAnnotation() {
        CASImpl cas = this.fSTreeModel.getCas();
        if (this.nodeClass != 4 || this.addr == 0L) {
            return false;
        }
        return cas.getTypeSystem().subsumes(cas.getAnnotationType(), this.getType()) && cas == ((AnnotationFS)cas.createFS((int)this.addr)).getView();
    }

    public int getStart() {
        CASImpl cas = this.fSTreeModel.getCas();
        if (this.isAnnotation()) {
            FeatureImpl feat1 = (FeatureImpl)cas.getBeginFeature();
            return cas.getHeapValue((int)this.addr + cas.getFeatureOffset(feat1.getCode()));
        }
        return -1;
    }

    public int getEnd() {
        CASImpl cas = this.fSTreeModel.getCas();
        if (this.isAnnotation()) {
            FeatureImpl feat1 = (FeatureImpl)cas.getEndFeature();
            return cas.getHeapValue((int)this.addr + cas.getFeatureOffset(feat1.getCode()));
        }
        return -1;
    }
}

