/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import org.apache.uima.cas.impl.TypeSystem2Xml;
import org.apache.uima.tools.cvd.MainFrame;
import org.xml.sax.SAXException;

public class XCASSaveTSHandler
implements ActionListener {
    private final MainFrame main;

    public XCASSaveTSHandler(MainFrame frame) {
        this.main = frame;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save type system file");
        if (this.main.getXcasFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getXcasFileOpenDir());
        }
        if ((rc = fileChooser.showSaveDialog(this.main)) == 0) {
            File tsFile = fileChooser.getSelectedFile();
            if (!this.main.confirmOverwrite(tsFile)) {
                return;
            }
            this.main.setXcasFileOpenDir(tsFile.getParentFile());
            try {
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(tsFile));
                TypeSystem2Xml.typeSystem2Xml(this.main.getCas().getTypeSystem(), outStream);
                ((OutputStream)outStream).close();
            }
            catch (IOException e) {
                this.main.handleException(e);
            }
            catch (SAXException e) {
                this.main.handleException(e);
            }
        }
    }
}

