/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFileChooser;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.tools.cvd.MainFrame;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.SAXException;

public class XmiCasSaveHandler
implements ActionListener {
    private final MainFrame main;

    private XmiCasSaveHandler() {
        this.main = null;
    }

    public XmiCasSaveHandler(MainFrame main) {
        this.main = main;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Save XMI CAS file");
        if (this.main.getXcasFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getXcasFileOpenDir());
        }
        if ((rc = fileChooser.showSaveDialog(this.main)) == 0) {
            File xmiCasFile = fileChooser.getSelectedFile();
            if (!this.main.confirmOverwrite(xmiCasFile)) {
                return;
            }
            this.main.setXcasFileOpenDir(xmiCasFile.getParentFile());
            try {
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(xmiCasFile));
                XMLSerializer xmlSerializer = new XMLSerializer(outStream);
                XmiCasSerializer xmiCasSerializer = new XmiCasSerializer(this.main.getCas().getTypeSystem());
                xmiCasSerializer.serialize(this.main.getCas(), xmlSerializer.getContentHandler());
                ((OutputStream)outStream).close();
            }
            catch (IOException e) {
                this.main.handleException(e);
            }
            catch (SAXException e) {
                this.main.handleException(e);
            }
        }
    }
}

