/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.jcasgen;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.UIManager;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.tools.jcasgen.GUI;
import org.apache.uima.tools.jcasgen.IError;
import org.apache.uima.tools.jcasgen.IMerge;
import org.apache.uima.tools.jcasgen.IProgressMonitor;
import org.apache.uima.tools.jcasgen.JCasTypeTemplate;
import org.apache.uima.tools.jcasgen.JCas_TypeTemplate;
import org.apache.uima.tools.jcasgen.LogThrowErrorImpl;
import org.apache.uima.tools.jcasgen.Prefs;
import org.apache.uima.tools.jcasgen.TypeInfo;
import org.apache.uima.tools.jcasgen.UimaLoggerProgressMonitor;
import org.apache.uima.tools.jcasgen.Waiter;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLizable;

public class Jg {
    static final String jControlModel = "jMergeCtl.xml";
    static final FeatureDescription[] featureDescriptionArray0 = new FeatureDescription[0];
    static final Collection reservedFeatureNames = new ArrayList();
    static final Set noGenTypes = new HashSet();
    public static final Properties casCreateProperties = new Properties();
    static final Map extendableBuiltInTypes;
    static final FeatureDescription[] emptyFds;
    static TypeSystem builtInTypeSystem;
    static Map builtInTypes;
    private static ResourceBundle resourceBundle;
    final Map imports;
    final Map _imports;
    String classPath;
    String xmlSourceFileName;
    CAS cas;
    GUI gui;
    IMerge merger;
    IProgressMonitor progressMonitor;
    public IError error;
    Waiter waiter;
    String packageName;
    String simpleClassName;
    private TypeSystem typeSystem;
    private Type casStringType;
    private Type tcasAnnotationType;
    private Map<String, Set<String>> mergedTypesAddingFeatures;
    private String projectPathDir;
    private boolean limitJCasGenToProjectScope;
    private static ArrayList nonImportableJavaNames;

    private static void addBuiltInTypeInfo(String casName, String javaName, String casElementName) {
        TypeInfo ti = new TypeInfo(casName, javaName, casElementName);
        builtInTypes.put(casName, ti);
    }

    private static void addBuiltInTypeInfo(String casName, String javaName) {
        Jg.addBuiltInTypeInfo(casName, javaName, null);
    }

    public Jg() {
        reservedFeatureNames.add("Address");
        reservedFeatureNames.add("CAS");
        reservedFeatureNames.add("CASImpl");
        reservedFeatureNames.add("Class");
        reservedFeatureNames.add("FeatureValue");
        reservedFeatureNames.add("FeatureValueAsString");
        reservedFeatureNames.add("FeatureValueFromString");
        reservedFeatureNames.add("FloatValue");
        reservedFeatureNames.add("IntValue");
        reservedFeatureNames.add("LowLevelCas");
        reservedFeatureNames.add("StringValue");
        reservedFeatureNames.add("Type");
        reservedFeatureNames.add("View");
        reservedFeatureNames.add("TypeIndexID");
        this.imports = new HashMap();
        this._imports = new HashMap();
        this.classPath = "";
        this.typeSystem = null;
        this.mergedTypesAddingFeatures = new TreeMap<String, Set<String>>();
    }

    public String getResourceString(String key) {
        ResourceBundle bundle = this.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getString(String key, Object[] substitutions) {
        return MessageFormat.format(this.getResourceString(key), substitutions);
    }

    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public void driveGui() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Could not set look and feel: " + e.getMessage());
        }
        this.gui = new GUI(this);
        this.gui.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Prefs.set(Jg.this.gui);
                Jg.this.waiter.finished();
            }
        });
        Prefs.get(this.gui);
        this.gui.pnG.taStatus.setLineWrap(true);
        this.gui.pnG.taStatus.setWrapStyleWord(true);
        this.gui.show();
        this.waiter = new Waiter();
        this.waiter.waitforGUI();
    }

    public static void main(String[] args2) {
        int rc = new Jg().main0(args2, null, null, new LogThrowErrorImpl());
        System.exit(rc);
    }

    public void mainForCde(IMerge aMerger, IProgressMonitor aProgressMonitor, IError aError, String inputFile, String outputDirectory, TypeDescription[] tds, CASImpl aCas) throws IOException {
        this.mainForCde(aMerger, aProgressMonitor, aError, inputFile, outputDirectory, tds, aCas, "", false, null);
    }

    public void mainForCde(IMerge aMerger, IProgressMonitor aProgressMonitor, IError aError, String inputFile, String outputDirectory, TypeDescription[] tds, CASImpl aCas, String projectPathDir, boolean limitJCasGenToProjectScope, Map<String, Set<String>> mergedTypesAddingFeatures) throws IOException {
        try {
            this.mainGenerateAllTypesFromTemplates(aMerger, aProgressMonitor, aError, inputFile, outputDirectory, tds, aCas, JCasTypeTemplate.class, JCas_TypeTemplate.class, projectPathDir, limitJCasGenToProjectScope, mergedTypesAddingFeatures);
        }
        catch (InstantiationException e) {
            throw new IOException(e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IOException(e.toString());
        }
    }

    public void mainGenerateAllTypesFromTemplates(IMerge aMerger, IProgressMonitor aProgressMonitor, IError aError, String inputFile, String outputDirectory, TypeDescription[] tds, CASImpl aCas, Class jcasTypeClass, Class jcas_TypeClass) throws IOException, InstantiationException, IllegalAccessException {
        this.mainGenerateAllTypesFromTemplates(aMerger, aProgressMonitor, aError, inputFile, outputDirectory, tds, aCas, jcasTypeClass, jcas_TypeClass, "", false, null);
    }

    public void mainGenerateAllTypesFromTemplates(IMerge aMerger, IProgressMonitor aProgressMonitor, IError aError, String inputFile, String outputDirectory, TypeDescription[] tds, CASImpl aCas, Class jcasTypeClass, Class jcas_TypeClass, String projectPathDir, boolean limitJCasGenToProjectScope, Map<String, Set<String>> mergedTypesAddingFeatures) throws IOException, InstantiationException, IllegalAccessException {
        this.merger = aMerger;
        this.error = aError;
        this.progressMonitor = aProgressMonitor;
        this.xmlSourceFileName = inputFile.replaceAll("\\\\", "/");
        this.projectPathDir = projectPathDir;
        this.limitJCasGenToProjectScope = limitJCasGenToProjectScope;
        this.mergedTypesAddingFeatures = mergedTypesAddingFeatures;
        this.generateAllTypesFromTemplates(outputDirectory, tds, aCas, jcasTypeClass, jcas_TypeClass);
    }

    public int main0(String[] args2, IMerge aMerger, IProgressMonitor aProgressMonitor, IError aError) {
        this.merger = aMerger;
        this.error = aError;
        this.progressMonitor = aProgressMonitor;
        boolean foundInput = false;
        for (int i = 0; i < args2.length; ++i) {
            if (!args2[i].equals("-jcasgeninput")) continue;
            if (i == args2.length - 1) {
                this.driveGui();
                return 0;
            }
            foundInput = true;
            break;
        }
        if (foundInput) {
            return this.main1(args2);
        }
        this.driveGui();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main1(String[] arguments) {
        boolean hadError = false;
        try {
            try {
                URL url;
                if (null == this.progressMonitor) {
                    this.progressMonitor = new UimaLoggerProgressMonitor();
                }
                if (null == this.error) {
                    this.error = new LogThrowErrorImpl();
                }
                String inputFile = null;
                String outputDirectory = null;
                TypeSystemDescription typeSystemDescription = null;
                TypeDescription[] tds = null;
                this.projectPathDir = "";
                this.limitJCasGenToProjectScope = false;
                for (int i = 0; i < arguments.length - 1; ++i) {
                    if (arguments[i].equalsIgnoreCase("-jcasgeninput")) {
                        inputFile = arguments[++i];
                        continue;
                    }
                    if (arguments[i].equalsIgnoreCase("-jcasgenoutput")) {
                        outputDirectory = arguments[++i];
                        continue;
                    }
                    if (arguments[i].equalsIgnoreCase("=jcasgenclasspath") || arguments[i].equalsIgnoreCase("-jcasgenclasspath")) {
                        this.classPath = arguments[++i];
                        continue;
                    }
                    if (!arguments[i].equalsIgnoreCase("-limitToDirectory")) continue;
                    this.projectPathDir = arguments[++i];
                    this.limitJCasGenToProjectScope = this.projectPathDir.length() > 0;
                }
                this.xmlSourceFileName = inputFile.replaceAll("\\\\", "/");
                if (inputFile.substring(0, 4).equalsIgnoreCase("jar:")) {
                    try {
                        url = new URL(inputFile);
                        if (null == outputDirectory || outputDirectory.equals("")) {
                            this.error.newError(2, this.getString("sourceArgNeedsDirectory", new Object[]{inputFile}), null);
                        }
                    }
                    catch (MalformedURLException e) {
                        this.error.newError(2, this.getString("fileNotFound", new Object[]{inputFile}), null);
                        url = null;
                    }
                } else {
                    File file = new File(inputFile);
                    if (!file.exists()) {
                        this.error.newError(2, this.getString("fileNotFound", new Object[]{inputFile}), null);
                    }
                    if (null == outputDirectory || outputDirectory.equals("")) {
                        File dir = file.getParentFile();
                        if (null == dir) {
                            this.error.newError(2, this.getString("sourceArgNeedsDirectory", new Object[]{inputFile}), null);
                        }
                        outputDirectory = dir.getPath() + File.separator + "JCas" + (null != this.merger ? "" : "New");
                    }
                    url = file.toURI().toURL();
                }
                this.progressMonitor.beginTask("", 5);
                this.progressMonitor.subTask("Output going to '" + outputDirectory + "'");
                this.progressMonitor.subTask(this.getString("ReadingDescriptorAndCreatingTypes", new Object[]{inputFile}));
                CASImpl casLocal = null;
                try {
                    XMLInputSource in = new XMLInputSource(url);
                    XMLizable specifier = UIMAFramework.getXMLParser().parse(in);
                    this.mergedTypesAddingFeatures.clear();
                    if (specifier instanceof AnalysisEngineDescription) {
                        AnalysisEngineDescription aeSpecifier = (AnalysisEngineDescription)specifier;
                        typeSystemDescription = !aeSpecifier.isPrimitive() ? CasCreationUtils.mergeDelegateAnalysisEngineTypeSystems(aeSpecifier, this.createResourceManager(), this.mergedTypesAddingFeatures) : this.mergeTypeSystemImports(aeSpecifier.getAnalysisEngineMetaData().getTypeSystem());
                    } else if (specifier instanceof TypeSystemDescription) {
                        typeSystemDescription = this.mergeTypeSystemImports((TypeSystemDescription)specifier);
                    } else {
                        this.error.newError(2, this.getString("fileDoesntParse", new Object[]{inputFile}), null);
                    }
                    if (this.mergedTypesAddingFeatures.size() > 0) {
                        this.error.newError(1, this.getString("typesHaveFeaturesAdded", new Object[]{this.makeMergeMessage(this.mergedTypesAddingFeatures)}), null);
                    }
                    TypePriorities typePriorities = null;
                    FsIndexDescription[] fsIndexDescription = null;
                    try {
                        casLocal = (CASImpl)CasCreationUtils.createCas(typeSystemDescription, typePriorities, fsIndexDescription);
                    }
                    catch (ResourceInitializationException e) {
                        this.error.newError(1, this.getString("resourceInitializationException", new Object[]{e.getLocalizedMessage()}), e);
                        casLocal = null;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InvalidXMLException e) {
                    this.error.newError(2, this.getString("invalidXML", new Object[]{inputFile}), e);
                }
                catch (ResourceInitializationException e) {
                    this.error.newError(2, this.getString("resourceInitializationExceptionError", new Object[0]), e);
                }
                this.progressMonitor.worked(1);
                tds = typeSystemDescription.getTypes();
                this.generateAllTypesFromTemplates(outputDirectory, tds, casLocal, JCasTypeTemplate.class, JCas_TypeTemplate.class);
            }
            catch (IOException e) {
                this.error.newError(2, this.getString("IOException", new Object[0]), e);
            }
            catch (ErrorExit e) {
                hadError = true;
            }
            catch (InstantiationException e) {
                this.error.newError(2, this.getString("InstantiationException", new Object[0]), e);
            }
            catch (IllegalAccessException e) {
                this.error.newError(2, this.getString("IllegalAccessException", new Object[0]), e);
            }
        }
        finally {
            this.progressMonitor.done();
        }
        return hadError ? -1 : 0;
    }

    private String makeMergeMessage(Map m3) {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry entry : m3.entrySet()) {
            String typeName = (String)entry.getKey();
            sb.append("\n  ");
            sb.append("TypeName having merged features = ").append(typeName).append("\n    URLs defining this type =");
            Set urls = (Set)entry.getValue();
            boolean afterFirst = false;
            Iterator itUrls = urls.iterator();
            while (itUrls.hasNext()) {
                if (afterFirst) {
                    sb.append(",\n        ");
                } else {
                    sb.append("\n        ");
                }
                afterFirst = true;
                String url = (String)itUrls.next();
                sb.append('\"').append(url).append('\"');
            }
        }
        return sb.toString();
    }

    private void generateAllTypesFromTemplates(String outputDirectory, TypeDescription[] tds, CASImpl aCas, Class jcasTypeClass, Class jcas_TypeClass) throws IOException, InstantiationException, IllegalAccessException {
        IJCasTypeTemplate jcasTypeInstance = (IJCasTypeTemplate)jcasTypeClass.newInstance();
        IJCasTypeTemplate jcas_TypeInstance = (IJCasTypeTemplate)jcas_TypeClass.newInstance();
        TreeSet<String> generatedBuiltInTypes = new TreeSet<String>();
        this.cas = aCas;
        this.typeSystem = this.cas.getTypeSystem();
        this.casStringType = this.typeSystem.getType("uima.cas.String");
        this.tcasAnnotationType = this.typeSystem.getType("uima.tcas.Annotation");
        for (int i = 0; i < tds.length; ++i) {
            TypeDescription td = tds[i];
            if (noGenTypes.contains(td.getName()) || td.getSupertypeName().equals("uima.cas.String")) continue;
            if (this.limitJCasGenToProjectScope && this.isOutOfScope(td, this.projectPathDir)) {
                Set<String> mt = this.mergedTypesAddingFeatures.get(td.getName());
                if (null == mt) continue;
                StringBuilder sb = new StringBuilder("\n");
                for (String p : mt) {
                    sb.append("  ").append(p).append('\n');
                }
                this.error.newError(2, this.getString("limitingButTypeWasExtended", new Object[]{td.getName(), sb.toString()}), null);
                continue;
            }
            FeatureDescription[] builtInFeatures = (FeatureDescription[])extendableBuiltInTypes.get(td.getName());
            if (null != builtInFeatures) {
                generatedBuiltInTypes.add(td.getName());
                List newFeatures = this.setDifference(td.getFeatures(), builtInFeatures);
                int newFeaturesSize = newFeatures.size();
                if (newFeaturesSize <= 0) continue;
                int newSize = builtInFeatures.length + newFeaturesSize;
                FeatureDescription[] newFds = new FeatureDescription[newSize];
                System.arraycopy(builtInFeatures, 0, newFds, 0, builtInFeatures.length);
                int j = builtInFeatures.length;
                for (int k = 0; k < newFeaturesSize; ++k) {
                    newFds[j] = (FeatureDescription)newFeatures.get(k);
                    ++j;
                }
                td.setFeatures(newFds);
            }
            this.generateClassesFromTemplate(td, outputDirectory, jcasTypeInstance, jcas_TypeInstance);
        }
    }

    private boolean isOutOfScope(TypeDescription td, String projectDirPath) {
        boolean r;
        URI typeDefinitionUri;
        try {
            typeDefinitionUri = new URI(td.getSourceUrlString());
        }
        catch (URISyntaxException e) {
            return true;
        }
        String tdPath = typeDefinitionUri.getPath();
        if (tdPath == null) {
            return true;
        }
        String resolvedProjectPath = !projectDirPath.startsWith("/") ? new File(projectDirPath).getAbsoluteFile().toURI().getPath() : projectDirPath;
        if (!tdPath.endsWith("/")) {
            tdPath = tdPath + "/";
        }
        if (!resolvedProjectPath.endsWith("/")) {
            resolvedProjectPath = resolvedProjectPath + "/";
        }
        boolean bl = r = !tdPath.startsWith(resolvedProjectPath);
        if (r) {
            return true;
        }
        Set<String> mergedPaths = this.mergedTypesAddingFeatures.get(td.getName());
        if (null != mergedPaths) {
            for (String p : mergedPaths) {
                URI tempURI;
                try {
                    tempURI = new URI(p);
                }
                catch (URISyntaxException e) {
                    return true;
                }
                String tempPath = tempURI.getPath();
                if (tempPath.startsWith(resolvedProjectPath)) continue;
                return true;
            }
        }
        return false;
    }

    private void generateClassesFromTemplate(TypeDescription td, String outputDirectory, IJCasTypeTemplate jcasTypeInstance, IJCasTypeTemplate jcas_TypeInstance) throws IOException {
        this.simpleClassName = Jg.removePkg(this.getJavaName(td));
        this.generateClass(this.progressMonitor, outputDirectory, td, jcasTypeInstance.generate(new Object[]{this, td}), this.getJavaName(td), this.merger);
        this.simpleClassName = Jg.removePkg(this.getJavaName_Type(td));
        this.generateClass(this.progressMonitor, outputDirectory, td, jcas_TypeInstance.generate(new Object[]{this, td}), this.getJavaName_Type(td), this.merger);
    }

    String getPkg(TypeDescription td) {
        return this.getPkg(td.getName());
    }

    String getPkg(String nameWithPkg) {
        int lastDot = nameWithPkg.lastIndexOf(46);
        if (lastDot >= 0) {
            return nameWithPkg.substring(0, lastDot);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateClass(IProgressMonitor progressMonitorGenerateClass, String outputDirectory, TypeDescription td, String sourceContents, String className, IMerge mergerGenerateClass) throws IOException {
        String pkgName = this.getJavaPkg(td);
        String qualifiedClassName = 0 != pkgName.length() ? pkgName + "." + className : className;
        String targetContainer = outputDirectory + '/' + pkgName.replace('.', '/');
        String targetPath = targetContainer + "/" + className + ".java";
        File targetFile = new File(targetPath);
        if (null != mergerGenerateClass) {
            mergerGenerateClass.doMerge(this, progressMonitorGenerateClass, sourceContents, targetContainer, targetPath, qualifiedClassName, targetFile);
        } else {
            if (targetFile.exists()) {
                progressMonitorGenerateClass.subTask(this.getString("replacingTarget", new Object[]{qualifiedClassName}));
            } else {
                progressMonitorGenerateClass.subTask(this.getString("creatingTarget", new Object[]{qualifiedClassName}));
            }
            new File(targetContainer).mkdirs();
            try (FileWriter fw = new FileWriter(targetPath);){
                fw.write(sourceContents);
            }
        }
    }

    public static String removePkg(String name) {
        int lastDot = name.lastIndexOf(46);
        String simpleName = name;
        if (lastDot >= 0) {
            simpleName = name.substring(lastDot + 1);
        }
        return simpleName;
    }

    String sc(String v) {
        if (v.equals("int")) {
            return "Int";
        }
        if (v.equals("float")) {
            return "Float";
        }
        if (v.equals("String")) {
            return "String";
        }
        if (v.equals("boolean")) {
            return "Boolean";
        }
        if (v.equals("byte")) {
            return "Byte";
        }
        if (v.equals("short")) {
            return "Short";
        }
        if (v.equals("long")) {
            return "Long";
        }
        if (v.equals("double")) {
            return "Double";
        }
        return "Ref";
    }

    String getJavaPkg(TypeDescription td) {
        TypeInfo bi = (TypeInfo)builtInTypes.get(td.getName());
        if (null == bi) {
            return this.getPkg(td);
        }
        return this.getPkg(bi.javaNameWithPkg);
    }

    String getJavaNameWithPkg(String casTypeName) {
        TypeInfo bi = (TypeInfo)builtInTypes.get(casTypeName);
        return null == bi ? casTypeName : bi.javaNameWithPkg;
    }

    boolean hasPkgPrefix(String name) {
        return name.lastIndexOf(46) >= 0;
    }

    String getJavaName(TypeDescription td) {
        return this.getJavaName(td.getName());
    }

    String getJavaName_Type(TypeDescription td) {
        return this.getJavaName(td) + "_Type";
    }

    String getJavaName(String name) {
        if (!this.hasPkgPrefix(name)) {
            return name;
        }
        String javaNameWithPkg = this.getJavaNameWithPkg(name);
        String simpleName = Jg.removePkg(javaNameWithPkg);
        if (this.getPkg(javaNameWithPkg).equals(this.packageName)) {
            return simpleName;
        }
        if (javaNameWithPkg.equals(this.imports.get(simpleName))) {
            return simpleName;
        }
        return javaNameWithPkg;
    }

    void collectImport(String casName, boolean _Type) {
        String simpleName;
        if (!this.hasPkgPrefix(casName)) {
            return;
        }
        String javaNameWithPkg = this.getJavaNameWithPkg(casName);
        if (nonImportableJavaNames.contains(javaNameWithPkg)) {
            return;
        }
        String pkg = this.getPkg(javaNameWithPkg);
        if (pkg.equals(this.packageName)) {
            return;
        }
        if (_Type) {
            javaNameWithPkg = javaNameWithPkg + "_Type";
        }
        if ((simpleName = Jg.removePkg(javaNameWithPkg)).equals(this.simpleClassName)) {
            return;
        }
        if (null == this.imports.get(simpleName)) {
            if (_Type) {
                this._imports.put(simpleName, javaNameWithPkg);
            } else {
                this.imports.put(simpleName, javaNameWithPkg);
            }
        }
    }

    Collection collectImports(TypeDescription td, boolean _Type) {
        if (_Type) {
            this._imports.clear();
        } else {
            this.imports.clear();
        }
        this.collectImport(td.getName(), _Type);
        this.collectImport(td.getSupertypeName(), _Type);
        if (!_Type) {
            FeatureDescription[] fds = td.getFeatures();
            for (int i = 0; i < fds.length; ++i) {
                String rangeTypeNameCAS;
                Type rangeCasType;
                FeatureDescription fd = fds[i];
                if (null != this.typeSystem && this.typeSystem.subsumes(this.casStringType, rangeCasType = this.typeSystem.getType(rangeTypeNameCAS = fd.getRangeTypeName()))) continue;
                this.collectImport(fd.getRangeTypeName(), false);
                if (!this.hasArrayRange(fd)) continue;
                this.collectImport(this.getJavaRangeArrayElementType(fd), false);
            }
        }
        return _Type ? this._imports.values() : this.imports.values();
    }

    String getJavaRangeType(FeatureDescription fd) {
        Type rangeCasType;
        String rangeTypeNameCAS = fd.getRangeTypeName();
        if (null != this.typeSystem && this.typeSystem.subsumes(this.casStringType, rangeCasType = this.typeSystem.getType(rangeTypeNameCAS))) {
            return "String";
        }
        return this.getJavaName(rangeTypeNameCAS);
    }

    boolean isSubTypeOfAnnotation(TypeDescription td) {
        if (null == this.cas) {
            return false;
        }
        Type type = this.typeSystem.getType(td.getName());
        if (null == type) {
            return false;
        }
        return this.typeSystem.subsumes(this.tcasAnnotationType, type);
    }

    boolean hasArrayRange(FeatureDescription fd) {
        TypeInfo bi = (TypeInfo)builtInTypes.get(fd.getRangeTypeName());
        if (null == bi) {
            return false;
        }
        return bi.isArray;
    }

    String getJavaRangeArrayElementType(FeatureDescription fd) {
        String arrayElementCasNameWithNameSpace = fd.getElementType();
        TypeInfo bi = (TypeInfo)builtInTypes.get(fd.getRangeTypeName());
        if (null == bi) {
            if (null == arrayElementCasNameWithNameSpace) {
                return "";
            }
            return this.getJavaName(arrayElementCasNameWithNameSpace);
        }
        if (null != arrayElementCasNameWithNameSpace && !"".equals(arrayElementCasNameWithNameSpace)) {
            return this.getJavaName(arrayElementCasNameWithNameSpace);
        }
        return this.getJavaName(bi.arrayElNameWithPkg);
    }

    String uc1(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    String getDate() {
        return new Date().toString();
    }

    String castResult(String resultType, String core) {
        if ("Ref".equals(this.sc(resultType)) && resultType != null && !resultType.equals("FeatureStructure")) {
            return "(" + resultType + ")(" + core + ")";
        }
        return core;
    }

    String wrapToGetFS(String core, String range) {
        if (range.equals("Ref")) {
            return "jcasType.ll_cas.ll_getFSForRef(" + core + ")";
        }
        return core;
    }

    String simpleCore(String get_set, String range, String fname, String tname_Type) {
        String v = ", v";
        if (get_set.equals("set") && range.equals("Ref")) {
            v = ", jcasType.ll_cas.ll_getFSRef(v)";
        }
        return "jcasType.ll_cas.ll_" + get_set + range + "Value(addr, ((" + tname_Type + ")jcasType).casFeatCode_" + fname + (get_set.equals("set") ? v : "") + ")";
    }

    String simpleLLCore(String get_set, String range, String fname) {
        String v = ", v";
        return "ll_cas.ll_" + get_set + range + "Value(addr, casFeatCode_" + fname + (get_set.equals("set") ? v : "") + ")";
    }

    String arrayCore(String get_set, String range, String fname, String tname_Type) {
        String v = ", v";
        if (get_set.equals("set") && range.equals("Ref")) {
            v = ", jcasType.ll_cas.ll_getFSRef(v)";
        }
        return "jcasType.ll_cas.ll_" + get_set + range + "ArrayValue(" + this.simpleCore("get", "Ref", fname, tname_Type) + ", i" + (get_set.equals("set") ? v : "") + ")";
    }

    String arrayLLCore(String get_set, String range, String fname) {
        String v = ", v";
        return "ll_cas.ll_" + get_set + range + "ArrayValue(" + this.simpleLLCore("get", "Ref", fname) + ", i" + (get_set.equals("set") ? v : "") + ")";
    }

    String arrayLLCoreChk(String get_set, String range, String fname) {
        String v = ", v";
        return "ll_cas.ll_" + get_set + range + "ArrayValue(" + this.simpleLLCore("get", "Ref", fname) + ", i" + (get_set.equals("set") ? v : "") + ", true)";
    }

    String getFeatureValue(FeatureDescription fd, TypeDescription td) {
        String getSetNamePart = this.getGetSetNamePart(fd);
        String core = this.wrapToGetFS(this.simpleCore("get", getSetNamePart, fd.getName(), this.getJavaName(td) + "_Type"), getSetNamePart);
        return this.castResult(this.getJavaRangeType(fd), core);
    }

    String setFeatureValue(FeatureDescription fd, TypeDescription td) {
        return this.simpleCore("set", this.getGetSetNamePart(fd), fd.getName(), this.getJavaName(td) + "_Type");
    }

    String getArrayFeatureValue(FeatureDescription fd, TypeDescription td) {
        String getSetArrayNamePart = this.getGetSetArrayNamePart(fd);
        String core = this.wrapToGetFS(this.arrayCore("get", getSetArrayNamePart, fd.getName(), this.getJavaName(td) + "_Type"), getSetArrayNamePart);
        return this.castResult(this.getJavaRangeArrayElementType(fd), core);
    }

    String setArrayFeatureValue(FeatureDescription fd, TypeDescription td) {
        return this.arrayCore("set", this.getGetSetArrayNamePart(fd), fd.getName(), this.getJavaName(td) + "_Type");
    }

    String getGetSetNamePart(FeatureDescription fd) {
        return this.sc(this.getJavaRangeType(fd));
    }

    String getGetSetArrayNamePart(FeatureDescription fd) {
        return this.sc(this.getJavaRangeArrayElementType(fd));
    }

    String nullBlank(String s2) {
        if (null == s2) {
            return "";
        }
        return s2;
    }

    public ResourceManager createResourceManager() {
        ResourceManager resourceManager = UIMAFramework.newDefaultResourceManager();
        try {
            resourceManager.setExtensionClassPath(this.getClass().getClassLoader(), this.classPath, true);
        }
        catch (MalformedURLException e1) {
            this.error.newError(2, this.getString("Internal Error", null), e1);
        }
        return resourceManager;
    }

    private TypeSystemDescription mergeTypeSystemImports(TypeSystemDescription tsd) throws ResourceInitializationException {
        ArrayList<Object> tsdc = new ArrayList<Object>(1);
        tsdc.add(tsd.clone());
        this.mergedTypesAddingFeatures.clear();
        TypeSystemDescription mergedTsd = CasCreationUtils.mergeTypeSystems(tsdc, this.createResourceManager(), this.mergedTypesAddingFeatures);
        return mergedTsd;
    }

    List setDifference(FeatureDescription[] newFeatures, FeatureDescription[] alreadyDefinedFeatures) {
        ArrayList<FeatureDescription> result = new ArrayList<FeatureDescription>();
        block0: for (int i = 0; i < newFeatures.length; ++i) {
            for (int j = 0; j < alreadyDefinedFeatures.length; ++j) {
                if (this.isSameFeatureDescription(newFeatures[i], alreadyDefinedFeatures[j])) continue block0;
            }
            result.add(newFeatures[i]);
        }
        return result;
    }

    private boolean isSameFeatureDescription(FeatureDescription f1, FeatureDescription f2) {
        if (!f2.getName().equals(f1.getName())) {
            return false;
        }
        return f2.getRangeTypeName().equals(f1.getRangeTypeName());
    }

    static {
        casCreateProperties.setProperty("cas_initial_heap_size", "200");
        extendableBuiltInTypes = new HashMap();
        emptyFds = new FeatureDescription[0];
        CAS tcas = null;
        try {
            tcas = CasCreationUtils.createCas((TypeSystemDescription)null, null, new FsIndexDescription[0], casCreateProperties);
        }
        catch (ResourceInitializationException e1) {
            // empty catch block
        }
        builtInTypeSystem = ((CASImpl)tcas).getTypeSystemImpl();
        ((CASImpl)tcas).commitTypeSystem();
        Iterator<Type> it = builtInTypeSystem.getTypeIterator();
        while (it.hasNext()) {
            Type type = it.next();
            if (type.isFeatureFinal()) {
                noGenTypes.add(type.getName());
                continue;
            }
            String typeName = type.getName();
            List<Feature> fs = type.getFeatures();
            ArrayList<Feature> features = new ArrayList<Feature>(fs.size());
            for (int i = 0; i < fs.size(); ++i) {
                Feature f = fs.get(i);
                String fName = f.getName();
                String fTypeName = fName.substring(0, fName.indexOf(58));
                if (!typeName.equals(fTypeName)) continue;
                features.add(f);
            }
            FeatureDescription[] fds = new FeatureDescription[features.size()];
            for (int i = 0; i < features.size(); ++i) {
                FeatureDescription fd = UIMAFramework.getResourceSpecifierFactory().createFeatureDescription();
                Feature f = (Feature)features.get(i);
                fd.setName(f.getShortName());
                fd.setRangeTypeName(f.getRange().getName());
                fds[i] = fd;
            }
            extendableBuiltInTypes.put(typeName, fds);
        }
        builtInTypes = new HashMap();
        Jg.addBuiltInTypeInfo("uima.cas.TOP", "org.apache.uima.cas.FeatureStructure");
        Jg.addBuiltInTypeInfo("uima.cas.Integer", "int");
        Jg.addBuiltInTypeInfo("uima.cas.Float", "float");
        Jg.addBuiltInTypeInfo("uima.cas.String", "String");
        Jg.addBuiltInTypeInfo("uima.cas.Byte", "byte");
        Jg.addBuiltInTypeInfo("uima.cas.Short", "short");
        Jg.addBuiltInTypeInfo("uima.cas.Long", "long");
        Jg.addBuiltInTypeInfo("uima.cas.Double", "double");
        Jg.addBuiltInTypeInfo("uima.cas.Boolean", "boolean");
        Jg.addBuiltInTypeInfo("uima.cas.TOP", "org.apache.uima.jcas.cas.TOP");
        Jg.addBuiltInTypeInfo("uima.cas.FSArray", "org.apache.uima.jcas.cas.FSArray", "uima.cas.TOP");
        Jg.addBuiltInTypeInfo("uima.cas.IntegerArray", "org.apache.uima.jcas.cas.IntegerArray", "uima.cas.Integer");
        Jg.addBuiltInTypeInfo("uima.cas.FloatArray", "org.apache.uima.jcas.cas.FloatArray", "uima.cas.Float");
        Jg.addBuiltInTypeInfo("uima.cas.StringArray", "org.apache.uima.jcas.cas.StringArray", "uima.cas.String");
        Jg.addBuiltInTypeInfo("uima.cas.BooleanArray", "org.apache.uima.jcas.cas.BooleanArray", "uima.cas.Boolean");
        Jg.addBuiltInTypeInfo("uima.cas.ByteArray", "org.apache.uima.jcas.cas.ByteArray", "uima.cas.Byte");
        Jg.addBuiltInTypeInfo("uima.cas.ShortArray", "org.apache.uima.jcas.cas.ShortArray", "uima.cas.Short");
        Jg.addBuiltInTypeInfo("uima.cas.LongArray", "org.apache.uima.jcas.cas.LongArray", "uima.cas.Long");
        Jg.addBuiltInTypeInfo("uima.cas.DoubleArray", "org.apache.uima.jcas.cas.DoubleArray", "uima.cas.Double");
        Jg.addBuiltInTypeInfo("uima.cas.AnnotationBase", "org.apache.uima.jcas.cas.AnnotationBase");
        Jg.addBuiltInTypeInfo("uima.tcas.Annotation", "org.apache.uima.jcas.tcas.Annotation");
        Jg.addBuiltInTypeInfo("uima.tcas.DocumentAnnotation", "org.apache.uima.jcas.tcas.DocumentAnnotation");
        Jg.addBuiltInTypeInfo("uima.cas.EmptyFloatList", "org.apache.uima.jcas.cas.EmptyFloatList");
        Jg.addBuiltInTypeInfo("uima.cas.EmptyFSList", "org.apache.uima.jcas.cas.EmptyFSList");
        Jg.addBuiltInTypeInfo("uima.cas.EmptyIntegerList", "org.apache.uima.jcas.cas.EmptyIntegerList");
        Jg.addBuiltInTypeInfo("uima.cas.EmptyStringList", "org.apache.uima.jcas.cas.EmptyStringList");
        Jg.addBuiltInTypeInfo("uima.cas.FloatList", "org.apache.uima.jcas.cas.FloatList");
        Jg.addBuiltInTypeInfo("uima.cas.FSList", "org.apache.uima.jcas.cas.FSList");
        Jg.addBuiltInTypeInfo("uima.cas.IntegerList", "org.apache.uima.jcas.cas.IntegerList");
        Jg.addBuiltInTypeInfo("uima.cas.StringList", "org.apache.uima.jcas.cas.StringList");
        Jg.addBuiltInTypeInfo("uima.cas.NonEmptyFloatList", "org.apache.uima.jcas.cas.NonEmptyFloatList");
        Jg.addBuiltInTypeInfo("uima.cas.NonEmptyFSList", "org.apache.uima.jcas.cas.NonEmptyFSList");
        Jg.addBuiltInTypeInfo("uima.cas.NonEmptyIntegerList", "org.apache.uima.jcas.cas.NonEmptyIntegerList");
        Jg.addBuiltInTypeInfo("uima.cas.NonEmptyStringList", "org.apache.uima.jcas.cas.NonEmptyStringList");
        Jg.addBuiltInTypeInfo("uima.cas.Sofa", "org.apache.uima.jcas.cas.Sofa");
        try {
            resourceBundle = ResourceBundle.getBundle("org.apache.uima.tools.jcasgen.jcasgenpPluginResources");
        }
        catch (MissingResourceException x) {
            resourceBundle = null;
        }
        nonImportableJavaNames = new ArrayList(8);
        nonImportableJavaNames.add("String");
        nonImportableJavaNames.add("float");
        nonImportableJavaNames.add("int");
        nonImportableJavaNames.add("boolean");
        nonImportableJavaNames.add("byte");
        nonImportableJavaNames.add("short");
        nonImportableJavaNames.add("long");
        nonImportableJavaNames.add("double");
    }

    public static class ErrorExit
    extends RuntimeException {
        private static final long serialVersionUID = -3314235749649859540L;
    }

    public static interface IJCasTypeTemplate {
        public String generate(Object var1);
    }
}

