/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.tools.images.Images;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;

public class CasTreeViewer
extends JPanel {
    private static final long serialVersionUID = -674412767134245565L;
    private JSplitPane splitPane;
    private JTree tree;
    private JPanel rightPanel;
    private JLabel annotationTypeLabel;
    private JTextPane annotationTextPane;
    private JTable featureTable;

    public CasTreeViewer(CAS aCAS) throws CASException {
        TreeNode root = this.buildTree(aCAS);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setResizeWeight(0.66);
        this.add(this.splitPane);
        this.tree = new JTree(root);
        this.splitPane.setLeftComponent(new JScrollPane(this.tree));
        this.rightPanel = new JPanel();
        this.rightPanel.setLayout(new BoxLayout(this.rightPanel, 1));
        this.annotationTypeLabel = new JLabel("Annotation Type: ");
        this.rightPanel.add(this.annotationTypeLabel);
        Object[] columnNames = new String[]{"Feature", "Value"};
        this.featureTable = new JTable(new DefaultTableModel(columnNames, 1));
        this.rightPanel.add(new JScrollPane(this.featureTable));
        this.annotationTextPane = new JTextPane();
        this.rightPanel.add(new JScrollPane(this.annotationTextPane));
        this.splitPane.setRightComponent(this.rightPanel);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent aEvent) {
                DefaultMutableTreeNode selectedNode;
                Object userObj;
                TreePath selPath = CasTreeViewer.this.tree.getSelectionPath();
                if (selPath != null && (userObj = (selectedNode = (DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject()) instanceof AnnotationTreeNodeObject) {
                    AnnotationFS annotation = ((AnnotationTreeNodeObject)userObj).getAnnotation();
                    CasTreeViewer.this.refreshAnnotationData(annotation);
                }
            }
        });
    }

    private void refreshAnnotationData(AnnotationFS aAnnotation) {
        String typeName = aAnnotation.getType().getName();
        this.annotationTypeLabel.setText("Annotation Type: " + typeName);
        this.annotationTextPane.setText(aAnnotation.getCoveredText());
        this.annotationTextPane.setSelectionStart(0);
        this.annotationTextPane.setSelectionEnd(0);
        DefaultTableModel tableModel = (DefaultTableModel)this.featureTable.getModel();
        while (tableModel.getRowCount() > 0) {
            tableModel.removeRow(0);
        }
        List<Feature> aFeatures = aAnnotation.getType().getFeatures();
        for (Feature feat : aFeatures) {
            int i;
            Object[] vals;
            StringBuffer displayVal;
            String featName = feat.getName();
            String rangeTypeName = feat.getRange().getName();
            if ("uima.cas.String".equals(rangeTypeName)) {
                String strVal = aAnnotation.getStringValue(feat);
                if (strVal != null && strVal.length() > 64) {
                    strVal = strVal.substring(0, 64) + "...";
                }
                tableModel.addRow(new Object[]{featName, strVal});
                continue;
            }
            if ("uima.cas.Integer".equals(rangeTypeName)) {
                int intVal = aAnnotation.getIntValue(feat);
                tableModel.addRow(new Object[]{featName, new Integer(intVal)});
                continue;
            }
            if ("uima.cas.Float".equals(rangeTypeName)) {
                float floatVal = aAnnotation.getFloatValue(feat);
                tableModel.addRow(new Object[]{featName, new Float(floatVal)});
                continue;
            }
            if ("uima.cas.StringArray".equals(rangeTypeName)) {
                StringArrayFS arrayFS = (StringArrayFS)aAnnotation.getFeatureValue(feat);
                displayVal = new StringBuffer();
                if (arrayFS == null) {
                    displayVal.append("null");
                } else {
                    displayVal.append('[');
                    vals = arrayFS.toArray();
                    for (i = 0; i < vals.length - 1; ++i) {
                        displayVal.append(vals[i]);
                        displayVal.append(',');
                    }
                    if (vals.length > 0) {
                        displayVal.append(vals[vals.length - 1]);
                    }
                    displayVal.append(']');
                }
                tableModel.addRow(new Object[]{featName, displayVal});
                continue;
            }
            if ("uima.cas.IntegerArray".equals(rangeTypeName)) {
                IntArrayFS arrayFS = (IntArrayFS)aAnnotation.getFeatureValue(feat);
                displayVal = new StringBuffer();
                if (arrayFS == null) {
                    displayVal.append("null");
                } else {
                    displayVal.append('[');
                    vals = arrayFS.toArray();
                    for (i = 0; i < vals.length - 1; ++i) {
                        displayVal.append((int)vals[i]);
                        displayVal.append(',');
                    }
                    if (vals.length > 0) {
                        displayVal.append((int)vals[vals.length - 1]);
                    }
                    displayVal.append(']');
                }
                tableModel.addRow(new Object[]{featName, displayVal});
                continue;
            }
            if (!"uima.cas.FloatArray".equals(rangeTypeName)) continue;
            FloatArrayFS arrayFS = (FloatArrayFS)aAnnotation.getFeatureValue(feat);
            displayVal = new StringBuffer();
            if (arrayFS == null) {
                displayVal.append("null");
            } else {
                displayVal.append('[');
                vals = arrayFS.toArray();
                for (i = 0; i < vals.length - 1; ++i) {
                    displayVal.append((float)vals[i]);
                    displayVal.append(',');
                }
                if (vals.length > 0) {
                    displayVal.append((float)vals[vals.length - 1]);
                }
                displayVal.append(']');
            }
            tableModel.addRow(new Object[]{featName, displayVal});
        }
    }

    private TreeNode buildTree(CAS aCAS) throws CASException {
        FSIterator iterator2 = aCAS.getAnnotationIndex().iterator();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Document");
        this._buildTree(root, iterator2, 0, aCAS.getDocumentText().length());
        return root;
    }

    private void _buildTree(DefaultMutableTreeNode aParentNode, FSIterator aIterator, int aStartPos, int aEndPos) {
        while (aIterator.isValid()) {
            AnnotationFS curAnnot = (AnnotationFS)aIterator.get();
            int curAnnotStart = curAnnot.getBegin();
            int curAnnotEnd = curAnnot.getEnd();
            if (curAnnotEnd > aEndPos) break;
            aIterator.moveToNext();
            if (curAnnotStart >= curAnnotEnd) continue;
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new AnnotationTreeNodeObject(curAnnot));
            aParentNode.add(newNode);
            this._buildTree(newNode, aIterator, curAnnotStart, curAnnotEnd);
        }
    }

    public static void main(String[] args2) {
        block8: {
            AnalysisEngine ae = null;
            try {
                File taeDescriptor = null;
                File inputFile = null;
                boolean validArgs = false;
                if (args2.length == 2) {
                    taeDescriptor = new File(args2[0]);
                    inputFile = new File(args2[1]);
                    boolean bl = validArgs = taeDescriptor.exists() && !taeDescriptor.isDirectory() && inputFile.exists() && !inputFile.isDirectory();
                }
                if (!validArgs) {
                    CasTreeViewer.printUsageMessage();
                    break block8;
                }
                XMLInputSource in = new XMLInputSource(taeDescriptor);
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
                ae = UIMAFramework.produceAnalysisEngine(specifier);
                CAS CAS2 = ae.newCAS();
                String document = FileUtils.file2String(inputFile);
                CAS2.setDocumentText(CasTreeViewer.getText(document).trim());
                ae.process(CAS2);
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Exception e) {
                    System.err.println("Could not set look and feel: " + e.getMessage());
                }
                JFrame frame = new JFrame();
                frame.setTitle("Annotation Tree Viewer");
                try {
                    frame.setIconImage(Images.getImage("/org/apache/uima/tools/images/Micro_16.gif"));
                }
                catch (IOException e) {
                    System.err.println("Image could not be loaded: " + e.getMessage());
                }
                frame.getContentPane().setBackground(Color.WHITE);
                frame.getContentPane().setLayout(new BorderLayout());
                JLabel banner = new JLabel(Images.getImageIcon("/org/apache/uima/tools/images/UIMA_banner2tlp.png"));
                frame.getContentPane().add((Component)banner, "North");
                CasTreeViewer treeViewer = new CasTreeViewer(CAS2);
                frame.getContentPane().add((Component)treeViewer, "Center");
                frame.setSize(800, 600);
                frame.pack();
                frame.show();
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(0);
            }
        }
    }

    private static String getText(String text) {
        int start = text.indexOf("<TEXT>");
        int end = text.indexOf("</TEXT>");
        if (start != -1 && end != -1) {
            return text.substring(start + 6, end);
        }
        return text;
    }

    private static void printUsageMessage() {
        System.err.println("Usage: UimaFrameworkTreeViewer <TAE descriptor or TEAR file name> <input file>");
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        Insets insets = this.getInsets();
        Dimension paneSize = new Dimension(d.width - insets.left - insets.right, d.height - insets.top - insets.bottom);
        this.splitPane.setPreferredSize(paneSize);
        this.splitPane.setSize(paneSize);
    }

    static class AnnotationTreeNodeObject {
        private AnnotationFS mAnnotation;
        private String mCaption;

        public AnnotationTreeNodeObject(AnnotationFS aAnnotation) {
            this.mAnnotation = aAnnotation;
            this.mCaption = aAnnotation.getCoveredText();
            if (this.mCaption.length() > 64) {
                this.mCaption = this.mCaption.substring(0, 64) + "...";
            }
        }

        public AnnotationFS getAnnotation() {
            return this.mAnnotation;
        }

        public String toString() {
            return this.mCaption;
        }
    }
}

