/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tutorial.RoomNumber;
import org.apache.uima.util.Level;

public class RoomNumberAnnotator
extends JCasAnnotator_ImplBase {
    private Pattern[] mPatterns;
    private String[] mLocations;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        String[] patternStrings = (String[])aContext.getConfigParameterValue("Patterns");
        this.mLocations = (String[])aContext.getConfigParameterValue("Locations");
        this.mPatterns = new Pattern[patternStrings.length];
        for (int i = 0; i < patternStrings.length; ++i) {
            this.mPatterns[i] = Pattern.compile(patternStrings[i]);
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String docText = aJCas.getDocumentText();
        for (int i = 0; i < this.mPatterns.length; ++i) {
            Matcher matcher = this.mPatterns[i].matcher(docText);
            while (matcher.find()) {
                RoomNumber annotation = new RoomNumber(aJCas);
                annotation.setBegin(matcher.start());
                annotation.setEnd(matcher.end());
                annotation.addToIndexes();
                annotation.setBuilding(this.mLocations[i]);
                this.getContext().getLogger().log(Level.FINEST, "Found: " + annotation);
            }
        }
    }
}

