/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex6;

import java.util.StringTokenizer;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tutorial.UimaAcronym;
import org.apache.uima.tutorial.ex6.StringMapResource;

public class UimaAcronymAnnotator
extends JCasAnnotator_ImplBase {
    private StringMapResource mMap;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.mMap = (StringMapResource)this.getContext().getResourceObject("AcronymTable");
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas aJCas) {
        String text = aJCas.getDocumentText();
        int pos = 0;
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\n\r.<.>/?\";:[{]}\\|=+()!", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String expandedForm = this.mMap.get(token);
            if (expandedForm != null) {
                UimaAcronym annot = new UimaAcronym(aJCas, pos, pos + token.length(), expandedForm);
                annot.addToIndexes();
            }
            pos += token.length();
        }
    }
}

