/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tutorial.ex6;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.tutorial.Meeting;
import org.apache.uima.tutorial.UimaMeeting;
import org.apache.uima.tutorial.ex6.StringMapResource;

public class UimaMeetingAnnotator
extends JCasAnnotator_ImplBase {
    private StringMapResource mMap;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        try {
            this.mMap = (StringMapResource)this.getContext().getResourceObject("UimaTermTable");
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException(e);
        }
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        String text = aJCas.getDocumentText();
        ArrayList<UimaMeeting> uimaMeetings = new ArrayList<UimaMeeting>();
        AnnotationIndex meetingIndex = aJCas.getAnnotationIndex(Meeting.type);
        FSIterator iter = meetingIndex.iterator();
        while (iter.isValid()) {
            Meeting meeting = (Meeting)iter.get();
            int begin = meeting.getBegin() - 50;
            int end = meeting.getEnd() + 50;
            if (begin < 0) {
                begin = 0;
            }
            if (end > text.length()) {
                end = text.length();
            }
            String window = text.substring(begin, end);
            StringTokenizer tokenizer = new StringTokenizer(window, " \t\n\r.<.>/?\";:[{]}\\|=+()!");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (this.mMap.get(token) == null) continue;
                UimaMeeting annot = new UimaMeeting(aJCas, meeting.getBegin(), meeting.getEnd(), meeting.getRoom(), meeting.getDate(), meeting.getStartTime(), meeting.getEndTime());
                uimaMeetings.add(annot);
                break;
            }
            iter.moveToNext();
        }
        for (UimaMeeting annot : uimaMeetings) {
            annot.addToIndexes();
        }
    }
}

