/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASFactory;
import org.apache.uima.cas.admin.CASMgr;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.FSIndexRepositoryMgr;
import org.apache.uima.cas.admin.LinearTypeOrderBuilder;
import org.apache.uima.cas.admin.TypeSystemMgr;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.FeatureStructure;
import org.apache.uima.cas_data.PrimitiveValue;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasInitializerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.flow.FlowControllerDescription;
import org.apache.uima.resource.CasDefinition;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.FsIndexKeyDescription;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypePriorityList;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.ProcessingResourceMetaData_impl;
import org.apache.uima.util.InvalidXMLException;

public class CasCreationUtils {
    private static final boolean cacheDebug = false;
    private static final int HOLD_TIME = 30000;
    private static final transient Map<MetaDataCacheKey, MetaDataCacheEntry> metaDataCache = new HashMap<MetaDataCacheKey, MetaDataCacheEntry>();
    private static Timer cleanupTimer = null;

    public static CAS createCas(AnalysisEngineMetaData aMetaData) throws ResourceInitializationException {
        ArrayList<AnalysisEngineMetaData> list = new ArrayList<AnalysisEngineMetaData>();
        list.add(aMetaData);
        return CasCreationUtils.createCas(list);
    }

    public static CAS createCas(ProcessingResourceMetaData aMetaData) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> list = new ArrayList<ProcessingResourceMetaData>();
        list.add(aMetaData);
        return CasCreationUtils.createCas(list);
    }

    public static CAS createCas(AnalysisEngineDescription aDescription) throws ResourceInitializationException {
        return CasCreationUtils.createCas(aDescription, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static CAS createCas(AnalysisEngineDescription aDescription, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> list = new ArrayList<AnalysisEngineDescription>();
        list.add(aDescription);
        return CasCreationUtils.createCas(list, aPerformanceTuningSettings);
    }

    public static CAS createCas(Collection<? extends MetaDataObject> aComponentDescriptionsOrMetaData) throws ResourceInitializationException {
        return CasCreationUtils.createCas(aComponentDescriptionsOrMetaData, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public static CAS createCas(Collection<? extends MetaDataObject> aComponentDescriptionsOrMetaData, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        return CasCreationUtils.createCas(aComponentDescriptionsOrMetaData, aPerformanceTuningSettings, UIMAFramework.newDefaultResourceManager());
    }

    public static CAS createCas(Collection<? extends MetaDataObject> aComponentDescriptionsOrMetaData, Properties aPerformanceTuningSettings, ResourceManager aResourceManager) throws ResourceInitializationException {
        List<ProcessingResourceMetaData> mdList = CasCreationUtils.getMetaDataList(aComponentDescriptionsOrMetaData, aResourceManager);
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> typePriorities = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> fsIndexes = new ArrayList<FsIndexCollection>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getTypeSystem() != null) {
                typeSystems.add(md.getTypeSystem());
            }
            if (md.getTypePriorities() != null) {
                typePriorities.add(md.getTypePriorities());
            }
            if (md.getFsIndexCollection() == null) continue;
            fsIndexes.add(md.getFsIndexCollection());
        }
        TypeSystemDescription aggTypeDesc = CasCreationUtils.mergeTypeSystems(typeSystems, aResourceManager);
        TypePriorities aggTypePriorities = CasCreationUtils.mergeTypePriorities(typePriorities, aResourceManager);
        FsIndexCollection aggIndexColl = CasCreationUtils.mergeFsIndexes(fsIndexes, aResourceManager);
        return CasCreationUtils.doCreateCas(null, aggTypeDesc, aggTypePriorities, aggIndexColl.getFsIndexes(), aPerformanceTuningSettings, aResourceManager);
    }

    public static CAS createCas(TypeSystemDescription aTypeSystem, TypePriorities aTypePriorities, FsIndexDescription[] aFsIndexes) throws ResourceInitializationException {
        return CasCreationUtils.createCas(aTypeSystem, aTypePriorities, aFsIndexes, null, null);
    }

    public static CAS createCas(TypeSystemDescription aTypeSystem, TypePriorities aTypePriorities, FsIndexDescription[] aFsIndexes, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        return CasCreationUtils.createCas(aTypeSystem, aTypePriorities, aFsIndexes, aPerformanceTuningSettings, null);
    }

    public static CAS createCas(TypeSystemDescription aTypeSystem, TypePriorities aTypePriorities, FsIndexDescription[] aFsIndexes, Properties aPerformanceTuningSettings, ResourceManager aResourceManager) throws ResourceInitializationException {
        return CasCreationUtils.doCreateCas(null, aTypeSystem, aTypePriorities, aFsIndexes, aPerformanceTuningSettings, aResourceManager);
    }

    public static CAS createCas(Collection<? extends MetaDataObject> aComponentDescriptionsOrMetaData, TypeSystem aTypeSystem, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        return CasCreationUtils.createCas(aComponentDescriptionsOrMetaData, aTypeSystem, aPerformanceTuningSettings, UIMAFramework.newDefaultResourceManager());
    }

    public static CAS createCas(Collection<? extends MetaDataObject> aComponentDescriptionsOrMetaData, TypeSystem aTypeSystem, Properties aPerformanceTuningSettings, ResourceManager aResourceManager) throws ResourceInitializationException {
        List<ProcessingResourceMetaData> mdList = CasCreationUtils.getMetaDataList(aComponentDescriptionsOrMetaData, aResourceManager);
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> typePriorities = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> fsIndexes = new ArrayList<FsIndexCollection>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getTypeSystem() != null) {
                typeSystems.add(md.getTypeSystem());
            }
            if (md.getTypePriorities() != null) {
                typePriorities.add(md.getTypePriorities());
            }
            if (md.getFsIndexCollection() == null) continue;
            fsIndexes.add(md.getFsIndexCollection());
        }
        TypePriorities aggTypePriorities = CasCreationUtils.mergeTypePriorities(typePriorities, aResourceManager);
        FsIndexCollection aggIndexColl = CasCreationUtils.mergeFsIndexes(fsIndexes, aResourceManager);
        if (aTypeSystem != null) {
            return CasCreationUtils.doCreateCas(aTypeSystem, null, aggTypePriorities, aggIndexColl.getFsIndexes(), aPerformanceTuningSettings, aResourceManager);
        }
        TypeSystemDescription aggTypeDesc = CasCreationUtils.mergeTypeSystems(typeSystems);
        return CasCreationUtils.doCreateCas(null, aggTypeDesc, aggTypePriorities, aggIndexColl.getFsIndexes(), aPerformanceTuningSettings, aResourceManager);
    }

    public static CAS createCas(TypeSystem aTypeSystem, TypePriorities aTypePriorities, FsIndexDescription[] aFsIndexes, Properties aPerformanceTuningSettings) throws ResourceInitializationException {
        return CasCreationUtils.createCas(aTypeSystem, aTypePriorities, aFsIndexes, aPerformanceTuningSettings, null);
    }

    public static CAS createCas(TypeSystem aTypeSystem, TypePriorities aTypePriorities, FsIndexDescription[] aFsIndexes, Properties aPerformanceTuningSettings, ResourceManager aResourceManager) throws ResourceInitializationException {
        return CasCreationUtils.doCreateCas(aTypeSystem, null, aTypePriorities, aFsIndexes, aPerformanceTuningSettings, aResourceManager);
    }

    private static CAS doCreateCas(TypeSystem aTypeSystem, TypeSystemDescription aTypeSystemDesc, TypePriorities aTypePriorities, FsIndexDescription[] aFsIndexes, Properties aPerformanceTuningSettings, ResourceManager aResourceManager) throws ResourceInitializationException {
        CASMgr casMgr;
        String useJcasCacheString;
        if (aResourceManager == null) {
            aResourceManager = UIMAFramework.newDefaultResourceManager();
        }
        try {
            if (aTypeSystemDesc != null) {
                aTypeSystemDesc.resolveImports(aResourceManager);
                ArrayList<TypeSystemDescription> tsList = new ArrayList<TypeSystemDescription>();
                tsList.add(aTypeSystemDesc);
                aTypeSystemDesc = CasCreationUtils.mergeTypeSystems(tsList, aResourceManager, null);
            }
            if (aTypePriorities != null) {
                aTypePriorities.resolveImports(aResourceManager);
            }
        }
        catch (InvalidXMLException e) {
            throw new ResourceInitializationException(e);
        }
        String initialHeapSizeStr = null;
        if (aPerformanceTuningSettings != null) {
            initialHeapSizeStr = aPerformanceTuningSettings.getProperty("cas_initial_heap_size");
        }
        boolean useJcasCache = true;
        if (aPerformanceTuningSettings != null && "false".equalsIgnoreCase(useJcasCacheString = aPerformanceTuningSettings.getProperty("jcas_cache_enabled", "true"))) {
            useJcasCache = false;
        }
        if (aTypeSystem != null) {
            casMgr = initialHeapSizeStr != null ? CASFactory.createCAS(Integer.parseInt(initialHeapSizeStr), aTypeSystem, useJcasCache) : CASFactory.createCAS(aTypeSystem, useJcasCache);
        } else {
            casMgr = initialHeapSizeStr != null ? CASFactory.createCAS(Integer.parseInt(initialHeapSizeStr), useJcasCache) : CASFactory.createCAS(500000, useJcasCache);
            CasCreationUtils.setupTypeSystem(casMgr, aTypeSystemDesc);
            ((CASImpl)casMgr).commitTypeSystem();
        }
        try {
            CasCreationUtils.setupTypePriorities(casMgr, aTypePriorities);
            casMgr.initCASIndexes();
        }
        catch (CASException e) {
            throw new ResourceInitializationException(e);
        }
        CasCreationUtils.setupIndexes(casMgr, aFsIndexes);
        casMgr.getIndexRepositoryMgr().commit();
        if (aResourceManager.getExtensionClassLoader() != null) {
            casMgr.setJCasClassLoader(aResourceManager.getExtensionClassLoader());
        }
        return casMgr.getCAS().getView("_InitialView");
    }

    public static CAS createCas(CasDefinition casDef, Properties performanceTuningSettings) throws ResourceInitializationException {
        return CasCreationUtils.createCas(casDef.getTypeSystemDescription(), casDef.getTypePriorities(), casDef.getFsIndexDescriptions(), performanceTuningSettings, casDef.getResourceManager());
    }

    public static CAS createCas(CasDefinition casDef, Properties performanceTuningSettings, TypeSystem typeSystem) throws ResourceInitializationException {
        return CasCreationUtils.createCas(typeSystem, casDef.getTypePriorities(), casDef.getFsIndexDescriptions(), performanceTuningSettings, casDef.getResourceManager());
    }

    public static void setupTypeSystem(CASMgr aCASMgr, TypeSystemDescription aTypeSystem) throws ResourceInitializationException {
        TypeDescription[] types;
        TypeSystemMgr typeSystemMgr = aCASMgr.getTypeSystemMgr();
        if (aTypeSystem != null && (types = aTypeSystem.getTypes()) != null) {
            int lastNumTypes;
            LinkedList<TypeDescription> typeList = new LinkedList<TypeDescription>();
            typeList.addAll(Arrays.asList(types));
            int numTypes = typeList.size();
            LinkedList<TypeDescription> typesInOrderOfCreation = new LinkedList<TypeDescription>();
            do {
                lastNumTypes = numTypes;
                Iterator it = typeList.iterator();
                while (it.hasNext()) {
                    TypeDescription curTypeDesc = (TypeDescription)it.next();
                    String typeName = curTypeDesc.getName();
                    String superTypeName = curTypeDesc.getSupertypeName();
                    if (superTypeName == null) {
                        throw new ResourceInitializationException("no_supertype", new Object[]{typeName, curTypeDesc.getSourceUrlString()});
                    }
                    Type builtIn = typeSystemMgr.getType(typeName);
                    if (builtIn != null && !superTypeName.equals(typeSystemMgr.getParent(builtIn).getName())) {
                        throw new ResourceInitializationException("redefining_builtin_type", new Object[]{typeSystemMgr.getParent(builtIn), typeName, superTypeName, curTypeDesc.getSourceUrlString()});
                    }
                    Type supertype = typeSystemMgr.getType(superTypeName);
                    if (supertype == null) continue;
                    if (curTypeDesc.getSupertypeName().equals("uima.cas.String")) {
                        AllowedValue[] vals = curTypeDesc.getAllowedValues();
                        if (vals == null) {
                            throw new ResourceInitializationException("missing_allowed_values", new Object[]{typeName, curTypeDesc.getSourceUrlString()});
                        }
                        String[] valStrs = new String[vals.length];
                        for (int i = 0; i < valStrs.length; ++i) {
                            valStrs[i] = vals[i].getString();
                        }
                        typeSystemMgr.addStringSubtype(typeName, valStrs);
                    } else {
                        if (curTypeDesc.getAllowedValues() != null && curTypeDesc.getAllowedValues().length > 0) {
                            throw new ResourceInitializationException("allowed_values_on_non_string_type", new Object[]{typeName, curTypeDesc.getSourceUrlString()});
                        }
                        typeSystemMgr.addType(typeName, supertype);
                    }
                    it.remove();
                    typesInOrderOfCreation.add(curTypeDesc);
                }
            } while ((numTypes = typeList.size()) > 0 && numTypes != lastNumTypes);
            for (int i = 0; i < typeList.size(); ++i) {
                TypeDescription td_i = (TypeDescription)typeList.get(i);
                boolean foundSuperType = false;
                for (int j = 0; j < typeList.size(); ++j) {
                    TypeDescription td_j;
                    if (i == j || !(td_j = (TypeDescription)typeList.get(j)).getName().equals(td_i.getSupertypeName())) continue;
                    foundSuperType = true;
                    break;
                }
                if (foundSuperType) continue;
                throw new ResourceInitializationException("undefined_supertype", new Object[]{td_i.getSupertypeName(), td_i.getName(), td_i.getSourceUrlString()});
            }
            if (numTypes > 0) {
                TypeDescription firstFailed = (TypeDescription)typeList.getFirst();
                throw new ResourceInitializationException("undefined_supertype", new Object[]{firstFailed.getSupertypeName(), firstFailed.getName(), firstFailed.getSourceUrlString()});
            }
            for (TypeDescription typeDesc : typesInOrderOfCreation) {
                Type type = typeSystemMgr.getType(typeDesc.getName());
                FeatureDescription[] features = typeDesc.getFeatures();
                if (features == null) continue;
                for (int j = 0; j < features.length; ++j) {
                    Boolean multiRefAllowed;
                    String elementTypeName;
                    String featName = features[j].getName();
                    String rangeTypeName = features[j].getRangeTypeName();
                    Type rangeType = typeSystemMgr.getType(rangeTypeName);
                    if (rangeType == null) {
                        throw new ResourceInitializationException("undefined_range_type", new Object[]{rangeTypeName, featName, typeDesc.getName(), features[j].getSourceUrlString()});
                    }
                    if (rangeType.isArray() && (elementTypeName = features[j].getElementType()) != null && elementTypeName.length() > 0) {
                        Type elementType = typeSystemMgr.getType(elementTypeName);
                        if (elementType == null) {
                            throw new ResourceInitializationException("undefined_range_type", new Object[]{elementTypeName, featName, typeDesc.getName(), features[j].getSourceUrlString()});
                        }
                        rangeType = typeSystemMgr.getArrayType(elementType);
                    }
                    if ((multiRefAllowed = features[j].getMultipleReferencesAllowed()) == null) {
                        multiRefAllowed = Boolean.FALSE;
                    }
                    typeSystemMgr.addFeature(featName, type, rangeType, multiRefAllowed);
                }
            }
        }
    }

    public static void setupTypePriorities(CASMgr aCASMgr, TypePriorities aTypePriorities) throws ResourceInitializationException {
        if (aTypePriorities != null) {
            LinearTypeOrderBuilder typeOrderBuilder = aCASMgr.getIndexRepositoryMgr().getDefaultOrderBuilder();
            TypePriorityList[] priorityLists = aTypePriorities.getPriorityLists();
            for (int i = 0; i < priorityLists.length; ++i) {
                String[] typeList = priorityLists[i].getTypes();
                for (int j = 0; j < typeList.length; ++j) {
                    if (aCASMgr.getTypeSystemMgr().getType(typeList[j]) != null) continue;
                    throw new ResourceInitializationException("undefined_type_for_priority_list", new Object[]{typeList[j], priorityLists[i].getSourceUrlString()});
                }
                try {
                    typeOrderBuilder.add(priorityLists[i].getTypes());
                    continue;
                }
                catch (CASException e) {
                    throw new ResourceInitializationException("invalid_type_priorities", new Object[]{priorityLists[i].getSourceUrlString()}, e);
                }
            }
        }
    }

    public static void setupIndexes(CASMgr aCASMgr, FsIndexDescription[] aIndexes) throws ResourceInitializationException {
        if (aIndexes != null) {
            TypeSystemMgr tsm = aCASMgr.getTypeSystemMgr();
            FSIndexRepositoryMgr irm = aCASMgr.getIndexRepositoryMgr();
            for (int i = 0; i < aIndexes.length; ++i) {
                Type type;
                int kind = 0;
                String kindStr = aIndexes[i].getKind();
                if (kindStr != null) {
                    if (kindStr.equals("bag")) {
                        kind = 2;
                    } else if (kindStr.equals("set")) {
                        kind = 1;
                    } else if (kindStr.equals("sorted")) {
                        kind = 0;
                    }
                }
                if ((type = tsm.getType(aIndexes[i].getTypeName())) == null) {
                    throw new ResourceInitializationException("undefined_type_for_index", new Object[]{aIndexes[i].getTypeName(), aIndexes[i].getLabel(), aIndexes[i].getSourceUrlString()});
                }
                FSIndexComparator comparator = irm.createComparator();
                comparator.setType(type);
                FsIndexKeyDescription[] keys2 = aIndexes[i].getKeys();
                if (keys2 != null) {
                    for (int j = 0; j < keys2.length; ++j) {
                        if (keys2[j].isTypePriority()) {
                            comparator.addKey(irm.getDefaultTypeOrder(), 0);
                            continue;
                        }
                        Feature feature = type.getFeatureByBaseName(keys2[j].getFeatureName());
                        if (feature == null) {
                            throw new ResourceInitializationException("index_key_feature_not_found", new Object[]{keys2[j].getFeatureName(), aIndexes[i].getLabel(), aIndexes[i].getSourceUrlString()});
                        }
                        comparator.addKey(feature, keys2[j].getComparator());
                    }
                }
                irm.createIndex(comparator, aIndexes[i].getLabel(), kind);
            }
        }
    }

    public static TypeSystemDescription convertData2TypeSystem(CasData aCasData) {
        TypeSystemDescription result = UIMAFramework.getResourceSpecifierFactory().createTypeSystemDescription();
        Iterator<FeatureStructure> iter = aCasData.getFeatureStructures();
        ArrayList<TypeDescription> typesArr = new ArrayList<TypeDescription>();
        while (iter.hasNext()) {
            FeatureStructure casFS = iter.next();
            TypeDescription newType = UIMAFramework.getResourceSpecifierFactory().createTypeDescription();
            newType.setName(casFS.getType());
            newType.setSupertypeName("uima.tcas.annotation");
            newType.setDescription("CasData Type");
            String[] features = casFS.getFeatureNames();
            if (features != null) {
                for (int i = 0; i < features.length; ++i) {
                    String featName = features[i];
                    String rangeName = "";
                    String description = "";
                    PrimitiveValue pVal = (PrimitiveValue)casFS.getFeatureValue(featName);
                    if (pVal.get().getClass().getName().equals("java.lang.String")) {
                        System.out.println(" the feature is a String ");
                        rangeName = "uima.cas.String";
                        description = " featue of the casDataType";
                    }
                    newType.addFeature(featName, description, rangeName);
                }
            }
            typesArr.add(newType);
        }
        TypeDescription[] td = new TypeDescription[typesArr.size()];
        for (int j = 0; j < typesArr.size(); ++j) {
            td[j] = (TypeDescription)typesArr.get(j);
        }
        result.setTypes(td);
        return result;
    }

    public static TypeSystemDescription mergeTypeSystems(Collection<? extends TypeSystemDescription> aTypeSystems) throws ResourceInitializationException {
        return CasCreationUtils.mergeTypeSystems(aTypeSystems, UIMAFramework.newDefaultResourceManager());
    }

    public static TypeSystemDescription mergeTypeSystems(Collection<? extends TypeSystemDescription> aTypeSystems, ResourceManager aResourceManager) throws ResourceInitializationException {
        return CasCreationUtils.mergeTypeSystems(aTypeSystems, aResourceManager, null);
    }

    public static TypeSystemDescription mergeTypeSystems(Collection<? extends TypeSystemDescription> aTypeSystems, ResourceManager aResourceManager, Map<String, Set<String>> aOutputMergedTypes) throws ResourceInitializationException {
        int n;
        TreeMap<String, TypeDescription> typeNameMap = new TreeMap<String, TypeDescription>();
        LinkedList<TypeDescription> typeList = new LinkedList<TypeDescription>();
        for (TypeSystemDescription typeSystemDescription : aTypeSystems) {
            if (typeSystemDescription == null) continue;
            try {
                typeSystemDescription.resolveImports(aResourceManager);
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
            TypeDescription[] types = typeSystemDescription.getTypes();
            typeList.addAll(Arrays.asList(types));
        }
        do {
            n = typeList.size();
            Iterator typeIter = typeList.iterator();
            while (typeIter.hasNext()) {
                TypeDescription type = (TypeDescription)typeIter.next();
                String supertypeName = type.getSupertypeName();
                if (!supertypeName.startsWith("uima.cas") && !supertypeName.startsWith("uima.tcas") && !typeNameMap.containsKey(supertypeName)) continue;
                CasCreationUtils.addTypeToMergedTypeSystem(aOutputMergedTypes, typeNameMap, type);
                typeIter.remove();
            }
        } while (typeList.size() > 0 && typeList.size() != n);
        for (TypeDescription type : typeList) {
            CasCreationUtils.addTypeToMergedTypeSystem(aOutputMergedTypes, typeNameMap, type);
        }
        TypeSystemDescription result = UIMAFramework.getResourceSpecifierFactory().createTypeSystemDescription();
        TypeDescription[] types = new TypeDescription[typeNameMap.values().size()];
        typeNameMap.values().toArray(types);
        result.setTypes(types);
        return result;
    }

    private static void addTypeToMergedTypeSystem(Map<String, Set<String>> aOutputMergedTypes, Map<String, TypeDescription> typeNameMap, TypeDescription type) throws ResourceInitializationException {
        String typeName = type.getName();
        String supertypeName = type.getSupertypeName();
        TypeDescription existingType = typeNameMap.get(typeName);
        if (existingType == null) {
            existingType = UIMAFramework.getResourceSpecifierFactory().createTypeDescription();
            existingType.setName(typeName);
            existingType.setDescription(type.getDescription());
            existingType.setSupertypeName(supertypeName);
            existingType.setAllowedValues(type.getAllowedValues());
            existingType.setSourceUrl(type.getSourceUrl());
            typeNameMap.put(type.getName(), existingType);
            FeatureDescription[] features = type.getFeatures();
            if (features != null) {
                CasCreationUtils.mergeFeatures(existingType, type.getFeatures());
            }
        } else {
            String existingSupertypeName = existingType.getSupertypeName();
            if (!existingSupertypeName.equals(supertypeName)) {
                if (CasCreationUtils.subsumes(existingSupertypeName, supertypeName, typeNameMap)) {
                    existingType.setSupertypeName(supertypeName);
                    CasCreationUtils.reportMerge(aOutputMergedTypes, type, existingType);
                } else if (CasCreationUtils.subsumes(supertypeName, existingSupertypeName, typeNameMap)) {
                    CasCreationUtils.reportMerge(aOutputMergedTypes, type, existingType);
                } else {
                    throw new ResourceInitializationException("incompatible_supertypes", new Object[]{typeName, supertypeName, existingSupertypeName, type.getSourceUrlString()});
                }
            }
            if (supertypeName.equals("uima.cas.String")) {
                AllowedValue[] av2;
                AllowedValue[] av1 = CasCreationUtils.getAllowedValues(type);
                if (!CasCreationUtils.isAllowedValuesMatch(av1, av2 = CasCreationUtils.getAllowedValues(existingType))) {
                    throw new ResourceInitializationException("string_allowed_values_not_the_same", new Object[]{typeName, CasCreationUtils.avAsString(av1), CasCreationUtils.avAsString(av2), type.getSourceUrlString()});
                }
            } else {
                int prevNumFeatures = existingType.getFeatures().length;
                FeatureDescription[] features = type.getFeatures();
                if (features != null) {
                    CasCreationUtils.mergeFeatures(existingType, type.getFeatures());
                    if (existingType.getFeatures().length != prevNumFeatures) {
                        CasCreationUtils.reportMerge(aOutputMergedTypes, type, existingType);
                    }
                }
            }
        }
    }

    private static boolean isAllowedValuesMatch(AllowedValue[] av1, AllowedValue[] av2) {
        if (av1.length != av2.length) {
            return false;
        }
        HashSet<String> s1 = new HashSet<String>(av1.length);
        HashSet<String> s2 = new HashSet<String>(av1.length);
        for (AllowedValue av : av1) {
            s1.add(av.getString());
        }
        for (AllowedValue av : av2) {
            s2.add(av.getString());
        }
        return s1.equals(s2);
    }

    private static String avAsString(AllowedValue[] av) {
        StringBuilder sb = new StringBuilder("{");
        for (int i = 0; i < av.length; ++i) {
            sb.append(av[i].getString());
            if (i >= av.length - 1) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    private static AllowedValue[] getAllowedValues(TypeDescription type) {
        AllowedValue[] r = type.getAllowedValues();
        if (r == null) {
            return new AllowedValue[0];
        }
        return r;
    }

    private static void reportMerge(Map<String, Set<String>> aOutputMergedTypes, TypeDescription currentType, TypeDescription existingType) {
        if (aOutputMergedTypes != null) {
            String typeName = currentType.getName();
            Set<String> descriptorUrls = aOutputMergedTypes.get(typeName);
            if (descriptorUrls == null) {
                descriptorUrls = new TreeSet<String>();
                descriptorUrls.add(existingType.getSourceUrlString());
                descriptorUrls.add(currentType.getSourceUrlString());
                aOutputMergedTypes.put(typeName, descriptorUrls);
            } else {
                descriptorUrls.add(currentType.getSourceUrlString());
            }
        }
    }

    public static TypeSystemDescription mergeDelegateAnalysisEngineTypeSystems(AnalysisEngineDescription aAggregateDescription) throws ResourceInitializationException {
        return CasCreationUtils.mergeDelegateAnalysisEngineTypeSystems(aAggregateDescription, UIMAFramework.newDefaultResourceManager());
    }

    public static TypeSystemDescription mergeDelegateAnalysisEngineTypeSystems(AnalysisEngineDescription aAggregateDescription, ResourceManager aResourceManager) throws ResourceInitializationException {
        return CasCreationUtils.mergeDelegateAnalysisEngineTypeSystems(aAggregateDescription, aResourceManager, null);
    }

    public static TypeSystemDescription mergeDelegateAnalysisEngineTypeSystems(AnalysisEngineDescription aAggregateDescription, ResourceManager aResourceManager, Map<String, Set<String>> aOutputMergedTypes) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> l = new ArrayList<AnalysisEngineDescription>();
        l.add(aAggregateDescription);
        List<ProcessingResourceMetaData> mdList = CasCreationUtils.getMetaDataList(l, aResourceManager);
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getTypeSystem() == null) continue;
            typeSystems.add(md.getTypeSystem());
        }
        return CasCreationUtils.mergeTypeSystems(typeSystems, aResourceManager, aOutputMergedTypes);
    }

    public static FsIndexCollection mergeFsIndexes(List<? extends FsIndexCollection> aFsIndexCollections, ResourceManager aResourceManager) throws ResourceInitializationException {
        FsIndexDescription[] indexes;
        HashMap<String, FsIndexDescription> aggIndexes = new HashMap<String, FsIndexDescription>();
        for (FsIndexCollection fsIndexCollection : aFsIndexCollections) {
            if (fsIndexCollection == null) continue;
            try {
                fsIndexCollection.resolveImports(aResourceManager);
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
            indexes = fsIndexCollection.getFsIndexes();
            for (int i = 0; i < indexes.length; ++i) {
                FsIndexDescription duplicateIndex = (FsIndexDescription)aggIndexes.get(indexes[i].getLabel());
                if (duplicateIndex == null) {
                    aggIndexes.put(indexes[i].getLabel(), indexes[i]);
                    continue;
                }
                if (duplicateIndex.equals(indexes[i])) continue;
                throw new ResourceInitializationException("duplicate_index_name", new Object[]{duplicateIndex.getLabel(), duplicateIndex.getSourceUrlString(), indexes[i].getSourceUrlString()});
            }
        }
        FsIndexCollection fsIndexCollection = UIMAFramework.getResourceSpecifierFactory().createFsIndexCollection();
        indexes = aggIndexes.values();
        FsIndexDescription[] indexArray = new FsIndexDescription[indexes.size()];
        indexes.toArray(indexArray);
        fsIndexCollection.setFsIndexes(indexArray);
        return fsIndexCollection;
    }

    public static FsIndexCollection mergeDelegateAnalysisEngineFsIndexCollections(AnalysisEngineDescription aAggregateDescription) throws ResourceInitializationException {
        return CasCreationUtils.mergeDelegateAnalysisEngineFsIndexCollections(aAggregateDescription, UIMAFramework.newDefaultResourceManager());
    }

    public static FsIndexCollection mergeDelegateAnalysisEngineFsIndexCollections(AnalysisEngineDescription aAggregateDescription, ResourceManager aResourceManager) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> l = new ArrayList<AnalysisEngineDescription>();
        l.add(aAggregateDescription);
        List<ProcessingResourceMetaData> mdList = CasCreationUtils.getMetaDataList(l, aResourceManager);
        ArrayList<FsIndexCollection> fsIndexes = new ArrayList<FsIndexCollection>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getFsIndexCollection() == null) continue;
            fsIndexes.add(md.getFsIndexCollection());
        }
        return CasCreationUtils.mergeFsIndexes(fsIndexes, aResourceManager);
    }

    public static TypePriorities mergeTypePriorities(List<? extends TypePriorities> aTypePriorities, ResourceManager aResourceManager) throws ResourceInitializationException {
        TypePriorities aggTypePriorities = UIMAFramework.getResourceSpecifierFactory().createTypePriorities();
        for (TypePriorities typePriorities : aTypePriorities) {
            try {
                typePriorities.resolveImports(aResourceManager);
            }
            catch (InvalidXMLException e) {
                throw new ResourceInitializationException(e);
            }
            TypePriorityList[] pls = typePriorities.getPriorityLists();
            if (pls == null) continue;
            for (int i = 0; i < pls.length; ++i) {
                aggTypePriorities.addPriorityList(pls[i]);
            }
        }
        return aggTypePriorities;
    }

    public static TypePriorities mergeDelegateAnalysisEngineTypePriorities(AnalysisEngineDescription aAggregateDescription) throws ResourceInitializationException {
        return CasCreationUtils.mergeDelegateAnalysisEngineTypePriorities(aAggregateDescription, UIMAFramework.newDefaultResourceManager());
    }

    public static TypePriorities mergeDelegateAnalysisEngineTypePriorities(AnalysisEngineDescription aAggregateDescription, ResourceManager aResourceManager) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> l = new ArrayList<AnalysisEngineDescription>();
        l.add(aAggregateDescription);
        List<ProcessingResourceMetaData> mdList = CasCreationUtils.getMetaDataList(l, aResourceManager);
        ArrayList<TypePriorities> typePriorities = new ArrayList<TypePriorities>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getTypePriorities() == null) continue;
            typePriorities.add(md.getTypePriorities());
        }
        return CasCreationUtils.mergeTypePriorities(typePriorities, aResourceManager);
    }

    public static ProcessingResourceMetaData mergeDelegateAnalysisEngineMetaData(AnalysisEngineDescription aAggregateDescription, ResourceManager aResourceManager, Map<String, Set<String>> aOutputMergedTypes, Map<String, ? super Exception> aOutputFailedRemotes) throws ResourceInitializationException {
        ArrayList<AnalysisEngineDescription> l = new ArrayList<AnalysisEngineDescription>();
        l.add(aAggregateDescription);
        List<ProcessingResourceMetaData> mdList = CasCreationUtils.getMetaDataList(l, aResourceManager, aOutputFailedRemotes);
        ProcessingResourceMetaData result = UIMAFramework.getResourceSpecifierFactory().createProcessingResourceMetaData();
        ArrayList<TypeSystemDescription> typeSystems = new ArrayList<TypeSystemDescription>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getTypeSystem() == null) continue;
            typeSystems.add(md.getTypeSystem());
        }
        result.setTypeSystem(CasCreationUtils.mergeTypeSystems(typeSystems, aResourceManager, aOutputMergedTypes));
        ArrayList<TypePriorities> typePriorities = new ArrayList<TypePriorities>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getTypePriorities() == null) continue;
            typePriorities.add(md.getTypePriorities());
        }
        result.setTypePriorities(CasCreationUtils.mergeTypePriorities(typePriorities, aResourceManager));
        ArrayList<FsIndexCollection> fsIndexes = new ArrayList<FsIndexCollection>();
        for (ProcessingResourceMetaData md : mdList) {
            if (md.getFsIndexCollection() == null) continue;
            fsIndexes.add(md.getFsIndexCollection());
        }
        result.setFsIndexCollection(CasCreationUtils.mergeFsIndexes(fsIndexes, aResourceManager));
        return result;
    }

    protected static boolean subsumes(String aType1Name, String aType2Name, Map<String, ? extends TypeDescription> aNameMap) {
        if ("uima.cas.TOP".equals(aType1Name)) {
            return true;
        }
        String current = aType2Name;
        while (current != null && !current.equals(aType1Name)) {
            TypeDescription curType = aNameMap.get(current);
            if (curType == null) {
                current = null;
                continue;
            }
            current = curType.getSupertypeName();
        }
        return current != null;
    }

    protected static void mergeFeatures(TypeDescription aType, FeatureDescription[] aFeatures) throws ResourceInitializationException {
        FeatureDescription[] existingFeatures = aType.getFeatures();
        if (existingFeatures == null) {
            existingFeatures = new FeatureDescription[]{};
        }
        for (int i = 0; i < aFeatures.length; ++i) {
            String featName = aFeatures[i].getName();
            String rangeTypeName = aFeatures[i].getRangeTypeName();
            String elementTypeName = aFeatures[i].getElementType();
            Boolean multiRefsAllowed = aFeatures[i].getMultipleReferencesAllowed();
            FeatureDescription feat = null;
            for (int j = 0; j < existingFeatures.length; ++j) {
                if (!existingFeatures[j].getName().equals(featName)) continue;
                feat = existingFeatures[j];
                break;
            }
            if (feat == null) {
                FeatureDescription featDesc = aType.addFeature(featName, aFeatures[i].getDescription(), rangeTypeName, elementTypeName, multiRefsAllowed);
                featDesc.setSourceUrl(aFeatures[i].getSourceUrl());
                continue;
            }
            if (!feat.getRangeTypeName().equals(rangeTypeName)) {
                throw new ResourceInitializationException("incompatible_range_types", new Object[]{aType.getName() + ":" + feat.getName(), rangeTypeName, feat.getRangeTypeName(), aType.getSourceUrlString()});
            }
            Boolean mra1 = feat.getMultipleReferencesAllowed();
            Boolean mra2 = multiRefsAllowed;
            if (!(mra1 == null && mra2 == null || mra1 != null && mra1.equals(mra2) || mra1 == null && !mra2.booleanValue() || mra2 == null && !mra1.booleanValue())) {
                throw new ResourceInitializationException("incompatible_multi_refs", new Object[]{aType.getName() + ":" + feat.getName(), aType.getSourceUrlString()});
            }
            if (CasCreationUtils.elementTypesCompatible(feat.getElementType(), elementTypeName)) continue;
            throw new ResourceInitializationException("incompatible_element_range_types", new Object[]{aType.getName() + ':' + feat.getName(), elementTypeName, feat.getElementType(), aType.getSourceUrlString()});
        }
    }

    private static boolean elementTypesCompatible(String o1, String o2) {
        return null == o1 && null == o2 || null != o1 && o1.equals(o2) || o1 != null && o1.equals("uima.cas.TOP") && o2 == null || o2 != null && o2.equals("uima.cas.TOP") && o1 == null;
    }

    public static List<ProcessingResourceMetaData> getMetaDataList(Collection<? extends MetaDataObject> aComponentDescriptionOrMetaData, ResourceManager aResourceManager, Map<String, ? super Exception> aOutputFailedRemotes) throws ResourceInitializationException {
        return CasCreationUtils.getMetaDataList(aComponentDescriptionOrMetaData, aResourceManager, aOutputFailedRemotes, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ProcessingResourceMetaData> getMetaDataList(Collection<? extends MetaDataObject> aComponentDescriptionOrMetaData, ResourceManager aResourceManager, Map<String, ? super Exception> aOutputFailedRemotes, String aContextName) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> mdList = new ArrayList<ProcessingResourceMetaData>();
        if (null == aComponentDescriptionOrMetaData) {
            return mdList;
        }
        for (MetaDataObject metaDataObject : aComponentDescriptionOrMetaData) {
            ProcessingResourceMetaData_impl md;
            Map<Object, Object> delegateMap;
            if (metaDataObject instanceof ProcessingResourceMetaData) {
                mdList.add((ProcessingResourceMetaData)((ProcessingResourceMetaData)metaDataObject).clone());
                continue;
            }
            if (metaDataObject instanceof AnalysisEngineDescription) {
                AnalysisEngineDescription aeDesc = (AnalysisEngineDescription)metaDataObject;
                mdList.add((ProcessingResourceMetaData)aeDesc.getAnalysisEngineMetaData().clone());
                if (aeDesc.isPrimitive()) continue;
                try {
                    delegateMap = aeDesc.getAllComponentSpecifiers(aResourceManager);
                }
                catch (InvalidXMLException e) {
                    throw new ResourceInitializationException(e);
                }
                for (Map.Entry<String, ResourceSpecifier> delEntry : delegateMap.entrySet()) {
                    ArrayList<ResourceSpecifier> tempList = new ArrayList<ResourceSpecifier>();
                    tempList.add(delEntry.getValue());
                    mdList.addAll(CasCreationUtils.getMetaDataList(tempList, aResourceManager, aOutputFailedRemotes, aContextName + "/" + delEntry.getKey()));
                }
                continue;
            }
            if (metaDataObject instanceof CollectionReaderDescription) {
                mdList.add((ProcessingResourceMetaData)((CollectionReaderDescription)metaDataObject).getCollectionReaderMetaData().clone());
                continue;
            }
            if (metaDataObject instanceof CasInitializerDescription) {
                mdList.add((ProcessingResourceMetaData)((CasInitializerDescription)metaDataObject).getCasInitializerMetaData().clone());
                continue;
            }
            if (metaDataObject instanceof CasConsumerDescription) {
                mdList.add((ProcessingResourceMetaData)((CasConsumerDescription)metaDataObject).getCasConsumerMetaData().clone());
                continue;
            }
            if (metaDataObject instanceof FlowControllerDescription) {
                mdList.add((ProcessingResourceMetaData)((FlowControllerDescription)metaDataObject).getFlowControllerMetaData().clone());
                continue;
            }
            if (metaDataObject instanceof TypeSystemDescription) {
                md = new ProcessingResourceMetaData_impl();
                md.setTypeSystem((TypeSystemDescription)metaDataObject);
                mdList.add(md);
                continue;
            }
            if (metaDataObject instanceof FsIndexCollection) {
                md = new ProcessingResourceMetaData_impl();
                md.setFsIndexCollection((FsIndexCollection)metaDataObject);
                mdList.add(md);
                continue;
            }
            if (metaDataObject instanceof TypePriorities) {
                md = new ProcessingResourceMetaData_impl();
                md.setTypePriorities((TypePriorities)metaDataObject);
                mdList.add(md);
                continue;
            }
            if (metaDataObject instanceof ResourceSpecifier) {
                Map<MetaDataCacheKey, MetaDataCacheEntry> map;
                MetaDataCacheKey metaDataCacheKey = new MetaDataCacheKey((ResourceSpecifier)metaDataObject, aResourceManager);
                delegateMap = metaDataCache;
                synchronized (delegateMap) {
                    MetaDataCacheEntry metaData = metaDataCache.get(metaDataCacheKey);
                    if (null != metaData) {
                        if (null != metaData.processingResourceMetaData) {
                            mdList.add(metaData.processingResourceMetaData);
                        }
                        continue;
                    }
                }
                Resource resource = null;
                HashMap<String, Object> prParams = new HashMap<String, Object>();
                if (aResourceManager != null) {
                    prParams.put("RESOURCE_MANAGER", aResourceManager);
                }
                prParams.put("VERIFICATION_MODE", Boolean.TRUE);
                try {
                    resource = UIMAFramework.produceResource((ResourceSpecifier)metaDataObject, prParams);
                }
                catch (Exception e) {
                    map = metaDataCache;
                    synchronized (map) {
                        metaDataCache.put(metaDataCacheKey, new MetaDataCacheEntry(null));
                    }
                    if (aOutputFailedRemotes != null) {
                        aOutputFailedRemotes.put(aContextName, e);
                    }
                    if (e instanceof ResourceInitializationException) {
                        throw (ResourceInitializationException)e;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
                ResourceMetaData metadata = resource == null ? null : resource.getMetaData();
                map = metaDataCache;
                synchronized (map) {
                    metaDataCache.put(metaDataCacheKey, new MetaDataCacheEntry(metadata));
                }
                if (resource == null) continue;
                if (metadata instanceof ProcessingResourceMetaData) {
                    mdList.add((ProcessingResourceMetaData)metadata);
                }
                resource.destroy();
                continue;
            }
            throw new ResourceInitializationException("unsupported_object_type_in_create_cas", new Object[]{metaDataObject.getClass().getName()});
        }
        return mdList;
    }

    public static List<ProcessingResourceMetaData> getMetaDataList(Collection<? extends MetaDataObject> aComponentDescriptionOrMetaData, ResourceManager aResourceManager) throws ResourceInitializationException {
        return CasCreationUtils.getMetaDataList(aComponentDescriptionOrMetaData, aResourceManager, null);
    }

    private static class MetaDataCacheEntry {
        ProcessingResourceMetaData processingResourceMetaData;
        long creationTime;

        MetaDataCacheEntry(ResourceMetaData resourceMetaData) {
            this.processingResourceMetaData = resourceMetaData instanceof ProcessingResourceMetaData ? (ProcessingResourceMetaData)resourceMetaData : null;
            this.creationTime = System.currentTimeMillis();
            if (null == cleanupTimer) {
                cleanupTimer = new Timer("metaDataCacheCleanup", true);
                TimerTask metaDataCacheCleanupTask = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Map map = metaDataCache;
                        synchronized (map) {
                            long now = System.currentTimeMillis();
                            Iterator it = metaDataCache.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry e = it.next();
                                if (((MetaDataCacheEntry)e.getValue()).creationTime + 30000L >= now) continue;
                                it.remove();
                            }
                            if (metaDataCache.size() == 0) {
                                this.cancel();
                                cleanupTimer.cancel();
                                cleanupTimer = null;
                            }
                        }
                    }
                };
                cleanupTimer.schedule(metaDataCacheCleanupTask, 30000L, 30000L);
            }
        }
    }

    private static class MetaDataCacheKey {
        final ResourceSpecifier resourceSpecifier;
        final ClassLoader rmClassLoader;
        final String rmDataPath;

        MetaDataCacheKey(ResourceSpecifier resourceSpecifier, ResourceManager resourceManager) {
            this.resourceSpecifier = resourceSpecifier;
            this.rmClassLoader = null == resourceManager ? null : resourceManager.getExtensionClassLoader();
            this.rmDataPath = null == resourceManager ? null : resourceManager.getDataPath();
        }

        public int hashCode() {
            return (this.rmClassLoader == null ? 0 : this.rmClassLoader.hashCode()) + (this.rmDataPath == null ? 0 : this.rmDataPath.hashCode()) + this.resourceSpecifier.hashCode();
        }

        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            MetaDataCacheKey k = (MetaDataCacheKey)obj;
            if (this.rmDataPath == null) {
                if (k.rmDataPath != null) {
                    return false;
                }
                return this.resourceSpecifier.equals(k.resourceSpecifier) && this.rmClassLoader == k.rmClassLoader;
            }
            return this.resourceSpecifier.equals(k.resourceSpecifier) && this.rmClassLoader == k.rmClassLoader && this.rmDataPath.equals(k.rmDataPath);
        }

        public String toString() {
            return "MetaDataCacheKey [resourceSpecifier=" + this.resourceSpecifier + ", rmClassLoader=" + this.rmClassLoader + ", rmDataPath=" + this.rmDataPath + "]";
        }
    }
}

