/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.BaseServerRunnable;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.ServiceException;
import org.apache.vinci.transport.Transportable;
import org.apache.vinci.transport.VinciServable;

public class BaseServer {
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final int DEFAULT_MAX_POOL_SIZE = 20;
    private static final int SERVER_SOCKET_TIMEOUT = 1000;
    private volatile boolean shutdown;
    private volatile boolean isServing;
    private ServerSocket serverSocket;
    private VinciServable servable;
    private Thread servingThread;
    private int socketTimeout;
    private int initialPoolSize;
    private int maxPoolSize;
    private int pooledCount;
    private int busyCount;
    private PooledThread[] threadPool;
    private PooledThread[] busyThreads;

    public BaseServer(VinciServable my_servable) {
        this.servable = my_servable;
        this.shutdown = false;
        this.isServing = false;
        this.serverSocket = null;
        this.servingThread = null;
        this.socketTimeout = 60000;
        this.threadPool = null;
        this.initialPoolSize = 1;
        this.pooledCount = 0;
        this.busyCount = 0;
        this.maxPoolSize = 20;
    }

    public VinciServable getServable() {
        return this.servable;
    }

    public void setSocketTimeout(int millis) throws IOException {
        this.socketTimeout = millis;
    }

    private void expandOrWait() throws InterruptedException {
        Debug.Assert(this.pooledCount == 0);
        if (this.busyCount < this.maxPoolSize) {
            Debug.p("Creating a thread for pool of current size " + this.busyCount);
            PooledThread add_me = new PooledThread(this.busyCount);
            add_me.start();
            this.threadPool[0] = add_me;
            this.pooledCount = 1;
        } else {
            Debug.p("WARNING: Blocking until pooled thread available. Consider expanding the pool size.");
            this.threadPool.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PooledThread getThreadFromPool() throws InterruptedException {
        PooledThread[] pooledThreadArray = this.threadPool;
        synchronized (this.threadPool) {
            PooledThread return_me;
            Debug.p("Pooledcount: " + this.pooledCount + " busyCount: " + this.busyCount);
            if (this.pooledCount == 0) {
                this.expandOrWait();
            }
            this.busyThreads[return_me.getWhich()] = return_me = this.threadPool[--this.pooledCount];
            ++this.busyCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return return_me;
        }
    }

    public void setThreadPoolSize(int initial, int max) {
        Debug.Assert(!this.isServing);
        this.initialPoolSize = initial;
        this.maxPoolSize = max;
    }

    private void configureServerSocket(int port) throws IOException {
        Debug.Assert(!this.isServing);
        this.serverSocket = this.createServerSocket(port);
        this.serverSocket.setSoTimeout(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeServing() {
        Debug.Assert(this.isServing);
        this.threadPool = new PooledThread[this.maxPoolSize];
        this.busyThreads = new PooledThread[this.maxPoolSize];
        PooledThread[] pooledThreadArray = this.threadPool;
        synchronized (this.threadPool) {
            for (int i = 0; i < this.initialPoolSize; ++i) {
                PooledThread add_me = new PooledThread(i);
                add_me.start();
                this.threadPool[i] = add_me;
            }
            this.pooledCount = this.initialPoolSize;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void startServing(int port) throws IOException {
        this.configureServerSocket(port);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BaseServer.this.shutdown = false;
                BaseServer.this.isServing = true;
                try {
                    BaseServer.this.initializeServing();
                    BaseServer.this.handleRequests();
                }
                finally {
                    BaseServer.this.isServing = false;
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serve(int port) throws IOException {
        this.configureServerSocket(port);
        this.shutdown = false;
        this.isServing = true;
        try {
            this.initializeServing();
            this.handleRequests();
        }
        finally {
            this.isServing = false;
        }
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    protected ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket s2 = new ServerSocket(port);
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequests() {
        try {
            this.servingThread = Thread.currentThread();
            while (!this.shutdown) {
                try {
                    Socket s2 = this.serverSocket.accept();
                    s2.setTcpNoDelay(true);
                    if (this.socketTimeout != 0) {
                        s2.setSoTimeout(this.socketTimeout);
                    }
                    this.handleRequest(s2);
                }
                catch (InterruptedIOException e) {
                }
                catch (Exception e) {
                    Debug.reportException(e);
                }
            }
        }
        finally {
            this.cleanExit();
        }
    }

    public void shutdownServing() {
        this.shutdown = true;
        if (this.servingThread != null) {
            try {
                this.servingThread.join(2000L);
            }
            catch (InterruptedException e) {
                Debug.reportException(e);
                Thread.currentThread().interrupt();
            }
        }
    }

    protected Runnable getRunnable(Socket client) {
        return new BaseServerRunnable(client, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRequest(Socket client) {
        try {
            PooledThread t;
            PooledThread pooledThread = t = this.getThreadFromPool();
            synchronized (pooledThread) {
                t.setRunnable(this.getRunnable(client), client);
                t.notify();
            }
        }
        catch (InterruptedException e) {
            Debug.reportException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanExit() {
        this.isServing = false;
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            Debug.reportException(e);
        }
        PooledThread[] pooledThreadArray = this.threadPool;
        synchronized (this.threadPool) {
            int i;
            for (i = 0; i < this.pooledCount; ++i) {
                Debug.p("Interrupting pooled thread: " + this.threadPool[i].getWhich());
                this.threadPool[i].interrupt();
            }
            for (i = 0; i < this.maxPoolSize; ++i) {
                if (this.busyThreads[i] == null) continue;
                Debug.p("Interrupting pooled thread: " + i);
                this.busyThreads[i].interrupt();
                try {
                    this.busyThreads[i].getSocket().close();
                    continue;
                }
                catch (IOException e) {
                    Debug.reportException(e);
                }
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            this.servable.cleanExit();
            return;
        }
    }

    public Transportable eval(Transportable in, KeyValuePair header) {
        try {
            return this.servable.eval(in);
        }
        catch (ServiceException e) {
            return e.getCompleteDocument();
        }
    }

    public Transportable makeTransportable() {
        return this.servable.makeTransportable();
    }

    private class PooledThread
    extends Thread {
        private Runnable run_me;
        private Socket socket;
        private final int which;

        PooledThread(int which) {
            this.which = which;
            this.socket = null;
            this.run_me = null;
            this.setName("PooledThread#" + which);
        }

        int getWhich() {
            return this.which;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (BaseServer.this.isServing) {
                    try {
                        PooledThread[] pooledThreadArray = this;
                        // MONITORENTER : this
                        while (this.run_me == null) {
                            this.wait();
                        }
                        // MONITOREXIT : pooledThreadArray
                        try {
                            this.run_me.run();
                            pooledThreadArray = this;
                        }
                        catch (Throwable e2) {
                            PooledThread[] e2;
                            try {
                                Debug.reportException(e2);
                                e2 = this;
                            }
                            catch (Throwable throwable) {
                                PooledThread[] pooledThreadArray2 = this;
                                // MONITORENTER : this
                                this.run_me = null;
                                this.socket = null;
                                // MONITOREXIT : pooledThreadArray2
                                pooledThreadArray2 = BaseServer.this.threadPool;
                                // MONITORENTER : pooledThreadArray2
                                ((BaseServer)BaseServer.this).threadPool[((BaseServer)BaseServer.this).pooledCount++] = this;
                                ((BaseServer)BaseServer.this).busyThreads[this.which] = null;
                                BaseServer.this.busyCount--;
                                BaseServer.this.threadPool.notify();
                                // MONITOREXIT : pooledThreadArray2
                                throw throwable;
                            }
                            this.run_me = null;
                            this.socket = null;
                            // MONITOREXIT : e2
                            e2 = BaseServer.this.threadPool;
                            // MONITORENTER : e2
                            ((BaseServer)BaseServer.this).threadPool[((BaseServer)BaseServer.this).pooledCount++] = this;
                            ((BaseServer)BaseServer.this).busyThreads[this.which] = null;
                            BaseServer.this.busyCount--;
                            BaseServer.this.threadPool.notify();
                            // MONITOREXIT : e2
                            continue;
                        }
                        // MONITORENTER : this
                        this.run_me = null;
                        this.socket = null;
                        // MONITOREXIT : pooledThreadArray
                        pooledThreadArray = BaseServer.this.threadPool;
                        // MONITORENTER : pooledThreadArray
                        ((BaseServer)BaseServer.this).threadPool[((BaseServer)BaseServer.this).pooledCount++] = this;
                        ((BaseServer)BaseServer.this).busyThreads[this.which] = null;
                        BaseServer.this.busyCount--;
                        BaseServer.this.threadPool.notify();
                        // MONITOREXIT : pooledThreadArray
                    }
                    catch (InterruptedException e) {
                        Debug.p("interrupted");
                    }
                }
                return;
            }
            catch (Throwable e) {
                Debug.reportException(e);
                return;
            }
            finally {
                Debug.p("pooled thread exit");
            }
        }

        void setRunnable(Runnable r, Socket c) {
            this.run_me = r;
            this.socket = c;
        }

        Socket getSocket() {
            return this.socket;
        }
    }
}

